/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.jupyter.kernel.server.embedded;

import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessage;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessageChannel;
import com.intellij.jupyter.execution.kernel.BaseJupyterKernelCommunicationClientKt;
import com.intellij.jupyter.execution.kernel.MessageBridgeKt;
import java.util.concurrent.ArrayBlockingQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterSendReceiveSocket;
import org.jetbrains.kotlinx.jupyter.protocol.api.JupyterSocketType;
import org.jetbrains.kotlinx.jupyter.protocol.api.RawMessage;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\fJ\b\u0010\u000f\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/embedded/EmbeddedJupyterSocket;", "Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterSendReceiveSocket;", "socketType", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/JupyterSocketType;", "onMessageCallback", "Lkotlin/Function1;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessage;", "", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/protocol/api/JupyterSocketType;Lkotlin/jvm/functions/Function1;)V", "clientReplyQueue", "Ljava/util/concurrent/ArrayBlockingQueue;", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/RawMessage;", "setClientReply", "reply", "receiveRawMessage", "sendRawMessage", "msg", "intellij.kotlin.jupyter.core"})
public class EmbeddedJupyterSocket
implements JupyterSendReceiveSocket {
    @NotNull
    private final JupyterSocketType socketType;
    @NotNull
    private final Function1<JupyterMessage, Unit> onMessageCallback;
    @NotNull
    private final ArrayBlockingQueue<RawMessage> clientReplyQueue;

    public EmbeddedJupyterSocket(@NotNull JupyterSocketType socketType, @NotNull Function1<? super JupyterMessage, Unit> onMessageCallback) {
        Intrinsics.checkNotNullParameter((Object)socketType, (String)"socketType");
        Intrinsics.checkNotNullParameter(onMessageCallback, (String)"onMessageCallback");
        this.socketType = socketType;
        this.onMessageCallback = onMessageCallback;
        this.clientReplyQueue = new ArrayBlockingQueue(10);
    }

    public final void setClientReply(@NotNull RawMessage reply) {
        Intrinsics.checkNotNullParameter((Object)reply, (String)"reply");
        this.clientReplyQueue.add(reply);
    }

    @NotNull
    public RawMessage receiveRawMessage() {
        RawMessage rawMessage = this.clientReplyQueue.take();
        Intrinsics.checkNotNullExpressionValue((Object)rawMessage, (String)"take(...)");
        return rawMessage;
    }

    public void sendRawMessage(@NotNull RawMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        JupyterMessage message = MessageBridgeKt.toJupyterMessage((RawMessage)msg, (JupyterMessageChannel)BaseJupyterKernelCommunicationClientKt.getChannel((JupyterSocketType)this.socketType));
        this.onMessageCallback.invoke((Object)message);
    }
}

