/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.testing.tsqlt;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.InterruptibleDatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.NoisyStatement;
import com.intellij.database.dataSource.connection.statements.OutParameter;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.run.AsyncTaskProcessHandler;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.messages.serviceMessages.TestFinished;
import jetbrains.buildServer.messages.serviceMessages.TestIgnored;
import jetbrains.buildServer.messages.serviceMessages.TestStarted;
import jetbrains.buildServer.messages.serviceMessages.TestSuiteFinished;
import jetbrains.buildServer.messages.serviceMessages.TestSuiteStarted;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u0010\u001a\u00020\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0012H\u0002J$\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0012H\u0002J,\u0010\u0016\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00182\u0006\u0010\u0019\u001a\u00020\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aH\u0002J&\u0010\u001b\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00182\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\u001a\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u0007H\u0002J,\u0010\u001e\u001a\u00020\u000f2\u001a\u0010\u001f\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020!\u0018\u00010 2\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/database/dialects/mssql/testing/tsqlt/TSqltHandler;", "Lcom/intellij/database/run/AsyncTaskProcessHandler;", "project", "Lcom/intellij/openapi/project/Project;", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "db", "", "paths", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Ljava/lang/String;Ljava/util/List;)V", "expected", "Lkotlin/text/Regex;", "start", "", "prepareTree", "tests", "Lcom/intellij/util/containers/MultiMap;", "runTests", "c", "Lcom/intellij/database/dataSource/DatabaseConnection;", "runSuite", "stmt", "Lcom/intellij/database/dataSource/connection/statements/NoisyStatement;", "suite", "", "runTest", "test", "locationHint", "processTestResult", "result", "Lkotlin/Triple;", "", "getTests", "intellij.database.dialects.mssql.ex"})
@SourceDebugExtension(value={"SMAP\nTSqltHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TSqltHandler.kt\ncom/intellij/database/dialects/mssql/testing/tsqlt/TSqltHandler\n+ 2 StandardResultsProcessors.kt\ncom/intellij/database/dataSource/connection/statements/StandardResultsProcessors\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n149#2:149\n1#3:150\n*S KotlinDebug\n*F\n+ 1 TSqltHandler.kt\ncom/intellij/database/dialects/mssql/testing/tsqlt/TSqltHandler\n*L\n87#1:149\n*E\n"})
public final class TSqltHandler
extends AsyncTaskProcessHandler {
    @NotNull
    private final Project project;
    @NotNull
    private final LocalDataSource ds;
    @Nullable
    private final String db;
    @NotNull
    private final List<String> paths;
    @NotNull
    private final Regex expected;

    public TSqltHandler(@NotNull Project project, @NotNull LocalDataSource ds, @Nullable String db, @NotNull List<String> paths) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        this.project = project;
        this.ds = ds;
        this.db = db;
        this.paths = paths;
        this.expected = new Regex("Expected: <(.*)> but was: <(.*)>");
    }

    public final void start() {
        this.start(() -> TSqltHandler.start$lambda$0(this));
        this.notifyTextAvailable(ServiceMessageBuilder.testsStarted().toString(), ProcessOutputTypes.STDOUT);
    }

    private final void prepareTree(MultiMap<String, String> tests) {
        for (Map.Entry entry : tests.entrySet()) {
            Intrinsics.checkNotNull((Object)entry);
            String suite = (String)entry.getKey();
            Collection suiteTests = (Collection)entry.getValue();
            ServiceMessageBuilder serviceMessageBuilder = new ServiceMessageBuilder("suiteTreeStarted").addAttribute("name", suite);
            Intrinsics.checkNotNull((Object)suite);
            this.notifyTextAvailable(serviceMessageBuilder.addAttribute("locationHint", this.locationHint(suite, null)).toString(), ProcessOutputTypes.STDOUT);
            for (String test : suiteTests) {
                this.notifyTextAvailable(new ServiceMessageBuilder("suiteTreeNode").addAttribute("name", test).addAttribute("locationHint", this.locationHint(suite, test)).toString(), ProcessOutputTypes.STDOUT);
            }
            this.notifyTextAvailable(new ServiceMessageBuilder("suiteTreeEnded").addAttribute("name", suite).toString(), ProcessOutputTypes.STDOUT);
        }
        this.notifyTextAvailable(new ServiceMessageBuilder("treeEnded").toString(), ProcessOutputTypes.STDOUT);
    }

    private final void runTests(DatabaseConnection c, MultiMap<String, String> tests) {
        NoisyStatement stmt = SmartStatements.Companion.poweredBy(c).simple().noisy();
        for (Map.Entry entry : tests.entrySet()) {
            Intrinsics.checkNotNull((Object)entry);
            String suite = (String)entry.getKey();
            Collection suiteTests = (Collection)entry.getValue();
            Intrinsics.checkNotNull((Object)suite);
            Intrinsics.checkNotNull((Object)suiteTests);
            this.runSuite((NoisyStatement<String>)stmt, suite, suiteTests);
        }
    }

    private final void runSuite(NoisyStatement<String> stmt, String suite, Collection<String> tests) {
        this.notifyTextAvailable(new TestSuiteStarted(suite).asString(), ProcessOutputTypes.STDOUT);
        for (String test : tests) {
            this.runTest(stmt, suite, test);
        }
        this.notifyTextAvailable(new TestSuiteFinished(suite).asString(), ProcessOutputTypes.STDOUT);
    }

    private final void runTest(NoisyStatement<String> stmt, String suite, String test) {
        this.notifyTextAvailable(new TestStarted(test, true, this.locationHint(suite, test)).asString(), ProcessOutputTypes.STDOUT);
        NoisyStatement.execute$default(stmt, (Object)("exec tSQLt.RunWithNullResults " + ScriptGeneratorHelperKt.getSqlString((String)(suite + "." + test))), null, (int)2, null);
        boolean $i$f$first = false;
        Triple result = (Triple)stmt.execute((Object)("select Result, Msg, DateDiff(ms, TestStartTime, TestEndTime) Duration from tSQLt.TestResult where Class = " + ScriptGeneratorHelperKt.getSqlString((String)suite) + " and TestCase = " + ScriptGeneratorHelperKt.getSqlString((String)test)), (ExecutionMode)StandardExecutionMode.QUERY, (ResultsProducer.VoidReadyProcessor)new ResultsProducer.VoidReadyProcessor<Triple<? extends String, ? extends String, ? extends Integer>>(){

            public Triple<? extends String, ? extends String, ? extends Integer> empty() {
                Object it = null;
                boolean bl = false;
                return null;
            }

            public Triple<? extends String, ? extends String, ? extends Integer> results(RemoteResultSet resultSet, int subQueryIndex, int resultSetIndex, ResultsProducer.ReferenceInfo referenceInfo, Function2<? super RemoteResultSet, ? super ResultsProducer.ReferenceInfo, Unit> referenceConsumer) {
                Triple triple;
                Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
                Intrinsics.checkNotNullParameter(referenceConsumer, (String)"referenceConsumer");
                RemoteResultSet it = resultSet.next() ? resultSet : null;
                boolean bl = false;
                RemoteResultSet remoteResultSet = it;
                if (remoteResultSet != null) {
                    RemoteResultSet $this$runTest_u24lambda_u240_u240 = remoteResultSet;
                    boolean bl2 = false;
                    triple = new Triple((Object)$this$runTest_u24lambda_u240_u240.getString(1), (Object)$this$runTest_u24lambda_u240_u240.getString(2), (Object)$this$runTest_u24lambda_u240_u240.getInt(3));
                } else {
                    triple = null;
                }
                return triple;
            }

            public Triple<? extends String, ? extends String, ? extends Integer> parameterResults(List<? extends OutParameter<?>> parameters, int subQueryIndex, int resultSetIndex, Function1<? super OutParameter<?>, ? extends Object> retriever) {
                Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
                Intrinsics.checkNotNullParameter(retriever, (String)"retriever");
                Object it = null;
                boolean bl = false;
                return null;
            }

            public Triple<? extends String, ? extends String, ? extends Integer> updateCount(int count) {
                Object it = null;
                boolean bl = false;
                return null;
            }
        });
        this.processTestResult((Triple<String, String, Integer>)result, test);
    }

    private final String locationHint(String suite, String test) {
        String string = test;
        return string != null ? "db://" + suite + "." + string : "db://" + suite;
    }

    private final void processTestResult(Triple<String, String, Integer> result, String test) {
        String resMessage;
        String string;
        String string2;
        Triple<String, String, Integer> triple = result;
        String string3 = string2 = triple != null ? (String)triple.getFirst() : null;
        if (Intrinsics.areEqual((Object)string2, (Object)"Success")) {
            if (StringUtil.isNotEmpty((String)((String)result.getSecond()))) {
                this.notifyTextAvailable((String)result.getSecond(), ProcessOutputTypes.STDOUT);
            }
            string = null;
        } else if (Intrinsics.areEqual((Object)string2, (Object)"Failure")) {
            ServiceMessageBuilder serviceMessageBuilder;
            ServiceMessageBuilder $this$processTestResult_u24lambda_u240 = serviceMessageBuilder = ServiceMessageBuilder.testFailed((String)test);
            boolean bl = false;
            MatchResult m = this.expected.matchEntire((CharSequence)result.getSecond());
            if (m == null) {
                $this$processTestResult_u24lambda_u240.addAttribute("message", (String)result.getSecond());
            } else {
                List it = m.getGroupValues();
                boolean bl2 = false;
                $this$processTestResult_u24lambda_u240.addAttribute("actual", (String)it.get(1));
                $this$processTestResult_u24lambda_u240.addAttribute("expected", (String)it.get(2));
                $this$processTestResult_u24lambda_u240.addAttribute("type", "comparisonFailure");
            }
            string = serviceMessageBuilder.toString();
        } else {
            Object object;
            if (result != null) {
                this.notifyTextAvailable("Unknown status " + result.getFirst(), ProcessOutputTypes.STDERR);
            }
            if ((object = result) == null || (object = (String)object.getSecond()) == null) {
                object = "Not run by tSQLt";
            }
            string = new TestIgnored(test, object).asString();
        }
        String string4 = resMessage = string;
        if (string4 != null) {
            String it = string4;
            boolean bl = false;
            this.notifyTextAvailable(it, ProcessOutputTypes.STDOUT);
        }
        Triple<String, String, Integer> triple2 = result;
        this.notifyTextAvailable(new TestFinished(test, triple2 != null ? ((Number)triple2.getThird()).intValue() : 0).asString(), ProcessOutputTypes.STDOUT);
    }

    private final MultiMap<String, String> getTests(DatabaseConnection c) {
        MultiMap multiMap = MultiMap.createSet();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createSet(...)");
        MultiMap tests = multiMap;
        for (String path : this.paths) {
            int dot = StringsKt.indexOf$default((CharSequence)path, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (dot != -1) {
                String string = path.substring(0, dot);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string2 = path.substring(dot + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                tests.putValue((Object)string, (Object)string2);
                continue;
            }
            tests.putValues((Object)path, (Collection)SmartStatements.Companion.poweredBy(c).simple().noisy().execute((Object)("select Name from tSQLt.Tests where TestClassName = " + ScriptGeneratorHelperKt.getSqlString((String)path)), StandardResultsProcessors.listOfStrings((int)1)));
        }
        if (this.paths.isEmpty()) {
            SmartStatements.Companion.poweredBy(c).simple().noisy().execute((Object)"select TestClassName, Name from tSQLt.Tests", StandardResultsProcessors.firstResult(arg_0 -> TSqltHandler.getTests$lambda$0(tests, arg_0)));
        }
        return tests;
    }

    private static final AsyncTask start$lambda$0(TSqltHandler this$0) {
        String string = DatabaseBundle.message((String)"progress.title.run.tsqlt.tests", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return AsyncTask.Companion.frame(string).computeAsync(null, () -> TSqltHandler.start$lambda$0$0(this$0));
    }

    /*
     * WARNING - void declaration
     */
    private static final AsyncTask start$lambda$0$0(TSqltHandler this$0) {
        ObjectPath objectPath;
        Project project = this$0.project;
        DatabaseConnectionPoint databaseConnectionPoint = (DatabaseConnectionPoint)this$0.ds;
        DatabaseCredentials databaseCredentials = null;
        String string = this$0.db;
        if (string != null) {
            void it;
            String string2 = string;
            DatabaseCredentials databaseCredentials2 = databaseCredentials;
            DatabaseConnectionPoint databaseConnectionPoint2 = databaseConnectionPoint;
            Project project2 = project;
            boolean bl = false;
            ObjectPath objectPath2 = ObjectPath.create((String)it, (ObjectKind)ObjectKind.DATABASE);
            project = project2;
            databaseConnectionPoint = databaseConnectionPoint2;
            databaseCredentials = databaseCredentials2;
            objectPath = objectPath2;
        } else {
            objectPath = null;
        }
        return DatabaseSessionManager.getFacade((Project)project, (DatabaseConnectionPoint)databaseConnectionPoint, databaseCredentials, (SearchPath)SearchPath.of(objectPath), (boolean)false, null, (DatabaseDepartment)((DatabaseDepartment)DGDepartment.TEST_RUNNER)).runAsync(arg_0 -> TSqltHandler.start$lambda$0$0$1(this$0, arg_0));
    }

    private static final Unit start$lambda$0$0$1(TSqltHandler this$0, InterruptibleDatabaseConnection c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        MultiMap<String, String> tests = this$0.getTests((DatabaseConnection)c);
        this$0.prepareTree(tests);
        this$0.runTests((DatabaseConnection)c, tests);
        return Unit.INSTANCE;
    }

    private static final void getTests$lambda$0(MultiMap $tests, RemoteResultSet it) {
        $tests.putValue((Object)it.getString(1), (Object)it.getString(2));
    }
}

