/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.frontend.split.configurations;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.TargetAwareRunProfile;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.platform.execution.frontend.split.configurations.RunConfigurationOverProtocol;
import com.intellij.platform.execution.frontend.split.configurations.ThinClientRunContentHost;
import com.intellij.platform.execution.frontend.split.console.BeControlConsoleView;
import com.intellij.platform.execution.frontend.split.console.ThinClientConsoleViewWrapper;
import com.intellij.platform.execution.frontend.split.tests.ThinClientTestConsoleProperties;
import com.intellij.platform.frontend.split.FrontendProcessInfo;
import com.intellij.terminal.TerminalExecutionConsole;
import com.jetbrains.codeWithMe.model.BackendRunProcessModel;
import com.jetbrains.codeWithMe.model.CodeWithMeRunConfigurationModel;
import com.jetbrains.codeWithMe.model.CwmRunConfigurationExecuteArgs;
import com.jetbrains.codeWithMe.model.ExecutionConsoleKind;
import com.jetbrains.codeWithMe.model.RunnerLayoutUiModel;
import com.jetbrains.codeWithMe.model.SessionPortForwarding;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.rd.framework.impl.RdCall;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.thinclient.ConsoleViewUtilsKt;
import com.jetbrains.thinclient.PlatformFrontendSplitBundle;
import com.jetbrains.thinclient.ThinClientFakeProcessHandler;
import com.jetbrains.thinclient.portForwarding.ThinClientPortForwardingConsoleWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 (2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002'(B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0014\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0013H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00000\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0000H\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\tH\u0016J\b\u0010&\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/platform/execution/frontend/split/configurations/ThinClientRunConfiguration;", "Lcom/intellij/platform/execution/frontend/split/configurations/RunConfigurationOverProtocol;", "Lcom/intellij/execution/configurations/RunConfiguration;", "Lcom/intellij/execution/configurations/TargetAwareRunProfile;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "model", "Lcom/jetbrains/codeWithMe/model/CodeWithMeRunConfigurationModel;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Lcom/jetbrains/codeWithMe/model/CodeWithMeRunConfigurationModel;)V", "getModel", "()Lcom/jetbrains/codeWithMe/model/CodeWithMeRunConfigurationModel;", "name", "", "icon", "Ljavax/swing/Icon;", "getName", "setName", "", "getIcon", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "canRunOn", "", "target", "Lcom/intellij/execution/ExecutionTarget;", "clone", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getFactory", "getProject", "RunConfigurationFakeProcessHandler", "Companion", "intellij.platform.execution.frontend.split"})
@SourceDebugExtension(value={"SMAP\nThinClientRunConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinClientRunConfiguration.kt\ncom/intellij/platform/execution/frontend/split/configurations/ThinClientRunConfiguration\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,186:1\n13#2:187\n*S KotlinDebug\n*F\n+ 1 ThinClientRunConfiguration.kt\ncom/intellij/platform/execution/frontend/split/configurations/ThinClientRunConfiguration\n*L\n184#1:187\n*E\n"})
public final class ThinClientRunConfiguration
implements RunConfigurationOverProtocol,
RunConfiguration,
TargetAwareRunProfile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Project project;
    @NotNull
    private final ConfigurationFactory factory;
    @NotNull
    private final CodeWithMeRunConfigurationModel model;
    @NotNull
    private String name;
    @Nullable
    private final Icon icon;
    @NotNull
    private static final Key<BackendRunProcessModel> runProcessModelKey;
    @NotNull
    private static final Logger logger;

    public ThinClientRunConfiguration(@NotNull Lifetime lifetime, @NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull CodeWithMeRunConfigurationModel model) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.lifetime = lifetime;
        this.project = project;
        this.factory = factory;
        this.model = model;
        this.name = this.getModel().getName();
        IconModel iconModel = this.getModel().getIcon();
        this.icon = iconModel != null ? UtilKt.fromModel((IconModel)iconModel) : null;
    }

    @Override
    @NotNull
    public CodeWithMeRunConfigurationModel getModel() {
        return this.model;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
    }

    @Nullable
    public Icon getIcon() {
        return this.icon;
    }

    @NotNull
    public SettingsEditor<ThinClientRunConfiguration> getConfigurationEditor() {
        return (SettingsEditor)new SettingsEditor<ThinClientRunConfiguration>(){

            protected void resetEditorFrom(ThinClientRunConfiguration s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            }

            protected void applyEditorTo(ThinClientRunConfiguration s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            }

            protected JComponent createEditor() {
                return new JLabel(PlatformFrontendSplitBundle.INSTANCE.message("edit.run.configuration.not.supported", new Object[0]), AllIcons.General.Warning, 2);
            }
        };
    }

    public boolean canRunOn(@NotNull ExecutionTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return this.getModel().getCanRunDefaultTarget() || !Intrinsics.areEqual((Object)target, (Object)DefaultExecutionTarget.INSTANCE);
    }

    @NotNull
    public ThinClientRunConfiguration clone() {
        return new ThinClientRunConfiguration(this.lifetime, this.project, this.factory, this.getModel());
    }

    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        ThinClientRunConfiguration thinClientRunConfiguration = this;
        BackendRunProcessModel processModel = (BackendRunProcessModel)environment.getUserData(runProcessModelKey);
        if (processModel == null || processModel.getExecutionId() != environment.getExecutionId()) {
            return (arg_0, arg_1) -> ThinClientRunConfiguration.getState$lambda$0(this, executor, arg_0, arg_1);
        }
        return (arg_0, arg_1) -> ThinClientRunConfiguration.getState$lambda$1(this, processModel, thinClientRunConfiguration, executor, environment, arg_0, arg_1);
    }

    @NotNull
    public ConfigurationFactory getFactory() {
        return this.factory;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    private static final ExecutionResult getState$lambda$0(ThinClientRunConfiguration this$0, Executor $executor, Executor innerExecutor, ProgramRunner programRunner) {
        Intrinsics.checkNotNullParameter((Object)programRunner, (String)"<unused var>");
        RdCall rdCall = this$0.getModel().getExecute();
        Executor executor = innerExecutor;
        if (executor == null) {
            executor = $executor;
        }
        String string = executor.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        rdCall.start((Object)new CwmRunConfigurationExecuteArgs(string));
        return null;
    }

    private static final ExecutionResult getState$lambda$1(ThinClientRunConfiguration this$0, BackendRunProcessModel $processModel, ThinClientRunConfiguration $thinClientRunConfiguration, Executor $executor, ExecutionEnvironment $environment, Executor executor, ProgramRunner programRunner) {
        ConsoleView consoleView2;
        ConsoleView consoleViewWithPortForwarding;
        ConsoleView consoleView3;
        Intrinsics.checkNotNullParameter((Object)programRunner, (String)"<unused var>");
        RunConfigurationFakeProcessHandler processHandler = new RunConfigurationFakeProcessHandler(this$0.project, $processModel);
        ArrayList<AnAction> additionalActions = new ArrayList<AnAction>();
        if (((CharSequence)$processModel.getTestFramework()).length() > 0) {
            BaseTestsOutputConsoleView baseTestsOutputConsoleView;
            ThinClientTestConsoleProperties testConsoleProperties = new ThinClientTestConsoleProperties($thinClientRunConfiguration, $executor, $environment.getExecutionId(), $processModel.getTestFramework(), $processModel.getConsoleTextControlId());
            testConsoleProperties.setIdBasedTestTree($processModel.getIdBased());
            BaseTestsOutputConsoleView $this$getState_u24lambda_u241_u240 = baseTestsOutputConsoleView = SMTestRunnerConnectionUtil.createConsole((String)$processModel.getTestFramework(), (TestConsoleProperties)((TestConsoleProperties)testConsoleProperties));
            boolean bl = false;
            $this$getState_u24lambda_u241_u240.attachToProcess((ProcessHandler)processHandler);
            additionalActions.add(ActionManager.getInstance().getAction("RerunFailedTests"));
            var10_16 = baseTestsOutputConsoleView;
            Intrinsics.checkNotNull((Object)var10_16);
            consoleView3 = (ConsoleView)var10_16;
        } else if ($processModel.getExecutionConsoleKind() == ExecutionConsoleKind.TerminalExecutionConsole) {
            TerminalExecutionConsole $this$getState_u24lambda_u241_u241 = var10_16 = new TerminalExecutionConsole(this$0.project, (ProcessHandler)processHandler);
            boolean bl = false;
            ConsoleViewUtilsKt.syncToConsole((ISignal)((ISignal)$processModel.getConsoleOutput()), (Lifetime)this$0.lifetime, (ConsoleView)((ConsoleView)$this$getState_u24lambda_u241_u241));
            consoleView3 = (ConsoleView)var10_16;
        } else if ($processModel.getExecutionConsoleKind() == ExecutionConsoleKind.BeControlledConsole) {
            beControl = $processModel.getLanguageConsoleBeControl();
            if (beControl == null) {
                logger.error("executionConsoleKind is LanguageConsoleImpl, but languageConsoleBeControl is null");
                consoleView3 = (ConsoleView)new ConsoleViewImpl(this$0.project, true);
            } else {
                consoleView3 = new BeControlConsoleView(this$0.lifetime, beControl);
            }
        } else {
            BeControl $this$getState_u24lambda_u241_u242 = beControl = ThinClientRunContentHost.Companion.createLanguageConsole$intellij_platform_execution_frontend_split(this$0.project, $processModel.getConsoleTextControlId(), (ISignal<String>)((ISignal)$processModel.getGuestInput()));
            boolean bl = false;
            $this$getState_u24lambda_u241_u242.attachToProcess((ProcessHandler)processHandler);
            ConsoleViewUtilsKt.syncToConsole((ISignal)((ISignal)$processModel.getConsoleOutput()), (Lifetime)this$0.lifetime, (ConsoleView)((ConsoleView)$this$getState_u24lambda_u241_u242));
            consoleView3 = (ConsoleView)beControl;
        }
        ConsoleView rawConsoleView = consoleView3;
        SessionPortForwarding pfModel = $processModel.getPortForwarding();
        ConsoleView consoleView4 = consoleViewWithPortForwarding = FrontendProcessInfo.INSTANCE.isController() && pfModel != null ? (ConsoleView)new ThinClientPortForwardingConsoleWrapper(rawConsoleView, this$0.project, this$0.lifetime, pfModel) : rawConsoleView;
        if ($processModel.getRunnerLayoutUiModel() != null) {
            RunnerLayoutUiModel runnerLayoutUiModel = $processModel.getRunnerLayoutUiModel();
            Intrinsics.checkNotNull((Object)runnerLayoutUiModel);
            consoleView2 = (ConsoleView)new ThinClientConsoleViewWrapper(consoleViewWithPortForwarding, runnerLayoutUiModel, this$0.lifetime);
        } else {
            consoleView2 = consoleViewWithPortForwarding;
        }
        ConsoleView consoleView5 = consoleView2;
        String contentToolWindowId = $processModel.getContentToolWindowId();
        if (contentToolWindowId != null && ToolWindowManager.Companion.getInstance(this$0.project).getToolWindow(contentToolWindowId) != null) {
            processHandler.putUserData(RunContentDescriptor.CONTENT_TOOL_WINDOW_ID_KEY, contentToolWindowId);
        }
        DefaultExecutionResult result = new DefaultExecutionResult((ExecutionConsole)consoleView5, (ProcessHandler)processHandler);
        AnAction[] anActionArray = additionalActions.toArray(AnAction.EMPTY_ARRAY);
        result.setRestartActions(Arrays.copyOf(anActionArray, anActionArray.length));
        return (ExecutionResult)result;
    }

    static {
        Key key = Key.create((String)"BACKEND_RUN_PROCESS_MODEL");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        runProcessModelKey = key;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ThinClientRunConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ThinClientRunConfiguration.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/execution/frontend/split/configurations/ThinClientRunConfiguration$Companion;", "", "<init>", "()V", "runProcessModelKey", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/codeWithMe/model/BackendRunProcessModel;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getRunProcessModelKey", "()Lcom/intellij/openapi/util/Key;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.execution.frontend.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<BackendRunProcessModel> getRunProcessModelKey() {
            return runProcessModelKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/execution/frontend/split/configurations/ThinClientRunConfiguration$RunConfigurationFakeProcessHandler;", "Lcom/jetbrains/thinclient/ThinClientFakeProcessHandler;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/jetbrains/codeWithMe/model/BackendRunProcessModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/codeWithMe/model/BackendRunProcessModel;)V", "getModel", "()Lcom/jetbrains/codeWithMe/model/BackendRunProcessModel;", "destroyProcessImpl", "", "intellij.platform.execution.frontend.split"})
    public static final class RunConfigurationFakeProcessHandler
    extends ThinClientFakeProcessHandler {
        @NotNull
        private final BackendRunProcessModel model;

        public RunConfigurationFakeProcessHandler(@NotNull Project project, @NotNull BackendRunProcessModel model) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            super(project);
            this.model = model;
        }

        @NotNull
        public final BackendRunProcessModel getModel() {
            return this.model;
        }

        protected void destroyProcessImpl() {
            super.destroyProcessImpl();
            this.model.getTerminateFromFrontend().fire((Object)Unit.INSTANCE);
        }
    }
}

