/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.frontend.split.debugger;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.platform.execution.frontend.split.debugger.ProtocolUtilsKt;
import com.intellij.platform.execution.frontend.split.debugger.ThinClientBreakpointConditionEditorsProvider;
import com.intellij.platform.execution.frontend.split.debugger.ThinClientDebuggerEvaluatorKt;
import com.intellij.platform.execution.frontend.split.debugger.ThinClientEditorsProviderBase;
import com.intellij.platform.execution.frontend.split.debugger.ThinExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.codeWithMe.model.BreakpointConditionInfo;
import com.jetbrains.codeWithMe.model.SourcePositionModel;
import com.jetbrains.rd.ide.model.DocumentExtension;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.SourcePositionBase;
import com.jetbrains.rd.util.Boxed;
import com.jetbrains.rdclient.document.FrontendDocumentExtensionsProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/execution/frontend/split/debugger/ThinClientBreakpointConditionProvider;", "Lcom/jetbrains/rdclient/document/FrontendDocumentExtensionsProvider;", "<init>", "()V", "getExtensions", "", "Lcom/jetbrains/rd/ide/model/DocumentExtension;", "document", "Lcom/intellij/openapi/editor/Document;", "Companion", "intellij.platform.execution.frontend.split"})
@SourceDebugExtension(value={"SMAP\nThinClientBreakpointConditionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinClientBreakpointConditionProvider.kt\ncom/intellij/platform/execution/frontend/split/debugger/ThinClientBreakpointConditionProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,37:1\n23#2:38\n13#2:39\n*S KotlinDebug\n*F\n+ 1 ThinClientBreakpointConditionProvider.kt\ncom/intellij/platform/execution/frontend/split/debugger/ThinClientBreakpointConditionProvider\n*L\n28#1:38\n35#1:39\n*E\n"})
public final class ThinClientBreakpointConditionProvider
implements FrontendDocumentExtensionsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    @NotNull
    public List<DocumentExtension> getExtensions(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (ThinClientEditorsProviderBase.Companion.getProviderKind(document) != ThinClientEditorsProviderBase.Kind.BreakpointCondition) {
            return CollectionsKt.emptyList();
        }
        Boxed<XSourcePosition> boxed = ThinClientEditorsProviderBase.Companion.getSourcePosition(document);
        if (boxed == null) {
            return CollectionsKt.emptyList();
        }
        Boxed<XSourcePosition> position = boxed;
        XSourcePosition xSourcePosition = (XSourcePosition)position.getValue();
        SourcePositionModel positionModel = xSourcePosition != null ? ProtocolUtilsKt.toModel(xSourcePosition) : null;
        String string = ThinClientBreakpointConditionEditorsProvider.Companion.getBreakpointId(document);
        if (string == null) {
            ThinClientBreakpointConditionProvider $this$getExtensions_u24lambda_u240 = this;
            boolean bl = false;
            logger.error("Breakpoint id is null, can't create document extension for breakpoint condition");
            return CollectionsKt.emptyList();
        }
        String breakpointId = string;
        ThinExpression thinExpression = ThinClientEditorsProviderBase.Companion.getInitialExpression(document);
        if (thinExpression == null) {
            String string2 = document.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            thinExpression = ThinExpression.Companion.createDefault(string2);
        }
        ThinExpression expression = thinExpression;
        RdProjectId rdProjectId = ThinClientEditorsProviderBase.Companion.getDebuggerRdProjectId(document);
        if (rdProjectId == null) {
            boolean bl = false;
            ThinClientBreakpointConditionProvider $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ThinClientBreakpointConditionProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("rdProjectId is not set for document: " + document);
            return CollectionsKt.emptyList();
        }
        RdProjectId projectId = rdProjectId;
        return CollectionsKt.listOf((Object)new BreakpointConditionInfo(projectId, ThinClientDebuggerEvaluatorKt.toCodeWithMeExpressionModel(expression), breakpointId, (SourcePositionBase)positionModel));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ThinClientBreakpointConditionProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ThinClientBreakpointConditionProvider.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/execution/frontend/split/debugger/ThinClientBreakpointConditionProvider$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.execution.frontend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

