/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl.classFiles;

import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationOwner;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.MutableJavaAnnotationOwner;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryClassSignatureParser;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaAnnotationVisitor;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaMethod;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaMethodBase;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaValueParameter;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.ClassifierResolutionContext;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.TypePath;
import org.jetbrains.org.objectweb.asm.TypeReference;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\tH\u0016J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\"\u0010!\u001a\u0004\u0018\u00010\u00152\u0006\u0010\"\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J,\u0010#\u001a\u0004\u0018\u00010\u00152\u0006\u0010$\u001a\u00020\t2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/AnnotationsAndParameterCollectorMethodVisitor;", "Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "member", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryJavaMethodBase;", "context", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext;", "signatureParser", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser;", "parametersToSkipNumber", "", "parametersCountInMethodDesc", "<init>", "(Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryJavaMethodBase;Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext;Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser;II)V", "parameterIndex", "visibleAnnotableParameterCount", "invisibleAnnotableParameterCount", "freshlySupportedPositions", "", "getFreshlySupportedPositions", "()Ljava/util/Set;", "visitAnnotationDefault", "Lorg/jetbrains/org/objectweb/asm/AnnotationVisitor;", "visitParameter", "", "name", "", "access", "visitAnnotation", "desc", "visible", "", "visitAnnotableParameterCount", "parameterCount", "visitParameterAnnotation", "parameter", "visitTypeAnnotation", "typeRef", "typePath", "Lorg/jetbrains/org/objectweb/asm/TypePath;", "descriptor", "frontend.common.jvm"})
public final class AnnotationsAndParameterCollectorMethodVisitor
extends MethodVisitor {
    @NotNull
    private final BinaryJavaMethodBase member;
    @NotNull
    private final ClassifierResolutionContext context;
    @NotNull
    private final BinaryClassSignatureParser signatureParser;
    private final int parametersToSkipNumber;
    private final int parametersCountInMethodDesc;
    private int parameterIndex;
    private int visibleAnnotableParameterCount;
    private int invisibleAnnotableParameterCount;
    @NotNull
    private final Set<Integer> freshlySupportedPositions;

    public AnnotationsAndParameterCollectorMethodVisitor(@NotNull BinaryJavaMethodBase member, @NotNull ClassifierResolutionContext context, @NotNull BinaryClassSignatureParser signatureParser, int parametersToSkipNumber, int parametersCountInMethodDesc) {
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)signatureParser, (String)"signatureParser");
        super(589824);
        this.member = member;
        this.context = context;
        this.signatureParser = signatureParser;
        this.parametersToSkipNumber = parametersToSkipNumber;
        this.visibleAnnotableParameterCount = this.parametersCountInMethodDesc = parametersCountInMethodDesc;
        this.invisibleAnnotableParameterCount = this.parametersCountInMethodDesc;
        Object[] objectArray = new Integer[]{1, 18};
        this.freshlySupportedPositions = SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    public final Set<Integer> getFreshlySupportedPositions() {
        return this.freshlySupportedPositions;
    }

    @NotNull
    public AnnotationVisitor visitAnnotationDefault() {
        return new BinaryJavaAnnotationVisitor(this.context, this.signatureParser, (Function1<? super JavaAnnotationArgument, Unit>)((Function1)arg_0 -> AnnotationsAndParameterCollectorMethodVisitor.visitAnnotationDefault$lambda$0(this, arg_0)));
    }

    public void visitParameter(@Nullable String name2, int access) {
        int index;
        if (name2 != null && (index = this.parameterIndex - this.parametersToSkipNumber) >= 0) {
            BinaryJavaValueParameter binaryJavaValueParameter = (BinaryJavaValueParameter)CollectionsKt.getOrNull(this.member.getValueParameters(), (int)index);
            if (binaryJavaValueParameter == null) {
                throw new IllegalStateException(("No parameter with index " + this.parameterIndex + '-' + this.parametersToSkipNumber + " (name=" + name2 + " access=" + access + ") in method " + this.member.getContainingClass().getFqName() + '.' + this.member.getName()).toString());
            }
            BinaryJavaValueParameter parameter = binaryJavaValueParameter;
            Name name3 = Name.identifier(name2);
            Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
            parameter.updateName$frontend_common_jvm(name3);
        }
        int n = this.parameterIndex;
        this.parameterIndex = n + 1;
    }

    @NotNull
    public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        return BinaryJavaAnnotation.Companion.addAnnotation$default(BinaryJavaAnnotation.Companion, this.member, desc, this.context, this.signatureParser, false, 16, null);
    }

    public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
        if (visible) {
            this.visibleAnnotableParameterCount = parameterCount;
        } else {
            this.invisibleAnnotableParameterCount = parameterCount;
        }
    }

    @Nullable
    public AnnotationVisitor visitParameterAnnotation(int parameter, @NotNull String desc, boolean visible) {
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        int absoluteParameterIndex = parameter + this.parametersCountInMethodDesc - (visible ? this.visibleAnnotableParameterCount : this.invisibleAnnotableParameterCount);
        int index = absoluteParameterIndex - this.parametersToSkipNumber;
        if (index < 0) {
            return null;
        }
        return BinaryJavaAnnotation.Companion.addAnnotation$default(BinaryJavaAnnotation.Companion, this.member.getValueParameters().get(index), desc, this.context, this.signatureParser, false, 16, null);
    }

    @Nullable
    public AnnotationVisitor visitTypeAnnotation(int typeRef, @Nullable TypePath typePath, @NotNull String descriptor2, boolean visible) {
        Pair<JavaType, Boolean> pair;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        TypeReference typeReference = new TypeReference(typeRef);
        switch (typeReference.getSort()) {
            case 20: {
                BinaryJavaMethodBase binaryJavaMethodBase = this.member;
                JavaAnnotationOwner javaAnnotationOwner = binaryJavaMethodBase instanceof BinaryJavaMethod ? (BinaryJavaMethod)binaryJavaMethodBase : null;
                if (javaAnnotationOwner == null || (javaAnnotationOwner = javaAnnotationOwner.getReturnType()) == null) {
                    return null;
                }
                pair = AnnotationsAndParameterCollectorMethodVisitor.visitTypeAnnotation$getTargetType(typePath, this, typeReference, (JavaType)javaAnnotationOwner);
                break;
            }
            case 1: {
                pair = TuplesKt.to((Object)this.member.getTypeParameters().get(typeReference.getTypeParameterIndex()), (Object)true);
                break;
            }
            case 22: {
                pair = AnnotationsAndParameterCollectorMethodVisitor.visitTypeAnnotation$getTargetType(typePath, this, typeReference, this.member.getValueParameters().get(typeReference.getFormalParameterIndex()).getType());
                break;
            }
            case 18: {
                pair = AnnotationsAndParameterCollectorMethodVisitor.visitTypeAnnotation$getTargetType(typePath, this, typeReference, BinaryJavaAnnotation.Companion.computeTypeParameterBound$frontend_common_jvm(this.member.getTypeParameters(), typeReference));
                break;
            }
            default: {
                return null;
            }
        }
        Pair<JavaType, Boolean> pair2 = pair;
        JavaAnnotationOwner annotationOwner = (JavaAnnotationOwner)pair2.component1();
        boolean isFreshlySupportedAnnotation = (Boolean)pair2.component2();
        if (!(annotationOwner instanceof MutableJavaAnnotationOwner)) {
            return null;
        }
        return BinaryJavaAnnotation.Companion.addAnnotation((MutableJavaAnnotationOwner)annotationOwner, descriptor2, this.context, this.signatureParser, isFreshlySupportedAnnotation);
    }

    private static final Unit visitAnnotationDefault$lambda$0(AnnotationsAndParameterCollectorMethodVisitor this$0, JavaAnnotationArgument it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            BinaryJavaMethodBase binaryJavaMethodBase = this$0.member;
            BinaryJavaMethod binaryJavaMethod = binaryJavaMethodBase instanceof BinaryJavaMethod ? (BinaryJavaMethod)binaryJavaMethodBase : null;
            if (binaryJavaMethod == null) break block0;
            binaryJavaMethod.setAnnotationParameterDefaultValue$frontend_common_jvm(it);
        }
        return Unit.INSTANCE;
    }

    private static final Pair<JavaType, Boolean> visitTypeAnnotation$getTargetType(TypePath $typePath, AnnotationsAndParameterCollectorMethodVisitor this$0, TypeReference typeReference, JavaType baseType) {
        return $typePath != null ? TuplesKt.to((Object)BinaryJavaAnnotation.Companion.computeTargetType$frontend_common_jvm(baseType, $typePath), (Object)true) : TuplesKt.to((Object)baseType, (Object)this$0.freshlySupportedPositions.contains(typeReference.getSort()));
    }
}

