/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.async;

import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.model.CallWithValue;
import com.intellij.profiler.model.CantBeParsedCall;
import com.intellij.profiler.model.NativeCall;
import com.intellij.profiler.model.ThreadInfo;
import com.intellij.profiler.ultimate.jfr.JFRMethodCall;
import com.intellij.profiler.ultimate.jfr.events.JfrEvents;
import com.intellij.profiler.ultimate.jfr.events.JfrThreadTimelineData;
import com.intellij.profiler.ultimate.jfr.events.JfrThreadTimestampInfoStorage;
import com.intellij.profiler.ultimate.jfr.events.JfrTimelineEvents;
import com.intellij.profiler.ultimate.jfr.ui.JfrTimelineEventKind;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\"B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\t\u001a\u00020\nJ0\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00050\u000fH\u0002J0\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00050\u000f2\u0006\u0010\u0014\u001a\u00020\rH\u0002J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u0005H\u0002J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00062\u0006\u0010!\u001a\u00020\u0006H\u0002\u00a8\u0006#"}, d2={"Lcom/intellij/profiler/ultimate/async/JFRThreadDumpExtractor;", "", "<init>", "()V", "extractThreadDumps", "", "", "parsedEvents", "Lcom/intellij/profiler/ultimate/jfr/events/JfrEvents;", "sampleCount", "", "findTimeRange", "Lkotlin/Pair;", "", "timelineData", "", "Lcom/intellij/profiler/model/ThreadInfo;", "Lcom/intellij/profiler/ultimate/jfr/events/JfrThreadTimelineData;", "getThreadStatesAt", "Lcom/intellij/profiler/ultimate/async/JFRThreadDumpExtractor$ThreadState;", "offset", "extractStackTrace", "stackNode", "Lcom/intellij/profiler/model/CallTreeNode;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "mapKindToThreadState", "kind", "Lcom/intellij/profiler/ultimate/jfr/ui/JfrTimelineEventKind;", "createJFRThreadDump", "threadStates", "mapJFRState", "state", "extractSourceFileName", "className", "ThreadState", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nJFRThreadDumpExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JFRThreadDumpExtractor.kt\ncom/intellij/profiler/ultimate/async/JFRThreadDumpExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 JfrEventType.kt\ncom/intellij/profiler/ultimate/jfr/events/JfrThreadTimestampInfoStorage\n*L\n1#1,198:1\n1374#2:199\n1460#2,5:200\n1056#2:230\n382#3,7:205\n196#4,9:212\n196#4,9:221\n*S KotlinDebug\n*F\n+ 1 JFRThreadDumpExtractor.kt\ncom/intellij/profiler/ultimate/async/JFRThreadDumpExtractor\n*L\n24#1:199\n24#1:200,5\n156#1:230\n33#1:205,7\n70#1:212,9\n94#1:221,9\n*E\n"})
public final class JFRThreadDumpExtractor {
    @NotNull
    public static final JFRThreadDumpExtractor INSTANCE = new JFRThreadDumpExtractor();

    private JFRThreadDumpExtractor() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> extractThreadDumps(@NotNull List<JfrEvents> parsedEvents, int sampleCount) {
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(parsedEvents, (String)"parsedEvents");
        Iterable $this$flatMap$iv = parsedEvents;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            JfrEvents it = (JfrEvents)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getTimelineEvents();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List timelineEvents = (List)destination$iv$iv;
        if (timelineEvents.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Map allTimelineData = new LinkedHashMap();
        for (JfrTimelineEvents timelineEvent : timelineEvents) {
            for (Map.Entry<ThreadInfo, JfrThreadTimelineData> $i$f$flatMapTo2 : timelineEvent.getTimelineRepository().entrySet()) {
                Object object;
                void $this$getOrPut$iv;
                ThreadInfo thread = $i$f$flatMapTo2.getKey();
                JfrThreadTimelineData data2 = $i$f$flatMapTo2.getValue();
                list$iv$iv = allTimelineData;
                ThreadInfo key$iv = thread;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(data2);
            }
        }
        if (allTimelineData.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Pair<Long, Long> pair = this.findTimeRange(allTimelineData);
        if (pair == null) {
            return CollectionsKt.emptyList();
        }
        Pair<Long, Long> timeRange = pair;
        long duration = ((Number)timeRange.getSecond()).longValue() - ((Number)timeRange.getFirst()).longValue();
        if (duration <= 0L) {
            return CollectionsKt.emptyList();
        }
        List threadDumps = new ArrayList();
        long interval = duration / (long)(sampleCount + 1);
        int i = 1;
        if (i <= sampleCount) {
            while (true) {
                List<ThreadState> threadStatesAtTime;
                if (!((Collection)(threadStatesAtTime = this.getThreadStatesAt(allTimelineData, ((Number)timeRange.getFirst()).longValue() + interval * (long)i))).isEmpty()) {
                    String threadDump = this.createJFRThreadDump(threadStatesAtTime);
                    threadDumps.add(threadDump);
                }
                if (i == sampleCount) break;
                ++i;
            }
        }
        return threadDumps;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Long, Long> findTimeRange(Map<ThreadInfo, ? extends List<JfrThreadTimelineData>> timelineData) {
        long minTime = 0L;
        minTime = Long.MAX_VALUE;
        long maxTime = 0L;
        maxTime = Long.MIN_VALUE;
        Iterator<Map.Entry<ThreadInfo, ? extends List<JfrThreadTimelineData>>> iterator2 = timelineData.entrySet().iterator();
        while (iterator2.hasNext()) {
            List<JfrThreadTimelineData> timeline = iterator2.next().getValue();
            for (JfrThreadTimelineData eventData : timeline) {
                JfrThreadTimestampInfoStorage<CallTreeNode<BaseCallStackElement>> this_$iv = eventData.getTimestamps();
                boolean $i$f$forEach = false;
                int n = ((Collection)this_$iv.getTimestampStarts()).size();
                for (int i$iv = 0; i$iv < n; ++i$iv) {
                    void timestampEnd;
                    CallTreeNode<BaseCallStackElement> info$iv = this_$iv.getInfos().get(i$iv);
                    int interval$iv = ((Number)this_$iv.getEventInterval().invoke(info$iv)).intValue();
                    int start$iv = this_$iv.getTimestampStarts().getInt(i$iv);
                    int actualStart$iv = start$iv - interval$iv / 2;
                    IntArrayList intArrayList = this_$iv.getTimestampEnds();
                    int actualEnd$iv = (intArrayList != null ? intArrayList.getInt(i$iv) : start$iv) + interval$iv / 2;
                    int n2 = actualEnd$iv;
                    int timestampStart = actualStart$iv;
                    boolean bl = false;
                    minTime = Math.min(minTime, (long)timestampStart + eventData.getPivot());
                    maxTime = Math.max(maxTime, (long)timestampEnd + eventData.getPivot());
                }
            }
        }
        return minTime != Long.MAX_VALUE && maxTime != Long.MIN_VALUE ? TuplesKt.to((Object)minTime, (Object)maxTime) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ThreadState> getThreadStatesAt(Map<ThreadInfo, ? extends List<JfrThreadTimelineData>> timelineData, long offset) {
        List threadStates = new ArrayList();
        for (Map.Entry<ThreadInfo, ? extends List<JfrThreadTimelineData>> entry : timelineData.entrySet()) {
            Pair pair;
            ThreadInfo threadInfo = entry.getKey();
            List<JfrThreadTimelineData> dataList = entry.getValue();
            Pair bestMatch = null;
            long bestMatchTime = 0L;
            bestMatchTime = Long.MIN_VALUE;
            for (JfrThreadTimelineData data2 : dataList) {
                JfrThreadTimestampInfoStorage<CallTreeNode<BaseCallStackElement>> this_$iv = data2.getTimestamps();
                boolean $i$f$forEach = false;
                int n = ((Collection)this_$iv.getTimestampStarts()).size();
                for (int i$iv = 0; i$iv < n; ++i$iv) {
                    void stackNode;
                    void timestampEnd;
                    CallTreeNode<BaseCallStackElement> info$iv = this_$iv.getInfos().get(i$iv);
                    int interval$iv = ((Number)this_$iv.getEventInterval().invoke(info$iv)).intValue();
                    int start$iv = this_$iv.getTimestampStarts().getInt(i$iv);
                    int actualStart$iv = start$iv - interval$iv / 2;
                    IntArrayList intArrayList = this_$iv.getTimestampEnds();
                    int actualEnd$iv = (intArrayList != null ? intArrayList.getInt(i$iv) : start$iv) + interval$iv / 2;
                    CallTreeNode<BaseCallStackElement> callTreeNode = info$iv;
                    int n2 = actualEnd$iv;
                    int timestampStart = actualStart$iv;
                    boolean bl = false;
                    long actualStart = (long)timestampStart + data2.getPivot();
                    long actualEnd = (long)timestampEnd + data2.getPivot();
                    boolean bl2 = actualStart <= offset ? offset <= actualEnd : false;
                    if (!bl2 || actualStart <= bestMatchTime) continue;
                    bestMatch = TuplesKt.to((Object)stackNode, (Object)((Object)data2.getKind()));
                    bestMatchTime = actualStart;
                }
            }
            if (bestMatch == null) continue;
            Pair pair2 = pair;
            boolean bl = false;
            CallTreeNode stackNode = (CallTreeNode)pair2.component1();
            JfrTimelineEventKind kind = (JfrTimelineEventKind)((Object)pair2.component2());
            threadStates.add(new ThreadState(threadInfo.getName(), INSTANCE.mapKindToThreadState(kind), INSTANCE.extractStackTrace((CallTreeNode<? extends BaseCallStackElement>)stackNode)));
        }
        return threadStates;
    }

    private final String extractStackTrace(CallTreeNode<? extends BaseCallStackElement> stackNode) {
        List stack = new ArrayList();
        for (CallTreeNode current = stackNode; current != null && current.getData() != null; current = current.getParent()) {
            BaseCallStackElement call;
            CallWithValue callWithValue = (CallWithValue)current.getData();
            Object object = call = callWithValue != null ? (BaseCallStackElement)callWithValue.getCall() : null;
            if (call instanceof JFRMethodCall) {
                String className;
                StringBuilder line = new StringBuilder();
                line.append("        at ");
                String packageName = ((JFRMethodCall)call).getFullPackageName();
                if (((CharSequence)packageName).length() > 0) {
                    line.append(packageName + ".");
                }
                if (((CharSequence)(className = ((JFRMethodCall)call).getClassName())).length() > 0) {
                    line.append(className + ".");
                }
                String methodName = ((JFRMethodCall)call).getMethodName();
                line.append(methodName);
                String sourceFile = this.extractSourceFileName(className);
                if (sourceFile != null) {
                    line.append("(" + sourceFile + ":" + ((JFRMethodCall)call).getLineNumber() + ")");
                }
                String string = line.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                stack.add(string);
                continue;
            }
            if (!(call instanceof NativeCall) && !(call instanceof CantBeParsedCall)) continue;
            stack.add("        at " + call.fullName());
        }
        return !((Collection)stack).isEmpty() ? CollectionsKt.joinToString$default((Iterable)stack, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) : null;
    }

    private final String mapKindToThreadState(JfrTimelineEventKind kind) {
        return switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1 -> "STATE_RUNNABLE";
            case 2 -> "STATE_WAITING";
            case 3 -> "STATE_RUNNABLE";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String createJFRThreadDump(List<ThreadState> threadStates) {
        StringBuilder sb = new StringBuilder();
        Iterable $this$sortedBy$iv = threadStates;
        boolean $i$f$sortedBy = false;
        for (ThreadState threadState : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ThreadState it = (ThreadState)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getThreadName());
                it = (ThreadState)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getThreadName())));
            }
        })) {
            sb.append("\"" + threadState.getThreadName() + "\" " + this.mapJFRState(threadState.getState())).append('\n');
            sb.append("   java.lang.Thread.State: " + threadState.getState()).append('\n');
            StringBuilder stringBuilder = threadState.getStackTrace() != null ? sb.append(threadState.getStackTrace()).append('\n') : sb.append("   (no stack trace available)").append('\n');
            sb.append('\n');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String mapJFRState(String state) {
        String string = state.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return switch (string) {
            case "STATE_RUNNABLE" -> "runnable";
            case "STATE_WAITING" -> "in Object.wait()";
            case "STATE_TIMED_WAITING" -> "waiting on condition";
            case "STATE_BLOCKED" -> "waiting for monitor entry";
            default -> "unknown";
        };
    }

    private final String extractSourceFileName(String className) {
        String string;
        String simpleClassName = StringsKt.substringAfterLast$default((String)className, (char)'.', null, (int)2, null);
        if (((CharSequence)simpleClassName).length() == 0) {
            return null;
        }
        String outerClassName = StringsKt.substringBefore$default((String)simpleClassName, (char)'$', null, (int)2, null);
        if (StringsKt.endsWith$default((String)outerClassName, (String)"Kt", (boolean)false, (int)2, null) && outerClassName.length() > 2) {
            String kotlinFileName = StringsKt.removeSuffix((String)outerClassName, (CharSequence)"Kt");
            string = kotlinFileName + ".kt";
        } else {
            string = outerClassName + ".java";
        }
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/intellij/profiler/ultimate/async/JFRThreadDumpExtractor$ThreadState;", "", "threadName", "", "state", "stackTrace", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getThreadName", "()Ljava/lang/String;", "getState", "getStackTrace", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.profiler.ultimate"})
    public static final class ThreadState {
        @NotNull
        private final String threadName;
        @NotNull
        private final String state;
        @Nullable
        private final String stackTrace;

        public ThreadState(@NotNull String threadName, @NotNull String state, @Nullable String stackTrace) {
            Intrinsics.checkNotNullParameter((Object)threadName, (String)"threadName");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.threadName = threadName;
            this.state = state;
            this.stackTrace = stackTrace;
        }

        @NotNull
        public final String getThreadName() {
            return this.threadName;
        }

        @NotNull
        public final String getState() {
            return this.state;
        }

        @Nullable
        public final String getStackTrace() {
            return this.stackTrace;
        }

        @NotNull
        public final String component1() {
            return this.threadName;
        }

        @NotNull
        public final String component2() {
            return this.state;
        }

        @Nullable
        public final String component3() {
            return this.stackTrace;
        }

        @NotNull
        public final ThreadState copy(@NotNull String threadName, @NotNull String state, @Nullable String stackTrace) {
            Intrinsics.checkNotNullParameter((Object)threadName, (String)"threadName");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            return new ThreadState(threadName, state, stackTrace);
        }

        public static /* synthetic */ ThreadState copy$default(ThreadState threadState, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = threadState.threadName;
            }
            if ((n & 2) != 0) {
                string2 = threadState.state;
            }
            if ((n & 4) != 0) {
                string3 = threadState.stackTrace;
            }
            return threadState.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ThreadState(threadName=" + this.threadName + ", state=" + this.state + ", stackTrace=" + this.stackTrace + ")";
        }

        public int hashCode() {
            int result = this.threadName.hashCode();
            result = result * 31 + this.state.hashCode();
            result = result * 31 + (this.stackTrace == null ? 0 : this.stackTrace.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ThreadState)) {
                return false;
            }
            ThreadState threadState = (ThreadState)other;
            if (!Intrinsics.areEqual((Object)this.threadName, (Object)threadState.threadName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.state, (Object)threadState.state)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.stackTrace, (Object)threadState.stackTrace);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JfrTimelineEventKind.values().length];
            try {
                nArray[JfrTimelineEventKind.CPU_RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JfrTimelineEventKind.CPU_SLEEPING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JfrTimelineEventKind.MEMORY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

