/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.async.troubleshooting;

import com.intellij.notification.NotificationAction;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.profiler.api.ProfilerErrorWithContext;
import com.intellij.profiler.api.ProfilerState;
import com.intellij.profiler.api.RecoveredFromProfilerError;
import com.intellij.profiler.ultimate.AttachedToAlreadyRunningProcessCommunicator;
import com.intellij.profiler.ultimate.DumpState;
import com.intellij.profiler.ultimate.JavaProfilerErrorContext;
import com.intellij.profiler.ultimate.JavaProfilerProcess;
import com.intellij.profiler.ultimate.JavaProfilerTroubleshooter;
import com.intellij.profiler.ultimate.NewProcessStartedFromGradleCommunicator;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.async.AsyncProfilerProcess;
import com.intellij.profiler.ultimate.async.troubleshooting.AsyncProfilerErrorReason;
import com.intellij.profiler.ultimate.async.troubleshooting.report.AsyncProfilerErrorReporter;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0002!\"B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0015\u0010\u0019\u001a\u00070\u0017\u00a2\u0006\u0002\b\u001a2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0015\u0010\u001b\u001a\u00070\u0017\u00a2\u0006\u0002\b\u001a2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u001c\u001a\u00070\u0017\u00a2\u0006\u0002\b\u001a2\u000b\u0010\u001d\u001a\u00070\u0017\u00a2\u0006\u0002\b\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/profiler/ultimate/async/troubleshooting/AsyncProfilerTroubleshooter;", "Lcom/intellij/profiler/ultimate/JavaProfilerTroubleshooter;", "logProvider", "Lkotlin/Function0;", "Ljava/io/File;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "myErrorReporters", "", "Lcom/intellij/profiler/ultimate/async/troubleshooting/report/AsyncProfilerErrorReporter;", "addErrorReporter", "", "errorReporter", "analyzeAndReport", "Lcom/intellij/profiler/api/ProfilerState;", "errorContext", "Lcom/intellij/profiler/ultimate/JavaProfilerErrorContext;", "analyzeLogIsEmpty", "Lcom/intellij/profiler/ultimate/async/troubleshooting/AsyncProfilerTroubleshooter$AnalysisResult;", "analyzeDumpNotExistLogIsEmpty", "analyzeDumpIsEmptyLogIsEmpty", "analyzeLogIsNotEmpty", "log", "", "analyzeDumpIsEmptyLogIsNotEmpty", "dumpMissingMessage", "Lorg/jetbrains/annotations/Nls;", "profilerNotStartedMessage", "prepareMessage", "mainStatement", "reasons", "", "Lcom/intellij/profiler/ultimate/async/troubleshooting/AsyncProfilerErrorReason;", "AnalysisResult", "Companion", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nAsyncProfilerTroubleshooter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncProfilerTroubleshooter.kt\ncom/intellij/profiler/ultimate/async/troubleshooting/AsyncProfilerTroubleshooter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 promise.kt\norg/jetbrains/concurrency/Promises__PromiseKt\n*L\n1#1,197:1\n774#2:198\n865#2,2:199\n1563#2:213\n1634#2,3:214\n212#3,12:201\n*S KotlinDebug\n*F\n+ 1 AsyncProfilerTroubleshooter.kt\ncom/intellij/profiler/ultimate/async/troubleshooting/AsyncProfilerTroubleshooter\n*L\n80#1:198\n80#1:199,2\n169#1:213\n169#1:214,3\n122#1:201,12\n*E\n"})
public final class AsyncProfilerTroubleshooter
implements JavaProfilerTroubleshooter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<File> logProvider;
    @NotNull
    private final List<AsyncProfilerErrorReporter> myErrorReporters;
    private static final int SHORT_PROFILING_TIME_THRESHOLD_MS = 1000;
    @NotNull
    private static final String ERROR_PREFIX = "[ERROR] ";
    @NotNull
    private static final String DUPLICATE_ARGUMENT_SUFFIX = " argument";
    @NotNull
    private static final String FAILED_DEFINE_JFR_SYNC_CLASS = "Failed to define JfrSync class";
    @NotNull
    private static final String FAILED_INITIALIZE_JFR_SYNC_CLASS = "Failed to initialize JfrSync class";
    @NotNull
    private static final String FAILED_START_JFR_SYNC = "Could not start master JFR recording";

    public AsyncProfilerTroubleshooter(@NotNull Function0<? extends File> logProvider) {
        Intrinsics.checkNotNullParameter(logProvider, (String)"logProvider");
        this.logProvider = logProvider;
        this.myErrorReporters = new ArrayList();
    }

    public final void addErrorReporter(@NotNull AsyncProfilerErrorReporter errorReporter) {
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        this.myErrorReporters.add(errorReporter);
    }

    @Override
    @NotNull
    public ProfilerState analyzeAndReport(@NotNull JavaProfilerErrorContext errorContext) {
        AnalysisResult analysisResult;
        Intrinsics.checkNotNullParameter((Object)errorContext, (String)"errorContext");
        String string = FileUtil.loadFile((File)((File)this.logProvider.invoke()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadFile(...)");
        String log = string;
        AnalysisResult analysisResult2 = analysisResult = StringsKt.isBlank((CharSequence)log) ? this.analyzeLogIsEmpty(errorContext) : this.analyzeLogIsNotEmpty(errorContext, log);
        if (analysisResult instanceof AnalysisResult.Error) {
            AnalysisResult analysisResult3 = analysisResult;
            String mainMessage = ((AnalysisResult.Error)analysisResult3).component1();
            List<AsyncProfilerErrorReason> reasons = ((AnalysisResult.Error)analysisResult3).component2();
            NotificationAction[] actions = ((AnalysisResult.Error)analysisResult3).component3();
            for (AsyncProfilerErrorReporter reporter : this.myErrorReporters) {
                reporter.reportError(errorContext, log, reasons);
            }
            String message = this.prepareMessage(mainMessage, reasons);
            return (ProfilerState)new ProfilerErrorWithContext(message, actions);
        }
        for (AsyncProfilerErrorReporter reporter : this.myErrorReporters) {
            reporter.reportRecover(errorContext, log, analysisResult.getReasons());
        }
        return (ProfilerState)RecoveredFromProfilerError.INSTANCE;
    }

    private final AnalysisResult analyzeLogIsEmpty(JavaProfilerErrorContext errorContext) {
        return switch (WhenMappings.$EnumSwitchMapping$0[errorContext.getDumpState().ordinal()]) {
            case 1 -> this.analyzeDumpNotExistLogIsEmpty(errorContext);
            case 2 -> this.analyzeDumpIsEmptyLogIsEmpty();
            case 3 -> throw new AssertionError((Object)"Should not reach here");
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final AnalysisResult analyzeDumpNotExistLogIsEmpty(JavaProfilerErrorContext errorContext) {
        List reasons = new ArrayList();
        if (errorContext.getDurationMs() <= 1000L) {
            reasons.add(new AsyncProfilerErrorReason.ShortSession(errorContext.getDurationMs()));
        }
        if (errorContext.getCommunicator() instanceof NewProcessStartedFromGradleCommunicator) {
            reasons.add(AsyncProfilerErrorReason.Gradle.INSTANCE);
        }
        return new AnalysisResult.Error(this.profilerNotStartedMessage(errorContext), reasons, null, 4, null);
    }

    private final AnalysisResult analyzeDumpIsEmptyLogIsEmpty() {
        return new AnalysisResult.Error(UltimateProfilerBundleKt.profilerMessage("async.profiler.troubleshoot.dump.is.empty", new Object[0]), CollectionsKt.emptyList(), null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final AnalysisResult analyzeLogIsNotEmpty(JavaProfilerErrorContext errorContext, String log) {
        void $this$filterTo$iv$iv;
        if (errorContext.getDumpState() == DumpState.EMPTY) {
            return this.analyzeDumpIsEmptyLogIsNotEmpty(errorContext);
        }
        CharSequence charSequence = log;
        String[] stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)System.lineSeparator(), (String)"lineSeparator(...)");
        List lines = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Iterable $this$filter$iv = lines;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)ERROR_PREFIX, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List errorLines = (List)destination$iv$iv;
        List reasons = new ArrayList();
        for (String errorLine : errorLines) {
            if (StringsKt.endsWith$default((String)errorLine, (String)DUPLICATE_ARGUMENT_SUFFIX, (boolean)false, (int)2, null)) {
                reasons.add(AsyncProfilerErrorReason.DuplicateArguments.INSTANCE);
                return new AnalysisResult.Error(this.dumpMissingMessage(errorContext), reasons, null, 4, null);
            }
            if (StringsKt.endsWith$default((String)errorLine, (String)FAILED_INITIALIZE_JFR_SYNC_CLASS, (boolean)false, (int)2, null)) {
                reasons.add(AsyncProfilerErrorReason.IncompatibleJdk.INSTANCE);
                reasons.add(AsyncProfilerErrorReason.JfrSyncInitializationInterrupted.INSTANCE);
                return new AnalysisResult.Error(UltimateProfilerBundleKt.profilerMessage("async.profiler.troubleshoot.failed.to.run.jfrsync", new Object[0]), reasons, null, 4, null);
            }
            if (StringsKt.endsWith$default((String)errorLine, (String)FAILED_DEFINE_JFR_SYNC_CLASS, (boolean)false, (int)2, null)) {
                reasons.add(AsyncProfilerErrorReason.IncompatibleJdk.INSTANCE);
                return new AnalysisResult.Error(UltimateProfilerBundleKt.profilerMessage("async.profiler.troubleshoot.failed.to.run.jfrsync", new Object[0]), reasons, null, 4, null);
            }
            if (!StringsKt.endsWith$default((String)errorLine, (String)FAILED_START_JFR_SYNC, (boolean)false, (int)2, null)) continue;
            reasons.add(AsyncProfilerErrorReason.JfrSyncStartFailure.INSTANCE);
            return new AnalysisResult.Error(UltimateProfilerBundleKt.profilerMessage("async.profiler.troubleshoot.jfrsync.start.failure", new Object[0]), reasons, null, 4, null);
        }
        return new AnalysisResult.Error(this.dumpMissingMessage(errorContext), reasons, null, 4, null);
    }

    private final AnalysisResult analyzeDumpIsEmptyLogIsNotEmpty(JavaProfilerErrorContext errorContext) {
        AsyncProfilerProcess profilerProcess;
        List reasons = CollectionsKt.listOf((Object)AsyncProfilerErrorReason.StoppedBeforeFlushing.INSTANCE);
        JavaProfilerProcess<?> javaProfilerProcess = errorContext.getProfilerProcess();
        AsyncProfilerProcess asyncProfilerProcess = profilerProcess = javaProfilerProcess instanceof AsyncProfilerProcess ? (AsyncProfilerProcess)javaProfilerProcess : null;
        if (profilerProcess == null) {
            return new AnalysisResult.Error(UltimateProfilerBundleKt.profilerMessage("async.profiler.troubleshoot.dump.is.empty", new Object[0]), reasons, null, 4, null);
        }
        int attempts = 5;
        long waitBetweenAttemptsMs = 1000L;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = new Object[]{(long)attempts * waitBetweenAttemptsMs};
        objectArray[0] = UltimateProfilerBundleKt.profilerMessage("async.profiler.troubleshoot.no.data.in.0.ms", objectArray2);
        AnalysisResult.Error error2 = new AnalysisResult.Error(UltimateProfilerBundleKt.profilerMessage("async.profiler.troubleshoot.dump.is.empty.0", objectArray), CollectionsKt.listOf((Object)AsyncProfilerErrorReason.ForcefulKill.INSTANCE), null, 4, null);
        boolean $i$f$runAsync = false;
        AsyncPromise promise$iv = new AsyncPromise();
        AppExecutorUtil.getAppExecutorService().execute(new Runnable(promise$iv, profilerProcess, attempts, waitBetweenAttemptsMs, errorContext){
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ AsyncProfilerProcess $profilerProcess$inlined;
            final /* synthetic */ int $attempts$inlined;
            final /* synthetic */ long $waitBetweenAttemptsMs$inlined;
            final /* synthetic */ JavaProfilerErrorContext $errorContext$inlined;
            {
                this.$promise = $promise;
                this.$profilerProcess$inlined = asyncProfilerProcess;
                this.$attempts$inlined = n;
                this.$waitBetweenAttemptsMs$inlined = l;
                this.$errorContext$inlined = javaProfilerErrorContext;
            }

            public final void run() {
                Boolean bl;
                try {
                    boolean bl2 = false;
                    bl = this.$profilerProcess$inlined.tryReopenDump(this.$attempts$inlined, this.$waitBetweenAttemptsMs$inlined, this.$errorContext$inlined.getCurrentIndicator());
                }
                catch (Throwable e) {
                    this.$promise.setError(e);
                    return;
                }
                Boolean result = bl;
                this.$promise.setResult((Object)result);
            }
        });
        Promise promise = (Promise)promise$iv;
        AnalysisResult analysisResult = (AnalysisResult)promise.then(arg_0 -> AsyncProfilerTroubleshooter.analyzeDumpIsEmptyLogIsNotEmpty$lambda$2(arg_0 -> AsyncProfilerTroubleshooter.analyzeDumpIsEmptyLogIsNotEmpty$lambda$1(reasons, error2, arg_0), arg_0)).blockingGet(10, TimeUnit.SECONDS);
        if (analysisResult == null) {
            analysisResult = error2;
        }
        return analysisResult;
    }

    private final String dumpMissingMessage(JavaProfilerErrorContext errorContext) {
        return AsyncProfilerTroubleshooter.Companion.isInAttachMode(errorContext) ? UltimateProfilerBundleKt.profilerMessage("async.profiler.troubleshoot.failed.to.attach", new Object[0]) : UltimateProfilerBundleKt.profilerMessage("async.profiler.troubleshoot.dump.is.missing", new Object[0]);
    }

    private final String profilerNotStartedMessage(JavaProfilerErrorContext errorContext) {
        return AsyncProfilerTroubleshooter.Companion.isInAttachMode(errorContext) ? UltimateProfilerBundleKt.profilerMessage("async.profiler.troubleshoot.failed.to.attach", new Object[0]) : UltimateProfilerBundleKt.profilerMessage("async.profiler.troubleshoot.profiler.not.started", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final String prepareMessage(String mainStatement, List<? extends AsyncProfilerErrorReason> reasons) {
        String string;
        switch (reasons.size()) {
            case 0: {
                string = mainStatement;
                break;
            }
            case 1: {
                HtmlBuilder htmlBuilder;
                HtmlBuilder $this$prepareMessage_u24lambda_u240 = htmlBuilder = new HtmlBuilder();
                boolean bl = false;
                $this$prepareMessage_u24lambda_u240.append(mainStatement);
                $this$prepareMessage_u24lambda_u240.append((HtmlChunk)HtmlChunk.br());
                $this$prepareMessage_u24lambda_u240.append(((AsyncProfilerErrorReason)CollectionsKt.first(reasons)).message());
                String string2 = htmlBuilder.toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                break;
            }
            default: {
                Collection<HtmlChunk.Element> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                HtmlBuilder htmlBuilder;
                HtmlBuilder $this$prepareMessage_u24lambda_u241 = htmlBuilder = new HtmlBuilder();
                boolean bl = false;
                Object object = new Object[]{mainStatement};
                $this$prepareMessage_u24lambda_u241.append(UltimateProfilerBundleKt.profilerMessage("async.profiler.troubleshoot.reasons", object));
                $this$prepareMessage_u24lambda_u241.append((HtmlChunk)HtmlChunk.br());
                object = reasons;
                HtmlChunk.Element element = HtmlChunk.ul();
                HtmlBuilder htmlBuilder2 = $this$prepareMessage_u24lambda_u241;
                boolean $i$f$map = false;
                void var10_13 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    AsyncProfilerErrorReason asyncProfilerErrorReason = (AsyncProfilerErrorReason)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(HtmlChunk.text((String)it.message()).wrapWith("li"));
                }
                collection = (List)destination$iv$iv;
                htmlBuilder2.append((HtmlChunk)element.children((List)collection));
                String string3 = htmlBuilder.toString();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            }
        }
        return string;
    }

    private static final AnalysisResult analyzeDumpIsEmptyLogIsNotEmpty$lambda$1(List $reasons, AnalysisResult.Error $error, Boolean it) {
        return it != false ? (AnalysisResult)new AnalysisResult.Recovery($reasons) : (AnalysisResult)$error;
    }

    private static final AnalysisResult analyzeDumpIsEmptyLogIsNotEmpty$lambda$2(Function1 $tmp0, Object p0) {
        return (AnalysisResult)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\t\nB\u0017\b\u0004\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0002\u000b\f\u00a8\u0006\r"}, d2={"Lcom/intellij/profiler/ultimate/async/troubleshooting/AsyncProfilerTroubleshooter$AnalysisResult;", "", "reasons", "", "Lcom/intellij/profiler/ultimate/async/troubleshooting/AsyncProfilerErrorReason;", "<init>", "(Ljava/util/List;)V", "getReasons", "()Ljava/util/List;", "Error", "Recovery", "Lcom/intellij/profiler/ultimate/async/troubleshooting/AsyncProfilerTroubleshooter$AnalysisResult$Error;", "Lcom/intellij/profiler/ultimate/async/troubleshooting/AsyncProfilerTroubleshooter$AnalysisResult$Recovery;", "intellij.profiler.ultimate"})
    private static abstract sealed class AnalysisResult {
        @NotNull
        private final List<AsyncProfilerErrorReason> reasons;

        private AnalysisResult(List<? extends AsyncProfilerErrorReason> reasons) {
            this.reasons = reasons;
        }

        @NotNull
        public final List<AsyncProfilerErrorReason> getReasons() {
            return this.reasons;
        }

        public /* synthetic */ AnalysisResult(List reasons, DefaultConstructorMarker $constructor_marker) {
            this(reasons);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B4\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0014\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\u0016\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\tH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0012J?\u0010\u0017\u001a\u00020\u00002\r\b\u0002\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0010\b\u0002\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lcom/intellij/profiler/ultimate/async/troubleshooting/AsyncProfilerTroubleshooter$AnalysisResult$Error;", "Lcom/intellij/profiler/ultimate/async/troubleshooting/AsyncProfilerTroubleshooter$AnalysisResult;", "userMessage", "", "Lorg/jetbrains/annotations/Nls;", "reasonsList", "", "Lcom/intellij/profiler/ultimate/async/troubleshooting/AsyncProfilerErrorReason;", "actions", "", "Lcom/intellij/notification/NotificationAction;", "<init>", "(Ljava/lang/String;Ljava/util/List;[Lcom/intellij/notification/NotificationAction;)V", "getUserMessage", "()Ljava/lang/String;", "getReasonsList", "()Ljava/util/List;", "getActions", "()[Lcom/intellij/notification/NotificationAction;", "[Lcom/intellij/notification/NotificationAction;", "component1", "component2", "component3", "copy", "(Ljava/lang/String;Ljava/util/List;[Lcom/intellij/notification/NotificationAction;)Lcom/intellij/profiler/ultimate/async/troubleshooting/AsyncProfilerTroubleshooter$AnalysisResult$Error;", "equals", "", "other", "", "hashCode", "", "toString", "intellij.profiler.ultimate"})
        public static final class Error
        extends AnalysisResult {
            @NotNull
            private final String userMessage;
            @NotNull
            private final List<AsyncProfilerErrorReason> reasonsList;
            @NotNull
            private final NotificationAction[] actions;

            public Error(@NotNull String userMessage, @NotNull List<? extends AsyncProfilerErrorReason> reasonsList, @NotNull NotificationAction[] actions) {
                Intrinsics.checkNotNullParameter((Object)userMessage, (String)"userMessage");
                Intrinsics.checkNotNullParameter(reasonsList, (String)"reasonsList");
                Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
                super(reasonsList, null);
                this.userMessage = userMessage;
                this.reasonsList = reasonsList;
                this.actions = actions;
            }

            public /* synthetic */ Error(String string, List list, NotificationAction[] notificationActionArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    notificationActionArray = new NotificationAction[]{};
                }
                this(string, list, notificationActionArray);
            }

            @NotNull
            public final String getUserMessage() {
                return this.userMessage;
            }

            @NotNull
            public final List<AsyncProfilerErrorReason> getReasonsList() {
                return this.reasonsList;
            }

            @NotNull
            public final NotificationAction[] getActions() {
                return this.actions;
            }

            @NotNull
            public final String component1() {
                return this.userMessage;
            }

            @NotNull
            public final List<AsyncProfilerErrorReason> component2() {
                return this.reasonsList;
            }

            @NotNull
            public final NotificationAction[] component3() {
                return this.actions;
            }

            @NotNull
            public final Error copy(@NotNull String userMessage, @NotNull List<? extends AsyncProfilerErrorReason> reasonsList, @NotNull NotificationAction[] actions) {
                Intrinsics.checkNotNullParameter((Object)userMessage, (String)"userMessage");
                Intrinsics.checkNotNullParameter(reasonsList, (String)"reasonsList");
                Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
                return new Error(userMessage, reasonsList, actions);
            }

            public static /* synthetic */ Error copy$default(Error error2, String string, List list, NotificationAction[] notificationActionArray, int n, Object object) {
                if ((n & 1) != 0) {
                    string = error2.userMessage;
                }
                if ((n & 2) != 0) {
                    list = error2.reasonsList;
                }
                if ((n & 4) != 0) {
                    notificationActionArray = error2.actions;
                }
                return error2.copy(string, list, notificationActionArray);
            }

            @NotNull
            public String toString() {
                return "Error(userMessage=" + this.userMessage + ", reasonsList=" + this.reasonsList + ", actions=" + Arrays.toString(this.actions) + ")";
            }

            public int hashCode() {
                int result = this.userMessage.hashCode();
                result = result * 31 + ((Object)this.reasonsList).hashCode();
                result = result * 31 + Arrays.hashCode(this.actions);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Error)) {
                    return false;
                }
                Error error2 = (Error)other;
                if (!Intrinsics.areEqual((Object)this.userMessage, (Object)error2.userMessage)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.reasonsList, error2.reasonsList)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.actions, (Object)error2.actions);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profiler/ultimate/async/troubleshooting/AsyncProfilerTroubleshooter$AnalysisResult$Recovery;", "Lcom/intellij/profiler/ultimate/async/troubleshooting/AsyncProfilerTroubleshooter$AnalysisResult;", "reasons", "", "Lcom/intellij/profiler/ultimate/async/troubleshooting/AsyncProfilerErrorReason;", "<init>", "(Ljava/util/List;)V", "intellij.profiler.ultimate"})
        public static final class Recovery
        extends AnalysisResult {
            public Recovery(@NotNull List<? extends AsyncProfilerErrorReason> reasons) {
                Intrinsics.checkNotNullParameter(reasons, (String)"reasons");
                super(reasons, null);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/profiler/ultimate/async/troubleshooting/AsyncProfilerTroubleshooter$Companion;", "", "<init>", "()V", "SHORT_PROFILING_TIME_THRESHOLD_MS", "", "ERROR_PREFIX", "", "DUPLICATE_ARGUMENT_SUFFIX", "FAILED_DEFINE_JFR_SYNC_CLASS", "FAILED_INITIALIZE_JFR_SYNC_CLASS", "FAILED_START_JFR_SYNC", "isInAttachMode", "", "errorContext", "Lcom/intellij/profiler/ultimate/JavaProfilerErrorContext;", "intellij.profiler.ultimate"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isInAttachMode(JavaProfilerErrorContext errorContext) {
            return errorContext.getCommunicator() instanceof AttachedToAlreadyRunningProcessCommunicator;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DumpState.values().length];
            try {
                nArray[DumpState.NOT_EXIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DumpState.EMPTY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DumpState.NON_EMPTY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

