/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.widget;

import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.ToolWindowActivationProperties;
import com.intellij.profiler.UtilsKt;
import com.intellij.profiler.actions.ImportProfilerResultAction;
import com.intellij.profiler.api.AttachableTargetProcess;
import com.intellij.profiler.api.Attached;
import com.intellij.profiler.api.DataReady;
import com.intellij.profiler.api.Disposed;
import com.intellij.profiler.api.Inactive;
import com.intellij.profiler.api.ParsingData;
import com.intellij.profiler.api.ProfilerError;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.api.ProfilerState;
import com.intellij.profiler.api.ProfilerTargetProcess;
import com.intellij.profiler.api.ReadingData;
import com.intellij.profiler.api.RecoveredFromProfilerError;
import com.intellij.profiler.api.Terminated;
import com.intellij.profiler.api.XLocalAttachProfiler;
import com.intellij.profiler.api.monitor.CpuMemoryChartColors;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.statistics.SnapshotImportEventData;
import com.intellij.profiler.statistics.SnapshotImportOrigin;
import com.intellij.profiler.statistics.SnapshotImportSource;
import com.intellij.profiler.ultimate.JavaLocalAttachProfilerProvider;
import com.intellij.profiler.ultimate.JavaProfilerProcess;
import com.intellij.profiler.ultimate.ProcessUtilKt;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.async.TargetProcessBase;
import com.intellij.profiler.ultimate.welcome.actions.CaptureMemorySnapshotKt;
import com.intellij.profiler.ultimate.widget.JavaProfilerConsoleWidgetManager;
import com.intellij.profiler.ultimate.widget.JavaProfilerWidgetLiveChart;
import com.intellij.profiler.ultimate.widget.JavaProfilerWidgetPanel;
import com.intellij.profiler.ultimate.widget.LiveChartState;
import com.intellij.profiler.ultimate.widget.WidgetMode;
import com.intellij.ui.CardLayoutPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.content.Content;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0005'()*+B#\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\fJ\u0012\u0010\u001f\u001a\u00020\u001d2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!J\u001e\u0010\"\u001a\u00020\u001d2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\f2\b\b\u0002\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020\u001dH\u0016R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00060\u0010R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00060\u0012R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel;", "Lcom/intellij/ui/components/JBPanelWithEmptyText;", "Lcom/intellij/openapi/Disposable;", "configuration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "widgetMode", "Lcom/intellij/profiler/ultimate/widget/WidgetMode;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/profiler/ultimate/widget/WidgetMode;Lkotlinx/coroutines/CoroutineScope;)V", "currentProfilerProcess", "Lcom/intellij/profiler/ultimate/JavaProfilerProcess;", "timer", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyTimer;", "controller", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController;", "cpuAndMemoryPanel", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyCpuAndMemoryPanel;", "myParts", "", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyWidgetPart;", "processExitCode", "", "panel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "getBackground", "Ljava/awt/Color;", "setProfilerProcess", "", "newProfilerProcess", "setTargetProcess", "handler", "Lcom/intellij/execution/process/BaseProcessHandler;", "updatePanel", "process", "newState", "Lcom/intellij/profiler/api/ProfilerState;", "dispose", "MyWidgetPart", "MyTimer", "MyRecordingController", "ControllerButtonState", "MyCpuAndMemoryPanel", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nJavaProfilerWidgetPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaProfilerWidgetPanel.kt\ncom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,564:1\n1869#2,2:565\n*S KotlinDebug\n*F\n+ 1 JavaProfilerWidgetPanel.kt\ncom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel\n*L\n93#1:565,2\n*E\n"})
public final class JavaProfilerWidgetPanel
extends JBPanelWithEmptyText
implements Disposable {
    @NotNull
    private final RunConfigurationBase<?> configuration;
    @NotNull
    private final WidgetMode widgetMode;
    private JavaProfilerProcess<?> currentProfilerProcess;
    @NotNull
    private final MyTimer timer;
    @NotNull
    private final MyRecordingController controller;
    @NotNull
    private final MyCpuAndMemoryPanel cpuAndMemoryPanel;
    @NotNull
    private final List<MyWidgetPart> myParts;
    private volatile int processExitCode;
    @NotNull
    private final BorderLayoutPanel panel;

    /*
     * WARNING - void declaration
     */
    public JavaProfilerWidgetPanel(@NotNull RunConfigurationBase<?> configuration, @NotNull WidgetMode widgetMode, @NotNull CoroutineScope scope) {
        void $this$panel_u24lambda_u240_u240;
        BorderLayoutPanel borderLayoutPanel;
        void $this$panel_u24lambda_u240;
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)((Object)widgetMode), (String)"widgetMode");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        super((LayoutManager)new BorderLayout());
        this.configuration = configuration;
        this.widgetMode = widgetMode;
        this.timer = new MyTimer();
        this.controller = new MyRecordingController();
        this.cpuAndMemoryPanel = new MyCpuAndMemoryPanel(scope);
        MyWidgetPart[] myWidgetPartArray = new MyWidgetPart[]{this.timer, this.controller, this.cpuAndMemoryPanel};
        this.myParts = CollectionsKt.listOf((Object[])myWidgetPartArray);
        this.processExitCode = -1;
        MyWidgetPart[] myWidgetPartArray2 = myWidgetPartArray = new BorderLayoutPanel();
        JavaProfilerWidgetPanel javaProfilerWidgetPanel = this;
        boolean bl = false;
        $this$panel_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)16, (int)13, (int)10, (int)13));
        BorderLayoutPanel borderLayoutPanel2 = borderLayoutPanel = new BorderLayoutPanel();
        void var9_12 = $this$panel_u24lambda_u240;
        boolean bl2 = false;
        $this$panel_u24lambda_u240_u240.addToLeft((Component)this.controller.getPanel());
        $this$panel_u24lambda_u240_u240.addToCenter((Component)((Object)this.timer));
        var9_12.addToTop((Component)borderLayoutPanel);
        $this$panel_u24lambda_u240.addToCenter((Component)((Object)this.cpuAndMemoryPanel));
        UIUtil.forEachComponentInHierarchy((Component)((Component)$this$panel_u24lambda_u240), arg_0 -> JavaProfilerWidgetPanel.panel$lambda$0$2(JavaProfilerWidgetPanel::panel$lambda$0$1, arg_0));
        javaProfilerWidgetPanel.panel = myWidgetPartArray;
        this.setMinimumSize(new Dimension(400, this.getMinimumSize().height));
        Iterable $this$forEach$iv = this.myParts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MyWidgetPart it = (MyWidgetPart)element$iv;
            boolean bl3 = false;
            Disposer.register((Disposable)this, (Disposable)it);
        }
        this.add((Component)this.panel, "Center");
    }

    @NotNull
    public Color getBackground() {
        Color color = JBColor.background();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background(...)");
        return color;
    }

    public final void setProfilerProcess(@NotNull JavaProfilerProcess<?> newProfilerProcess) {
        Intrinsics.checkNotNullParameter(newProfilerProcess, (String)"newProfilerProcess");
        this.currentProfilerProcess = newProfilerProcess;
        JavaProfilerWidgetPanel.updatePanel$default(this, newProfilerProcess, null, 2, null);
        newProfilerProcess.addStateChangedListener((arg_0, arg_1) -> JavaProfilerWidgetPanel.setProfilerProcess$lambda$0(this, newProfilerProcess, arg_0, arg_1));
    }

    public final void setTargetProcess(@NotNull BaseProcessHandler<?> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        handler.addProcessListener((ProcessListener)new ProcessAdapter(this, handler){
            final /* synthetic */ JavaProfilerWidgetPanel this$0;
            final /* synthetic */ BaseProcessHandler<?> $handler;
            {
                this.this$0 = $receiver;
                this.$handler = $handler;
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                JavaProfilerWidgetPanel.access$setProcessExitCode$p(this.this$0, event.getExitCode());
                if (JavaProfilerWidgetPanel.access$getCurrentProfilerProcess$p(this.this$0) != null) {
                    Project project = JavaProfilerWidgetPanel.access$getConfiguration$p(this.this$0).getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    JavaProfilerConsoleWidgetManager javaProfilerConsoleWidgetManager = JavaProfilerConsoleWidgetManager.Companion.getInstance(project);
                    JavaProfilerProcess javaProfilerProcess = JavaProfilerWidgetPanel.access$getCurrentProfilerProcess$p(this.this$0);
                    if (javaProfilerProcess == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"currentProfilerProcess");
                        javaProfilerProcess = null;
                    }
                    javaProfilerConsoleWidgetManager.processDetached(javaProfilerProcess);
                }
                for (MyWidgetPart part : JavaProfilerWidgetPanel.access$getMyParts$p(this.this$0)) {
                    part.processTerminated();
                }
                UIUtil.invokeLaterIfNeeded(() -> setTargetProcess.1.processTerminated$lambda$0(this.this$0));
                this.$handler.removeProcessListener((ProcessListener)this);
            }

            private static final void processTerminated$lambda$0(JavaProfilerWidgetPanel this$0) {
                this$0.revalidate();
                this$0.repaint();
            }
        });
        this.cpuAndMemoryPanel.setProcessId(handler.getProcess().pid());
        if (this.widgetMode == WidgetMode.RUN) {
            for (MyWidgetPart part : this.myParts) {
                part.processSetWithoutProfiler(handler);
            }
        }
    }

    private final void updatePanel(JavaProfilerProcess<?> process, ProfilerState newState) {
        if (process.getTargetProcessHandler().isProcessTerminating() || process.getTargetProcessHandler().isProcessTerminated()) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> JavaProfilerWidgetPanel.updatePanel$lambda$0(newState, this, process));
    }

    static /* synthetic */ void updatePanel$default(JavaProfilerWidgetPanel javaProfilerWidgetPanel, JavaProfilerProcess javaProfilerProcess, ProfilerState profilerState, int n, Object object) {
        if ((n & 2) != 0) {
            profilerState = javaProfilerProcess.getState();
        }
        javaProfilerWidgetPanel.updatePanel(javaProfilerProcess, profilerState);
    }

    public void dispose() {
    }

    private static final Unit panel$lambda$0$1(Component it) {
        if (it instanceof JComponent) {
            ((JComponent)it).setOpaque(false);
        }
        return Unit.INSTANCE;
    }

    private static final void panel$lambda$0$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit setProfilerProcess$lambda$0(JavaProfilerWidgetPanel this$0, JavaProfilerProcess $newProfilerProcess, ProfilerState profilerState, ProfilerState newState) {
        Intrinsics.checkNotNullParameter((Object)profilerState, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        this$0.updatePanel($newProfilerProcess, newState);
        return Unit.INSTANCE;
    }

    private static final void updatePanel$lambda$0(ProfilerState $newState, JavaProfilerWidgetPanel this$0, JavaProfilerProcess $process) {
        ProfilerState profilerState = $newState;
        if (Intrinsics.areEqual((Object)profilerState, (Object)Inactive.INSTANCE)) {
            this$0.panel.setEnabled(false);
            this$0.getEmptyText().clear();
            this$0.getEmptyText().appendText(CommonProfilerBundleKt.commonProfilerMessage((String)"run.profiler.waiting", (Object[])new Object[0]));
            this$0.removeAll();
        } else if (Intrinsics.areEqual((Object)profilerState, (Object)Attached.INSTANCE)) {
            this$0.panel.setEnabled(true);
            for (MyWidgetPart part : this$0.myParts) {
                part.profilerAttached($process);
            }
        } else if (Intrinsics.areEqual((Object)profilerState, (Object)ReadingData.INSTANCE) || Intrinsics.areEqual((Object)profilerState, (Object)ParsingData.INSTANCE) || profilerState instanceof DataReady || profilerState instanceof ProfilerError || Intrinsics.areEqual((Object)profilerState, (Object)RecoveredFromProfilerError.INSTANCE)) {
            for (MyWidgetPart part : this$0.myParts) {
                part.profilerDetached($process, $newState);
            }
        } else if (Intrinsics.areEqual((Object)profilerState, (Object)Disposed.INSTANCE) || Intrinsics.areEqual((Object)profilerState, (Object)Terminated.INSTANCE)) {
            for (MyWidgetPart part : this$0.myParts) {
                part.processTerminated();
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this$0.revalidate();
        this$0.repaint();
    }

    public static final /* synthetic */ void access$setProcessExitCode$p(JavaProfilerWidgetPanel $this, int n) {
        $this.processExitCode = n;
    }

    public static final /* synthetic */ List access$getMyParts$p(JavaProfilerWidgetPanel $this) {
        return $this.myParts;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0003\u0005\u0006\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$ControllerButtonState;", "", "StartRecording", "StopRecording", "ShowResults", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$ControllerButtonState$ShowResults;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$ControllerButtonState$StartRecording;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$ControllerButtonState$StopRecording;", "intellij.profiler.ultimate"})
    private static sealed interface ControllerButtonState {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$ControllerButtonState$ShowResults;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$ControllerButtonState;", "<init>", "()V", "intellij.profiler.ultimate"})
        public static final class ShowResults
        implements ControllerButtonState {
            @NotNull
            public static final ShowResults INSTANCE = new ShowResults();

            private ShowResults() {
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$ControllerButtonState$StartRecording;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$ControllerButtonState;", "targetProcess", "Lcom/intellij/profiler/api/AttachableTargetProcess;", "<init>", "(Lcom/intellij/profiler/api/AttachableTargetProcess;)V", "getTargetProcess", "()Lcom/intellij/profiler/api/AttachableTargetProcess;", "intellij.profiler.ultimate"})
        public static final class StartRecording
        implements ControllerButtonState {
            @NotNull
            private final AttachableTargetProcess targetProcess;

            public StartRecording(@NotNull AttachableTargetProcess targetProcess) {
                Intrinsics.checkNotNullParameter((Object)targetProcess, (String)"targetProcess");
                this.targetProcess = targetProcess;
            }

            @NotNull
            public final AttachableTargetProcess getTargetProcess() {
                return this.targetProcess;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$ControllerButtonState$StopRecording;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$ControllerButtonState;", "profilerProcess", "Lcom/intellij/profiler/ultimate/JavaProfilerProcess;", "<init>", "(Lcom/intellij/profiler/ultimate/JavaProfilerProcess;)V", "getProfilerProcess", "()Lcom/intellij/profiler/ultimate/JavaProfilerProcess;", "intellij.profiler.ultimate"})
        public static final class StopRecording
        implements ControllerButtonState {
            @NotNull
            private final JavaProfilerProcess<?> profilerProcess;

            public StopRecording(@NotNull JavaProfilerProcess<?> profilerProcess) {
                Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
                this.profilerProcess = profilerProcess;
            }

            @NotNull
            public final JavaProfilerProcess<?> getProfilerProcess() {
                return this.profilerProcess;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0014\u0010\u0013\u001a\u00020\u00102\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016J\u0014\u0010\u0016\u001a\u00020\u00102\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0016J\u001c\u0010\u0019\u001a\u00020\u00102\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0010H\u0016J\b\u0010\u001d\u001a\u00020\u0010H\u0016R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyCpuAndMemoryPanel;", "Lcom/intellij/ui/components/JBPanelWithEmptyText;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyWidgetPart;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel;Lkotlinx/coroutines/CoroutineScope;)V", "worker", "flow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/profiler/ultimate/widget/LiveChartState;", "liveChart", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetLiveChart;", "firstAttach", "", "setProcessId", "", "processId", "", "processSetWithoutProfiler", "handler", "Lcom/intellij/execution/process/BaseProcessHandler;", "profilerAttached", "profilerProcess", "Lcom/intellij/profiler/ultimate/JavaProfilerProcess;", "profilerDetached", "exactState", "Lcom/intellij/profiler/api/ProfilerState;", "processTerminated", "dispose", "intellij.profiler.ultimate"})
    private final class MyCpuAndMemoryPanel
    extends JBPanelWithEmptyText
    implements MyWidgetPart {
        @NotNull
        private final CoroutineScope worker;
        @NotNull
        private final MutableStateFlow<LiveChartState> flow;
        @NotNull
        private final JavaProfilerWidgetLiveChart liveChart;
        private boolean firstAttach;

        public MyCpuAndMemoryPanel(CoroutineScope scope) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            super((LayoutManager)new BorderLayout());
            this.worker = CoroutineScopeKt.childScope$default((CoroutineScope)scope, (String)"CPU And Memory Worker", null, (boolean)false, (int)6, null);
            this.flow = StateFlowKt.MutableStateFlow((Object)LiveChartState.Initial.INSTANCE);
            this.liveChart = new JavaProfilerWidgetLiveChart(this.flow);
            this.firstAttach = true;
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)3));
            this.add((Component)((Object)this.liveChart), "Center");
            BuildersKt.launch$default((CoroutineScope)this.worker, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ MyCpuAndMemoryPanel this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = FlowKt.collectLatest((Flow)((Flow)this.this$0.flow), (Function2)((Function2)new Function2<LiveChartState, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                /* synthetic */ Object L$0;
                                final /* synthetic */ MyCpuAndMemoryPanel this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    LiveChartState liveChartState = (LiveChartState)this.L$0;
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            void state;
                                            ResultKt.throwOnFailure((Object)$result);
                                            void var3_3 = state;
                                            if (!(var3_3 instanceof LiveChartState.Initial)) {
                                                if (var3_3 instanceof LiveChartState.Empty) {
                                                    StatusText statusText;
                                                    if (Intrinsics.areEqual((Object)state, (Object)LiveChartState.Empty.ProcessTerminated.INSTANCE)) {
                                                        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.this$0.worker, null, (int)1, null);
                                                    }
                                                    this.this$0.liveChart.setVisible(false);
                                                    StatusText $this$invokeSuspend_u24lambda_u240 = statusText = this.this$0.getEmptyText();
                                                    boolean bl = false;
                                                    $this$invokeSuspend_u24lambda_u240.clear();
                                                    $this$invokeSuspend_u24lambda_u240.appendLine(((LiveChartState.Empty)state).getMessage());
                                                } else if (var3_3 instanceof LiveChartState.NotEmpty) {
                                                    this.this$0.liveChart.setVisible(true);
                                                } else {
                                                    throw new NoWhenBranchMatchedException();
                                                }
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(LiveChartState p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }

        @Override
        public void setProcessId(long processId) {
            this.liveChart.setProcessId(processId);
        }

        @Override
        public void processSetWithoutProfiler(@NotNull BaseProcessHandler<?> handler) {
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            BuildersKt.launch$default((CoroutineScope)this.worker, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ MyCpuAndMemoryPanel this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void $this$launch;
                            ResultKt.throwOnFailure((Object)$result);
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                            this.label = 1;
                            Object object2 = MyCpuAndMemoryPanel.access$getLiveChart$p(this.this$0).start((CoroutineScope)$this$launch, (Continuation<? super Unit>)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        @Override
        public void profilerAttached(@NotNull JavaProfilerProcess<?> profilerProcess) {
            Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
            boolean first = this.firstAttach;
            this.firstAttach = false;
            if (first) {
                BuildersKt.launch$default((CoroutineScope)this.worker, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ MyCpuAndMemoryPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void $this$launch;
                                ResultKt.throwOnFailure((Object)$result);
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                                this.label = 1;
                                Object object2 = MyCpuAndMemoryPanel.access$getLiveChart$p(this.this$0).start((CoroutineScope)$this$launch, (Continuation<? super Unit>)((Continuation)this));
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }

        @Override
        public void profilerDetached(@NotNull JavaProfilerProcess<?> profilerProcess, @NotNull ProfilerState exactState) {
            Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
            Intrinsics.checkNotNullParameter((Object)exactState, (String)"exactState");
        }

        @Override
        public void processTerminated() {
            BuildersKt.launch$default((CoroutineScope)this.worker, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ MyCpuAndMemoryPanel this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = MyCpuAndMemoryPanel.access$getLiveChart$p(this.this$0).processTerminated((Continuation<? super Unit>)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        public void dispose() {
            BuildersKt.launch$default((CoroutineScope)this.worker, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ MyCpuAndMemoryPanel this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = MyCpuAndMemoryPanel.access$getLiveChart$p(this.this$0).cancel(JavaProfilerWidgetLiveChart.ChartsTerminationStrategy.DISABLE, (Continuation<? super Unit>)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)MyCpuAndMemoryPanel.access$getWorker$p(this.this$0), null, (int)1, null);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0014\u0010\u0013\u001a\u00020\u00102\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016J\u0014\u0010\u0016\u001a\u00020\u00102\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0016J\u001c\u0010\u0019\u001a\u00020\u00102\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0010H\u0016J\b\u0010\u001d\u001a\u00020\u0010H\u0002J\b\u0010\u001e\u001a\u00020\u0010H\u0002J\b\u0010\u001f\u001a\u00020\u0010H\u0002J\b\u0010 \u001a\u00020\u0010H\u0016J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#H\u0002R\u0016\u0010\u0004\u001a\n0\u0005R\u00060\u0000R\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyWidgetPart;", "<init>", "(Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel;)V", "actionsHolder", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController$ActionsHolder;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel;", "panel", "Lcom/intellij/ui/CardLayoutPanel;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$ControllerButtonState;", "Ljavax/swing/JComponent;", "getPanel", "()Lcom/intellij/ui/CardLayoutPanel;", "switchWindowOnDataReadyRequired", "", "setProcessId", "", "processId", "", "processSetWithoutProfiler", "handler", "Lcom/intellij/execution/process/BaseProcessHandler;", "profilerAttached", "profilerProcess", "Lcom/intellij/profiler/ultimate/JavaProfilerProcess;", "profilerDetached", "exactState", "Lcom/intellij/profiler/api/ProfilerState;", "processTerminated", "showToolWindowContent", "onCannotFindToolWindow", "onCannotFindContent", "dispose", "logAction", "actionDescriptor", "Lcom/intellij/profiler/statistics/ProfilerUsageTriggerCollector$RunWidgetActionFusDescriptor;", "ActionsHolder", "intellij.profiler.ultimate"})
    private final class MyRecordingController
    implements MyWidgetPart {
        @NotNull
        private final ActionsHolder actionsHolder = new ActionsHolder();
        @NotNull
        private final CardLayoutPanel<ControllerButtonState, ControllerButtonState, JComponent> panel = (CardLayoutPanel)new CardLayoutPanel<ControllerButtonState, ControllerButtonState, JComponent>(this){
            final /* synthetic */ MyRecordingController this$0;
            {
                this.this$0 = $receiver;
            }

            protected ControllerButtonState prepare(ControllerButtonState key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return key;
            }

            protected JComponent create(ControllerButtonState state) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                return MyRecordingController.access$getActionsHolder$p(this.this$0).createComponent(state);
            }
        };
        private boolean switchWindowOnDataReadyRequired;

        @NotNull
        public final CardLayoutPanel<ControllerButtonState, ControllerButtonState, JComponent> getPanel() {
            return this.panel;
        }

        @Override
        public void setProcessId(long processId) {
        }

        @Override
        public void processSetWithoutProfiler(@NotNull BaseProcessHandler<?> handler) {
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            if (handler instanceof BaseOSProcessHandler) {
                BaseOSProcessHandler baseOSProcessHandler = (BaseOSProcessHandler)handler;
                String string = JavaProfilerWidgetPanel.this.configuration.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                this.panel.select((Object)new ControllerButtonState.StartRecording(new TargetProcessBase(baseOSProcessHandler, string)), true);
            }
        }

        @Override
        public void profilerAttached(@NotNull JavaProfilerProcess<?> profilerProcess) {
            Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
            this.panel.select((Object)new ControllerButtonState.StopRecording(profilerProcess), true);
        }

        @Override
        public void profilerDetached(@NotNull JavaProfilerProcess<?> profilerProcess, @NotNull ProfilerState exactState) {
            Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
            Intrinsics.checkNotNullParameter((Object)exactState, (String)"exactState");
            ProfilerTargetProcess targetProcess = profilerProcess.getTargetProcess();
            ActionCallback actionCallback = targetProcess instanceof AttachableTargetProcess ? this.panel.select((Object)new ControllerButtonState.StartRecording((AttachableTargetProcess)targetProcess), true) : this.panel.select((Object)ControllerButtonState.ShowResults.INSTANCE, true);
            if (exactState instanceof DataReady && this.switchWindowOnDataReadyRequired) {
                this.switchWindowOnDataReadyRequired = false;
                this.showToolWindowContent();
            }
        }

        @Override
        public void processTerminated() {
            this.switchWindowOnDataReadyRequired = false;
            this.panel.select((Object)ControllerButtonState.ShowResults.INSTANCE, true);
        }

        private final void showToolWindowContent() {
            Content content;
            Project project = JavaProfilerWidgetPanel.this.configuration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Profiler");
            if (toolWindow == null) {
                this.onCannotFindToolWindow();
                return;
            }
            Project project2 = JavaProfilerWidgetPanel.this.configuration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            ProfilerToolWindowManager profilerToolWindowManager = ProfilerToolWindowManager.Companion.getInstance(project2);
            JavaProfilerProcess javaProfilerProcess = JavaProfilerWidgetPanel.this.currentProfilerProcess;
            if (javaProfilerProcess == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentProfilerProcess");
                javaProfilerProcess = null;
            }
            if ((content = profilerToolWindowManager.findToolWindowContent(toolWindow, (ProfilerProcess)javaProfilerProcess)) == null) {
                this.onCannotFindContent();
                return;
            }
            toolWindow.getContentManager().setSelectedContent(content);
            toolWindow.activate(null);
        }

        private final void onCannotFindToolWindow() {
        }

        private final void onCannotFindContent() {
            JavaProfilerProcess javaProfilerProcess = JavaProfilerWidgetPanel.this.currentProfilerProcess;
            if (javaProfilerProcess == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentProfilerProcess");
                javaProfilerProcess = null;
            }
            Project project = javaProfilerProcess.getProject();
            JavaProfilerProcess javaProfilerProcess2 = JavaProfilerWidgetPanel.this.currentProfilerProcess;
            if (javaProfilerProcess2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentProfilerProcess");
                javaProfilerProcess2 = null;
            }
            ImportProfilerResultAction.Companion.importProfilerDump$default((ImportProfilerResultAction.Companion)ImportProfilerResultAction.Companion, (Project)project, (File)javaProfilerProcess2.getDumpFileWhenTargetProcessFinished(), null, null, null, (SnapshotImportEventData)new SnapshotImportEventData(SnapshotImportOrigin.REOPEN_FROM_WIDGET, (SnapshotImportSource)SnapshotImportSource.External.INSTANCE), (int)28, null);
        }

        public void dispose() {
        }

        private final void logAction(ProfilerUsageTriggerCollector.RunWidgetActionFusDescriptor actionDescriptor) {
            Project project = JavaProfilerWidgetPanel.this.configuration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ProfilerUsageTriggerCollector.INSTANCE.logRunWidgetInteraction(project, actionDescriptor, JavaProfilerWidgetPanel.this.widgetMode.getOrigin());
        }

        public static final /* synthetic */ ActionsHolder access$getActionsHolder$p(MyRecordingController $this) {
            return $this.actionsHolder;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0005\u0018\u0019\u001a\u001b\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u000e0\u000fR\n0\u0000R\u00060\u0010R\u00020\u0011*\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u000e0\u000fR\n0\u0000R\u00060\u0010R\u00020\u0011*\u00020\u0012H\u0002J\u0014\u0010\u0014\u001a\u00020\u000b2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController$ActionsHolder;", "", "<init>", "(Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController;)V", "button", "Lcom/intellij/ui/components/JBOptionButton;", "createComponent", "Ljavax/swing/JComponent;", "state", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$ControllerButtonState;", "startButton", "", "targetProcess", "Lcom/intellij/profiler/api/AttachableTargetProcess;", "createStartRecordingActionWithoutName", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController$ActionsHolder$StartRecordingAction;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel;", "Lcom/intellij/profiler/api/XLocalAttachProfiler;", "createStartRecordingActionWithName", "stopButton", "profilerProcess", "Lcom/intellij/profiler/ultimate/JavaProfilerProcess;", "resultsButton", "StartRecordingAction", "StopRecordingAndShowResultsAction", "ShowResultsAction", "CaptureMemorySnapshotAction", "AnActionAdapter", "intellij.profiler.ultimate"})
        private final class ActionsHolder {
            @NotNull
            private final JBOptionButton button = new JBOptionButton(null, null);

            public ActionsHolder() {
                this.button.setPopupHandler(arg_0 -> ActionsHolder._init_$lambda$0(MyRecordingController.this, arg_0));
            }

            @NotNull
            public final JComponent createComponent(@NotNull ControllerButtonState state) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                ControllerButtonState controllerButtonState = state;
                if (controllerButtonState instanceof ControllerButtonState.StartRecording) {
                    this.startButton(((ControllerButtonState.StartRecording)state).getTargetProcess());
                } else if (controllerButtonState instanceof ControllerButtonState.StopRecording) {
                    this.stopButton(((ControllerButtonState.StopRecording)state).getProfilerProcess());
                } else if (Intrinsics.areEqual((Object)controllerButtonState, (Object)ControllerButtonState.ShowResults.INSTANCE)) {
                    this.resultsButton();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return (JComponent)this.button;
            }

            private final void startButton(AttachableTargetProcess targetProcess) {
                JBOptionButton jBOptionButton;
                List<XLocalAttachProfiler> profilers = JavaLocalAttachProfilerProvider.Companion.profilersFactory$intellij_profiler_ultimate(targetProcess);
                JBOptionButton $this$startButton_u24lambda_u240 = jBOptionButton = this.button;
                boolean bl = false;
                switch (profilers.size()) {
                    case 0: {
                        $this$startButton_u24lambda_u240.setAction((Action)new CaptureMemorySnapshotAction(this, targetProcess.getPid(), targetProcess.getShortName()));
                        $this$startButton_u24lambda_u240.setOptions(null);
                        break;
                    }
                    case 1: {
                        $this$startButton_u24lambda_u240.setAction((Action)this.createStartRecordingActionWithoutName((XLocalAttachProfiler)CollectionsKt.single(profilers)));
                        Action[] actionArray = new Action[]{new CaptureMemorySnapshotAction(this, targetProcess.getPid(), targetProcess.getShortName())};
                        $this$startButton_u24lambda_u240.setOptions(actionArray);
                        break;
                    }
                    default: {
                        $this$startButton_u24lambda_u240.setAction((Action)this.createStartRecordingActionWithName((XLocalAttachProfiler)CollectionsKt.first(profilers)));
                        int otherProfilersAmount = profilers.size() - 1;
                        int n = otherProfilersAmount + 1;
                        Action[] actionArray = new Action[n];
                        JBOptionButton jBOptionButton2 = $this$startButton_u24lambda_u240;
                        for (int i = 0; i < n; ++i) {
                            int n2 = i;
                            actionArray[n2] = n2 >= otherProfilersAmount ? (AnActionAdapter)new CaptureMemorySnapshotAction(this, targetProcess.getPid(), targetProcess.getShortName()) : (AnActionAdapter)this.createStartRecordingActionWithName(profilers.get(n2 + 1));
                        }
                        jBOptionButton2.setOptions(actionArray);
                    }
                }
            }

            private final StartRecordingAction createStartRecordingActionWithoutName(XLocalAttachProfiler $this$createStartRecordingActionWithoutName) {
                return new StartRecordingAction(CommonProfilerBundleKt.commonProfilerMessage((String)"run.profiler.startRecording", (Object[])new Object[0]), $this$createStartRecordingActionWithoutName);
            }

            private final StartRecordingAction createStartRecordingActionWithName(XLocalAttachProfiler $this$createStartRecordingActionWithName) {
                Object[] objectArray = new Object[]{$this$createStartRecordingActionWithName.getProfilerDisplayName()};
                return new StartRecordingAction(CommonProfilerBundleKt.commonProfilerMessage((String)"run.profiler.startRecordingWith", (Object[])objectArray), $this$createStartRecordingActionWithName);
            }

            private final void stopButton(JavaProfilerProcess<?> profilerProcess) {
                JBOptionButton jBOptionButton;
                JBOptionButton $this$stopButton_u24lambda_u240 = jBOptionButton = this.button;
                boolean bl = false;
                $this$stopButton_u24lambda_u240.setAction((Action)new StopRecordingAndShowResultsAction(profilerProcess));
                ProfilerTargetProcess profilerTargetProcess = profilerProcess.getTargetProcess();
                Intrinsics.checkNotNull((Object)profilerTargetProcess, (String)"null cannot be cast to non-null type com.intellij.profiler.api.AttachableTargetProcess");
                AttachableTargetProcess targetProcess = (AttachableTargetProcess)profilerTargetProcess;
                Action[] actionArray = new Action[]{new CaptureMemorySnapshotAction(this, targetProcess.getPid(), targetProcess.getShortName())};
                $this$stopButton_u24lambda_u240.setOptions(actionArray);
            }

            private final void resultsButton() {
                JBOptionButton jBOptionButton;
                JBOptionButton $this$resultsButton_u24lambda_u240 = jBOptionButton = this.button;
                boolean bl = false;
                $this$resultsButton_u24lambda_u240.setAction((Action)new ShowResultsAction());
                $this$resultsButton_u24lambda_u240.setOptions(null);
            }

            private static final Unit _init_$lambda$0(MyRecordingController this$0, JBPopup popup2) {
                Intrinsics.checkNotNullParameter((Object)popup2, (String)"popup");
                this$0.logAction(ProfilerUsageTriggerCollector.RunWidgetActionFusDescriptor.WIDGET_EXPAND_OPTIONS);
                return Unit.INSTANCE;
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00a2\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0014\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController$ActionsHolder$AnActionAdapter;", "Ljavax/swing/AbstractAction;", "Lcom/intellij/openapi/ui/OptionAction;", "Lcom/intellij/openapi/project/DumbAware;", "text", "", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController$ActionsHolder;Ljava/lang/String;)V", "getOptions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "intellij.profiler.ultimate"})
            private abstract class AnActionAdapter
            extends AbstractAction
            implements OptionAction,
            DumbAware {
                public AnActionAdapter(String text) {
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    super(text);
                }

                @NotNull
                public Action[] getOptions() {
                    return new Action[0];
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u000e0\u0001R\n0\u0002R\u00060\u0003R\u00020\u0004B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\fJ\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController$ActionsHolder$CaptureMemorySnapshotAction;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController$ActionsHolder$AnActionAdapter;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController$ActionsHolder;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel;", "pid", "", "executableName", "", "appName", "<init>", "(Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController$ActionsHolder;ILjava/lang/String;Ljava/lang/String;)V", "(Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController$ActionsHolder;ILjava/lang/String;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.profiler.ultimate"})
            private final class CaptureMemorySnapshotAction
            extends AnActionAdapter {
                private final int pid;
                @NotNull
                private final String executableName;
                @NotNull
                private final String appName;
                final /* synthetic */ ActionsHolder this$0;

                public CaptureMemorySnapshotAction(ActionsHolder this$0, @NotNull int pid, @NotNull String executableName, String appName) {
                    Intrinsics.checkNotNullParameter((Object)executableName, (String)"executableName");
                    Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
                    this.this$0 = this$0;
                    super(UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.processes.capture", new Object[0]));
                    this.pid = pid;
                    this.executableName = executableName;
                    this.appName = appName;
                }

                public CaptureMemorySnapshotAction(ActionsHolder this$0, @NotNull int pid, String appName) {
                    Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
                    this(this$0, pid, "java", appName);
                }

                @Override
                public void actionPerformed(@Nullable ActionEvent e) {
                    Project project = this.this$0.JavaProfilerWidgetPanel.this.configuration.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    CaptureMemorySnapshotKt.captureMemorySnapshot(project, this.pid, this.executableName, this.appName, (Function2<? super Project, ? super File, Unit>)((Function2)(arg_0, arg_1) -> CaptureMemorySnapshotAction.actionPerformed$lambda$0(this.this$0.MyRecordingController.this, arg_0, arg_1)));
                }

                private static final Unit actionPerformed$lambda$0(MyRecordingController this$0, Project project, File file) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    this$0.logAction(ProfilerUsageTriggerCollector.RunWidgetActionFusDescriptor.WIDGET_CAPTURE_MEMORY_SNAPSHOT);
                    ImportProfilerResultAction.Companion.importProfilerDump$default((ImportProfilerResultAction.Companion)ImportProfilerResultAction.Companion, (Project)project, (File)file, null, null, null, null, (int)60, null);
                    return Unit.INSTANCE;
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u000e0\u0001R\n0\u0002R\u00060\u0003R\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController$ActionsHolder$ShowResultsAction;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController$ActionsHolder$AnActionAdapter;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController$ActionsHolder;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel;", "<init>", "(Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController$ActionsHolder;)V", "isEnabled", "", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.profiler.ultimate"})
            private final class ShowResultsAction
            extends AnActionAdapter {
                public ShowResultsAction() {
                    super(CommonProfilerBundleKt.commonProfilerMessage((String)"run.profiler.showResults", (Object[])new Object[0]));
                }

                @Override
                public boolean isEnabled() {
                    return JavaProfilerWidgetPanel.this.currentProfilerProcess != null;
                }

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    MyRecordingController.this.logAction(ProfilerUsageTriggerCollector.RunWidgetActionFusDescriptor.WIDGET_SHOW_RESULTS);
                    MyRecordingController.this.showToolWindowContent();
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u000e0\u0001R\n0\u0002R\u00060\u0003R\u00020\u0004B\u001c\u0012\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController$ActionsHolder$StartRecordingAction;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController$ActionsHolder$AnActionAdapter;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController$ActionsHolder;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel;", "name", "", "Lorg/jetbrains/annotations/Nls;", "profiler", "Lcom/intellij/profiler/api/XLocalAttachProfiler;", "<init>", "(Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController$ActionsHolder;Ljava/lang/String;Lcom/intellij/profiler/api/XLocalAttachProfiler;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.profiler.ultimate"})
            private final class StartRecordingAction
            extends AnActionAdapter {
                @NotNull
                private final XLocalAttachProfiler profiler;

                public StartRecordingAction(@NotNull String name, XLocalAttachProfiler profiler2) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    Intrinsics.checkNotNullParameter((Object)profiler2, (String)"profiler");
                    super(name);
                    this.profiler = profiler2;
                }

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    MyRecordingController.this.logAction(ProfilerUsageTriggerCollector.RunWidgetActionFusDescriptor.WIDGET_START_RECORDING);
                    Project project = JavaProfilerWidgetPanel.this.configuration.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    this.profiler.attachProfilerSession(project, arg_0 -> StartRecordingAction.actionPerformed$lambda$0(JavaProfilerWidgetPanel.this, arg_0));
                }

                private static final Unit actionPerformed$lambda$0(JavaProfilerWidgetPanel this$0, ProfilerProcess process) {
                    Intrinsics.checkNotNullParameter((Object)process, (String)"process");
                    if (process instanceof JavaProfilerProcess) {
                        this$0.setProfilerProcess((JavaProfilerProcess)process);
                        ToolWindowActivationProperties properties = new ToolWindowActivationProperties(false, false, () -> StartRecordingAction.actionPerformed$lambda$0$0(this$0, process));
                        Project project = this$0.configuration.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        ProfilerToolWindowManager.Companion.getInstance(project).addProfilerProcessTab(process, properties);
                    }
                    return Unit.INSTANCE;
                }

                private static final boolean actionPerformed$lambda$0$0(JavaProfilerWidgetPanel this$0, ProfilerProcess $process) {
                    return !ProcessUtilKt.isProcessLikelyTerminatedByUser(this$0.processExitCode) && !ProcessUtilKt.isProfilerDetached((JavaProfilerProcess)$process);
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u000e0\u0001R\n0\u0002R\u00060\u0003R\u00020\u0004B\u0013\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController$ActionsHolder$StopRecordingAndShowResultsAction;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController$ActionsHolder$AnActionAdapter;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController$ActionsHolder;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel;", "profilerProcess", "Lcom/intellij/profiler/ultimate/JavaProfilerProcess;", "<init>", "(Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyRecordingController$ActionsHolder;Lcom/intellij/profiler/ultimate/JavaProfilerProcess;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.profiler.ultimate"})
            private final class StopRecordingAndShowResultsAction
            extends AnActionAdapter {
                @NotNull
                private final JavaProfilerProcess<?> profilerProcess;

                public StopRecordingAndShowResultsAction(JavaProfilerProcess<?> profilerProcess) {
                    Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
                    super(CommonProfilerBundleKt.commonProfilerMessage((String)"run.profiler.stopRecordingAndShow", (Object[])new Object[0]));
                    this.profilerProcess = profilerProcess;
                }

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    MyRecordingController.this.logAction(ProfilerUsageTriggerCollector.RunWidgetActionFusDescriptor.WIDGET_STOP_RECORDING);
                    MyRecordingController.this.switchWindowOnDataReadyRequired = true;
                    this.profilerProcess.stop();
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0006H\u0016J\u0014\u0010\u0019\u001a\u00020\u00142\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016J\u0014\u0010\u001c\u001a\u00020\u00142\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0016J\u001c\u0010\u001f\u001a\u00020\u00142\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001e2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0014H\u0016J\b\u0010#\u001a\u00020\u0014H\u0002J\b\u0010$\u001a\u00020\u0014H\u0016J\b\u0010%\u001a\u00020\u0014H\u0002J\b\u0010&\u001a\u00020\u0014H\u0002J\b\u0010'\u001a\u00020\u0014H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyTimer;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyWidgetPart;", "<init>", "()V", "startTimeMs", "", "getStartTimeMs", "()J", "setStartTimeMs", "(J)V", "myTimeString", "", "myCurrentIcon", "Ljavax/swing/Icon;", "myForeground", "Ljava/awt/Color;", "durationUpdater", "Ljava/util/concurrent/ScheduledFuture;", "paintComponent", "", "g", "Ljava/awt/Graphics;", "setProcessId", "processId", "processSetWithoutProfiler", "handler", "Lcom/intellij/execution/process/BaseProcessHandler;", "profilerAttached", "profilerProcess", "Lcom/intellij/profiler/ultimate/JavaProfilerProcess;", "profilerDetached", "exactState", "Lcom/intellij/profiler/api/ProfilerState;", "processTerminated", "doTerminate", "dispose", "updateProfilingDuration", "setInactive", "setActive", "Companion", "intellij.profiler.ultimate"})
    private static final class MyTimer
    extends BorderLayoutPanel
    implements MyWidgetPart {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private long startTimeMs;
        @NotNull
        private String myTimeString = "00:00";
        private Icon myCurrentIcon;
        private Color myForeground;
        @Nullable
        private ScheduledFuture<?> durationUpdater;
        @NotNull
        private static final Font FONT = new Font("JetBrains Mono", 0, FontPreferences.DEFAULT_FONT_SIZE);
        private static final int TIMER_HEIGHT = 24;
        private static final int LEFT_RIGHT_BORDER = 6;
        private static final int ICON_TEXT_GAP = 7;
        private static final int ARC_SIZE = 3;

        public MyTimer() {
            this.setInactive();
        }

        public final long getStartTimeMs() {
            return this.startTimeMs;
        }

        public final void setStartTimeMs(long l) {
            this.startTimeMs = l;
        }

        protected void paintComponent(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            super.paintComponent(g);
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            g.setFont(FONT);
            String time = this.myTimeString;
            Icon icon = this.myCurrentIcon;
            if (icon == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myCurrentIcon");
                icon = null;
            }
            Icon icon2 = icon;
            FontMetrics fm = g.getFontMetrics();
            int timeWidth = fm.stringWidth(time);
            Icon icon3 = this.myCurrentIcon;
            if (icon3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myCurrentIcon");
                icon3 = null;
            }
            int totalWidth = 6 + icon3.getIconWidth() + 7 + timeWidth + 6;
            int totalHeight = 24;
            int rectStartY = (this.getHeight() - 24) / 2;
            int componentWidth = this.getWidth() - rectStartY;
            JBColor background = CpuMemoryChartColors.INSTANCE.getTimerBackground();
            if (background != null) {
                g.setColor((Color)background);
                int rectStartX = componentWidth - totalWidth;
                g.fillRoundRect(rectStartX, rectStartY, totalWidth, totalHeight, 3, 3);
            }
            int iconStartX = componentWidth - totalWidth + 6;
            int iconStartY = (this.getHeight() - icon2.getIconHeight()) / 2;
            icon2.paintIcon((Component)((Object)this), g, iconStartX, iconStartY);
            Color color = this.myForeground;
            if (color == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myForeground");
                color = null;
            }
            g.setColor(color);
            Icon icon4 = this.myCurrentIcon;
            if (icon4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myCurrentIcon");
                icon4 = null;
            }
            int textStartX = componentWidth - totalWidth + 6 + icon4.getIconWidth() + 7;
            int textStartY = fm.getAscent() + (this.getHeight() - (fm.getAscent() + fm.getDescent())) / 2;
            g.drawString(time, textStartX, textStartY);
        }

        @Override
        public void setProcessId(long processId) {
        }

        @Override
        public void processSetWithoutProfiler(@NotNull BaseProcessHandler<?> handler) {
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
        }

        @Override
        public void profilerAttached(@NotNull JavaProfilerProcess<?> profilerProcess) {
            Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
            this.setActive();
            this.startTimeMs = profilerProcess.getStartTimeMs();
            this.durationUpdater = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(this::updateProfilingDuration, 0L, 1L, TimeUnit.SECONDS);
        }

        @Override
        public void profilerDetached(@NotNull JavaProfilerProcess<?> profilerProcess, @NotNull ProfilerState exactState) {
            Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
            Intrinsics.checkNotNullParameter((Object)exactState, (String)"exactState");
            this.doTerminate();
        }

        @Override
        public void processTerminated() {
            this.doTerminate();
        }

        private final void doTerminate() {
            ScheduledFuture<?> scheduledFuture = this.durationUpdater;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(true);
            }
            this.durationUpdater = null;
            this.setInactive();
        }

        public void dispose() {
            this.doTerminate();
        }

        private final void updateProfilingDuration() {
            String text;
            Duration duration = Duration.ofMillis(System.currentTimeMillis() - this.startTimeMs);
            Intrinsics.checkNotNull((Object)duration);
            this.myTimeString = text = UtilsKt.durationToCompactString((Duration)duration);
            this.repaint();
        }

        private final void setInactive() {
            Icon icon = AllIcons.Profiler.Rec;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Rec");
            this.myCurrentIcon = IconLoader.getDisabledIcon((Icon)icon);
            this.myForeground = (Color)CpuMemoryChartColors.INSTANCE.getTimerDisabledForeground();
        }

        private final void setActive() {
            Icon icon = AllIcons.Profiler.Rec;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Rec");
            this.myCurrentIcon = icon;
            this.myForeground = (Color)CpuMemoryChartColors.INSTANCE.getTimerForeground();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyTimer$Companion;", "", "<init>", "()V", "FONT", "Ljava/awt/Font;", "TIMER_HEIGHT", "", "LEFT_RIGHT_BORDER", "ICON_TEXT_GAP", "ARC_SIZE", "intellij.profiler.ultimate"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0014\u0010\u0006\u001a\u00020\u00032\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH&J\u0014\u0010\t\u001a\u00020\u00032\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH&J\u001c\u0010\f\u001a\u00020\u00032\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\r\u001a\u00020\u000eH&J\b\u0010\u000f\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lcom/intellij/profiler/ultimate/widget/JavaProfilerWidgetPanel$MyWidgetPart;", "Lcom/intellij/openapi/Disposable;", "setProcessId", "", "processId", "", "processSetWithoutProfiler", "handler", "Lcom/intellij/execution/process/BaseProcessHandler;", "profilerAttached", "profilerProcess", "Lcom/intellij/profiler/ultimate/JavaProfilerProcess;", "profilerDetached", "exactState", "Lcom/intellij/profiler/api/ProfilerState;", "processTerminated", "intellij.profiler.ultimate"})
    private static interface MyWidgetPart
    extends Disposable {
        public void setProcessId(long var1);

        public void processSetWithoutProfiler(@NotNull BaseProcessHandler<?> var1);

        public void profilerAttached(@NotNull JavaProfilerProcess<?> var1);

        public void profilerDetached(@NotNull JavaProfilerProcess<?> var1, @NotNull ProfilerState var2);

        public void processTerminated();
    }
}

