/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v1;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.openjdk.jmc.flightrecorder.internal.parser.v1.IDataInput;
import org.openjdk.jmc.flightrecorder.internal.util.DataInputToolkit;
import org.openjdk.jmc.flightrecorder.parser.ByteBufferWrapper;

class SeekableInputStream
implements IDataInput {
    private static final byte STRING_ENCODING_NULL = 0;
    private static final byte STRING_ENCODING_EMPTY_STRING = 1;
    static final byte STRING_ENCODING_CONSTANT_POOL = 2;
    private static final byte STRING_ENCODING_UTF8_BYTE_ARRAY = 3;
    private static final byte STRING_ENCODING_CHAR_ARRAY = 4;
    private static final byte STRING_ENCODING_LATIN1_BYTE_ARRAY = 5;
    private final ByteBufferWrapper buffer;
    private int pos;

    public SeekableInputStream(ByteBufferWrapper buffer) {
        this.buffer = buffer;
    }

    public void seek(long pos) throws IOException {
        if (pos < 0L || pos >= (long)this.buffer.limit()) {
            throw new IOException("Seeking for " + pos + " in buffer of length " + this.buffer.limit());
        }
        this.pos = (int)pos;
    }

    public void readFully(byte[] b) {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] dst, int off, int len) {
        this.buffer.position(this.pos);
        this.buffer.get(dst, off, len);
        this.pos += len;
    }

    @Override
    public boolean readBoolean() throws IOException {
        boolean value = DataInputToolkit.readBoolean(this.buffer, this.pos);
        ++this.pos;
        return value;
    }

    @Override
    public byte readByte() throws IOException {
        byte value = DataInputToolkit.readByte(this.buffer, this.pos);
        ++this.pos;
        return value;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int value = DataInputToolkit.readUnsignedByte(this.buffer, this.pos);
        ++this.pos;
        return value;
    }

    @Override
    public short readShort() throws IOException {
        short value = DataInputToolkit.readShort(this.buffer, this.pos);
        this.pos += 2;
        return value;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int value = DataInputToolkit.readUnsignedShort(this.buffer, this.pos);
        this.pos += 2;
        return value;
    }

    @Override
    public char readChar() throws IOException {
        char value = DataInputToolkit.readChar(this.buffer, this.pos);
        this.pos += 2;
        return value;
    }

    @Override
    public int readInt() throws IOException {
        int value = DataInputToolkit.readInt(this.buffer, this.pos);
        this.pos += 4;
        return value;
    }

    @Override
    public long readUnsignedInt() throws IOException {
        long value = DataInputToolkit.readUnsignedInt(this.buffer, this.pos);
        this.pos += 4;
        return value;
    }

    @Override
    public long readLong() throws IOException {
        long value = DataInputToolkit.readLong(this.buffer, this.pos);
        this.pos += 8;
        return value;
    }

    @Override
    public float readFloat() throws IOException {
        float value = DataInputToolkit.readFloat(this.buffer, this.pos);
        this.pos += 4;
        return value;
    }

    @Override
    public double readDouble() throws IOException {
        double value = DataInputToolkit.readDouble(this.buffer, this.pos);
        this.pos += 8;
        return value;
    }

    @Override
    public String readRawString(byte encoding) throws IOException {
        switch (encoding) {
            case 0: {
                return null;
            }
            case 1: {
                return "";
            }
            case 3: 
            case 5: {
                int size = this.readInt();
                byte[] buf = new byte[size];
                this.readFully(buf);
                return new String(buf, encoding == 3 ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1);
            }
            case 4: {
                int charCount = this.readInt();
                char[] c = new char[charCount];
                for (int i = 0; i < c.length; ++i) {
                    c[i] = this.readChar();
                }
                return new String(c);
            }
        }
        throw new IOException("Disallowed raw string encoding: " + encoding);
    }

    @Override
    public void skipString() throws IOException {
        byte encoding = this.readByte();
        switch (encoding) {
            case 0: 
            case 1: {
                return;
            }
            case 3: 
            case 5: {
                int size = this.readInt();
                this.pos += size;
                return;
            }
            case 4: {
                int charCount = this.readInt();
                for (int i = 0; i < charCount; ++i) {
                    this.readChar();
                }
                return;
            }
            case 2: {
                this.readLong();
                return;
            }
        }
        throw new IOException();
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    static SeekableInputStream build(ByteBufferWrapper data2, boolean compressedInts) {
        return compressedInts ? new CompressedIntsDataInput(data2) : new SeekableInputStream(data2);
    }

    private static class CompressedIntsDataInput
    extends SeekableInputStream {
        public CompressedIntsDataInput(ByteBufferWrapper buffer) {
            super(buffer);
        }

        @Override
        public short readShort() throws IOException {
            return (short)this.readCompressedLong();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            return (int)this.readCompressedLong();
        }

        @Override
        public char readChar() throws IOException {
            return (char)this.readCompressedLong();
        }

        @Override
        public int readInt() throws IOException {
            return (int)this.readCompressedLong();
        }

        @Override
        public long readUnsignedInt() throws IOException {
            return this.readCompressedLong();
        }

        @Override
        public long readLong() throws IOException {
            return this.readCompressedLong();
        }

        private long readCompressedLong() throws IOException {
            long ret = 0L;
            for (int i = 0; i < 8; ++i) {
                byte b = this.readByte();
                ret += ((long)b & 0x7FL) << 7 * i;
                if (b < 0) continue;
                return ret;
            }
            return ret + (((long)this.readByte() & 0xFFL) << 56);
        }
    }
}

