/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.mapping;

import com.intellij.jpa.jpb.model.backend.ed.ddl.DbDialect;
import com.intellij.jpa.jpb.model.backend.ed.ddl.MysqlDbDialect;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.db.HibernateSqlType;
import com.intellij.jpa.jpb.model.db.HibernateTypes;
import com.intellij.jpa.jpb.model.db.VladmihalceaHibernateTypes;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.liquibase.common.mapping.ReMappingSettings;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u00152\u0006\u0010\u0019\u001a\u00020\rH\u0016J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\tH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u001a\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0!0\fH\u0016J\u0010\u0010\"\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\rH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R&\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00150\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0!8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lcom/intellij/liquibase/common/mapping/MysqlReMappingSettings;", "Lcom/intellij/liquibase/common/mapping/ReMappingSettings;", "project", "Lcom/intellij/openapi/project/Project;", "dbType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;)V", "isHibernate6Project", "", "hasVladMihalceaHibernateTypes", "mappingTypes", "", "", "Lcom/intellij/jpa/jpb/model/model/Datatypes$BasicDatatype;", "getMappingTypes", "()Ljava/util/Map;", "sqlTypeToJdbcTypeCode", "Lcom/intellij/jpa/jpb/model/db/HibernateSqlType;", "getSqlTypeToJdbcTypeCode", "sqlSynonymTypes", "", "getSqlSynonymTypes", "getMaxVarcharLength", "", "sqlType", "getSqlTypeSynonyms", "getWrapQuote", "inJavaString", "getDbDialect", "Lcom/intellij/jpa/jpb/model/backend/ed/ddl/DbDialect;", "getTemporalTypeMappings", "Lcom/intellij/jpa/jpb/model/model/EntityAttribute$TemporalType;", "", "useColumnDefinition", "lengthUnlessTypes", "getLengthUnlessTypes", "()[Ljava/lang/String;", "intellij.liquibase.common"})
public final class MysqlReMappingSettings
extends ReMappingSettings {
    private final boolean isHibernate6Project;
    private final boolean hasVladMihalceaHibernateTypes;
    @NotNull
    private final Map<String, HibernateSqlType> sqlTypeToJdbcTypeCode;

    public MysqlReMappingSettings(@NotNull Project project, @NotNull DbType dbType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        super(project, dbType);
        this.isHibernate6Project = JpaUtils.isHibernate6Project((Project)project, null);
        this.hasVladMihalceaHibernateTypes = JpaUtils.hasVladMihalceaHibernateTypes((Project)project);
        this.sqlTypeToJdbcTypeCode = MapsKt.mapOf((Pair)TuplesKt.to((Object)"JSON", (Object)HibernateSqlType.JSON));
    }

    @Override
    @NotNull
    public Map<String, Datatypes.BasicDatatype> getMappingTypes() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"BIT", (Object)Datatypes.BasicDatatype.Boolean), TuplesKt.to((Object)"TINYINT UNSIGNED", (Object)Datatypes.BasicDatatype.Short), TuplesKt.to((Object)"TINYINT", (Object)Datatypes.BasicDatatype.Byte), TuplesKt.to((Object)"TINYINT(1)", (Object)Datatypes.BasicDatatype.Boolean), TuplesKt.to((Object)"BOOL", (Object)Datatypes.BasicDatatype.Boolean), TuplesKt.to((Object)"SMALLINT UNSIGNED", (Object)Datatypes.BasicDatatype.Integer), TuplesKt.to((Object)"SMALLINT", (Object)Datatypes.BasicDatatype.Short), TuplesKt.to((Object)"MEDIUMINT", (Object)Datatypes.BasicDatatype.Integer), TuplesKt.to((Object)"INT UNSIGNED", (Object)Datatypes.BasicDatatype.Long), TuplesKt.to((Object)"INT", (Object)Datatypes.BasicDatatype.Integer), TuplesKt.to((Object)"BIGINT", (Object)Datatypes.BasicDatatype.Long), TuplesKt.to((Object)"DECIMAL", (Object)Datatypes.BasicDatatype.BigDecimal), TuplesKt.to((Object)"FLOAT", (Object)Datatypes.BasicDatatype.Float), TuplesKt.to((Object)"DOUBLE", (Object)Datatypes.BasicDatatype.Double), TuplesKt.to((Object)"DATE", (Object)Datatypes.BasicDatatype.LocalDate), TuplesKt.to((Object)"TIME", (Object)Datatypes.BasicDatatype.LocalTime), TuplesKt.to((Object)"DATETIME", (Object)Datatypes.BasicDatatype.Instant), TuplesKt.to((Object)"TIMESTAMP", (Object)Datatypes.BasicDatatype.Instant), TuplesKt.to((Object)"YEAR", (Object)Datatypes.BasicDatatype.Integer), TuplesKt.to((Object)"CHAR(1)", (Object)Datatypes.BasicDatatype.Character), TuplesKt.to((Object)"CHAR", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"VARCHAR", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"BINARY", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"VARBINARY", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"TEXT", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"BLOB", (Object)Datatypes.BasicDatatype.PByteArray), TuplesKt.to((Object)"ENUM", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"SET", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"JSON", (Object)(this.isHibernate6Project ? HibernateTypes.INSTANCE.getMapStringToObject() : (this.hasVladMihalceaHibernateTypes ? VladmihalceaHibernateTypes.Companion.getInstance(this.getProject()).getJsonNodeStringType() : Datatypes.BasicDatatype.String)))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public Map<String, HibernateSqlType> getSqlTypeToJdbcTypeCode() {
        return this.sqlTypeToJdbcTypeCode;
    }

    @Override
    @NotNull
    public Map<String, Collection<String>> getSqlSynonymTypes() {
        Pair[] pairArray = new Pair[12];
        pairArray[0] = TuplesKt.to((Object)"BOOL", (Object)CollectionsKt.listOf((Object)"BOOLEAN"));
        pairArray[1] = TuplesKt.to((Object)"INT UNSIGNED", (Object)CollectionsKt.listOf((Object)"INTEGER UNSIGNED"));
        pairArray[2] = TuplesKt.to((Object)"INT", (Object)CollectionsKt.listOf((Object)"INTEGER"));
        pairArray[3] = TuplesKt.to((Object)"MEDIUMINT", (Object)CollectionsKt.listOf((Object)"mediumint unsigned"));
        Object[] objectArray = new String[]{"SERIAL", "BIGINT unsigned"};
        pairArray[4] = TuplesKt.to((Object)"BIGINT", (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"DEC", "NUMERIC", "FIXED"};
        pairArray[5] = TuplesKt.to((Object)"DECIMAL", (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"DOUBLE PRECISION", "REAL"};
        pairArray[6] = TuplesKt.to((Object)"DOUBLE", (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"TINYTEXT", "MEDIUMTEXT", "LONGTEXT"};
        pairArray[7] = TuplesKt.to((Object)"TEXT", (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"TINYBLOB", "MEDIUMBLOB", "LONGBLOB"};
        pairArray[8] = TuplesKt.to((Object)"BLOB", (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"NCHAR", "CHARACTER", "NATIONAL CHAR"};
        pairArray[9] = TuplesKt.to((Object)"CHAR", (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"NVARCHAR", "NATIONAL VARCHAR"};
        pairArray[10] = TuplesKt.to((Object)"VARCHAR", (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"datetime(1)", "datetime(2)", "datetime(3)", "datetime(4)", "datetime(5)", "datetime(6)"};
        pairArray[11] = TuplesKt.to((Object)"DATETIME", (Object)CollectionsKt.listOf((Object[])objectArray));
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    public int getMaxVarcharLength(@NotNull String sqlType) {
        Intrinsics.checkNotNullParameter((Object)sqlType, (String)"sqlType");
        if (StringsKt.equals((String)"varchar", (String)sqlType, (boolean)true) || StringsKt.equals((String)"char", (String)sqlType, (boolean)true) || StringsKt.equals((String)"text", (String)sqlType, (boolean)true)) {
            return 65535;
        }
        return StringsKt.equals((String)"mediumtext", (String)sqlType, (boolean)true) ? 0xFFFFFF : Integer.MAX_VALUE;
    }

    @Override
    @NotNull
    public Collection<String> getSqlTypeSynonyms(@NotNull String sqlType) {
        Intrinsics.checkNotNullParameter((Object)sqlType, (String)"sqlType");
        if (StringsKt.startsWith((String)sqlType, (String)"enum(", (boolean)true)) {
            return CollectionsKt.listOf((Object)"ENUM");
        }
        if (StringsKt.startsWith((String)sqlType, (String)"set(", (boolean)true)) {
            return CollectionsKt.listOf((Object)"SET");
        }
        return super.getSqlTypeSynonyms(sqlType);
    }

    @Override
    @NotNull
    public String getWrapQuote(boolean inJavaString) {
        return "`";
    }

    @Override
    @NotNull
    public DbDialect getDbDialect() {
        DbDialect dbDialect = MysqlDbDialect.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)dbDialect, (String)"INSTANCE");
        return dbDialect;
    }

    @Override
    @NotNull
    public Map<EntityAttribute.TemporalType, String[]> getTemporalTypeMappings() {
        Pair[] pairArray = new Pair[3];
        String[] stringArray = new String[]{"date", "year"};
        pairArray[0] = TuplesKt.to((Object)EntityAttribute.TemporalType.DATE, (Object)stringArray);
        stringArray = new String[]{"time"};
        pairArray[1] = TuplesKt.to((Object)EntityAttribute.TemporalType.TIME, (Object)stringArray);
        stringArray = new String[]{"datetime", "datetime(1)", "datetime(2)", "datetime(3)", "datetime(4)", "datetime(5)", "datetime(6)"};
        pairArray[2] = TuplesKt.to((Object)EntityAttribute.TemporalType.TIMESTAMP, (Object)stringArray);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean useColumnDefinition(@NotNull String sqlType) {
        Intrinsics.checkNotNullParameter((Object)sqlType, (String)"sqlType");
        if (super.useColumnDefinition(sqlType)) return true;
        Object[] objectArray = new String[]{"TINYINT UNSIGNED", "SMALLINT UNSIGNED", "INT UNSIGNED"};
        String string = sqlType.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        if (!ArraysKt.contains((Object[])objectArray, (Object)string)) return false;
        return true;
    }

    @Override
    @NotNull
    protected String[] getLengthUnlessTypes() {
        String[] stringArray = new String[]{"TINYINT", "SMALLINT", "INT"};
        return stringArray;
    }
}

