/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.mapping;

import com.intellij.jpa.jpb.model.backend.ed.ddl.DbDialect;
import com.intellij.jpa.jpb.model.backend.ed.indexing.CustomTypeModel;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.db.HibernateSqlType;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.liquibase.common.config.ReDatabaseInfo;
import com.intellij.liquibase.common.config.ReMappingType;
import com.intellij.liquibase.common.config.ReverseEngineeringConfig;
import com.intellij.liquibase.common.config.ReverseEngineeringState;
import com.intellij.liquibase.common.mapping.ReMappingSettingsCache;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u0000 L2\u00020\u0001:\u0002LMB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u0012H\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00120\u00172\u0006\u0010(\u001a\u00020\u0012H\u0016J\u0010\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u0004\u0018\u00010\u001e2\u0006\u0010.\u001a\u00020,J\u0012\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u000202H\u0016J!\u0010/\u001a\u0004\u0018\u00010\u00132\u0006\u0010(\u001a\u00020\u00122\b\u00103\u001a\u0004\u0018\u00010\u001aH\u0002\u00a2\u0006\u0002\u00104J\u0012\u00105\u001a\u0004\u0018\u00010\u00132\u0006\u0010(\u001a\u00020\u0012H\u0004J\u0012\u00106\u001a\u0004\u0018\u00010\u00132\u0006\u0010(\u001a\u00020\u0012H\u0004J\u0012\u00107\u001a\u0004\u0018\u00010\u00132\u0006\u00101\u001a\u000202H\u0004J\u0012\u00107\u001a\u0004\u0018\u00010\u00132\u0006\u0010(\u001a\u00020\u0012H\u0002J\u0010\u00108\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u0012H\u0016J\u0010\u00109\u001a\u00020\u00122\u0006\u0010:\u001a\u00020\u000fH\u0016J\u0014\u0010;\u001a\u0004\u0018\u00010<2\b\u0010(\u001a\u0004\u0018\u00010\u0012H\u0016J\n\u0010=\u001a\u0004\u0018\u00010>H&J\u001a\u0010?\u001a\u0014\u0012\u0004\u0012\u00020<\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120@0\u0011H&J\u0012\u0010A\u001a\u0004\u0018\u00010\u00122\u0006\u0010B\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020\u00122\u0006\u0010E\u001a\u000202H\u0016J\u0010\u0010F\u001a\u00020\u00122\u0006\u0010E\u001a\u000202H\u0002J\u0010\u0010G\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020,H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R$\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00170\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0015R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR \u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001e0\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0015R\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R)\u0010%\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130!0\u00118F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0015R\u001c\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00120@X\u0094\u0004\u00a2\u0006\n\n\u0002\u0010K\u001a\u0004\bI\u0010J\u00a8\u0006N"}, d2={"Lcom/intellij/liquibase/common/mapping/ReMappingSettings;", "", "project", "Lcom/intellij/openapi/project/Project;", "dbType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDbType", "()Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "reverseEngineeringState", "Lcom/intellij/liquibase/common/config/ReverseEngineeringState;", "isHibernate6", "", "mappingTypes", "", "", "Lcom/intellij/jpa/jpb/model/model/Datatypes$BasicDatatype;", "getMappingTypes", "()Ljava/util/Map;", "sqlSynonymTypes", "", "getSqlSynonymTypes", "maxDecimalPrecision", "", "getMaxDecimalPrecision", "()I", "sqlTypeToJdbcTypeCode", "Lcom/intellij/jpa/jpb/model/db/HibernateSqlType;", "getSqlTypeToJdbcTypeCode", "allMappingTypes", "", "Lcom/intellij/liquibase/common/mapping/ReMappingSettings$MappingTypeInfo;", "getAllMappingTypes", "()Ljava/util/Set;", "allCompatibleMappingTypes", "getAllCompatibleMappingTypes", "getMaxVarcharLength", "sqlType", "getSqlTypeSynonyms", "isLobStringType", "dataType", "Lliquibase/structure/core/DataType;", "getJdbcTypeCodeIfNeed", "type", "getJavaType", "Lcom/intellij/jpa/jpb/model/model/Datatype;", "column", "Lliquibase/structure/core/Column;", "columnSize", "(Ljava/lang/String;Ljava/lang/Integer;)Lcom/intellij/jpa/jpb/model/model/Datatypes$BasicDatatype;", "findMappingTypeWithSynonyms", "findMappingType", "getExplicitConfiguredJavaType", "useColumnDefinition", "getWrapQuote", "inJavaString", "findTemporalTypeByColumnType", "Lcom/intellij/jpa/jpb/model/model/EntityAttribute$TemporalType;", "getDbDialect", "Lcom/intellij/jpa/jpb/model/backend/ed/ddl/DbDialect;", "getTemporalTypeMappings", "", "getConverterJavaType", "foundTypeModel", "Lcom/intellij/jpa/jpb/model/backend/ed/indexing/CustomTypeModel;", "extractColumnDefinition", "dbColumn", "processDbType", "isNationalizedType", "lengthUnlessTypes", "getLengthUnlessTypes", "()[Ljava/lang/String;", "[Ljava/lang/String;", "Companion", "MappingTypeInfo", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nReMappingSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReMappingSettings.kt\ncom/intellij/liquibase/common/mapping/ReMappingSettings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,257:1\n295#2,2:258\n1869#2,2:260\n1869#2:262\n2746#2,3:263\n1870#2:266\n295#2,2:267\n1869#2:269\n230#2,2:273\n1870#2:275\n1869#2:276\n295#2,2:277\n1870#2:279\n295#2,2:281\n1869#2,2:283\n188#3,3:270\n1#4:280\n12970#5,2:285\n*S KotlinDebug\n*F\n+ 1 ReMappingSettings.kt\ncom/intellij/liquibase/common/mapping/ReMappingSettings\n*L\n37#1:258,2\n38#1:260,2\n52#1:262\n54#1:263,3\n52#1:266\n66#1:267,2\n68#1:269\n75#1:273,2\n68#1:275\n84#1:276\n85#1:277,2\n84#1:279\n189#1:281,2\n190#1:283,2\n73#1:270,3\n207#1:285,2\n*E\n"})
public abstract class ReMappingSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final DbType dbType;
    @NotNull
    private final ReverseEngineeringState reverseEngineeringState;
    private final boolean isHibernate6;
    private final int maxDecimalPrecision;
    @NotNull
    private final Map<String, HibernateSqlType> sqlTypeToJdbcTypeCode;
    @NotNull
    private final String[] lengthUnlessTypes;

    public ReMappingSettings(@NotNull Project project, @NotNull DbType dbType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        this.project = project;
        this.dbType = dbType;
        this.reverseEngineeringState = ReverseEngineeringConfig.Companion.getInstance(this.project).getState();
        this.isHibernate6 = JpaUtils.isHibernate6Project((Project)this.project, null);
        this.maxDecimalPrecision = Integer.MAX_VALUE;
        this.sqlTypeToJdbcTypeCode = MapsKt.emptyMap();
        this.lengthUnlessTypes = new String[0];
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DbType getDbType() {
        return this.dbType;
    }

    @NotNull
    public abstract Map<String, Datatypes.BasicDatatype> getMappingTypes();

    @NotNull
    public abstract Map<String, Collection<String>> getSqlSynonymTypes();

    public int getMaxDecimalPrecision() {
        return this.maxDecimalPrecision;
    }

    @NotNull
    public Map<String, HibernateSqlType> getSqlTypeToJdbcTypeCode() {
        return this.sqlTypeToJdbcTypeCode;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<MappingTypeInfo> getAllMappingTypes() {
        Object v0;
        List<ReMappingType> $this$firstOrNull$iv;
        LinkedHashSet<MappingTypeInfo> result;
        block7: {
            result = new LinkedHashSet<MappingTypeInfo>();
            $this$firstOrNull$iv = (List<ReMappingType>)this.reverseEngineeringState.getDatabaseInfos();
            boolean $i$f$firstOrNull = false;
            for (Object t : $this$firstOrNull$iv) {
                ReDatabaseInfo it = (ReDatabaseInfo)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)DbType.Companion.getMainType(this.dbType).getId(), (Object)it.getDbmsId())) continue;
                v0 = t;
                break block7;
            }
            v0 = null;
        }
        ReDatabaseInfo reDatabaseInfo = v0;
        if (reDatabaseInfo != null && ($this$firstOrNull$iv = reDatabaseInfo.getMappingTypes()) != null) {
            void $this$forEach$iv;
            Iterable $i$f$firstOrNull = $this$firstOrNull$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ReMappingType mappingType = (ReMappingType)element$iv;
                boolean bl = false;
                String javaClass = mappingType.getJavaClass();
                String sqlType = mappingType.getSqlType();
                if (javaClass == null || sqlType == null) continue;
                Datatypes.BasicDatatype basicDatatype = Datatypes.BasicDatatype.getInstance((String)javaClass);
                Intrinsics.checkNotNullExpressionValue((Object)basicDatatype, (String)"getInstance(...)");
                Boolean bl2 = mappingType.getUseColumnDefinition();
                result.add(new MappingTypeInfo(sqlType, basicDatatype, bl2 != null ? bl2 : false));
            }
        }
        Iterable $this$forEach$iv = this.getMappingTypes().entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            String sqlType;
            Map.Entry entry;
            block8: {
                entry = (Map.Entry)element$iv;
                boolean bl3 = false;
                sqlType = (String)entry.getKey();
                Iterable $this$none$iv = result;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv2 : $this$none$iv) {
                        MappingTypeInfo it = (MappingTypeInfo)element$iv2;
                        boolean bl4 = false;
                        if (!StringsKt.equals((String)it.getSqlType(), (String)sqlType, (boolean)true)) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            result.add(new MappingTypeInfo(sqlType, (Datatypes.BasicDatatype)entry.getValue(), false, 4, null));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Collection<String>, Set<Datatypes.BasicDatatype>> getAllCompatibleMappingTypes() {
        Object v0;
        List<ReMappingType> $this$firstOrNull$iv;
        LinkedHashMap result;
        block11: {
            result = new LinkedHashMap();
            $this$firstOrNull$iv = (List<ReMappingType>)this.reverseEngineeringState.getDatabaseInfos();
            boolean $i$f$firstOrNull = false;
            for (Object t : $this$firstOrNull$iv) {
                ReDatabaseInfo it = (ReDatabaseInfo)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)DbType.Companion.getMainType(this.dbType).getId(), (Object)it.getDbmsId())) continue;
                v0 = t;
                break block11;
            }
            v0 = null;
        }
        ReDatabaseInfo reDatabaseInfo = v0;
        if (reDatabaseInfo != null && ($this$firstOrNull$iv = reDatabaseInfo.getMappingTypes()) != null) {
            void $this$forEach$iv;
            Iterable $i$f$firstOrNull = $this$firstOrNull$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean pairExists;
                Map.Entry it;
                Object object;
                String sqlType;
                String javaClass;
                block12: {
                    ReMappingType mappingType = (ReMappingType)element$iv;
                    boolean bl = false;
                    javaClass = mappingType.getJavaClass();
                    sqlType = mappingType.getSqlType();
                    if (javaClass == null || sqlType == null) continue;
                    Map $this$any$iv = result;
                    boolean $i$f$any = false;
                    if ($this$any$iv.isEmpty()) {
                        v1 = false;
                    } else {
                        object = $this$any$iv.entrySet().iterator();
                        while (object.hasNext()) {
                            Map.Entry element$iv22;
                            it = element$iv22 = object.next();
                            boolean bl2 = false;
                            if (!((Collection)it.getKey()).contains(sqlType)) continue;
                            v1 = true;
                            break block12;
                        }
                        v1 = pairExists = false;
                    }
                }
                if (pairExists) {
                    Object element$iv22;
                    block13: {
                        Set set = result.entrySet();
                        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
                        Iterable $this$first$iv = set;
                        boolean $i$f$first = false;
                        for (Object element$iv22 : $this$first$iv) {
                            it = (Map.Entry)element$iv22;
                            boolean bl = false;
                            if (!((Collection)it.getKey()).contains(sqlType)) continue;
                            break block13;
                        }
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    Set set = (Set)((Map.Entry)element$iv22).getValue();
                    Datatypes.BasicDatatype basicDatatype = Datatypes.BasicDatatype.getInstance((String)javaClass);
                    Intrinsics.checkNotNullExpressionValue((Object)basicDatatype, (String)"getInstance(...)");
                    set.add(basicDatatype);
                    continue;
                }
                Collection<String> synonymousSqlTypes = this.getSqlTypeSynonyms(sqlType);
                Map $i$f$first = result;
                object = new Datatypes.BasicDatatype[1];
                Intrinsics.checkNotNullExpressionValue((Object)Datatypes.BasicDatatype.getInstance((String)javaClass), (String)"getInstance(...)");
                object = SetsKt.mutableSetOf((Object[])object);
                $i$f$first.put(synonymousSqlTypes, object);
            }
        }
        Iterable $this$forEach$iv = this.getMappingTypes().entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v6;
            Map.Entry entry;
            block14: {
                entry = (Map.Entry)element$iv;
                boolean bl = false;
                Set set = result.entrySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
                Iterable $this$firstOrNull$iv2 = set;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv3 : $this$firstOrNull$iv2) {
                    Map.Entry it = (Map.Entry)element$iv3;
                    boolean bl3 = false;
                    if (!((Collection)it.getKey()).contains(entry.getKey())) continue;
                    v6 = element$iv3;
                    break block14;
                }
                v6 = null;
            }
            Map.Entry existedPair = v6;
            if (existedPair != null) {
                ((Set)existedPair.getValue()).add(entry.getValue());
                continue;
            }
            Collection<String> synonymousSqlTypes = this.getSqlTypeSynonyms((String)entry.getKey());
            Map map = result;
            Object object = new Datatypes.BasicDatatype[]{entry.getValue()};
            object = SetsKt.mutableSetOf((Object[])object);
            map.put(synonymousSqlTypes, object);
        }
        return result;
    }

    public int getMaxVarcharLength(@NotNull String sqlType) {
        Intrinsics.checkNotNullParameter((Object)sqlType, (String)"sqlType");
        return Integer.MAX_VALUE;
    }

    @NotNull
    public Collection<String> getSqlTypeSynonyms(@NotNull String sqlType) {
        Intrinsics.checkNotNullParameter((Object)sqlType, (String)"sqlType");
        Set result = new LinkedHashSet();
        result.add(sqlType);
        for (Map.Entry<String, Collection<String>> entry : this.getSqlSynonymTypes().entrySet()) {
            String key = entry.getKey();
            Collection<String> value = entry.getValue();
            if (!StringUtil.equalsIgnoreCase((CharSequence)key, (CharSequence)sqlType) && !JpaUtils.containsIgnoreCase(value, (String)sqlType)) continue;
            result.add(key);
            result.addAll(value);
        }
        return result;
    }

    public boolean isLobStringType(@NotNull DataType dataType) {
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
        Integer columnSize = dataType.getColumnSize();
        String string = dataType.getTypeName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTypeName(...)");
        int maxVarcharLength = this.getMaxVarcharLength(string);
        return columnSize == null || columnSize <= 0 || columnSize >= maxVarcharLength;
    }

    @Nullable
    public final HibernateSqlType getJdbcTypeCodeIfNeed(@NotNull DataType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (this.getSqlTypeToJdbcTypeCode().isEmpty() || !this.isHibernate6) {
            return null;
        }
        String sqlType = type.getTypeName();
        Intrinsics.checkNotNull((Object)sqlType);
        Collection<String> sqlTypeSynonyms = this.getSqlTypeSynonyms(sqlType);
        for (String currSqlType : sqlTypeSynonyms) {
            HibernateSqlType hibernateSqlType;
            Map.Entry entry;
            Object v0;
            block3: {
                Iterable iterable = this.getSqlTypeToJdbcTypeCode().entrySet();
                for (Object t : iterable) {
                    Map.Entry it = (Map.Entry)t;
                    boolean bl = false;
                    if (!StringsKt.equals((String)((String)it.getKey()), (String)currSqlType, (boolean)true)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            if ((entry = (Map.Entry)v0) == null || (hibernateSqlType = (HibernateSqlType)entry.getValue()) == null) continue;
            HibernateSqlType it = hibernateSqlType;
            boolean bl = false;
            return it;
        }
        return null;
    }

    @Nullable
    public Datatype getJavaType(@NotNull Column column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        DataType dataType = column.getType();
        String sqlType = dataType.getTypeName();
        Intrinsics.checkNotNull((Object)sqlType);
        Collection<String> sqlTypeSynonyms = this.getSqlTypeSynonyms(sqlType);
        for (String currSqlType : sqlTypeSynonyms) {
            Datatypes.BasicDatatype foundAttrType;
            Integer columnSize = dataType.getColumnSize();
            if (columnSize != null && columnSize != 0 && (foundAttrType = this.getJavaType(currSqlType + "(" + columnSize + ")", columnSize)) != null) {
                return (Datatype)foundAttrType;
            }
            foundAttrType = this.getJavaType(currSqlType, columnSize);
            if (foundAttrType == null) continue;
            return (Datatype)foundAttrType;
        }
        return null;
    }

    private final Datatypes.BasicDatatype getJavaType(String sqlType, Integer columnSize) {
        Datatype[] datatypeArray;
        Datatypes.BasicDatatype basicDatatype = this.findMappingType(sqlType);
        if (basicDatatype == null) {
            return null;
        }
        Datatypes.BasicDatatype foundMappingType = basicDatatype;
        if (columnSize != null && (foundMappingType.isSame(datatypeArray = new Datatype[]{Datatypes.BasicDatatype.Character}) && columnSize > 1 || foundMappingType.isSame(datatypeArray = new Datatype[]{Datatypes.BasicDatatype.PChar}) && columnSize > 1)) {
            return Datatypes.BasicDatatype.PCharArray;
        }
        return foundMappingType;
    }

    @Nullable
    protected final Datatypes.BasicDatatype findMappingTypeWithSynonyms(@NotNull String sqlType) {
        Datatypes.BasicDatatype basicDatatype;
        block1: {
            Intrinsics.checkNotNullParameter((Object)sqlType, (String)"sqlType");
            for (String it : (Iterable)this.getSqlTypeSynonyms(sqlType)) {
                boolean bl = false;
                Datatypes.BasicDatatype basicDatatype2 = this.findMappingType(it);
                if (basicDatatype2 == null) continue;
                basicDatatype = basicDatatype2;
                break block1;
            }
            basicDatatype = null;
        }
        return basicDatatype;
    }

    @Nullable
    protected final Datatypes.BasicDatatype findMappingType(@NotNull String sqlType) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)sqlType, (String)"sqlType");
            Iterable iterable = this.getAllMappingTypes();
            for (Object t : iterable) {
                MappingTypeInfo it = (MappingTypeInfo)t;
                boolean bl = false;
                if (!StringsKt.equals((String)it.getSqlType(), (String)sqlType, (boolean)true)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        MappingTypeInfo mappingTypeInfo = v0;
        return mappingTypeInfo != null ? mappingTypeInfo.getType() : null;
    }

    @Nullable
    protected final Datatypes.BasicDatatype getExplicitConfiguredJavaType(@NotNull Column column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        String sqlType = column.getType().getTypeName();
        Integer n = column.getType().getColumnSize();
        if (n != null) {
            Integer n2 = n;
            int it = ((Number)n2).intValue();
            boolean bl = false;
            n = it != 0 ? n2 : null;
            if (n != null) {
                Datatypes.BasicDatatype result;
                it = ((Number)n).intValue();
                boolean bl2 = false;
                Datatypes.BasicDatatype basicDatatype = result = this.getExplicitConfiguredJavaType(sqlType + "(" + it + ")");
                if (basicDatatype != null) {
                    return basicDatatype;
                }
            }
        }
        Intrinsics.checkNotNull((Object)sqlType);
        return this.getExplicitConfiguredJavaType(sqlType);
    }

    /*
     * WARNING - void declaration
     */
    private final Datatypes.BasicDatatype getExplicitConfiguredJavaType(String sqlType) {
        List<ReMappingType> list;
        Object v0;
        block5: {
            Iterable $this$firstOrNull$iv = this.reverseEngineeringState.getDatabaseInfos();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ReDatabaseInfo it = (ReDatabaseInfo)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)DbType.Companion.getMainType(this.dbType).getId(), (Object)it.getDbmsId())) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        ReDatabaseInfo reDatabaseInfo = v0;
        if (reDatabaseInfo != null && (list = reDatabaseInfo.getMappingTypes()) != null) {
            void $this$forEach$iv;
            Iterable $i$f$firstOrNull = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Datatypes.BasicDatatype basicDatatype;
                ReMappingType mappingType = (ReMappingType)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)sqlType, (Object)mappingType.getSqlType())) continue;
                String string = mappingType.getJavaClass();
                if (string != null) {
                    String it = string;
                    boolean bl2 = false;
                    basicDatatype = Datatypes.BasicDatatype.getInstance((String)it);
                } else {
                    basicDatatype = null;
                }
                return basicDatatype;
            }
        }
        return null;
    }

    public boolean useColumnDefinition(@NotNull String sqlType) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)sqlType, (String)"sqlType");
            Iterable iterable = this.getAllMappingTypes();
            for (Object t : iterable) {
                MappingTypeInfo it = (MappingTypeInfo)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSqlType(), (Object)sqlType)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        MappingTypeInfo mappingTypeInfo = v0;
        return mappingTypeInfo != null ? mappingTypeInfo.getUseColumnDef() : false;
    }

    @NotNull
    public String getWrapQuote(boolean inJavaString) {
        return inJavaString ? "\\\"" : "\"";
    }

    @Nullable
    public EntityAttribute.TemporalType findTemporalTypeByColumnType(@Nullable String sqlType) {
        for (Map.Entry<EntityAttribute.TemporalType, String[]> entry : this.getTemporalTypeMappings().entrySet()) {
            boolean bl;
            EntityAttribute.TemporalType key;
            block2: {
                String[] value;
                key = entry.getKey();
                String[] $this$any$iv = value = entry.getValue();
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    String element$iv;
                    String temporalSqlType = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!StringsKt.equals((String)temporalSqlType, (String)sqlType, (boolean)true)) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (!bl) continue;
            return key;
        }
        return null;
    }

    @Nullable
    public abstract DbDialect getDbDialect();

    @NotNull
    public abstract Map<EntityAttribute.TemporalType, String[]> getTemporalTypeMappings();

    @Nullable
    public String getConverterJavaType(@NotNull CustomTypeModel foundTypeModel) {
        Intrinsics.checkNotNullParameter((Object)foundTypeModel, (String)"foundTypeModel");
        return foundTypeModel.getJavaTypeFqn();
    }

    @NotNull
    public String extractColumnDefinition(@NotNull Column dbColumn) {
        Intrinsics.checkNotNullParameter((Object)dbColumn, (String)"dbColumn");
        Object dbType = this.processDbType(dbColumn);
        if (!dbColumn.isNullable().booleanValue()) {
            dbType = (String)dbType + " not null";
        }
        return dbType;
    }

    private final String processDbType(Column dbColumn) {
        String string = dbColumn.getType().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String dbType = string;
        for (String lengthUnlessType : this.getLengthUnlessTypes()) {
            String string2;
            if (!StringsKt.startsWith((String)dbType, (String)(lengthUnlessType + "("), (boolean)true)) continue;
            int closeLengthIdx = StringsKt.indexOf$default((CharSequence)dbType, (char)')', (int)0, (boolean)false, (int)6, null);
            if (closeLengthIdx <= 0) break;
            String string3 = dbType.substring(0, lengthUnlessType.length());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            if (closeLengthIdx >= dbType.length()) {
                string2 = "";
            } else {
                String string4 = dbType.substring(closeLengthIdx + 1);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            }
            return string3 + string2;
        }
        return dbType;
    }

    public boolean isNationalizedType(@NotNull DataType type) {
        String string;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Object[] objectArray = new String[]{"nchar", "nvarchar", "nvarchar2", "nclob", "ntext", "national char", "national varchar", "national text"};
        String string2 = type.getTypeName();
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        return ArraysKt.contains((Object[])objectArray, (Object)string);
    }

    @NotNull
    protected String[] getLengthUnlessTypes() {
        return this.lengthUnlessTypes;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/liquibase/common/mapping/ReMappingSettings$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/liquibase/common/mapping/ReMappingSettings;", "project", "Lcom/intellij/openapi/project/Project;", "dbType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "intellij.liquibase.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReMappingSettings getInstance(@NotNull Project project, @NotNull DbType dbType) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
            return ReMappingSettingsCache.Companion.getInstance(project).get(dbType);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/liquibase/common/mapping/ReMappingSettings$MappingTypeInfo;", "", "sqlType", "", "type", "Lcom/intellij/jpa/jpb/model/model/Datatypes$BasicDatatype;", "useColumnDef", "", "<init>", "(Ljava/lang/String;Lcom/intellij/jpa/jpb/model/model/Datatypes$BasicDatatype;Z)V", "getSqlType", "()Ljava/lang/String;", "getType", "()Lcom/intellij/jpa/jpb/model/model/Datatypes$BasicDatatype;", "getUseColumnDef", "()Z", "intellij.liquibase.common"})
    private static final class MappingTypeInfo {
        @NotNull
        private final String sqlType;
        @NotNull
        private final Datatypes.BasicDatatype type;
        private final boolean useColumnDef;

        public MappingTypeInfo(@NotNull String sqlType, @NotNull Datatypes.BasicDatatype type, boolean useColumnDef) {
            Intrinsics.checkNotNullParameter((Object)sqlType, (String)"sqlType");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.sqlType = sqlType;
            this.type = type;
            this.useColumnDef = useColumnDef;
        }

        public /* synthetic */ MappingTypeInfo(String string, Datatypes.BasicDatatype basicDatatype, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            this(string, basicDatatype, bl);
        }

        @NotNull
        public final String getSqlType() {
            return this.sqlType;
        }

        @NotNull
        public final Datatypes.BasicDatatype getType() {
            return this.type;
        }

        public final boolean getUseColumnDef() {
            return this.useColumnDef;
        }
    }
}

