/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringSizeLimitedCache<K, V> {
    protected final Object2ObjectLinkedOpenHashMap<K, V> myQueue;
    private final int myMaxQueueSize;
    private final Object myLock = new Object();

    protected SpringSizeLimitedCache(int maxQueueSize) {
        this.myQueue = new Object2ObjectLinkedOpenHashMap<K, V>(10){

            public V get(Object k) {
                return this.getAndMoveToLast(k);
            }

            public V put(K k, V v) {
                return this.putAndMoveToLast(k, v);
            }
        };
        this.myMaxQueueSize = maxQueueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected V getCachedValue(K key) {
        Object value;
        Object object = this.myLock;
        synchronized (object) {
            value = this.myQueue.getAndMoveToLast(key);
        }
        return (V)value;
    }

    @NotNull
    protected abstract V createValue(K var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public V get(K key) {
        V value = this.getCachedValue(key);
        if (value != null) {
            V v = value;
            if (v == null) {
                SpringSizeLimitedCache.$$$reportNull$$$0(0);
            }
            return v;
        }
        V newValue = this.createValue(key);
        Object object = this.myLock;
        synchronized (object) {
            Object val;
            if (this.myQueue.size() >= this.myMaxQueueSize && (val = this.myQueue.removeFirst()) == null) {
                this.myQueue.clear();
            }
            this.myQueue.putAndMoveToLast(key, newValue);
        }
        V v = newValue;
        if (v == null) {
            SpringSizeLimitedCache.$$$reportNull$$$0(1);
        }
        return v;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringSizeLimitedCache", "get"));
    }
}

