/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.profile;

import com.intellij.jam.JamBaseElement;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.ref.AnnotationChildLink;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemKey;
import com.intellij.spring.model.aliasFor.SpringAliasFor;
import com.intellij.spring.model.aliasFor.SpringAliasForUtils;
import com.intellij.spring.model.jam.profile.SpringContextProfile;
import com.intellij.spring.model.jam.profile.SpringJamProfile;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomContextProfile
extends JamBaseElement<PsiMember>
implements SpringContextProfile {
    public static final SemKey<JamAnnotationMeta> JAM_ANNO_META_KEY = CONTEXT_PROFILE_JAM_ANNOTATION_KEY.subKey("CustomContextProfile", new SemKey[0]);
    public static final SemKey<CustomContextProfile> JAM_KEY = CONTEXT_PROFILE_JAM_KEY.subKey("CustomContextProfile", new SemKey[0]);
    public static final SemKey<JamMemberMeta<PsiMember, CustomContextProfile>> META_KEY = CONTEXT_PROFILE_META_KEY.subKey("CustomContextProfile", new SemKey[0]);
    private final PsiElementRef<PsiAnnotation> myPsiAnnotation;
    private final AnnotationChildLink myAnnotationChildLink;
    private final NullableLazyValue<SpringJamProfile> myDefiningMetaAnnotation;

    public CustomContextProfile(@NotNull String anno, @NotNull PsiMember psiMember) {
        if (anno == null) {
            CustomContextProfile.$$$reportNull$$$0(0);
        }
        if (psiMember == null) {
            CustomContextProfile.$$$reportNull$$$0(1);
        }
        super(PsiElementRef.real((PsiElement)psiMember));
        this.myDefiningMetaAnnotation = new NullableLazyValue<SpringJamProfile>(){

            @Nullable
            protected SpringJamProfile compute() {
                PsiClass annotationType;
                PsiMember element = (PsiMember)CustomContextProfile.this.getPsiElement();
                PsiAnnotation definingMetaAnnotation = SpringAliasForUtils.findDefiningMetaAnnotation((PsiElement)element, CustomContextProfile.this.myAnnotationChildLink.getAnnotationQualifiedName(), "org.springframework.context.annotation.Profile");
                if (definingMetaAnnotation != null && (annotationType = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)definingMetaAnnotation, PsiClass.class, (boolean)true)) != null) {
                    return (SpringJamProfile)SpringJamProfile.META.getJamElement((PsiModifierListOwner)annotationType);
                }
                return null;
            }
        };
        this.myAnnotationChildLink = new AnnotationChildLink(anno);
        this.myPsiAnnotation = this.myAnnotationChildLink.createChildRef((PsiElement)psiMember);
    }

    @Override
    @Nullable
    public PsiAnnotation getAnnotation() {
        return (PsiAnnotation)this.myPsiAnnotation.getPsiElement();
    }

    @Override
    @Nullable
    public PsiElement getIdentifyingPsiElement() {
        return this.getPsiElement();
    }

    @Override
    @NotNull
    public Set<String> getExpressions() {
        HashSet<String> profiles = new HashSet<String>();
        SpringAliasFor aliasFor = this.getAliasAttribute("value");
        if (aliasFor != null) {
            for (JamStringAttributeElement element : JamAttributeMeta.collectionString((String)aliasFor.getMethodName()).getJam(this.myPsiAnnotation)) {
                String value = element.getStringValue();
                if (StringUtil.isEmptyOrSpaces((String)value)) continue;
                profiles.add(value.trim());
            }
        } else {
            SpringJamProfile definingProfile = (SpringJamProfile)this.myDefiningMetaAnnotation.getValue();
            if (definingProfile != null) {
                Set<String> set = definingProfile.getExpressions();
                if (set == null) {
                    CustomContextProfile.$$$reportNull$$$0(2);
                }
                return set;
            }
        }
        HashSet<String> hashSet = profiles;
        if (hashSet == null) {
            CustomContextProfile.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @Nullable
    private SpringAliasFor getAliasAttribute(@NotNull String attrName) {
        if (attrName == null) {
            CustomContextProfile.$$$reportNull$$$0(4);
        }
        PsiMember element = (PsiMember)this.getPsiElement();
        return SpringAliasForUtils.findAliasFor((PsiElement)element, this.myAnnotationChildLink.getAnnotationQualifiedName(), "org.springframework.context.annotation.Profile", attrName);
    }

    @Override
    @NotNull
    public List<JamStringAttributeElement<String>> getValueElements() {
        SpringAliasFor aliasFor = this.getAliasAttribute("value");
        List list = aliasFor == null ? Collections.emptyList() : JamAttributeMeta.collectionString((String)aliasFor.getMethodName()).getJam(this.myPsiAnnotation);
        if (list == null) {
            CustomContextProfile.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMember";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/profile/CustomContextProfile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/profile/CustomContextProfile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAliasAttribute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5 -> new IllegalStateException(string);
        };
    }
}

