/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils.light;

import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.ImplicitVariableImpl;
import com.intellij.psi.search.SearchScope;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.model.utils.light.SpringLightRenameableIdentifier;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringImplicitVariable
extends ImplicitVariableImpl
implements ItemPresentation {
    protected final PsiElement myDeclaration;

    public SpringImplicitVariable(@NotNull String name, @NonNls PsiType type, @NotNull PsiElement declaration) {
        if (name == null) {
            SpringImplicitVariable.$$$reportNull$$$0(0);
        }
        if (declaration == null) {
            SpringImplicitVariable.$$$reportNull$$$0(1);
        }
        super(declaration.getManager(), (PsiIdentifier)SpringLightRenameableIdentifier.create(declaration, name), type, ElementManipulators.getManipulator((PsiElement)declaration) != null, declaration);
        this.myDeclaration = declaration;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = this.myDeclaration;
        if (psiElement == null) {
            SpringImplicitVariable.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        PsiElement element;
        if (name == null) {
            SpringImplicitVariable.$$$reportNull$$$0(3);
        }
        if ((element = PsiImplUtil.setName((PsiElement)this.myNameIdentifier, (String)name)) instanceof PsiIdentifier) {
            this.myNameIdentifier = (PsiIdentifier)element;
        }
        return this;
    }

    public ItemPresentation getPresentation() {
        return this;
    }

    @Nullable
    public PsiFile getContainingFile() {
        if (!this.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return this.myDeclaration != null ? this.myDeclaration.getContainingFile() : null;
    }

    public String getText() {
        PsiIdentifier identifier = this.getNameIdentifier();
        return this.getType().getPresentableText() + " " + (identifier != null ? identifier.getText() : null);
    }

    public String getPresentableText() {
        return this.getName();
    }

    @Nullable
    public Icon getIcon(boolean open) {
        return SpringApiIcons.Spring;
    }

    @Nullable
    public Icon getIcon(int flags) {
        return SpringApiIcons.Spring;
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (another == this) {
            return true;
        }
        if (another instanceof SpringImplicitVariable) {
            SpringImplicitVariable implicitVariable = (SpringImplicitVariable)another;
            String name = implicitVariable.getName();
            return name.equals(this.getName()) && another.getManager().areElementsEquivalent(implicitVariable.getDeclaration(), this.getDeclaration());
        }
        return this.getManager().areElementsEquivalent(this.getDeclaration(), another);
    }

    @NotNull
    public SearchScope getUseScope() {
        PsiFile file = (this.myDeclaration != null ? this.myDeclaration : this.getDeclarationScope()).getContainingFile();
        SearchScope searchScope = file.getUseScope();
        if (searchScope == null) {
            SpringImplicitVariable.$$$reportNull$$$0(4);
        }
        return searchScope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpringImplicitVariable)) {
            return false;
        }
        SpringImplicitVariable variable = (SpringImplicitVariable)((Object)o);
        return Objects.equals(this.getName(), variable.getName()) && Objects.equals(this.myDeclaration, variable.myDeclaration);
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.myDeclaration);
    }

    public PsiElement getDeclaration() {
        return this.myDeclaration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/utils/light/SpringImplicitVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/utils/light/SpringImplicitVariable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

