/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.config;

import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class MetaConfigKeyManager {
    public List<? extends MetaConfigKey> getAllMetaConfigKeys(@Nullable PsiElement psiElement) {
        return psiElement == null ? Collections.emptyList() : this.getAllMetaConfigKeys(ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement));
    }

    public abstract List<? extends MetaConfigKey> getAllMetaConfigKeys(@Nullable Module var1);

    @Contract(value="_, null -> null; null, !null -> null")
    @Nullable
    public MetaConfigKey findApplicationMetaConfigKey(@Nullable Module module, @Nullable String configKey) {
        return (MetaConfigKey)ContainerUtil.getFirstItem(this.doFindApplicationMetaConfigKeys(module, configKey, false));
    }

    @Contract(value="_, null -> null; null, !null -> null")
    @Nullable
    public MetaConfigKey findCanonicalApplicationMetaConfigKey(@Nullable Module module, @Nullable String configKey) {
        return (MetaConfigKey)ContainerUtil.getFirstItem(this.doFindApplicationMetaConfigKeys(module, configKey, true));
    }

    @NotNull
    public @Unmodifiable List<? extends MetaConfigKey> findAllApplicationMetaConfigKeys(@NotNull PsiElement psiElement, @Nullable String configKey) {
        if (psiElement == null) {
            MetaConfigKeyManager.$$$reportNull$$$0(0);
        }
        if (configKey == null) {
            List list = Collections.emptyList();
            if (list == null) {
                MetaConfigKeyManager.$$$reportNull$$$0(1);
            }
            return list;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            List list = Collections.emptyList();
            if (list == null) {
                MetaConfigKeyManager.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<? extends MetaConfigKey> list = this.findAllApplicationMetaConfigKeys(module, configKey);
        if (list == null) {
            MetaConfigKeyManager.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public @Unmodifiable List<? extends MetaConfigKey> findAllApplicationMetaConfigKeys(@Nullable Module module, @Nullable String configKey) {
        return this.doFindApplicationMetaConfigKeys(module, configKey, false);
    }

    @NotNull
    public abstract ConfigKeyNameBinder getConfigKeyNameBinder(@NotNull Module var1);

    protected boolean isCaseSensitiveKeys() {
        return true;
    }

    private @Unmodifiable @NotNull List<? extends MetaConfigKey> doFindApplicationMetaConfigKeys(@Nullable Module module, @Nullable String configKey, boolean exact) {
        if (module == null || configKey == null) {
            List list = Collections.emptyList();
            if (list == null) {
                MetaConfigKeyManager.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<? extends MetaConfigKey> allKeys = this.getAllMetaConfigKeys(module);
        if (allKeys.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                MetaConfigKeyManager.$$$reportNull$$$0(5);
            }
            return list;
        }
        if (exact) {
            List list = ContainerUtil.filter(allKeys, key -> configKey.equals(key.getName()));
            if (list == null) {
                MetaConfigKeyManager.$$$reportNull$$$0(6);
            }
            return list;
        }
        List normalMatchingKeys = ContainerUtil.findAll(allKeys, this.createNormalAccessTypeMatchingCondition(configKey));
        if (!normalMatchingKeys.isEmpty()) {
            List list = normalMatchingKeys;
            if (list == null) {
                MetaConfigKeyManager.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<? extends MetaConfigKey> list = this.filterMatchingKeys(allKeys, configKey, module);
        if (list == null) {
            MetaConfigKeyManager.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private Condition<MetaConfigKey> createNormalAccessTypeMatchingCondition(@NotNull String configKey) {
        if (configKey == null) {
            MetaConfigKeyManager.$$$reportNull$$$0(9);
        }
        Condition condition = key -> key.isAccessType(MetaConfigKey.AccessType.NORMAL) && Comparing.equal((String)key.getName(), (String)configKey, (boolean)this.isCaseSensitiveKeys());
        if (condition == null) {
            MetaConfigKeyManager.$$$reportNull$$$0(10);
        }
        return condition;
    }

    @NotNull
    protected List<? extends MetaConfigKey> filterMatchingKeys(@NotNull List<? extends MetaConfigKey> allKeys, @NotNull String configKey, @NotNull Module module) {
        if (allKeys == null) {
            MetaConfigKeyManager.$$$reportNull$$$0(11);
        }
        if (configKey == null) {
            MetaConfigKeyManager.$$$reportNull$$$0(12);
        }
        if (module == null) {
            MetaConfigKeyManager.$$$reportNull$$$0(13);
        }
        ConfigKeyNameBinder binder = this.getConfigKeyNameBinder(module);
        List list = binder.bindsTo(allKeys, configKey).toList();
        if (list == null) {
            MetaConfigKeyManager.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 10, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/jvm/config/MetaConfigKeyManager";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKey";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allKeys";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/jvm/config/MetaConfigKeyManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllApplicationMetaConfigKeys";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doFindApplicationMetaConfigKeys";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createNormalAccessTypeMatchingCondition";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "filterMatchingKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findAllApplicationMetaConfigKeys";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createNormalAccessTypeMatchingCondition";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "filterMatchingKeys";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 10, 14 -> new IllegalStateException(string);
        };
    }

    public static interface ConfigKeyNameBinder {
        public boolean bindsTo(@NotNull MetaConfigKey var1, @NotNull String var2);

        @NotNull
        default public JBIterable<? extends MetaConfigKey> bindsTo(@NotNull List<? extends MetaConfigKey> keys, @NotNull String configKeyText) {
            if (keys == null) {
                ConfigKeyNameBinder.$$$reportNull$$$0(0);
            }
            if (configKeyText == null) {
                ConfigKeyNameBinder.$$$reportNull$$$0(1);
            }
            JBIterable jBIterable = JBIterable.from(keys).filter(key -> this.bindsTo((MetaConfigKey)key, configKeyText));
            if (jBIterable == null) {
                ConfigKeyNameBinder.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        public boolean matchesPrefix(@NotNull MetaConfigKey var1, @NotNull String var2);

        public boolean matchesPart(@NotNull String var1, @NotNull String var2);

        @Nullable
        public String bindsToKeyProperty(@NotNull MetaConfigKey var1, @Nullable String var2, @NotNull String var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keys";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configKeyText";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/microservices/jvm/config/MetaConfigKeyManager$ConfigKeyNameBinder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/microservices/jvm/config/MetaConfigKeyManager$ConfigKeyNameBinder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "bindsTo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "bindsTo";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

