/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.index;

import com.intellij.microservices.jvm.index.PropertyCodeReferenceIndexKt;
import com.intellij.microservices.jvm.index.PropertyCodeReferenceIndexProcessor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IntCollectionDataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u001e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00012\u001a\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u00060\u0005B\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\nH\u0016J \u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\u0014\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00162\u0006\u0010\u0017\u001a\u00020\u0006H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/microservices/jvm/index/PropertyCodeReferenceIndex;", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "", "", "", "Lcom/intellij/util/indexing/DataIndexer;", "Lcom/intellij/util/indexing/FileContent;", "<init>", "()V", "getName", "Lcom/intellij/util/indexing/ID;", "getIndexer", "dependsOnFileContent", "", "getKeyDescriptor", "Lcom/intellij/util/io/KeyDescriptor;", "getValueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "getVersion", "getInputFilter", "Lcom/intellij/util/indexing/FileBasedIndex$InputFilter;", "map", "", "inputData", "intellij.microservices.jvm"})
final class PropertyCodeReferenceIndex
extends FileBasedIndexExtension<String, Collection<? extends Integer>>
implements DataIndexer<String, Collection<? extends Integer>, FileContent> {
    @NotNull
    public ID<String, Collection<Integer>> getName() {
        return PropertyCodeReferenceIndexKt.getPROPERTY_CODE_REFERENCE_INDEX();
    }

    @NotNull
    public DataIndexer<String, Collection<Integer>, FileContent> getIndexer() {
        return this;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)enumeratorStringDescriptor, (String)"INSTANCE");
        return (KeyDescriptor)enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Collection<Integer>> getValueExternalizer() {
        return (DataExternalizer)new IntCollectionDataExternalizer();
    }

    public int getVersion() {
        return 0;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return (FileBasedIndex.InputFilter)new FileBasedIndex.FileTypeSpecificInputFilter(){

            public boolean acceptInput(VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                for (PropertyCodeReferenceIndexProcessor processor : PropertyCodeReferenceIndexKt.access$getPROPERTY_CODE_REFERENCE_INDEX_PROCESSOR_EP$p().getExtensionList()) {
                    if (!Intrinsics.areEqual((Object)processor.getFileType(), (Object)file.getFileType()) || !processor.accept(file)) continue;
                    return true;
                }
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public void registerFileTypesUsedForIndexing(Consumer<? super FileType> fileTypeSink) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(fileTypeSink, (String)"fileTypeSink");
                Iterable $this$map$iv = PropertyCodeReferenceIndexKt.access$getPROPERTY_CODE_REFERENCE_INDEX_PROCESSOR_EP$p().getExtensionList();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PropertyCodeReferenceIndexProcessor propertyCodeReferenceIndexProcessor = (PropertyCodeReferenceIndexProcessor)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getFileType());
                }
                for (FileType ft : (List)destination$iv$iv) {
                    fileTypeSink.consume((Object)ft);
                }
            }
        };
    }

    @NotNull
    public Map<String, Collection<Integer>> map(@NotNull FileContent inputData) {
        Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
        for (PropertyCodeReferenceIndexProcessor processor : PropertyCodeReferenceIndexKt.access$getPROPERTY_CODE_REFERENCE_INDEX_PROCESSOR_EP$p().getExtensionList()) {
            if (!Intrinsics.areEqual((Object)processor.getFileType(), (Object)inputData.getFileType())) continue;
            return processor.findCodeReferences(inputData);
        }
        return MapsKt.emptyMap();
    }
}

