/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.retrofit.client.generator;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.microservices.client.generator.AvailableClientSettings;
import com.intellij.microservices.client.generator.ClientExample;
import com.intellij.microservices.client.generator.ClientGenerator;
import com.intellij.microservices.client.generator.ClientGeneratorSetting;
import com.intellij.microservices.jvm.client.generator.utils.KotlinClientParameter;
import com.intellij.microservices.jvm.retrofit.RetrofitBundle;
import com.intellij.microservices.oas.OasEndpointPath;
import com.intellij.microservices.oas.OasHttpMethod;
import com.intellij.microservices.oas.OasOperation;
import com.intellij.microservices.oas.OasParameter;
import com.intellij.microservices.oas.OasParameterIn;
import com.intellij.microservices.oas.OasSchema;
import com.intellij.microservices.oas.OpenApiSpecification;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0005H\u0002J\n\u0010\u0010\u001a\u00020\u0005*\u00020\u0011J\u0012\u0010\u0012\u001a\u00020\u0013*\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\"\u0010\u001c\u001a\u00020\u00172\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u0018\u001a\u00020\u0019R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/intellij/microservices/jvm/retrofit/client/generator/RetrofitClientGenerator;", "Lcom/intellij/microservices/client/generator/ClientGenerator;", "<init>", "()V", "title", "", "getTitle", "()Ljava/lang/String;", "availableClientSettings", "Lcom/intellij/microservices/client/generator/AvailableClientSettings;", "getAvailableClientSettings", "()Lcom/intellij/microservices/client/generator/AvailableClientSettings;", "getNameByOperationOrPath", "operation", "Lcom/intellij/microservices/oas/OasOperation;", "defaultName", "getHttpMethod", "Lcom/intellij/microservices/oas/OasHttpMethod;", "uniqMethodName", "", "", "Lcom/intellij/microservices/jvm/retrofit/client/generator/RetrofitClientGenerator$Method;", "generate", "Lcom/intellij/microservices/client/generator/ClientExample;", "project", "Lcom/intellij/openapi/project/Project;", "openApiSpecification", "Lcom/intellij/microservices/oas/OpenApiSpecification;", "build", "properties", "", "", "Method", "intellij.microservices.jvm.retrofit"})
@SourceDebugExtension(value={"SMAP\nRetrofitClientGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetrofitClientGenerator.kt\ncom/intellij/microservices/jvm/retrofit/client/generator/RetrofitClientGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1374#2:112\n1460#2,2:113\n1563#2:115\n1634#2,3:116\n1462#2,3:119\n*S KotlinDebug\n*F\n+ 1 RetrofitClientGenerator.kt\ncom/intellij/microservices/jvm/retrofit/client/generator/RetrofitClientGenerator\n*L\n69#1:112\n69#1:113,2\n70#1:115\n70#1:116,3\n69#1:119,3\n*E\n"})
public final class RetrofitClientGenerator
implements ClientGenerator {
    @NotNull
    private final AvailableClientSettings availableClientSettings = new AvailableClientSettings(){
        private final boolean boilerplateAvailable;
        private final ClientGeneratorSetting actualClientSettings;
        {
            this.boilerplateAvailable = true;
            this.actualClientSettings = new ClientGeneratorSetting(false, null, null, 7, null);
        }

        public boolean getBoilerplateAvailable() {
            return this.boilerplateAvailable;
        }

        public ClientGeneratorSetting getActualClientSettings() {
            return this.actualClientSettings;
        }
    };

    @NotNull
    public String getTitle() {
        return RetrofitBundle.INSTANCE.message("retrofit.client.generator.tab.name", new Object[0]);
    }

    @NotNull
    public AvailableClientSettings getAvailableClientSettings() {
        return this.availableClientSettings;
    }

    private final String getNameByOperationOrPath(OasOperation operation, String defaultName) {
        String string = operation.getOperationId();
        if (string == null) {
            string = defaultName;
        }
        return string;
    }

    static /* synthetic */ String getNameByOperationOrPath$default(RetrofitClientGenerator retrofitClientGenerator, OasOperation oasOperation, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "main";
        }
        return retrofitClientGenerator.getNameByOperationOrPath(oasOperation, string);
    }

    @NotNull
    public final String getHttpMethod(@NotNull OasHttpMethod $this$getHttpMethod) {
        Intrinsics.checkNotNullParameter((Object)$this$getHttpMethod, (String)"<this>");
        String string = $this$getHttpMethod.getMethodName().toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return string;
    }

    private final void uniqMethodName(List<Method> $this$uniqMethodName) {
        Map map = new LinkedHashMap();
        for (Method method : $this$uniqMethodName) {
            int n;
            Map map2 = map;
            String string = method.getUniqMethodName();
            Integer n2 = (Integer)map.get(method.getUniqMethodName());
            if (n2 != null) {
                int it = ((Number)n2).intValue();
                boolean bl = false;
                method.setUniqMethodName(method.getUniqMethodName() + it);
                n = it + 1;
            } else {
                n = 1;
            }
            Integer n3 = n;
            map2.put(string, n3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ClientExample generate(@NotNull Project project, @NotNull OpenApiSpecification openApiSpecification) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)openApiSpecification, (String)"openApiSpecification");
        Map attributes = new LinkedHashMap();
        Iterable $this$flatMap$iv = openApiSpecification.getPaths();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            OasEndpointPath path = (OasEndpointPath)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = path.getOperations();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void operation;
                OasOperation oasOperation = (OasOperation)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                Method builder = new Method(path.getPath(), this.getHttpMethod(operation.getMethod()), RetrofitClientGenerator.getNameByOperationOrPath$default(this, (OasOperation)operation, null, 2, null));
                for (OasParameter parameter : operation.getParameters()) {
                    KotlinClientParameter kotlinParam = KotlinClientParameter.Companion.fromOasParameter(parameter);
                    Collection collection2 = builder.getParameters();
                    collection2.add(switch (WhenMappings.$EnumSwitchMapping$0[parameter.getInPlace().ordinal()]) {
                        case 1 -> new Method.Param.Path(kotlinParam);
                        case 2 -> new Method.Param.Query(kotlinParam);
                        case 3 -> new Method.Param.Header(kotlinParam);
                        case 4 -> {
                            KotlinClientParameter cookieParam = KotlinClientParameter.Companion.fromOasSchema(parameter.getSchema(), kotlinParam.getName(), "Cookie");
                            yield new Method.Param.Header(cookieParam);
                        }
                        default -> throw new NoWhenBranchMatchedException();
                    });
                }
                Object object = operation.getRequestBody();
                if (object != null && (object = object.getContent()) != null && (object = object.entrySet()) != null && (object = (Map.Entry)CollectionsKt.firstOrNull((Iterable)((Iterable)object))) != null) {
                    Object object2 = object;
                    boolean bl3 = false;
                    String contentType = (String)object2.getKey();
                    OasSchema schema = (OasSchema)object2.getValue();
                    ((Collection)builder.getParameters()).add(new Method.Param.Body(KotlinClientParameter.Companion.bodyFromOasSchema(schema)));
                    ((Collection)builder.getDefaultHeaderParam()).add(TuplesKt.to((Object)"Content-Type", (Object)contentType));
                }
                collection.add(builder);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List clientMethods = (List)destination$iv$iv;
        this.uniqMethodName(clientMethods);
        attributes.put("ENDPOINTS", clientMethods);
        attributes.put("WITH_BOILERPLATE", this.getAvailableClientSettings().getActualClientSettings().getBoilerplate());
        return this.build(attributes, project);
    }

    @NotNull
    public final ClientExample build(@NotNull Map<String, ? extends Object> properties, @NotNull Project project) {
        FileTemplate template;
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getCodeTemplate("Retrofit.kt");
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getCodeTemplate(...)");
        FileTemplate $this$build_u24lambda_u240 = template = fileTemplate;
        boolean bl = false;
        $this$build_u24lambda_u240.setReformatCode(true);
        String string = $this$build_u24lambda_u240.getText(properties);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"run(...)");
        String text = string;
        return ClientExample.Companion.fromFileExtension(text, "kt");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001%B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R,\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00180\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0014\"\u0004\b\u001a\u0010\u0016\u00a8\u0006&"}, d2={"Lcom/intellij/microservices/jvm/retrofit/client/generator/RetrofitClientGenerator$Method;", "", "path", "", "operation", "uniqMethodName", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "setPath", "(Ljava/lang/String;)V", "getOperation", "setOperation", "getUniqMethodName", "setUniqMethodName", "parameters", "", "Lcom/intellij/microservices/jvm/retrofit/client/generator/RetrofitClientGenerator$Method$Param;", "getParameters", "()Ljava/util/List;", "setParameters", "(Ljava/util/List;)V", "defaultHeaderParam", "Lkotlin/Pair;", "getDefaultHeaderParam", "setDefaultHeaderParam", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Param", "intellij.microservices.jvm.retrofit"})
    public static final class Method {
        @NotNull
        private String path;
        @NotNull
        private String operation;
        @NotNull
        private String uniqMethodName;
        @NotNull
        private List<Param> parameters;
        @NotNull
        private List<Pair<String, String>> defaultHeaderParam;

        public Method(@NotNull String path, @NotNull String operation, @NotNull String uniqMethodName) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)uniqMethodName, (String)"uniqMethodName");
            this.path = path;
            this.operation = operation;
            this.uniqMethodName = uniqMethodName;
            this.parameters = new ArrayList();
            this.defaultHeaderParam = new ArrayList();
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        public final void setPath(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.path = string;
        }

        @NotNull
        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.operation = string;
        }

        @NotNull
        public final String getUniqMethodName() {
            return this.uniqMethodName;
        }

        public final void setUniqMethodName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.uniqMethodName = string;
        }

        @NotNull
        public final List<Param> getParameters() {
            return this.parameters;
        }

        public final void setParameters(@NotNull List<Param> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.parameters = list;
        }

        @NotNull
        public final List<Pair<String, String>> getDefaultHeaderParam() {
            return this.defaultHeaderParam;
        }

        public final void setDefaultHeaderParam(@NotNull List<Pair<String, String>> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.defaultHeaderParam = list;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final String component2() {
            return this.operation;
        }

        @NotNull
        public final String component3() {
            return this.uniqMethodName;
        }

        @NotNull
        public final Method copy(@NotNull String path, @NotNull String operation, @NotNull String uniqMethodName) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)uniqMethodName, (String)"uniqMethodName");
            return new Method(path, operation, uniqMethodName);
        }

        public static /* synthetic */ Method copy$default(Method method, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = method.path;
            }
            if ((n & 2) != 0) {
                string2 = method.operation;
            }
            if ((n & 4) != 0) {
                string3 = method.uniqMethodName;
            }
            return method.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Method(path=" + this.path + ", operation=" + this.operation + ", uniqMethodName=" + this.uniqMethodName + ")";
        }

        public int hashCode() {
            int result = this.path.hashCode();
            result = result * 31 + this.operation.hashCode();
            result = result * 31 + this.uniqMethodName.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Method)) {
                return false;
            }
            Method method = (Method)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)method.path)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.operation, (Object)method.operation)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.uniqMethodName, (Object)method.uniqMethodName);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\r\u000e\u000f\u0010B\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0004\u0011\u0012\u0013\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/microservices/jvm/retrofit/client/generator/RetrofitClientGenerator$Method$Param;", "", "annotationType", "", "parameter", "Lcom/intellij/microservices/jvm/client/generator/utils/KotlinClientParameter;", "<init>", "(Ljava/lang/String;Lcom/intellij/microservices/jvm/client/generator/utils/KotlinClientParameter;)V", "getAnnotationType", "()Ljava/lang/String;", "getParameter", "()Lcom/intellij/microservices/jvm/client/generator/utils/KotlinClientParameter;", "toString", "Query", "Path", "Header", "Body", "Lcom/intellij/microservices/jvm/retrofit/client/generator/RetrofitClientGenerator$Method$Param$Body;", "Lcom/intellij/microservices/jvm/retrofit/client/generator/RetrofitClientGenerator$Method$Param$Header;", "Lcom/intellij/microservices/jvm/retrofit/client/generator/RetrofitClientGenerator$Method$Param$Path;", "Lcom/intellij/microservices/jvm/retrofit/client/generator/RetrofitClientGenerator$Method$Param$Query;", "intellij.microservices.jvm.retrofit"})
        @SourceDebugExtension(value={"SMAP\nRetrofitClientGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetrofitClientGenerator.kt\ncom/intellij/microservices/jvm/retrofit/client/generator/RetrofitClientGenerator$Method$Param\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
        public static abstract sealed class Param {
            @NotNull
            private final String annotationType;
            @NotNull
            private final KotlinClientParameter parameter;

            private Param(String annotationType, KotlinClientParameter parameter) {
                this.annotationType = annotationType;
                this.parameter = parameter;
            }

            @NotNull
            public final String getAnnotationType() {
                return this.annotationType;
            }

            @NotNull
            public final KotlinClientParameter getParameter() {
                return this.parameter;
            }

            @NotNull
            public String toString() {
                Object object;
                String type;
                String name;
                block3: {
                    block2: {
                        KotlinClientParameter kotlinClientParameter = this.parameter;
                        name = kotlinClientParameter.component1();
                        type = kotlinClientParameter.component2();
                        String httpName = kotlinClientParameter.component3();
                        object = httpName;
                        if (object == null) break block2;
                        String it = object;
                        boolean bl = false;
                        String string = this.annotationType + "(\"" + it + "\")";
                        object = string;
                        if (string != null) break block3;
                    }
                    object = this.annotationType;
                }
                String annotation = object;
                return annotation + " " + name + ": " + type;
            }

            public /* synthetic */ Param(String annotationType, KotlinClientParameter parameter, DefaultConstructorMarker $constructor_marker) {
                this(annotationType, parameter);
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/microservices/jvm/retrofit/client/generator/RetrofitClientGenerator$Method$Param$Body;", "Lcom/intellij/microservices/jvm/retrofit/client/generator/RetrofitClientGenerator$Method$Param;", "parameter", "Lcom/intellij/microservices/jvm/client/generator/utils/KotlinClientParameter;", "<init>", "(Lcom/intellij/microservices/jvm/client/generator/utils/KotlinClientParameter;)V", "intellij.microservices.jvm.retrofit"})
            public static final class Body
            extends Param {
                public Body(@NotNull KotlinClientParameter parameter) {
                    Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                    super("@Body", parameter, null);
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/microservices/jvm/retrofit/client/generator/RetrofitClientGenerator$Method$Param$Header;", "Lcom/intellij/microservices/jvm/retrofit/client/generator/RetrofitClientGenerator$Method$Param;", "parameter", "Lcom/intellij/microservices/jvm/client/generator/utils/KotlinClientParameter;", "<init>", "(Lcom/intellij/microservices/jvm/client/generator/utils/KotlinClientParameter;)V", "intellij.microservices.jvm.retrofit"})
            public static final class Header
            extends Param {
                public Header(@NotNull KotlinClientParameter parameter) {
                    Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                    super("@Header", parameter, null);
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/microservices/jvm/retrofit/client/generator/RetrofitClientGenerator$Method$Param$Path;", "Lcom/intellij/microservices/jvm/retrofit/client/generator/RetrofitClientGenerator$Method$Param;", "parameter", "Lcom/intellij/microservices/jvm/client/generator/utils/KotlinClientParameter;", "<init>", "(Lcom/intellij/microservices/jvm/client/generator/utils/KotlinClientParameter;)V", "intellij.microservices.jvm.retrofit"})
            public static final class Path
            extends Param {
                public Path(@NotNull KotlinClientParameter parameter) {
                    Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                    super("@Path", parameter, null);
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/microservices/jvm/retrofit/client/generator/RetrofitClientGenerator$Method$Param$Query;", "Lcom/intellij/microservices/jvm/retrofit/client/generator/RetrofitClientGenerator$Method$Param;", "parameter", "Lcom/intellij/microservices/jvm/client/generator/utils/KotlinClientParameter;", "<init>", "(Lcom/intellij/microservices/jvm/client/generator/utils/KotlinClientParameter;)V", "intellij.microservices.jvm.retrofit"})
            public static final class Query
            extends Param {
                public Query(@NotNull KotlinClientParameter parameter) {
                    Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                    super("@Query", parameter, null);
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OasParameterIn.values().length];
            try {
                nArray[OasParameterIn.PATH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OasParameterIn.QUERY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OasParameterIn.HEADER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OasParameterIn.COOKIE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

