/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.util;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.microservices.MicroservicesBundle;
import com.intellij.microservices.http.request.NavigatorHttpRequest;
import com.intellij.microservices.http.request.RequestNavigator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.DropDownLink;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0019B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0010\u0010\u0016\u001a\u00020\u00112\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\u0012\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010\u0018\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/microservices/jvm/util/PortBindingNotificationPanel;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lcom/intellij/microservices/http/request/NavigatorHttpRequest;", "hint", "", "applicationPort", "", "resolvedPort", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/microservices/http/request/NavigatorHttpRequest;Ljava/lang/String;II)V", "messagePanel", "link", "Ljavax/swing/JComponent;", "registerProcessListener", "", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "setRequest", "createLink", "updateUI", "RequestNavigatorPopupStep", "intellij.microservices.jvm"})
@SourceDebugExtension(value={"SMAP\nPortBindingNotificationPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PortBindingNotificationPanel.kt\ncom/intellij/microservices/jvm/util/PortBindingNotificationPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
public final class PortBindingNotificationPanel
extends JPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final String hint;
    private final int resolvedPort;
    @NotNull
    private final JPanel messagePanel;
    @NotNull
    private JComponent link;

    public PortBindingNotificationPanel(@NotNull Project project, @Nullable NavigatorHttpRequest request2, @NotNull String hint, int applicationPort, int resolvedPort) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
        super(new BorderLayout());
        this.project = project;
        this.hint = hint;
        this.resolvedPort = resolvedPort;
        this.setBackground(EditorColorsManager.getInstance().getGlobalScheme().getColor(HintUtil.PROMOTION_PANE_KEY));
        this.setBorder((Border)JBUI.Borders.empty((int)5, (int)3));
        Object[] objectArray = new Object[]{applicationPort};
        JLabel messageLabel = new JLabel(MicroservicesBundle.message((String)"microservices.port.binding.notification.text", (Object[])objectArray));
        this.link = this.createLink(request2);
        this.messagePanel = new JPanel(new FlowLayout(1, 0, 0));
        this.messagePanel.setOpaque(false);
        this.messagePanel.add(messageLabel);
        this.messagePanel.add(this.link);
        this.add((Component)this.messagePanel, "West");
    }

    public final void registerProcessListener(@NotNull ProcessHandler processHandler, @Nullable Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        ProcessAdapter processListener2 = new ProcessAdapter(this){
            final /* synthetic */ PortBindingNotificationPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (PortBindingNotificationPanel.access$getLink$p(this.this$0) instanceof ActionLink) {
                    PortBindingNotificationPanel.access$getLink$p(this.this$0).setEnabled(false);
                }
            }
        };
        if (parentDisposable != null) {
            processHandler.addProcessListener((ProcessListener)processListener2, parentDisposable);
        } else {
            processHandler.addProcessListener((ProcessListener)processListener2);
        }
    }

    public final void setRequest(@Nullable NavigatorHttpRequest request2) {
        JComponent newLink = this.createLink(request2);
        JComponent oldLink = this.link;
        this.link = newLink;
        this.messagePanel.remove(oldLink);
        this.messagePanel.add(newLink);
        this.messagePanel.revalidate();
        this.messagePanel.repaint();
    }

    private final JComponent createLink(NavigatorHttpRequest request2) {
        JComponent jComponent;
        NavigatorHttpRequest navigatorHttpRequest = request2;
        List navigators = navigatorHttpRequest != null ? RequestNavigator.Companion.getRequestNavigators(navigatorHttpRequest) : CollectionsKt.emptyList();
        if (navigators.isEmpty()) {
            jComponent = new JLabel(String.valueOf(this.resolvedPort));
        } else if (navigators.size() == 1) {
            ActionLink actionLink;
            ActionLink $this$createLink_u24lambda_u241 = actionLink = new ActionLink(String.valueOf(this.resolvedPort), arg_0 -> PortBindingNotificationPanel.createLink$lambda$0(navigators, this, request2, arg_0));
            boolean bl = false;
            $this$createLink_u24lambda_u241.setAutoHideOnDisable(false);
            jComponent = (JComponent)actionLink;
        } else {
            DropDownLink dropDownLink;
            DropDownLink $this$createLink_u24lambda_u243 = dropDownLink = new DropDownLink((Object)this.resolvedPort, arg_0 -> PortBindingNotificationPanel.createLink$lambda$2(this, request2, navigators, arg_0));
            boolean bl = false;
            $this$createLink_u24lambda_u243.setAutoHideOnDisable(false);
            jComponent = (JComponent)dropDownLink;
        }
        return jComponent;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBorder((Border)JBUI.Borders.empty((int)5, (int)3));
    }

    private static final Unit createLink$lambda$0(List $navigators, PortBindingNotificationPanel this$0, NavigatorHttpRequest $request, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RequestNavigator requestNavigator = (RequestNavigator)$navigators.get(0);
        Project project = this$0.project;
        NavigatorHttpRequest navigatorHttpRequest = $request;
        Intrinsics.checkNotNull((Object)navigatorHttpRequest);
        requestNavigator.navigate(project, navigatorHttpRequest, this$0.hint);
        return Unit.INSTANCE;
    }

    private static final JBPopup createLink$lambda$2(PortBindingNotificationPanel this$0, NavigatorHttpRequest $request, List $navigators, DropDownLink it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JBPopupFactory jBPopupFactory = JBPopupFactory.getInstance();
        Project project = this$0.project;
        NavigatorHttpRequest navigatorHttpRequest = $request;
        Intrinsics.checkNotNull((Object)navigatorHttpRequest);
        ListPopup listPopup = jBPopupFactory.createListPopup((ListPopupStep)new RequestNavigatorPopupStep(project, navigatorHttpRequest, this$0.hint, $navigators));
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createListPopup(...)");
        return (JBPopup)listPopup;
    }

    public static final /* synthetic */ JComponent access$getLink$p(PortBindingNotificationPanel $this) {
        return $this.link;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/microservices/jvm/util/PortBindingNotificationPanel$RequestNavigatorPopupStep;", "Lcom/intellij/openapi/ui/popup/util/BaseListPopupStep;", "Lcom/intellij/microservices/http/request/RequestNavigator;", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lcom/intellij/microservices/http/request/NavigatorHttpRequest;", "hint", "", "navigators", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/microservices/http/request/NavigatorHttpRequest;Ljava/lang/String;Ljava/util/List;)V", "getIconFor", "Ljavax/swing/Icon;", "navigator", "getTextFor", "onChosen", "Lcom/intellij/openapi/ui/popup/PopupStep;", "finalChoice", "", "intellij.microservices.jvm"})
    private static final class RequestNavigatorPopupStep
    extends BaseListPopupStep<RequestNavigator> {
        @NotNull
        private final Project project;
        @NotNull
        private final NavigatorHttpRequest request;
        @NotNull
        private final String hint;

        public RequestNavigatorPopupStep(@NotNull Project project, @NotNull NavigatorHttpRequest request2, @NotNull String hint, @NotNull List<? extends RequestNavigator> navigators) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
            Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
            Intrinsics.checkNotNullParameter(navigators, (String)"navigators");
            super(null, navigators);
            this.project = project;
            this.request = request2;
            this.hint = hint;
        }

        @Nullable
        public Icon getIconFor(@NotNull RequestNavigator navigator) {
            Intrinsics.checkNotNullParameter((Object)navigator, (String)"navigator");
            return navigator.getIcon();
        }

        @NotNull
        public String getTextFor(@NotNull RequestNavigator navigator) {
            Intrinsics.checkNotNullParameter((Object)navigator, (String)"navigator");
            return navigator.getDisplayText();
        }

        @Nullable
        public PopupStep<?> onChosen(@NotNull RequestNavigator navigator, boolean finalChoice) {
            Intrinsics.checkNotNullParameter((Object)navigator, (String)"navigator");
            return this.doFinalStep(() -> RequestNavigatorPopupStep.onChosen$lambda$0(navigator, this));
        }

        private static final void onChosen$lambda$0(RequestNavigator $navigator, RequestNavigatorPopupStep this$0) {
            $navigator.navigate(this$0.project, this$0.request, this$0.hint);
        }
    }
}

