/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.maven;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramDataView;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.diagram.extras.custom.CommonDiagramExtras;
import com.intellij.diagram.util.DiagramAlgorithmsService;
import com.intellij.diagram.util.DiagramSelectionService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uml.maven.MavenDiagramCategoryManager;
import com.intellij.uml.maven.MavenElement;
import com.intellij.uml.maven.MavenUmlDataKeys;
import com.intellij.uml.maven.MavenUmlEdge;
import com.intellij.uml.maven.MavenUmlNode;
import com.intellij.uml.maven.MavenUmlNodeHighlighter;
import com.intellij.uml.maven.MavenUmlVisibilityManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenArtifactState;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;

final class MavenUmlDataModel
extends DiagramDataModel<MavenElement> {
    private final MavenElement myElement;
    private final ArrayList<DiagramNode<MavenElement>> myNodes = new ArrayList();
    private final Map<MavenArtifact, MavenUmlNode> myArtifactsNodes = new IdentityHashMap<MavenArtifact, MavenUmlNode>();
    private final ArrayList<DiagramEdge<MavenElement>> myEdges = new ArrayList();
    private MavenUmlNode myRoot;
    private final Map<MavenUmlNode, List<MavenUmlEdge>> conflicted = new HashMap<MavenUmlNode, List<MavenUmlEdge>>();
    private final Map<MavenUmlNode, List<MavenUmlEdge>> duplicated = new HashMap<MavenUmlNode, List<MavenUmlEdge>>();
    private VisibilityLevel myVisibility;

    MavenUmlDataModel(Project project, MavenElement element) {
        super(project, Objects.requireNonNull(DiagramProvider.findByID((String)"MAVEN")));
        this.myElement = element;
    }

    @NotNull
    protected <T> DiagramNodeContentManager getOrCreateContentManager(@NotNull DiagramProvider<T> provider) {
        if (provider == null) {
            MavenUmlDataModel.$$$reportNull$$$0(0);
        }
        DiagramNodeContentManager diagramNodeContentManager = provider.getNodeContentManager();
        if (diagramNodeContentManager == null) {
            MavenUmlDataModel.$$$reportNull$$$0(1);
        }
        return diagramNodeContentManager;
    }

    public void refreshDataModel() {
        this.myNodes.clear();
        this.myArtifactsNodes.clear();
        this.myEdges.clear();
        this.conflicted.clear();
        this.duplicated.clear();
        this.myVisibility = this.getVisibilityManager().getCurrentVisibilityLevel();
        this.myRoot = new MavenUmlNode(this.myElement);
        this.addNodesRecursively(this.myRoot);
        this.addConflictEdges();
        this.addDuplicatedEdges();
        DiagramNodeContentManager nodeContentManager = Objects.requireNonNull(this.getNodeContentManager());
        if (nodeContentManager.isCategoryEnabled(MavenDiagramCategoryManager.DUPLICATES)) {
            HashSet<DiagramNode> nodes = new HashSet<DiagramNode>();
            for (Map.Entry<MavenUmlNode, List<MavenUmlEdge>> entry : this.conflicted.entrySet()) {
                nodes.add((DiagramNode)entry.getKey());
                for (MavenUmlEdge edge : entry.getValue()) {
                    nodes.add(edge.getTarget());
                }
            }
            if (!nodes.isEmpty()) {
                this.removeAllExceptPathsFromRootToNodes(nodes);
            }
        } else if (nodeContentManager.isCategoryEnabled(CommonDiagramExtras.PATH_TO_ROOT)) {
            List nodes = DiagramSelectionService.getInstance().getSelectedNodes(this.getBuilder());
            if (!nodes.isEmpty()) {
                this.removeAllExceptPathsFromRootToNodes(nodes);
            }
        } else if (CommonDiagramExtras.isSelectionMode((DiagramBuilder)this.getBuilder())) {
            DiagramAlgorithmsService.getInstance().removeNonSelectedDependencies((DiagramDataModel)this);
        }
    }

    private void removeAllExceptPathsFromRootToNodes(@NotNull Collection<DiagramNode> nodes) {
        if (nodes == null) {
            MavenUmlDataModel.$$$reportNull$$$0(2);
        }
        Set pathEdges = DiagramAlgorithmsService.getInstance().getPathsFromRoot((DiagramNode)this.myRoot, nodes, (DiagramDataView)this);
        Set pathNodes = DiagramAlgorithmsService.getInstance().collectNodes((Collection)pathEdges);
        for (DiagramNode diagramNode : this.myNodes.toArray(new DiagramNode[0])) {
            if (pathNodes.contains(diagramNode) || diagramNode == this.myRoot) continue;
            this.myNodes.remove(diagramNode);
        }
        for (DiagramNode diagramNode : this.myEdges.toArray(new DiagramEdge[0])) {
            if (pathEdges.contains(diagramNode)) continue;
            this.myEdges.remove(diagramNode);
        }
    }

    private void addConflictEdges() {
        for (MavenUmlNode node : this.conflicted.keySet()) {
            for (DiagramNode<MavenElement> to : MavenUmlNodeHighlighter.getConflictedWith(this, (DiagramNode<MavenElement>)node)) {
                to.putUserData(MavenUmlDataKeys.CONFLICTED_WITH, (Object)node);
                if (to == node) continue;
                MavenUmlEdge e = new MavenUmlEdge(node, (MavenUmlNode)to, MavenArtifactState.CONFLICT);
                this.conflicted.get((Object)node).add(e);
                this.myEdges.add((DiagramEdge<MavenElement>)e);
            }
        }
    }

    private void addDuplicatedEdges() {
        for (MavenUmlNode node : this.duplicated.keySet()) {
            for (DiagramNode<MavenElement> to : MavenUmlNodeHighlighter.getConflictedWith(this, (DiagramNode<MavenElement>)node)) {
                to.putUserData(MavenUmlDataKeys.DUPLICATED_WITH, (Object)node);
                if (to == node) continue;
                MavenUmlEdge e = new MavenUmlEdge(node, (MavenUmlNode)to, MavenArtifactState.DUPLICATE);
                this.duplicated.get((Object)node).add(e);
                this.myEdges.add((DiagramEdge<MavenElement>)e);
            }
        }
    }

    private void addNodesRecursively(@NotNull MavenUmlNode root) {
        if (root == null) {
            MavenUmlDataModel.$$$reportNull$$$0(3);
        }
        ArrayList<Pair<MavenUmlNode, MavenElement>> duplicates = new ArrayList<Pair<MavenUmlNode, MavenElement>>();
        this.addNodesRecursively(root, duplicates);
        for (Pair<MavenUmlNode, MavenElement> duplicate : duplicates) {
            MavenUmlNode to = this.findOriginNode((MavenElement)duplicate.second);
            if (to == null) continue;
            this.myEdges.add((DiagramEdge<MavenElement>)new MavenUmlEdge((MavenUmlNode)((Object)duplicate.first), to));
        }
    }

    private void addNodesRecursively(@NotNull MavenUmlNode node, @NotNull List<Pair<MavenUmlNode, MavenElement>> duplicates) {
        if (node == null) {
            MavenUmlDataModel.$$$reportNull$$$0(4);
        }
        if (duplicates == null) {
            MavenUmlDataModel.$$$reportNull$$$0(5);
        }
        this.addNode(node);
        MavenElement mavenElement = node.getIdentifyingElement();
        MavenArtifactState state = mavenElement.getState();
        if (state == MavenArtifactState.CONFLICT) {
            this.conflicted.put(node, new ArrayList());
        } else if (state == MavenArtifactState.DUPLICATE) {
            this.duplicated.put(node, new ArrayList());
        }
        for (MavenElement child : mavenElement.getChildren()) {
            if (!MavenUmlDataModel.suite(child.getScope(), this.myVisibility)) continue;
            boolean addChildren = true;
            MavenUmlNode to = null;
            if (child.getState() == MavenArtifactState.DUPLICATE) {
                to = this.findOriginNode(child);
                if (to == null) {
                    duplicates.add((Pair<MavenUmlNode, MavenElement>)Pair.create((Object)((Object)node), (Object)child));
                    continue;
                }
                addChildren = false;
            }
            if (to == null) {
                if (this.isRootNodeElement(child)) {
                    to = this.myRoot;
                    addChildren = false;
                } else {
                    to = new MavenUmlNode(child);
                }
            }
            this.myEdges.add((DiagramEdge<MavenElement>)new MavenUmlEdge(node, to));
            if (!addChildren) continue;
            this.addNodesRecursively(to, duplicates);
        }
    }

    private void addNode(@NotNull MavenUmlNode node) {
        if (node == null) {
            MavenUmlDataModel.$$$reportNull$$$0(6);
        }
        this.myNodes.add((DiagramNode<MavenElement>)node);
        MavenArtifactNode mavenArtifactNode = node.getIdentifyingElement().getArtifact();
        if (mavenArtifactNode != null) {
            ContainerUtil.putIfNotNull((Object)mavenArtifactNode.getArtifact(), (Object)((Object)node), this.myArtifactsNodes);
        }
    }

    private boolean isRootNodeElement(MavenElement mavenElement) {
        MavenArtifactNode artifactNode = mavenElement.getArtifact();
        if (artifactNode == null) {
            return false;
        }
        MavenArtifact artifact = artifactNode.getArtifact();
        if (artifact == null) {
            return false;
        }
        String path = artifact.getFile().getPath();
        return VfsUtilCore.pathEqualsTo((VirtualFile)this.myElement.getMavenProject().getFile(), (String)path);
    }

    @Nullable
    private MavenUmlNode findOriginNode(MavenElement mavenElement) {
        MavenArtifactNode childArtifact = mavenElement.getArtifact();
        if (childArtifact == null) {
            return null;
        }
        MavenArtifact relatedArtifact = childArtifact.getRelatedArtifact();
        if (relatedArtifact == null) {
            return null;
        }
        return this.myArtifactsNodes.get(relatedArtifact);
    }

    private static boolean suite(MavenArtifactScope scope, VisibilityLevel visibility) {
        if (visibility == MavenUmlVisibilityManager.ALL || scope == null) {
            return true;
        }
        return switch (scope) {
            case MavenArtifactScope.COMPILE -> {
                if (visibility == MavenUmlVisibilityManager.COMPILE) {
                    yield true;
                }
                yield false;
            }
            case MavenArtifactScope.PROVIDED -> {
                if (visibility == MavenUmlVisibilityManager.PROVIDED) {
                    yield true;
                }
                yield false;
            }
            case MavenArtifactScope.RUNTIME -> {
                if (visibility == MavenUmlVisibilityManager.RUNTIME) {
                    yield true;
                }
                yield false;
            }
            case MavenArtifactScope.TEST -> {
                if (visibility == MavenUmlVisibilityManager.TEST) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @NotNull
    public Collection<DiagramNode<MavenElement>> getNodes() {
        ArrayList<DiagramNode<MavenElement>> arrayList = this.myNodes;
        if (arrayList == null) {
            MavenUmlDataModel.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    public Collection<DiagramEdge<MavenElement>> getEdges() {
        ArrayList<DiagramEdge<MavenElement>> arrayList = this.myEdges;
        if (arrayList == null) {
            MavenUmlDataModel.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    public String getNodeName(@NotNull DiagramNode<MavenElement> n) {
        if (n == null) {
            MavenUmlDataModel.$$$reportNull$$$0(9);
        }
        String string = ((MavenElement)n.getIdentifyingElement()).getName();
        if (string == null) {
            MavenUmlDataModel.$$$reportNull$$$0(10);
        }
        return string;
    }

    public DiagramNode<MavenElement> addElement(@Nullable MavenElement element) {
        MavenUmlNode node;
        if (element != null && !this.myNodes.contains((Object)(node = new MavenUmlNode(element)))) {
            this.addNode(node);
            return node;
        }
        return null;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        ModificationTracker modificationTracker = MavenProjectsManager.getInstance((Project)this.getProject()).getModificationTracker();
        if (modificationTracker == null) {
            MavenUmlDataModel.$$$reportNull$$$0(11);
        }
        return modificationTracker;
    }

    public void dispose() {
    }

    public MavenUmlNode getRoot() {
        return this.myRoot;
    }

    @Nullable
    public List<MavenUmlEdge> getConflictedEdgesForNode(MavenUmlNode node) {
        MavenUmlNode parent = (MavenUmlNode)((Object)node.getUserData(MavenUmlDataKeys.CONFLICTED_WITH));
        if (parent != null) {
            return this.conflicted.get((Object)parent);
        }
        return null;
    }

    @Nullable
    public List<MavenUmlEdge> getDuplicatedEdgesForNode(MavenUmlNode node) {
        MavenUmlNode parent = (MavenUmlNode)((Object)node.getUserData(MavenUmlDataKeys.DUPLICATED_WITH));
        if (parent != null) {
            return this.duplicated.get((Object)parent);
        }
        return null;
    }

    public void addConflicted(MavenUmlEdge edge) {
        this.myEdges.add((DiagramEdge<MavenElement>)edge);
    }

    public void addDuplicated(MavenUmlEdge edge) {
        this.myEdges.add((DiagramEdge<MavenElement>)edge);
    }

    public void removeAllExtraEdges() {
        for (List<MavenUmlEdge> edges : this.conflicted.values()) {
            this.myEdges.removeAll(edges);
        }
        for (List<MavenUmlEdge> edges : this.duplicated.values()) {
            this.myEdges.removeAll(edges);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7, 8, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/maven/MavenUmlDataModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicates";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/maven/MavenUmlDataModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateContentManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateContentManager";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeAllExceptPathsFromRootToNodes";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addNodesRecursively";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addNode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7, 8, 10, 11 -> new IllegalStateException(string);
        };
    }
}

