/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.ed.indexing;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.jpa.jpb.model.util.JavaPersistence;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.NanoXmlBuilder;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.n3.nanoxml.IXMLBuilder;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public abstract class EntityRegisterFileIndex
extends ScalarIndexExtension<String>
implements DataIndexer<String, Void, FileContent> {
    public static final Logger LOG = Logger.getInstance(EntityRegisterFileIndex.class);
    public static final String PERSISTENCE_XML_PREFIX = "P_";
    private static final String CLASS_TAG = "class";
    private final EnumeratorStringDescriptor keyDescriptor = new EnumeratorStringDescriptor();
    private final FileBasedIndex.InputFilter inputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{XmlFileType.INSTANCE});

    public static String getPersistenceKey(String entityFqn) {
        return PERSISTENCE_XML_PREFIX + entityFqn;
    }

    @NotNull
    public Map<String, Void> map(@NotNull FileContent inputData) {
        String text;
        List<String> entityKeys;
        if (inputData == null) {
            EntityRegisterFileIndex.$$$reportNull$$$0(0);
        }
        if ((entityKeys = this.searchEntityDefinitions(text = inputData.getContentAsText().toString())) == null) {
            Map<String, Void> map = Collections.emptyMap();
            if (map == null) {
                EntityRegisterFileIndex.$$$reportNull$$$0(1);
            }
            return map;
        }
        LOG.debug("Found entity registrations in " + inputData.getFileName());
        HashMap<String, Void> res = new HashMap<String, Void>();
        if (entityKeys.isEmpty()) {
            res.put("<key of empty entity registration config '" + String.valueOf(inputData.getFile()) + "'>", null);
        } else {
            for (String key : entityKeys) {
                res.put(key, null);
            }
        }
        HashMap<String, Void> hashMap = res;
        if (hashMap == null) {
            EntityRegisterFileIndex.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    protected List<String> searchEntityDefinitions(String text) {
        boolean isPersistence = StreamEx.of(JavaPersistence.PERSISTENCE_NAMESPACES).anyMatch(text::contains);
        if (!isPersistence) {
            return null;
        }
        ArrayList<String> keys = new ArrayList<String>(50);
        EntityFileKeyParser builder = new EntityFileKeyParser(keys);
        NanoXmlUtil.parse((Reader)CharArrayUtil.readerFromCharSequence((CharSequence)text), (IXMLBuilder)builder);
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        return StreamEx.of(keys).map(s -> PERSISTENCE_XML_PREFIX + s).toList();
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = this.inputFilter;
        if (inputFilter == null) {
            EntityRegisterFileIndex.$$$reportNull$$$0(3);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        EntityRegisterFileIndex entityRegisterFileIndex = this;
        if (entityRegisterFileIndex == null) {
            EntityRegisterFileIndex.$$$reportNull$$$0(4);
        }
        return entityRegisterFileIndex;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = this.keyDescriptor;
        if (enumeratorStringDescriptor == null) {
            EntityRegisterFileIndex.$$$reportNull$$$0(5);
        }
        return enumeratorStringDescriptor;
    }

    public int getVersion() {
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/backend/ed/indexing/EntityRegisterFileIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/backend/ed/indexing/EntityRegisterFileIndex";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    protected static class EntityFileKeyParser
    implements NanoXmlBuilder {
        private final List<String> keys;
        private boolean isEntity;

        public EntityFileKeyParser(List<String> keys) {
            this.keys = keys;
            this.isEntity = false;
        }

        public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) {
            if (EntityRegisterFileIndex.CLASS_TAG.equals(name)) {
                this.isEntity = true;
            }
        }

        public void endElement(String s, String s1, String s2) {
            this.isEntity = false;
        }

        public void addPCData(Reader reader, String systemID, int lineNr) throws Exception {
            if (this.isEntity) {
                String value = StreamUtil.readText((Reader)reader);
                this.keys.add(value);
            }
        }
    }
}

