/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.liquibase.ns;

import com.intellij.jpa.jpb.model.liquibase.ns.PhysicalNamingStrategy;
import com.intellij.jpa.jpb.model.model.DbIdentifierHelper;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class SpringPhysicalNamingStrategy
implements PhysicalNamingStrategy {
    public static final SpringPhysicalNamingStrategy INSTANCE = new SpringPhysicalNamingStrategy();

    @Override
    public String toCatalogName(String name) {
        return this.apply(name);
    }

    @Override
    public String toSchemaName(@Nullable String name) {
        return this.apply(name);
    }

    @Override
    public String toTableName(String name) {
        return this.apply(name);
    }

    @Override
    public String toSequenceName(String name) {
        return this.apply(name);
    }

    @Override
    public String toColumnName(String name) {
        return this.apply(name);
    }

    private String apply(@Nullable String name) {
        if (name == null) {
            return null;
        }
        String clearDbColumn = DbIdentifierHelper.trimEscapeQuotes(name, true);
        StringBuilder builder = new StringBuilder(clearDbColumn.replace('.', '_'));
        for (int i = 1; i < builder.length() - 1; ++i) {
            if (!this.isUnderscoreRequired(builder.charAt(i - 1), builder.charAt(i), builder.charAt(i + 1))) continue;
            builder.insert(i++, '_');
        }
        return this.getIdentifier(builder.toString());
    }

    protected String getIdentifier(String name) {
        name = name.toLowerCase(Locale.ROOT);
        return name;
    }

    private boolean isUnderscoreRequired(char before, char current, char after) {
        return Character.isLowerCase(before) && Character.isUpperCase(current) && Character.isLowerCase(after);
    }
}

