/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.model;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class Method {
    private String modifiers;
    private String type;
    private String name;
    private String[] signature;
    private String[] paramNames;
    private LinkedHashSet<String> annotations = new LinkedHashSet();

    public Method() {
    }

    public Method(Method other) {
        this.copyFrom(other);
    }

    public String getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(String modifiers) {
        this.modifiers = modifiers;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getSignature() {
        return this.signature;
    }

    public void setSignature(String[] signature) {
        this.signature = signature;
    }

    public LinkedHashSet<String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(LinkedHashSet<String> annotations) {
        this.annotations = annotations;
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public void setParamNames(String[] paramNames) {
        this.paramNames = paramNames;
    }

    @Nullable
    public String getAttrName() {
        if (!this.name.startsWith("get") && !this.name.startsWith("set") || this.name.length() == 3) {
            return null;
        }
        return this.name.substring(3, 4).toLowerCase() + (this.name.length() > 4 ? this.name.substring(4) : "");
    }

    public Method copyFrom(Method other) {
        this.setName(other.getName());
        this.setType(other.getType());
        this.setModifiers(other.getModifiers());
        this.setParamNames(other.getParamNames() != null ? (String[])other.getParamNames().clone() : null);
        this.setAnnotations(other.getAnnotations());
        this.setSignature(other.getSignature() != null ? (String[])other.getSignature().clone() : null);
        return this;
    }

    public String toString() {
        return this.modifiers + " " + this.type + ", name='" + this.name + ", signature=" + String.valueOf(this.signature == null ? null : Arrays.asList(this.signature)) + ", paramNames=" + String.valueOf(this.paramNames == null ? null : Arrays.asList(this.paramNames));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Method method = (Method)o;
        if (!Objects.equals(this.modifiers, method.modifiers)) {
            return false;
        }
        if (!Objects.equals(this.name, method.name)) {
            return false;
        }
        if (!Arrays.equals(this.paramNames, method.paramNames)) {
            return false;
        }
        if (!Objects.equals(this.annotations, method.annotations)) {
            return false;
        }
        if (!Arrays.equals(this.signature, method.signature)) {
            return false;
        }
        return Objects.equals(this.type, method.type);
    }

    public int hashCode() {
        int result = this.modifiers != null ? this.modifiers.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.signature != null ? Arrays.hashCode(this.signature) : 0);
        result = 31 * result + (this.paramNames != null ? Arrays.hashCode(this.paramNames) : 0);
        result = 31 * result + (this.annotations != null ? this.annotations.hashCode() : 0);
        return result;
    }
}

