/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.propertyform;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsSafe;
import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.collect.ArrayListModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import org.jetbrains.annotations.Nullable;

public class FormComboBox<T>
extends ComboBox<T> {
    private ArrayListModel<T> listModel;
    @Nullable
    private Runnable triggerCommit;

    public FormComboBox(List<T> options, ValueModel valueModel) {
        this.listModel = new ArrayListModel(options);
        ComboBoxAdapter model2 = new ComboBoxAdapter(this.listModel, valueModel);
        this.setModel((ComboBoxModel)model2);
    }

    public FormComboBox(List<T> options, ValueModel valueModel, ValueModel triggerChannel, Runnable triggerCommit) {
        this.listModel = new ArrayListModel(options);
        this.triggerCommit = triggerCommit;
        BufferedValueModel bufferedModel = new BufferedValueModel(valueModel, triggerChannel);
        ComboBoxAdapter model2 = new ComboBoxAdapter(this.listModel, (ValueModel)bufferedModel);
        this.setModel((ComboBoxModel)model2);
        this.addItemListener(e -> triggerCommit.run());
    }

    @NlsSafe
    public T getSelectedItem() {
        return (T)this.dataModel.getSelectedItem();
    }

    public void addElement(T element) {
        if (!this.listModel.contains(element)) {
            this.listModel.add(element);
        }
    }

    public void addElement(int index, T element) {
        if (!this.listModel.contains(element)) {
            this.listModel.add(index, element);
        }
    }

    public void addAll(Collection<T> c) {
        c.forEach(this::addElement);
    }

    public boolean removeElement(T element) {
        return this.listModel.remove(element);
    }

    public void removeAllElements() {
        this.listModel.clear();
    }

    public boolean retainAll(Collection<T> c) {
        return this.listModel.retainAll(c);
    }

    public boolean containsElement(T element) {
        return this.listModel.contains(element);
    }

    public List<T> getElements() {
        return new ArrayList<T>(this.listModel);
    }

    public boolean selectWithKeyChar(char keyChar) {
        boolean selected = super.selectWithKeyChar(keyChar);
        if (selected && this.triggerCommit != null) {
            this.triggerCommit.run();
        }
        return selected;
    }
}

