/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.validation.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.intellij.lang.xpath.XPathFileType;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.psi.XsltElementFactory;
import org.intellij.lang.xpath.xslt.psi.XsltNamedElement;
import org.intellij.lang.xpath.xslt.psi.XsltTemplate;
import org.intellij.lang.xpath.xslt.validation.DeclarationChecker;
import org.intellij.lang.xpath.xslt.validation.inspections.XsltInspection;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;

public final class XsltDeclarationInspection
extends XsltInspection {
    private XsltElementFactory myXsltElementFactory;

    @NotNull
    public String getShortName() {
        return "XsltDeclarations";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            XsltDeclarationInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            XsltDeclarationInspection.$$$reportNull$$$0(1);
        }
        if (!(holder.getFile() instanceof XmlFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                XsltDeclarationInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        return new XmlElementVisitor(){

            public void visitXmlTag(@NotNull XmlTag tag) {
                XmlAttribute nameAttr;
                if (tag == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((nameAttr = tag.getAttribute("name", null)) == null || PsiTreeUtil.hasErrorElements((PsiElement)nameAttr)) {
                    return;
                }
                if (XsltSupport.isVariableOrParam(tag)) {
                    XsltNamedElement instance = XsltDeclarationInspection.this.getXsltElementFactory().wrapElement(tag, XsltNamedElement.class);
                    this.checkDeclaration(instance, nameAttr.getValue(), holder);
                } else if (XsltSupport.isTemplate(tag)) {
                    XsltTemplate tmpl = XsltDeclarationInspection.this.getXsltElementFactory().wrapElement(tag, XsltTemplate.class);
                    this.checkDeclaration(tmpl, nameAttr.getValue(), holder);
                }
            }

            private void checkDeclaration(XsltNamedElement element, String name, ProblemsHolder holder2) {
                XmlTag tag = element.getTag();
                PsiElement token = element.getNameIdentifier();
                if (name == null || name.isEmpty()) {
                    if (token != null) {
                        holder2.registerProblem(token, XPathBundle.message("inspection.message.empty.name.not.permitted", new Object[0]), new LocalQuickFix[0]);
                    } else {
                        XmlAttributeValue e;
                        XmlAttribute attribute = element.getNameAttribute();
                        if (attribute != null && (e = attribute.getValueElement()) != null) {
                            holder2.registerProblem((PsiElement)e, XPathBundle.message("inspection.message.empty.name.not.permitted", new Object[0]), new LocalQuickFix[0]);
                        }
                    }
                } else if (!1.isLegalName(name, holder2.getManager().getProject())) {
                    assert (token != null);
                    holder2.registerProblem(token, XPathBundle.message("inspection.message.illegal.name", new Object[0]), new LocalQuickFix[0]);
                } else {
                    assert (token != null);
                    XmlFile file = (XmlFile)tag.getContainingFile();
                    XmlTag duplicatedSymbol = DeclarationChecker.getInstance(file).getDuplicatedSymbol(tag);
                    if (duplicatedSymbol != null) {
                        if (duplicatedSymbol.getContainingFile() == file) {
                            holder2.registerProblem(token, XPathBundle.message("inspection.message.duplicate.declaration", new Object[0]), new LocalQuickFix[0]);
                        } else {
                            holder2.registerProblem(token, XPathBundle.message("inspection.message.duplicates.declaration.from", duplicatedSymbol.getContainingFile().getName()), new LocalQuickFix[0]);
                        }
                    }
                }
            }

            private static boolean isLegalName(String value, Project project) {
                return LanguageNamesValidation.isIdentifier((Language)XPathFileType.XPATH.getLanguage(), (String)value, (Project)project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/intellij/lang/xpath/xslt/validation/inspections/XsltDeclarationInspection$1", "visitXmlTag"));
            }
        };
    }

    public XsltElementFactory getXsltElementFactory() {
        if (this.myXsltElementFactory == null) {
            this.myXsltElementFactory = XsltElementFactory.getInstance();
        }
        return this.myXsltElementFactory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/validation/inspections/XsltDeclarationInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/validation/inspections/XsltDeclarationInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

