/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Sets;

public final class FieldLocation
implements Comparable<FieldLocation> {
    public static final String FIELD_SEPARATOR = ".";
    private final String pathToUseInRules;
    private final List<String> decomposedPath;
    private final Set<String> pathsHierarchyToUseInRules;

    public FieldLocation(List<String> path) {
        this.decomposedPath = Collections.unmodifiableList(Objects.requireNonNull(path, "path cannot be null"));
        this.pathToUseInRules = FieldLocation.pathToUseInRules(this.decomposedPath);
        this.pathsHierarchyToUseInRules = this.pathsHierarchyToUseInRules();
    }

    public FieldLocation(String s) {
        this(Lists.list(s.split("\\.")));
    }

    @Override
    public int compareTo(FieldLocation other) {
        return this.pathToUseInRules.compareTo(other.pathToUseInRules);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FieldLocation)) {
            return false;
        }
        FieldLocation that = (FieldLocation)obj;
        return Objects.equals(this.pathToUseInRules, that.pathToUseInRules) && Objects.equals(this.decomposedPath, that.decomposedPath) && Objects.equals(this.pathsHierarchyToUseInRules, that.pathsHierarchyToUseInRules);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.pathToUseInRules);
        result = 31 * result + Objects.hashCode(this.decomposedPath);
        result = 31 * result + Objects.hashCode(this.pathsHierarchyToUseInRules);
        return result;
    }

    public String toString() {
        return "<%s>".formatted(this.pathToUseInRules);
    }

    public String shortDescription() {
        return this.pathToUseInRules;
    }

    private static String pathToUseInRules(List<String> path) {
        return path.stream().filter(subpath -> !subpath.startsWith("[")).collect(Collectors.joining(FIELD_SEPARATOR));
    }

    public boolean exactlyMatches(FieldLocation field) {
        return this.exactlyMatches(field.pathToUseInRules);
    }

    public boolean exactlyMatches(String fieldPath) {
        return this.pathToUseInRules.equals(fieldPath);
    }

    @Deprecated(since="3", forRemoval=true)
    public boolean matches(String fieldPath) {
        return this.exactlyMatches(fieldPath);
    }

    @Deprecated(since="3", forRemoval=true)
    public boolean matches(FieldLocation field) {
        return this.exactlyMatches(field);
    }

    public boolean hierarchyMatches(String fieldPath) {
        return this.pathsHierarchyToUseInRules.contains(fieldPath);
    }

    public boolean hierarchyMatchesRegex(Pattern regex) {
        return this.pathsHierarchyToUseInRules.stream().anyMatch(path -> regex.matcher((CharSequence)path).matches());
    }

    public List<String> getDecomposedPath() {
        return this.decomposedPath;
    }

    public String getPathToUseInRules() {
        return this.pathToUseInRules;
    }

    public String getPathToUseInRulesForChildField(String fieldName) {
        return this.pathToUseInRules.isEmpty() ? fieldName : this.pathToUseInRules + FIELD_SEPARATOR + fieldName;
    }

    public FieldLocation field(String field) {
        ArrayList<String> decomposedPathWithField = new ArrayList<String>(this.decomposedPath);
        decomposedPathWithField.add(field);
        return new FieldLocation(decomposedPathWithField);
    }

    public String getPathToUseInErrorReport() {
        return String.join((CharSequence)FIELD_SEPARATOR, this.decomposedPath);
    }

    public String getFieldName() {
        if (this.decomposedPath.isEmpty()) {
            return "";
        }
        return this.decomposedPath.get(this.decomposedPath.size() - 1);
    }

    public boolean isRoot() {
        return this.isRootPath(this.pathToUseInRules);
    }

    private boolean isRootPath(String pathToUseInRules) {
        return pathToUseInRules.isEmpty();
    }

    public boolean isTopLevelField() {
        return !this.isRoot() && !this.pathToUseInRules.contains(FIELD_SEPARATOR);
    }

    public static FieldLocation rootFieldLocation() {
        return new FieldLocation(Collections.emptyList());
    }

    public boolean hasParent(FieldLocation parent) {
        return this.pathToUseInRules.startsWith(parent.pathToUseInRules + FIELD_SEPARATOR);
    }

    public boolean hasChild(FieldLocation child) {
        return child.hasParent(this);
    }

    private Set<String> pathsHierarchyToUseInRules() {
        LinkedHashSet fieldAndParentFields = Sets.newLinkedHashSet();
        String currentPath = this.pathToUseInRules;
        while (!this.isRootPath(currentPath)) {
            fieldAndParentFields.add(currentPath);
            currentPath = this.parent(currentPath);
        }
        return Collections.unmodifiableSet(fieldAndParentFields);
    }

    private String parent(String currentPath) {
        int lastDot = currentPath.lastIndexOf(FIELD_SEPARATOR);
        if (lastDot < 0) {
            return "";
        }
        return currentPath.substring(0, lastDot);
    }
}

