/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.config.anno;

import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.CommonServletMapping;
import com.intellij.javaee.web.WebModelContributor;
import com.intellij.openapi.module.Module;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.mvc.config.anno.AnnotationConfigSpringWebModelContributor;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SpringMvcPsiBasedServletWebModelContributor
extends WebModelContributor {
    private static final Function<CommonServlet, CommonServletMapping<CommonServlet>> SERVLET_MAPPING_FUNCTION = servlet -> {
        if (!(servlet instanceof CommonServletMapping)) {
            return null;
        }
        return (CommonServletMapping)servlet;
    };

    public List<CommonServlet> getServlets(Module module) {
        if (!SpringCommonUtils.isSpringConfigured((Module)module)) {
            return Collections.emptyList();
        }
        if (!SpringMvcLibraryUtil.hasSpringMvcLibrary(module)) {
            return Collections.emptyList();
        }
        return AnnotationConfigSpringWebModelContributor.getCustomInitializers(module).stream().map(aClass -> AnnotationConfigSpringWebModelContributor.getServlet(aClass, module)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<CommonServletMapping<CommonServlet>> getServletMappings(Module module) {
        return ContainerUtil.mapNotNull(this.getServlets(module), SERVLET_MAPPING_FUNCTION);
    }
}

