/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.oas.swagger;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.icons.AllIcons;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.microservices.oas.OasExportUtilsKt;
import com.intellij.microservices.oas.OpenApiSpecification;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.inlay.UrlPathInlayAction;
import com.intellij.microservices.url.inlay.UrlPathInlayHint;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.utils.MicroservicesUsageCollector;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.mvc.SpringMvcBundle;
import com.intellij.spring.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.mvc.model.SpringMvcUrlTargetInfo;
import com.intellij.spring.mvc.model.jam.RequestMapping;
import com.intellij.spring.mvc.model.mappings.UrlMappingPsiBasedElement;
import com.intellij.spring.mvc.oas.SpringMvcOasConverters;
import com.intellij.spring.mvc.utils.SpringMvcUrlUtils;
import com.intellij.swagger.core.synthetic.OasSerializationUtilsKt;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J6\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001bH\u0002J\u001a\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010%\u001a\u0004\u0018\u00010\t2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\u0018\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\tH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006)"}, d2={"Lcom/intellij/spring/mvc/oas/swagger/SpringMVCGenerateOASUrlInlayAction;", "Lcom/intellij/microservices/url/inlay/UrlPathInlayAction;", "<init>", "()V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "name", "", "getName", "()Ljava/lang/String;", "isAvailable", "", "file", "Lcom/intellij/psi/PsiFile;", "urlPathInlayHint", "Lcom/intellij/microservices/url/inlay/UrlPathInlayHint;", "actionPerformed", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "urlPathContext", "Lcom/intellij/microservices/url/references/UrlPathContext;", "mouseEvent", "Ljava/awt/event/MouseEvent;", "getOpenApiSpecification", "", "Lcom/intellij/microservices/oas/OpenApiSpecification;", "uMethod", "Lorg/jetbrains/uast/UMethod;", "uClass", "Lorg/jetbrains/uast/UClass;", "authorities", "Lcom/intellij/microservices/url/Authority;", "getMappingElement", "Lorg/jetbrains/uast/UElement;", "getControllerPath", "joinPaths", "controllerPath", "endpointPath", "intellij.spring.mvc.impl"})
@SourceDebugExtension(value={"SMAP\nSpringMVCGenerateOASUrlInlayAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringMVCGenerateOASUrlInlayAction.kt\ncom/intellij/spring/mvc/oas/swagger/SpringMVCGenerateOASUrlInlayAction\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n11561#2:112\n11896#2,3:113\n1617#3,9:116\n1869#3:125\n1870#3:127\n1626#3:128\n1617#3,9:130\n1869#3:139\n1870#3:141\n1626#3:142\n1#4:126\n1#4:129\n1#4:140\n1#4:143\n*S KotlinDebug\n*F\n+ 1 SpringMVCGenerateOASUrlInlayAction.kt\ncom/intellij/spring/mvc/oas/swagger/SpringMVCGenerateOASUrlInlayAction\n*L\n65#1:112\n65#1:113,3\n80#1:116,9\n80#1:125\n80#1:127\n80#1:128\n82#1:130,9\n82#1:139\n82#1:141\n82#1:142\n80#1:126\n82#1:140\n*E\n"})
public final class SpringMVCGenerateOASUrlInlayAction
implements UrlPathInlayAction {
    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Webreferences.Openapi;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Openapi");
        return icon;
    }

    @NotNull
    public String getName() {
        String string = SpringMvcBundle.message("action.export.openapi.draft", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull PsiFile file, @NotNull UrlPathInlayHint urlPathInlayHint) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)urlPathInlayHint, (String)"urlPathInlayHint");
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)file);
        if (module == null) {
            return false;
        }
        Module module2 = module;
        if (!SpringMvcLibraryUtil.hasSpringMvcLibrary(module2) && !SpringMvcLibraryUtil.hasWebfluxLibrary(module2)) {
            return false;
        }
        SmartPsiElementPointer smartPsiElementPointer = urlPathInlayHint.getAttachedTo();
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)(smartPsiElementPointer != null ? smartPsiElementPointer.getElement() : null), PsiClass.class);
        if (psiClass == null) {
            return false;
        }
        PsiClass psiClass2 = psiClass;
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiClass2), (String)"org.springframework.stereotype.Controller", (int)0) || MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiClass2), (Collection)CollectionsKt.listOf((Object)"org.springframework.stereotype.Controller"));
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull PsiFile file, @NotNull Editor editor, @NotNull UrlPathContext urlPathContext, @NotNull MouseEvent mouseEvent) {
        List list;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)urlPathContext, (String)"urlPathContext");
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)file);
        if (module == null) {
            return;
        }
        Module module2 = module;
        MicroservicesUsageCollector.INSTANCE.getURL_INLAY_ACTION_TRIGGERED_EVENT().log(module2.getProject(), (Object)"generate_openapi");
        List<Authority> authorities = SpringMvcUrlUtils.getAuthoritiesByModule(module2);
        UElement mappingUElement = this.getMappingElement(file, editor);
        if (mappingUElement instanceof UMethod) {
            list = this.getOpenApiSpecification((UMethod)mappingUElement, null, urlPathContext, authorities);
        } else if (mappingUElement instanceof UClass) {
            void $this$mapTo$iv$iv;
            UMethod[] $this$map$iv = ((UClass)mappingUElement).getMethods();
            boolean $i$f$map = false;
            UMethod[] uMethodArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var17_16 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.getOpenApiSpecification((UMethod)it, (UClass)mappingUElement, urlPathContext, authorities));
            }
            list = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        } else {
            return;
        }
        List openApiSpecifications = list;
        OpenApiSpecification openApiSpecification = OasExportUtilsKt.squashOpenApiSpecifications(openApiSpecifications);
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        OasSerializationUtilsKt.exportOasDraft((OpenApiSpecification)openApiSpecification, (Project)project);
    }

    /*
     * WARNING - void declaration
     */
    private final List<OpenApiSpecification> getOpenApiSpecification(UMethod uMethod, UClass uClass, UrlPathContext urlPathContext, List<? extends Authority> authorities) {
        void $this$mapNotNullTo$iv$iv;
        Iterable mappingUrls;
        void $this$mapNotNullTo$iv$iv2;
        String string;
        UClass uClass2 = uClass;
        if (uClass2 == null) {
            uClass2 = UastUtils.getContainingUClass((UElement)((UElement)uMethod));
        }
        if ((string = this.getControllerPath(uClass2)) == null) {
            string = "";
        }
        String controllerPath = string;
        RequestMapping.Method method = SpringMvcOasConverters.getMethodMapping(uMethod);
        if (method == null) {
            return CollectionsKt.emptyList();
        }
        RequestMapping.Method requestMapping = method;
        List<JamStringAttributeElement<String>> list = requestMapping.getMappingUrls();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getMappingUrls(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            JamStringAttributeElement it = (JamStringAttributeElement)element$iv$iv;
            boolean bl2 = false;
            if (it.getStringValue() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable it = $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean bl = false;
        Iterable iterable2 = !((Collection)it).isEmpty() ? $this$mapNotNull$iv : null;
        if (iterable2 == null) {
            iterable2 = CollectionsKt.listOf((Object)"");
        }
        Iterable $this$mapNotNull$iv2 = mappingUrls = iterable2;
        boolean $i$f$mapNotNull2 = false;
        it = $this$mapNotNull$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            OpenApiSpecification it$iv$iv;
            SpringMvcUrlTargetInfo urlTargetInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl4 = false;
            String endpointPath = (String)element$iv$iv;
            boolean bl5 = false;
            String fullPath = this.joinPaths(controllerPath, endpointPath);
            UrlMappingPsiBasedElement urlMappingElement = new UrlMappingPsiBasedElement(fullPath, (PsiElement)uMethod.getJavaPsi(), null, fullPath, requestMapping.getMethods());
            if (SpringMvcOasConverters.getMvcOpenApiSpecification(urlMappingElement, (UrlTargetInfo)(urlTargetInfo = new SpringMvcUrlTargetInfo(urlPathContext.getSchemes(), urlMappingElement, authorities))) == null) continue;
            boolean bl6 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    private final UElement getMappingElement(PsiFile file, Editor editor) {
        PsiElement psiElement = file.findElementAt(editor.getCaretModel().getOffset());
        if (psiElement == null) {
            return null;
        }
        PsiElement psiElement2 = psiElement;
        Class[] classArray = new Class[]{UMethod.class, UClass.class};
        return UastContextKt.getUastParentOfTypes$default((PsiElement)psiElement2, (Class[])classArray, (boolean)false, (int)2, null);
    }

    private final String getControllerPath(UClass uClass) {
        String string;
        block4: {
            UClass uClass2 = uClass;
            if (uClass2 == null || (uClass2 = uClass2.getJavaPsi()) == null) {
                return null;
            }
            UClass psiClass = uClass2;
            JamService jamService = JamService.getJamService((Project)psiClass.getProject());
            RequestMapping classRequestMapping = (RequestMapping)jamService.getJamElement(RequestMapping.CLASS_JAM_KEY, (PsiElement)psiClass);
            Object object = classRequestMapping;
            if (object != null && (object = object.getMappingUrls()) != null) {
                for (JamStringAttributeElement it : (Iterable)object) {
                    boolean bl = false;
                    String string2 = it.getStringValue();
                    if (string2 == null) continue;
                    string = string2;
                    break block4;
                }
                string = null;
            } else {
                string = null;
            }
        }
        return string;
    }

    private final String joinPaths(String controllerPath, String endpointPath) {
        char[] cArray = new char[]{'/'};
        String controller = StringsKt.trimEnd((String)controllerPath, (char[])cArray);
        char[] cArray2 = new char[]{'/'};
        String endpoint = StringsKt.trimStart((String)endpointPath, (char[])cArray2);
        String path = controller + "/" + endpoint;
        char[] cArray3 = new char[]{'/'};
        return StringsKt.trim((String)path, (char[])cArray3);
    }
}

