/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.introspection.IntrospectionScopes;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SmartPredicate;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternSubdivision;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.ints.IntList;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreePatternUtils {
    private static final List<List<String>> ESCAPES = Arrays.asList(Arrays.asList("\\", ":", ",", "|"), Arrays.asList("\\\\", "\\:", "\\,", "\\|"));
    public static final GroupedGroupFactory UNION_PROCESSOR = new GroupedGroupFactory(){

        @Override
        protected boolean checkGroup(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> value) {
            if (value == null) {
                1.$$$reportNull$$$0(0);
            }
            return true;
        }

        @Override
        protected boolean willDestroyEmpty(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode> groups) {
            return !1.containsNotNull(groups);
        }

        @Override
        protected boolean checkNode(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode> value) {
            if (value == null) {
                1.$$$reportNull$$$0(1);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/util/TreePatternUtils$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkNode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final GroupedGroupFactory INTERSECTION_PROCESSOR = new GroupedGroupFactory(){

        @Override
        protected boolean checkGroup(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> value) {
            if (value == null) {
                2.$$$reportNull$$$0(0);
            }
            return !2.containsNull(value);
        }

        @Override
        protected boolean willDestroyEmpty(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode> groups) {
            return 2.containsNull(groups);
        }

        @Override
        protected boolean checkNode(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode> value) {
            if (value == null) {
                2.$$$reportNull$$$0(1);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/util/TreePatternUtils$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkNode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final GroupedGroupFactory MINUS_PROCESSOR = new GroupedGroupFactory(){

        @Override
        @Nullable
        public TreePatternNode.Group[] mergeRoots(@NotNull Iterable<TreePatternNode> nodes) {
            if (nodes == null) {
                3.$$$reportNull$$$0(0);
            }
            JBIterable ji = JBIterable.from(nodes);
            return super.mergeRoots((Iterable<TreePatternNode>)ji.take(1).append((Iterable)ji.skip(1).filter(n -> n.groups.length != 0)));
        }

        @Override
        protected boolean checkNode(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode> value) {
            Iterator<TreePatternNode> it;
            if (value == null) {
                3.$$$reportNull$$$0(1);
            }
            if (!(it = value.iterator()).hasNext()) {
                return false;
            }
            TreePatternNode first2 = it.next();
            if (first2 == null) {
                return false;
            }
            while (it.hasNext()) {
                TreePatternNode n = it.next();
                if (n == null || first2.groups.length != 0) continue;
                return false;
            }
            return true;
        }

        @Override
        protected boolean checkGroup(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> value) {
            Iterator<TreePatternNode.Group> it;
            if (value == null) {
                3.$$$reportNull$$$0(2);
            }
            return (it = value.iterator()).hasNext() && it.next() != null;
        }

        @Override
        protected boolean willDestroyEmpty(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode> groups) {
            for (TreePatternNode group : groups) {
                if (group == null || group.groups.length != 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean mergeChildren() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/util/TreePatternUtils$3";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mergeRoots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkGroup";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final TreePatternNode.Group SKIP_PROCESSING = new TreePatternNode.Group(ObjectKind.NONE, null);

    public static String escape(String s) {
        return StringUtil.replace((String)s, ESCAPES.get(0), ESCAPES.get(1));
    }

    private static String unescape(String s) {
        return StringUtil.replace((String)s, ESCAPES.get(1), ESCAPES.get(0));
    }

    public static TreePattern parse(@NotNull Dbms dbms, String s) {
        if (dbms == null) {
            TreePatternUtils.$$$reportNull$$$0(0);
        }
        MultiMap<String, String> state = TreePatternUtils.parseToState(s);
        return TreePatternUtils.fromScopeMap(DbImplUtilCore.getMetaModel(dbms), state);
    }

    public static TreePattern parse(boolean multiDatabase, String s) {
        MultiMap<String, String> state = TreePatternUtils.parseToState(s);
        return TreePatternUtils.fromScopeMap(multiDatabase, state);
    }

    @NotNull
    private static MultiMap<String, String> parseToState(String s) {
        ArrayList<String> dbs = new ArrayList<String>();
        ArrayList schs = new ArrayList();
        int dbPos = s.length();
        while (dbPos > 0) {
            int dbEnd2;
            int curDbPos = TreePatternUtils.lastIndexOf(s, '|', dbPos - 1) + 1;
            int dbEnd = TreePatternUtils.lastIndexOf(s, ':', dbPos - 1, curDbPos);
            int n = dbEnd2 = dbEnd == -1 ? -1 : TreePatternUtils.lastIndexOf(s, ':', dbEnd - 1, curDbPos);
            if (dbEnd != -1 && dbEnd2 == -1) {
                dbs.add(TreePatternUtils.unescape(s.substring(curDbPos, dbEnd)));
                LinkedHashSet<String> ss = new LinkedHashSet<String>();
                schs.add(ss);
                int schPos = dbPos;
                while (schPos > 0) {
                    int curSchPos = TreePatternUtils.lastIndexOf(s, ',', schPos - 1, dbEnd);
                    String sch = TreePatternUtils.unescape(s.substring(Math.max(dbEnd, curSchPos) + 1, schPos));
                    if (!sch.isEmpty()) {
                        ss.add(sch);
                    }
                    schPos = curSchPos;
                }
            }
            dbPos = curDbPos - 1;
        }
        MultiMap state = MultiMap.create();
        for (int i2 = dbs.size() - 1; i2 >= 0; --i2) {
            state.putValues((Object)((String)dbs.get(i2)), (Collection)schs.get(i2));
        }
        MultiMap multiMap = state;
        if (multiMap == null) {
            TreePatternUtils.$$$reportNull$$$0(1);
        }
        return multiMap;
    }

    public static String serialize(TreePattern scope) {
        StringBuilder res = new StringBuilder();
        TreePatternNode.Group dbG = scope.root.getGroup(ObjectKind.DATABASE);
        if (dbG == null) {
            if (!TreePatternUtils.serializeSchemas(res, scope.root, (JBIterable<String>)JBIterable.of((Object)"*"))) {
                return "";
            }
        } else if (dbG.children != null) {
            for (TreePatternNode child : dbG.children) {
                TreePatternUtils.serializeSchemas(res, child, TreePatternUtils.serializeNamings(child));
            }
        }
        return res.toString();
    }

    private static boolean serializeSchemas(StringBuilder res, TreePatternNode child, JBIterable<@NotNull String> dbs) {
        String scs = TreePatternUtils.serializeSchemas(child);
        for (String db : dbs) {
            if (!res.isEmpty()) {
                res.append('|');
            }
            res.append(TreePatternUtils.escape(db)).append(':').append(scs);
        }
        return !scs.isEmpty();
    }

    @NotNull
    private static String serializeSchemas(TreePatternNode child) {
        StringBuilder res = new StringBuilder();
        int start2 = res.length();
        for (TreePatternNode.Group group : child.groups) {
            TreePatternUtils.serializeSchemaNames(group, group.kind == ObjectKind.SCHEMA ? null : group.kind.code(), res, start2);
        }
        String string = res.toString();
        if (string == null) {
            TreePatternUtils.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static void serializeSchemaNames(@NotNull TreePatternNode.Group scG, @Nullable String kind, StringBuilder res, int start2) {
        if (scG == null) {
            TreePatternUtils.$$$reportNull$$$0(3);
        }
        for (Object sch : JBIterable.of((Object[])scG.children).flatten(n -> TreePatternUtils.serializeNamings(n))) {
            if (res.length() != start2) {
                res.append(',');
            }
            if (kind != null) {
                sch = (String)sch + "[" + kind + "]";
            }
            res.append(TreePatternUtils.escape((String)sch));
        }
    }

    @NotNull
    private static @NotNull JBIterable<@NotNull String> serializeNamings(TreePatternNode n) {
        if (n.naming instanceof TreePatternNode.NegativeNaming) {
            JBIterable patterns = SmartPredicate.extractPositiveChecks(((TreePatternNode.NegativeNaming)n.naming).pattern).collect();
            if (patterns.isEmpty()) {
                JBIterable jBIterable = JBIterable.of((Object)"*");
                if (jBIterable == null) {
                    TreePatternUtils.$$$reportNull$$$0(4);
                }
                return jBIterable;
            }
            JBIterable jBIterable = patterns.map(p -> "{" + p.getText() + "}");
            if (jBIterable == null) {
                TreePatternUtils.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object[])n.naming.names).map(ObjectName::name);
        if (jBIterable == null) {
            TreePatternUtils.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    public static int lastIndexOf(String s, char c2, int from) {
        return TreePatternUtils.lastIndexOf(s, c2, from, 0);
    }

    private static int lastIndexOf(String s, char c2, int from, int to) {
        while (from >= to) {
            char cur = s.charAt(from);
            --from;
            if (cur != c2) continue;
            int pos = from + 1;
            int slashes = 0;
            while (from >= to && (cur = s.charAt(from)) == '\\') {
                ++slashes;
                --from;
            }
            if (slashes % 2 != 0) continue;
            return pos;
        }
        return -1;
    }

    @NotNull
    public static Couple<Integer> countNamespaces(@NotNull BasicNamespaceOwner namespaceOwner, @NotNull TreePattern scope) {
        if (namespaceOwner == null) {
            TreePatternUtils.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            TreePatternUtils.$$$reportNull$$$0(8);
        }
        int m = 0;
        int n = 0;
        for (BasicNamespace namespace : namespaceOwner.getNamespaces()) {
            boolean shown = DataSourceSchemaMapping.matches(scope, namespace);
            if (shown) {
                ++m;
            }
            ++n;
        }
        Couple couple = Couple.of((Object)m, (Object)n);
        if (couple == null) {
            TreePatternUtils.$$$reportNull$$$0(9);
        }
        return couple;
    }

    @Nullable
    public static TreePatternNode findNegativeChild(@Nullable TreePatternNode.Group cg) {
        return cg == null || cg.children == null ? null : (TreePatternNode)ContainerUtil.find((Object[])cg.children, c2 -> c2.naming instanceof TreePatternNode.NegativeNaming);
    }

    @Nullable
    public static TreePatternNode findPositiveChild(@Nullable TreePatternNode.Group cg) {
        return cg == null || cg.children == null ? null : (TreePatternNode)ContainerUtil.find((Object[])cg.children, c2 -> c2.naming instanceof TreePatternNode.PositiveNaming);
    }

    @NotNull
    public static String[] toStringArray(@NotNull Collection<String> names) {
        if (names == null) {
            TreePatternUtils.$$$reportNull$$$0(10);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(names);
        if (stringArray == null) {
            TreePatternUtils.$$$reportNull$$$0(11);
        }
        return stringArray;
    }

    @NotNull
    public static String[] toStringArray(@NotNull Iterable<String> names) {
        if (names == null) {
            TreePatternUtils.$$$reportNull$$$0(12);
        }
        List list = ContainerUtil.collect(names.iterator());
        return TreePatternUtils.toStringArray(list);
    }

    @NotNull
    public static JBIterable<ObjectName> getAllNames(@NotNull TreePatternNode.Group g) {
        if (g == null) {
            TreePatternUtils.$$$reportNull$$$0(13);
        }
        JBIterable jBIterable = JBIterable.of((Object[])g.children).flatten(c2 -> JBIterable.of((Object[])c2.naming.names));
        if (jBIterable == null) {
            TreePatternUtils.$$$reportNull$$$0(14);
        }
        return jBIterable;
    }

    public static void subdivideChildren(@NotNull Iterable<TreePatternNode.Group> groups, @NotNull MultiMap<TreePatternNode.BaseNaming, TreePatternNode> subdiv) {
        if (groups == null) {
            TreePatternUtils.$$$reportNull$$$0(15);
        }
        if (subdiv == null) {
            TreePatternUtils.$$$reportNull$$$0(16);
        }
        TreePatternSubdivision.Subdivision<Pair<Integer, TreePatternNode>> subdivision = TreePatternSubdivision.generateSubdivision(groups);
        for (Pair<TreePatternNode.BaseNaming, IntList> datum : subdivision.data) {
            Collection nodes = subdiv.getModifiable((Object)((TreePatternNode.BaseNaming)datum.first));
            HashSet usedGroups = new HashSet();
            ((IntList)datum.second).forEach(id -> {
                if (subdivision.isCovered(id)) {
                    usedGroups.add((Integer)((Pair)subdivision.getLayer((int)id)).first);
                }
            });
            ((IntList)datum.second).forEach(id -> {
                Pair layer = (Pair)subdivision.getLayer(id);
                if (subdivision.isCovered(id)) {
                    nodes.add((TreePatternNode)layer.second);
                } else if (layer == null || usedGroups.add((Integer)layer.first)) {
                    nodes.add(null);
                }
            });
        }
    }

    @Nullable
    private static TreePatternNode.Group processGrouped(@NotNull ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> groups, @NotNull GroupedGroupFactory fac) {
        if (kind == null) {
            TreePatternUtils.$$$reportNull$$$0(17);
        }
        if (groups == null) {
            TreePatternUtils.$$$reportNull$$$0(18);
        }
        if (fac == null) {
            TreePatternUtils.$$$reportNull$$$0(19);
        }
        LinkedHashSet grouped = fac.mergeChildren() ? ContainerUtil.newLinkedHashSet(groups) : groups;
        MultiMap children = fac.mergeChildren() ? MultiMap.createLinkedSet() : MultiMap.createLinked();
        TreePatternUtils.subdivideChildren(grouped, (MultiMap<TreePatternNode.BaseNaming, TreePatternNode>)children);
        return fac.create((MultiMap<TreePatternNode.BaseNaming, TreePatternNode>)children, kind);
    }

    public static boolean isValid(TreePatternNode node) {
        HashSet<ObjectKind> kinds = new HashSet<ObjectKind>();
        for (TreePatternNode.Group group : node.groups) {
            if (kinds.add(group.kind)) continue;
            return false;
        }
        return true;
    }

    public static StringBuilder print(@NotNull StringBuilder builder, @NotNull TreePatternNode.Group group, int depth) {
        if (builder == null) {
            TreePatternUtils.$$$reportNull$$$0(20);
        }
        if (group == null) {
            TreePatternUtils.$$$reportNull$$$0(21);
        }
        builder.append(StringUtil.repeat((String)"  ", (int)depth)).append("kind: ");
        builder.append(group.kind).append("\n");
        TreePatternUtils.printChildren(builder, group, depth + 1);
        return builder;
    }

    public static void printChildren(@NotNull StringBuilder builder, @NotNull TreePatternNode.Group group, int depth) {
        if (builder == null) {
            TreePatternUtils.$$$reportNull$$$0(22);
        }
        if (group == null) {
            TreePatternUtils.$$$reportNull$$$0(23);
        }
        TreePatternUtils.printChildren(builder, group, depth, false);
        TreePatternUtils.printChildren(builder, group, depth, true);
    }

    private static void printChildren(@NotNull StringBuilder builder, @NotNull TreePatternNode.Group group, int depth, boolean negative) {
        if (builder == null) {
            TreePatternUtils.$$$reportNull$$$0(24);
        }
        if (group == null) {
            TreePatternUtils.$$$reportNull$$$0(25);
        }
        if (group.children != null) {
            for (TreePatternNode n : group.children) {
                if (n.naming instanceof TreePatternNode.NegativeNaming != negative) continue;
                TreePatternUtils.print(builder, n, depth);
            }
        }
    }

    public static StringBuilder print(@NotNull StringBuilder builder, @NotNull TreePatternNode node, int depth) {
        if (builder == null) {
            TreePatternUtils.$$$reportNull$$$0(26);
        }
        if (node == null) {
            TreePatternUtils.$$$reportNull$$$0(27);
        }
        builder.append(StringUtil.repeat((String)"  ", (int)depth)).append("name: ").append(node.naming).append("\n");
        return TreePatternUtils.printChildren(builder, node, depth + 1);
    }

    public static StringBuilder printChildren(@NotNull StringBuilder builder, @NotNull TreePatternNode node, int depth) {
        if (builder == null) {
            TreePatternUtils.$$$reportNull$$$0(28);
        }
        if (node == null) {
            TreePatternUtils.$$$reportNull$$$0(29);
        }
        for (TreePatternNode.Group n : node.groups) {
            TreePatternUtils.print(builder, n, depth);
        }
        return builder;
    }

    private static TreePatternNode @Nullable [] createPositiveNodes(@NotNull MultiMap<AW<TreePatternNode.Group>, TreePatternNode.BaseNaming> mergedBranches) {
        if (mergedBranches == null) {
            TreePatternUtils.$$$reportNull$$$0(30);
        }
        if (mergedBranches.isEmpty()) {
            return null;
        }
        ArrayList<TreePatternNode> positive = new ArrayList<TreePatternNode>();
        for (Map.Entry entry : mergedBranches.entrySet()) {
            TreePatternNode.BaseNaming[] merged = TreePatternUtils.merge((Iterable)entry.getValue(), false);
            if (merged == null) continue;
            for (TreePatternNode.BaseNaming naming : merged) {
                positive.add(new TreePatternNode(naming, (TreePatternNode.Group[])((AW)entry.getKey()).array));
            }
        }
        return (TreePatternNode[])positive.toArray(TreePatternNode[]::new);
    }

    private static TreePatternNode.Group[] preserve(@NotNull TreePatternNode.Group[] groups, boolean preserveOthers, @Nullable TreePatternNode.Group res, int pos) {
        if (groups == null) {
            TreePatternUtils.$$$reportNull$$$0(31);
        }
        if (pos == -1) {
            TreePatternNode.Group[] groupArray;
            if (preserveOthers) {
                groupArray = res == null ? groups : (TreePatternNode.Group[])ArrayUtil.append((Object[])groups, (Object)res);
            } else if (res == null) {
                groupArray = null;
            } else {
                TreePatternNode.Group[] groupArray2 = new TreePatternNode.Group[1];
                groupArray = groupArray2;
                groupArray2[0] = res;
            }
            return groupArray;
        }
        if (res == null) {
            return preserveOthers && groups.length != 1 ? (TreePatternNode.Group[])ArrayUtil.remove((Object[])groups, (int)pos) : null;
        }
        if (!preserveOthers) {
            return new TreePatternNode.Group[]{res};
        }
        TreePatternNode.Group[] clone = (TreePatternNode.Group[])groups.clone();
        clone[pos] = res;
        return clone;
    }

    @Nullable
    private static TreePatternNode.Group[] mask(@NotNull TreePatternNode.Group[] groups, @NotNull ObjectKind[] kinds, @NotNull boolean[] mask, int i2, boolean preserveOthers) {
        if (groups == null) {
            TreePatternUtils.$$$reportNull$$$0(32);
        }
        if (kinds == null) {
            TreePatternUtils.$$$reportNull$$$0(33);
        }
        if (mask == null) {
            TreePatternUtils.$$$reportNull$$$0(34);
        }
        if (i2 >= kinds.length) {
            return TreePatternNode.NO_GROUPS;
        }
        boolean wildcard = !mask[i2];
        int idx = -1;
        for (int k = 0; k < groups.length; ++k) {
            if (groups[k].kind != kinds[i2]) continue;
            idx = k;
            break;
        }
        if (idx == -1) {
            TreePatternNode.Group res = null;
            if (wildcard) {
                TreePatternNode.Group[] children = TreePatternUtils.mask(TreePatternNode.NO_GROUPS, kinds, mask, i2 + 1, preserveOthers);
                res = children == null ? null : new TreePatternNode.Group(kinds[i2], new TreePatternNode[]{new TreePatternNode(TreePatternNode.NegativeNaming.WILDCARD, children)});
            }
            return TreePatternUtils.preserve(groups, preserveOthers, res, -1);
        }
        TreePatternNode.Group group = groups[idx];
        if (!wildcard) {
            MultiMap merged = MultiMap.createLinkedSet();
            if (group.children != null) {
                for (TreePatternNode child : group.children) {
                    TreePatternNode.Group[] masked = TreePatternUtils.mask(child.groups, kinds, mask, i2 + 1, preserveOthers);
                    if (masked == null) continue;
                    merged.putValue(new AW<TreePatternNode.Group>(masked), (Object)child.naming);
                }
            }
            TreePatternNode[] children = TreePatternUtils.createPositiveNodes((MultiMap<AW<TreePatternNode.Group>, TreePatternNode.BaseNaming>)merged);
            TreePatternNode.Group result = merged.isEmpty() ? null : new TreePatternNode.Group(kinds[i2], children);
            return TreePatternUtils.preserve(groups, preserveOthers, result, idx);
        }
        LinkedHashSet<TreePatternNode> res = new LinkedHashSet<TreePatternNode>();
        for (TreePatternNode node : JBIterable.of((Object[])group.children)) {
            TreePatternNode.Group[] grouped = TreePatternUtils.mask(node.groups, kinds, mask, i2 + 1, preserveOthers);
            if (grouped == null) continue;
            res.add(new TreePatternNode(node.naming, grouped));
        }
        TreePatternNode.Group[] merged = UNION_PROCESSOR.mergeRoots(res);
        TreePatternNode.Group result = merged == null ? null : new TreePatternNode.Group(kinds[i2], new TreePatternNode[]{new TreePatternNode(TreePatternNode.NegativeNaming.WILDCARD, merged)});
        return TreePatternUtils.preserve(groups, preserveOthers, result, idx);
    }

    @NotNull
    public static TreePattern union(TreePattern ... patterns) {
        if (patterns == null) {
            TreePatternUtils.$$$reportNull$$$0(35);
        }
        return TreePatternUtils.union(Arrays.asList(patterns));
    }

    @NotNull
    public static TreePattern union(@NotNull Iterable<TreePattern> patterns) {
        if (patterns == null) {
            TreePatternUtils.$$$reportNull$$$0(36);
        }
        TreePattern treePattern = UNION_PROCESSOR.merge(patterns);
        if (treePattern == null) {
            TreePatternUtils.$$$reportNull$$$0(37);
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern intersect(TreePattern ... patterns) {
        if (patterns == null) {
            TreePatternUtils.$$$reportNull$$$0(38);
        }
        TreePattern treePattern = INTERSECTION_PROCESSOR.merge((Iterable<TreePattern>)JBIterable.of((Object[])patterns));
        if (treePattern == null) {
            TreePatternUtils.$$$reportNull$$$0(39);
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern minus(TreePattern ... patterns) {
        if (patterns == null) {
            TreePatternUtils.$$$reportNull$$$0(40);
        }
        TreePattern treePattern = MINUS_PROCESSOR.merge((Iterable<TreePattern>)JBIterable.of((Object[])patterns));
        if (treePattern == null) {
            TreePatternUtils.$$$reportNull$$$0(41);
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern diff(TreePattern ... patterns) {
        if (patterns == null) {
            TreePatternUtils.$$$reportNull$$$0(42);
        }
        return TreePatternUtils.minus(TreePatternUtils.union(patterns), TreePatternUtils.intersect(patterns));
    }

    @NotNull
    public static TreePattern mask(@NotNull TreePattern pattern, @NotNull ObjectKind[] kinds, @NotNull boolean[] mask, boolean preserveOthers) {
        if (pattern == null) {
            TreePatternUtils.$$$reportNull$$$0(43);
        }
        if (kinds == null) {
            TreePatternUtils.$$$reportNull$$$0(44);
        }
        if (mask == null) {
            TreePatternUtils.$$$reportNull$$$0(45);
        }
        return new TreePattern(TreePatternUtils.mask(pattern.root.groups, kinds, mask, 0, preserveOthers));
    }

    @NotNull
    public static TreePatternNode.Group create(@NotNull DasObject obj, TreePatternNode.Group ... children) {
        if (obj == null) {
            TreePatternUtils.$$$reportNull$$$0(46);
        }
        return TreePatternUtils.create(ObjectName.create((String)obj.getName(), (boolean)DbSqlUtilCore.isQuoted(obj)), obj.getKind(), children);
    }

    @NotNull
    public static TreePatternNode.Group create(@Nullable ObjectName name, @NotNull ObjectKind kind, TreePatternNode.Group ... children) {
        if (kind == null) {
            TreePatternUtils.$$$reportNull$$$0(47);
        }
        return TreePatternUtils.create(name == null ? null : Collections.singletonList(name), kind, children);
    }

    @NotNull
    public static TreePatternNode.Group create(@Nullable List<ObjectName> names, @NotNull ObjectKind kind, TreePatternNode.Group ... children) {
        if (kind == null) {
            TreePatternUtils.$$$reportNull$$$0(48);
        }
        return TreePatternUtils.create(ObjectName.toArray(names), kind, children);
    }

    @NotNull
    public static TreePatternNode.Group create(ObjectName @Nullable [] names, @NotNull ObjectKind kind, TreePatternNode.Group ... children) {
        if (kind == null) {
            TreePatternUtils.$$$reportNull$$$0(49);
        }
        if (children == null) {
            children = TreePatternNode.NO_GROUPS;
        }
        int nonNulls = 0;
        for (TreePatternNode.Group child : children) {
            if (child == null) continue;
            ++nonNulls;
        }
        if (nonNulls != children.length) {
            if (nonNulls == 0) {
                children = TreePatternNode.NO_GROUPS;
            } else {
                TreePatternNode.Group[] children2 = new TreePatternNode.Group[nonNulls];
                nonNulls = 0;
                for (TreePatternNode.Group child : children) {
                    if (child == null) continue;
                    children2[nonNulls++] = child;
                }
                children = children2;
            }
        }
        TreePatternNode.BaseNaming naming = names == null ? TreePatternNode.NegativeNaming.WILDCARD : new TreePatternNode.PositiveNaming(names);
        return new TreePatternNode.Group(kind, new TreePatternNode[]{new TreePatternNode(naming, children)});
    }

    @NotNull
    public static TreePattern patternProcessor(@NotNull TreePattern processed, @NotNull TreePattern mask, final @NotNull PatternProcessor processor) {
        TreePatternNode.Group[] newRoot;
        if (processed == null) {
            TreePatternUtils.$$$reportNull$$$0(50);
        }
        if (mask == null) {
            TreePatternUtils.$$$reportNull$$$0(51);
        }
        if (processor == null) {
            TreePatternUtils.$$$reportNull$$$0(52);
        }
        return (newRoot = new Object(){

            @Nullable
            public TreePatternNode.Group[] visit(@Nullable TreePatternNode node, @Nullable TreePatternNode checker, @Nullable TreePatternNode.BaseNaming parent, @Nullable ObjectKind parentKind) {
                TreePatternNode.Group processed;
                if (checker == null) {
                    return node == null ? null : node.groups;
                }
                NodeBuilder b = null;
                LinkedHashMap<ObjectKind, TreePatternNode.Group> newGroups = new LinkedHashMap<ObjectKind, TreePatternNode.Group>();
                for (TreePatternNode.Group group : checker.groups) {
                    newGroups.put(group.kind, group);
                }
                if (node != null) {
                    for (int i2 = 0; i2 < node.groups.length; ++i2) {
                        TreePatternNode.Group group = node.groups[i2];
                        newGroups.remove(group.kind);
                        TreePatternNode.Group checkerGroup = checker.getGroup(group.kind);
                        processed = group;
                        if (checkerGroup != null) {
                            processed = this.visit(group, checkerGroup, parent, parentKind);
                        }
                        if (processed != group && b == null) {
                            b = new NodeBuilder();
                            for (int k = 0; k < i2; ++k) {
                                b.addGroup(node.groups[k]);
                            }
                        }
                        if (b == null || processed == null) continue;
                        b.addGroup(processed);
                    }
                }
                Iterator iterator = newGroups.values().iterator();
                while (iterator.hasNext()) {
                    TreePatternNode.Group group;
                    TreePatternNode.Group temp = new TreePatternNode.Group(group.kind, null);
                    group = (TreePatternNode.Group)iterator.next();
                    processed = this.visit(temp, group, parent, parentKind);
                    if (processed == temp || processed == null) continue;
                    if (b == null) {
                        b = NodeBuilder.from(node);
                    }
                    b.addGroup(processed);
                }
                return b == null ? (node == null ? null : node.groups) : b.buildGroupsOpt();
            }

            @Nullable
            public TreePatternNode.Group visit(@NotNull TreePatternNode.Group group, @NotNull TreePatternNode.Group checker, @Nullable TreePatternNode.BaseNaming parent, @Nullable ObjectKind parentKind) {
                TreePatternNode.Group procRes;
                if (group == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (checker == null) {
                    4.$$$reportNull$$$0(1);
                }
                if ((procRes = processor.process(group, parent, parentKind)) == SKIP_PROCESSING) {
                    return group;
                }
                if (procRes == null) {
                    return null;
                }
                group = procRes;
                MultiMap gluedChildren = MultiMap.createLinked();
                MultiMap p = MultiMap.createLinked();
                TreePatternUtils.subdivideChildren((Iterable<TreePatternNode.Group>)JBIterable.of((Object[])new TreePatternNode.Group[]{group, checker}), (MultiMap<TreePatternNode.BaseNaming, TreePatternNode>)p);
                for (Map.Entry entry : p.entrySet()) {
                    Iterator it = ((Collection)entry.getValue()).iterator();
                    TreePatternNode p1 = (TreePatternNode)it.next();
                    TreePatternNode p2 = (TreePatternNode)it.next();
                    TreePatternNode.Group[] processed = this.visit(p1, p2, (TreePatternNode.BaseNaming)entry.getKey(), group.kind);
                    gluedChildren.putValue(new AW<TreePatternNode.Group>(processed), (Object)((TreePatternNode.BaseNaming)entry.getKey()));
                }
                return 4.createNewIfChanged(group, (MultiMap<AW<TreePatternNode.Group>, TreePatternNode.BaseNaming>)gluedChildren);
            }

            private static TreePatternNode.Group createNewIfChanged(@NotNull TreePatternNode.Group group, @NotNull MultiMap<AW<TreePatternNode.Group>, TreePatternNode.BaseNaming> children) {
                if (group == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (children == null) {
                    4.$$$reportNull$$$0(3);
                }
                HashMap<TreePatternNode.BaseNaming, TreePatternNode> pool = new HashMap<TreePatternNode.BaseNaming, TreePatternNode>();
                if (group.children != null) {
                    for (TreePatternNode child : group.children) {
                        pool.put(child.naming, child);
                    }
                }
                boolean changed = pool.size() != children.size();
                GroupBuilder builder = new GroupBuilder();
                for (Map.Entry entry : children.entrySet()) {
                    TreePatternNode.BaseNaming[] merged = TreePatternUtils.merge((Iterable)entry.getValue(), false);
                    if (merged == null) continue;
                    for (TreePatternNode.BaseNaming naming : merged) {
                        TreePatternNode node = (TreePatternNode)pool.get(naming);
                        if (node == null || node.groups != ((AW)entry.getKey()).array) {
                            changed = true;
                            node = ((AW)entry.getKey()).array == null ? null : new TreePatternNode(naming, (TreePatternNode.Group[])((AW)entry.getKey()).array);
                        }
                        ContainerUtil.addIfNotNull(builder.children, (Object)node);
                    }
                }
                return changed ? builder.build(group.kind) : group;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "group";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "checker";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "children";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/util/TreePatternUtils$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visit";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createNewIfChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.visit(processed.root, mask.root, null, null)) == processed.root.groups ? processed : new TreePattern(newRoot);
    }

    public static boolean isWildcard(@Nullable TreePatternNode.Group g) {
        return g != null && g.children != null && g.children.length == 1 && TreePatternUtils.isWildcard(g.children[0]);
    }

    public static boolean isWildcard(@Nullable TreePatternNode n) {
        return n != null && n.naming instanceof TreePatternNode.NegativeNaming && n.naming.names.length == 0 && n.groups.length == 0;
    }

    @NotNull
    public static TreePattern sorted(@NotNull TreePattern pattern) {
        TreePatternNode sortedRoot;
        if (pattern == null) {
            TreePatternUtils.$$$reportNull$$$0(53);
        }
        return (sortedRoot = TreePatternUtils.sorted(pattern.root)) == pattern.root ? pattern : new TreePattern(sortedRoot);
    }

    @NotNull
    private static TreePatternNode sorted(@NotNull TreePatternNode node) {
        if (node == null) {
            TreePatternUtils.$$$reportNull$$$0(54);
        }
        TreePatternNode.Group[] newGroups = TreePatternUtils.sorted(node.groups, TreePatternNode.Group.BY_KIND);
        TreePatternNode.BaseNaming naming = TreePatternUtils.sorted(node.naming);
        return newGroups == node.groups && naming == node.naming ? node : new TreePatternNode(naming, newGroups);
    }

    @NotNull
    private static <T> T[] sorted(T[] items, Comparator<? super T> comp) {
        Object[] newItems = null;
        boolean unsorted = false;
        for (int i2 = 0; i2 < items.length; ++i2) {
            Object newItem;
            Object object = newItem = items[i2] instanceof TreePatternNode.Group ? TreePatternUtils.sorted((TreePatternNode.Group)items[i2]) : TreePatternUtils.sorted((TreePatternNode)items[i2]);
            if (!unsorted && i2 != 0) {
                boolean bl = unsorted = comp.compare(items[i2 - 1], items[i2]) > 0;
            }
            if (newItems == null) {
                if (newItem == items[i2] && !unsorted) continue;
                newItems = (Object[])Array.newInstance(items[i2].getClass(), items.length);
                System.arraycopy(items, 0, newItems, 0, i2);
            }
            newItems[i2] = newItem;
        }
        if (unsorted) {
            Arrays.sort(newItems, comp);
        }
        Object[] objectArray = newItems == null ? items : newItems;
        if (objectArray == null) {
            TreePatternUtils.$$$reportNull$$$0(55);
        }
        return objectArray;
    }

    private static TreePatternNode.BaseNaming @Nullable [] merge(@NotNull Iterable<? extends TreePatternNode.BaseNaming> namings, boolean sort) {
        TreePatternNode.BaseNaming[] baseNamingArray;
        TreePatternNode.PositiveNaming pn;
        Iterator<? extends TreePatternNode.BaseNaming> it;
        if (namings == null) {
            TreePatternUtils.$$$reportNull$$$0(56);
        }
        if (!(it = namings.iterator()).hasNext()) {
            return null;
        }
        TreePatternNode.BaseNaming naming = it.next();
        if (!it.hasNext()) {
            return new TreePatternNode.BaseNaming[]{naming};
        }
        LinkedHashSet<ObjectName> positive = new LinkedHashSet<ObjectName>();
        LinkedHashSet<ObjectName> negative = new LinkedHashSet<ObjectName>();
        boolean hasNegative = false;
        SmartPredicate<TreePatternNode.PatternWrapper> pattern = SmartPredicate.none();
        while (naming != null) {
            LinkedHashSet<ObjectName> target;
            boolean n = naming instanceof TreePatternNode.NegativeNaming;
            if (n) {
                pattern = pattern.union(((TreePatternNode.NegativeNaming)naming).pattern);
                hasNegative = true;
                target = negative;
            } else {
                target = positive;
            }
            ContainerUtil.addAll(target, (Object[])naming.names);
            naming = it.hasNext() ? it.next() : null;
        }
        if (hasNegative) {
            negative.removeAll(positive);
            TreePatternUtils.removeByPattern(positive, pattern);
        }
        TreePatternNode.PositiveNaming positiveNaming = pn = positive.isEmpty() ? null : new TreePatternNode.PositiveNaming(TreePatternUtils.prepare(positive, sort));
        if (hasNegative) {
            TreePatternNode.NegativeNaming nn = new TreePatternNode.NegativeNaming(pattern, TreePatternUtils.prepare(negative, sort));
            if (pn == null) {
                return new TreePatternNode.BaseNaming[]{nn};
            }
            return new TreePatternNode.BaseNaming[]{pn, nn};
        }
        if (pn == null) {
            baseNamingArray = null;
        } else {
            TreePatternNode.BaseNaming[] baseNamingArray2 = new TreePatternNode.BaseNaming[1];
            baseNamingArray = baseNamingArray2;
            baseNamingArray2[0] = pn;
        }
        return baseNamingArray;
    }

    private static ObjectName[] prepare(Set<ObjectName> names, boolean sort) {
        Object[] res = ObjectName.toArray(names);
        if (sort) {
            Arrays.sort(res);
        }
        return res;
    }

    private static void removeByPattern(Set<ObjectName> positive, SmartPredicate<TreePatternNode.PatternWrapper> pattern) {
        positive.removeIf(n -> TreePatternNode.PatternWrapper.evaluate(pattern, n));
    }

    @NotNull
    private static TreePatternNode.Group sorted(@NotNull TreePatternNode.Group g) {
        if (g == null) {
            TreePatternUtils.$$$reportNull$$$0(57);
        }
        TreePatternNode[] nodes = g.children == null ? null : TreePatternUtils.sorted(g.children, TreePatternNode.BY_FIRST);
        nodes = TreePatternUtils.tighten(nodes);
        return nodes == g.children ? g : new TreePatternNode.Group(g.kind, nodes);
    }

    private static TreePatternNode[] tighten(TreePatternNode @Nullable [] c2) {
        if (c2 == null) {
            return null;
        }
        MultiMap grouping = MultiMap.createLinked();
        for (TreePatternNode node2 : c2) {
            grouping.putValue(new AW<TreePatternNode.Group>(node2.groups), (Object)node2);
        }
        if (c2.length == grouping.size()) {
            return c2;
        }
        if (grouping.isEmpty()) {
            return null;
        }
        ArrayList<TreePatternNode> children = new ArrayList<TreePatternNode>(grouping.size());
        for (Map.Entry entry : grouping.entrySet()) {
            if (((Collection)entry.getValue()).size() == 1) {
                children.add((TreePatternNode)ContainerUtil.getFirstItem((Collection)((Collection)entry.getValue())));
                continue;
            }
            TreePatternNode.BaseNaming[] merged = TreePatternUtils.merge((Iterable<? extends TreePatternNode.BaseNaming>)JBIterable.from((Iterable)((Iterable)entry.getValue())).transform(node -> node.naming), true);
            if (merged == null) continue;
            for (TreePatternNode.BaseNaming naming : merged) {
                children.add(new TreePatternNode(naming, Objects.requireNonNull((TreePatternNode.Group[])((AW)entry.getKey()).array)));
            }
        }
        return children.toArray(new TreePatternNode[0]);
    }

    @NotNull
    private static <N extends TreePatternNode.BaseNaming> N sorted(@NotNull N naming) {
        if (naming == null) {
            TreePatternUtils.$$$reportNull$$$0(58);
        }
        boolean unsorted = false;
        ObjectName[] names = naming.names;
        int s = names.length;
        for (int i2 = 1; i2 < s && !unsorted; ++i2) {
            unsorted = names[i2 - 1].compareTo(names[i2]) > 0;
        }
        if (!unsorted) {
            N n = naming;
            if (n == null) {
                TreePatternUtils.$$$reportNull$$$0(59);
            }
            return n;
        }
        Object[] newNames = (ObjectName[])names.clone();
        Arrays.sort(newNames);
        return (N)(naming instanceof TreePatternNode.NegativeNaming ? new TreePatternNode.NegativeNaming(((TreePatternNode.NegativeNaming)naming).pattern, (ObjectName[])newNames) : new TreePatternNode.PositiveNaming((ObjectName[])newNames));
    }

    @NotNull
    public static String exportScope(@NotNull MetaModel meta, @NotNull TreePattern pattern) {
        if (meta == null) {
            TreePatternUtils.$$$reportNull$$$0(60);
        }
        if (pattern == null) {
            TreePatternUtils.$$$reportNull$$$0(61);
        }
        String string = IntrospectionScopes.exportState(meta, pattern);
        if (string == null) {
            TreePatternUtils.$$$reportNull$$$0(62);
        }
        return string;
    }

    @NotNull
    public static TreePattern fromScopeMap(@NotNull BasicMetaModel<?> meta, @NotNull MultiMap<String, String> scope) {
        BasicMetaObject metaDb;
        if (meta == null) {
            TreePatternUtils.$$$reportNull$$$0(63);
        }
        if (scope == null) {
            TreePatternUtils.$$$reportNull$$$0(64);
        }
        TreePatternNode.Group[] g = (metaDb = BasicMetaUtils.findChild(meta.root, ObjectKind.DATABASE)) != null ? TreePatternUtils.scopeGroup(scope.keySet(), ObjectKind.DATABASE, (Function<String, TreePatternNode.Group[]>)((Function)db -> TreePatternUtils.scopeGroup(scope.get(db), ObjectKind.SCHEMA, null))) : TreePatternUtils.scopeGroup(scope.values(), ObjectKind.SCHEMA, null);
        return new TreePattern(g);
    }

    @NotNull
    public static TreePattern fromScopeMap(boolean multiDatabase, @NotNull MultiMap<String, String> scope) {
        if (scope == null) {
            TreePatternUtils.$$$reportNull$$$0(65);
        }
        TreePatternNode.Group[] g = multiDatabase ? TreePatternUtils.scopeGroup(scope.keySet(), ObjectKind.DATABASE, (Function<String, TreePatternNode.Group[]>)((Function)db -> TreePatternUtils.scopeGroup(scope.get(db), ObjectKind.SCHEMA, null))) : TreePatternUtils.scopeGroup(scope.values(), ObjectKind.SCHEMA, null);
        return new TreePattern(g);
    }

    private static TreePatternNode.Group[] scopeGroup(Collection<String> names, ObjectKind defKind, Function<String, TreePatternNode.Group[]> child) {
        Map groups = FactoryMap.createMap(k -> new GroupBuilder(), TreeMap::new);
        for (String name : ContainerUtil.sorted(names)) {
            Pair<ObjectKind, String> kindAndName = TreePatternUtils.extractKindAndName(name, defKind);
            TreePatternNode.Group[] schemas = child == null ? null : (TreePatternNode.Group[])child.fun((Object)((String)kindAndName.second));
            ((GroupBuilder)groups.get((Object)kindAndName.first)).children.add(new TreePatternNode(TreePatternUtils.createNaming((String)kindAndName.second), schemas == null ? TreePatternNode.NO_GROUPS : schemas));
        }
        ArrayList<TreePatternNode.Group> res = new ArrayList<TreePatternNode.Group>(groups.size());
        for (Map.Entry entry : groups.entrySet()) {
            ((GroupBuilder)entry.getValue()).deduplicate();
            res.add(((GroupBuilder)entry.getValue()).build((ObjectKind)entry.getKey()));
        }
        return res.toArray(TreePatternNode.NO_GROUPS);
    }

    @NotNull
    private static Pair<ObjectKind, String> extractKindAndName(String name, ObjectKind defKind) {
        String code;
        int kS = name.endsWith("]") ? name.lastIndexOf(91) : -1;
        ObjectKind kind = null;
        if (kS != -1 && (kind = ObjectKind.getKind((String)(code = name.substring(kS + 1, name.length() - 1)))) != null) {
            name = name.substring(0, kS);
        }
        if (kind == null) {
            kind = defKind;
        }
        Pair pair = Pair.create((Object)kind, (Object)name);
        if (pair == null) {
            TreePatternUtils.$$$reportNull$$$0(66);
        }
        return pair;
    }

    @NotNull
    private static TreePatternNode.BaseNaming createNaming(String name) {
        TreePatternNode.BaseNaming naming;
        if (name.equals("*")) {
            naming = TreePatternNode.NegativeNaming.WILDCARD;
        } else if (name.startsWith("{") && name.endsWith("}")) {
            String text2 = name.substring(1, name.length() - 1);
            TreePatternNode.PatternWrapper pattern = TreePatternNode.PatternWrapper.create(text2);
            naming = new TreePatternNode.NegativeNaming(SmartPredicate.create(pattern), new ObjectName[0]);
        } else {
            naming = new TreePatternNode.PositiveNaming(ObjectName.quoted((String)name));
        }
        TreePatternNode.NegativeNaming negativeNaming = naming;
        if (negativeNaming == null) {
            TreePatternUtils.$$$reportNull$$$0(67);
        }
        return negativeNaming;
    }

    private static void breakDown(@NotNull MetaModel meta, @NotNull TreePatternNode node, @NotNull String database, @NotNull MultiMap<String, String> scope) {
        if (meta == null) {
            TreePatternUtils.$$$reportNull$$$0(68);
        }
        if (node == null) {
            TreePatternUtils.$$$reportNull$$$0(69);
        }
        if (database == null) {
            TreePatternUtils.$$$reportNull$$$0(70);
        }
        if (scope == null) {
            TreePatternUtils.$$$reportNull$$$0(71);
        }
        for (TreePatternNode.Group group : node.groups) {
            TreePatternUtils.breakDown(meta, group, database, scope);
        }
    }

    private static void breakDown(@NotNull MetaModel meta, @NotNull TreePatternNode.Group group, @NotNull String database, @NotNull MultiMap<String, String> scope) {
        if (meta == null) {
            TreePatternUtils.$$$reportNull$$$0(72);
        }
        if (group == null) {
            TreePatternUtils.$$$reportNull$$$0(73);
        }
        if (database == null) {
            TreePatternUtils.$$$reportNull$$$0(74);
        }
        if (scope == null) {
            TreePatternUtils.$$$reportNull$$$0(75);
        }
        if (!meta.getNamespaces().contains(group.kind)) {
            return;
        }
        if (group.children != null) {
            for (TreePatternNode child : group.children) {
                if (child.naming instanceof TreePatternNode.NegativeNaming) {
                    TreePatternUtils.addToScope("*", group.kind, child, meta, database, scope);
                    continue;
                }
                for (ObjectName name : child.naming.names) {
                    TreePatternUtils.addToScope(name.name, group.kind, child, meta, database, scope);
                }
            }
        }
    }

    private static void addToScope(@NotNull String name, @NotNull ObjectKind kind, @NotNull TreePatternNode node, @NotNull MetaModel meta, @NotNull String database, @NotNull MultiMap<String, String> scope) {
        if (name == null) {
            TreePatternUtils.$$$reportNull$$$0(76);
        }
        if (kind == null) {
            TreePatternUtils.$$$reportNull$$$0(77);
        }
        if (node == null) {
            TreePatternUtils.$$$reportNull$$$0(78);
        }
        if (meta == null) {
            TreePatternUtils.$$$reportNull$$$0(79);
        }
        if (database == null) {
            TreePatternUtils.$$$reportNull$$$0(80);
        }
        if (scope == null) {
            TreePatternUtils.$$$reportNull$$$0(81);
        }
        if (kind == ObjectKind.DATABASE) {
            scope.getModifiable((Object)name);
            TreePatternUtils.breakDown(meta, node, name, scope);
        } else {
            scope.putValue((Object)database, (Object)name);
            TreePatternUtils.breakDown(meta, node, database, scope);
        }
    }

    public static ObjectName nameOf(@Nullable DasObject o, boolean nullize) {
        return o == null ? null : ObjectName.create((String)(nullize ? StringUtil.nullize((String)o.getName()) : o.getName()), (boolean)DbSqlUtilCore.isQuoted(o));
    }

    public static ObjectName nameOf(@Nullable DasObject o) {
        return TreePatternUtils.nameOf(o, false);
    }

    public static ObjectName nameOf(@Nullable ObjectPath p) {
        return p == null ? null : ObjectName.create((String)p.name, (boolean)p.isQuoted());
    }

    @NotNull
    public static TreePattern create(@NotNull ObjectPath path) {
        if (path == null) {
            TreePatternUtils.$$$reportNull$$$0(82);
        }
        return new TreePattern(TreePatternUtils.createGroup(path));
    }

    @Nullable
    private static TreePatternNode.Group createGroup(@NotNull ObjectPath path) {
        if (path == null) {
            TreePatternUtils.$$$reportNull$$$0(83);
        }
        TreePatternNode.Group g = null;
        ObjectPath p = path;
        while (p != null) {
            g = TreePatternUtils.create(TreePatternUtils.nameOf(p), p.kind, g);
            p = p.parent;
        }
        return g;
    }

    @Contract(pure=true)
    @NotNull
    public static TreePattern importPattern(@NotNull Dbms dbms, @Nullable String string) {
        if (dbms == null) {
            TreePatternUtils.$$$reportNull$$$0(84);
        }
        MultiMap map = MultiMap.createLinkedSet();
        if (string != null) {
            IntrospectionScopes.importStateToMap(string, (MultiMap<String, String>)map);
        }
        return TreePatternUtils.fromScopeMap(DbImplUtilCore.getMetaModel(dbms), (MultiMap<String, String>)map);
    }

    @Contract(pure=true)
    @NotNull
    public static TreePattern patternFromPattern(@NotNull Dbms dbms, @Nullable String string) {
        if (dbms == null) {
            TreePatternUtils.$$$reportNull$$$0(85);
        }
        MultiMap map = MultiMap.createLinkedSet();
        IntrospectionScopes.fromSchemaPatternToMap(string, (MultiMap<String, String>)map);
        return TreePatternUtils.fromScopeMap(DbImplUtilCore.getMetaModel(dbms), (MultiMap<String, String>)map);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 6, 9, 11, 14, 37, 39, 41, 55, 59, 62, 66, 67 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 37: 
            case 39: 
            case 41: 
            case 55: 
            case 59: 
            case 62: 
            case 66: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/TreePatternUtils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scG";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceOwner";
                break;
            }
            case 8: 
            case 64: 
            case 65: 
            case 71: 
            case 75: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 13: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 15: 
            case 18: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subdiv";
                break;
            }
            case 17: 
            case 47: 
            case 48: 
            case 49: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fac";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 21: 
            case 23: 
            case 25: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 27: 
            case 29: 
            case 54: 
            case 69: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedBranches";
                break;
            }
            case 33: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 34: 
            case 45: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mask";
                break;
            }
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 43: 
            case 53: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namings";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "naming";
                break;
            }
            case 60: 
            case 63: 
            case 68: 
            case 72: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 70: 
            case 74: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "database";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 82: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/TreePatternUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseToState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeSchemas";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeNamings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "countNamespaces";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toStringArray";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNames";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "intersect";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "minus";
                break;
            }
            case 55: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "sorted";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "exportScope";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "extractKindAndName";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "createNaming";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 37: 
            case 39: 
            case 41: 
            case 55: 
            case 59: 
            case 62: 
            case 66: 
            case 67: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serializeSchemaNames";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "countNamespaces";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "toStringArray";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAllNames";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "subdivideChildren";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processGrouped";
                break;
            }
            case 20: 
            case 21: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "printChildren";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createPositiveNodes";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "preserve";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "mask";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "intersect";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "minus";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "diff";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "patternProcessor";
                break;
            }
            case 53: 
            case 54: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "sorted";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "exportScope";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "fromScopeMap";
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "breakDown";
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "addToScope";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "createGroup";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "importPattern";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "patternFromPattern";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 6, 9, 11, 14, 37, 39, 41, 55, 59, 62, 66, 67 -> new IllegalStateException(string);
        };
    }

    public static abstract class GroupedGroupFactory {
        @Nullable
        public TreePatternNode.Group create(@NotNull MultiMap<TreePatternNode.BaseNaming, TreePatternNode> c2, ObjectKind kind) {
            if (c2 == null) {
                GroupedGroupFactory.$$$reportNull$$$0(0);
            }
            MultiMap mergedBranches = MultiMap.createLinkedSet();
            for (Map.Entry entry : c2.entrySet()) {
                TreePatternNode.Group[] merged = this.mergeNodes((TreePatternNode.BaseNaming)entry.getKey(), kind, (Iterable)entry.getValue());
                if (merged == null) continue;
                mergedBranches.putValue(new AW<TreePatternNode.Group>(merged), (Object)((TreePatternNode.BaseNaming)entry.getKey()));
            }
            if (mergedBranches.isEmpty()) {
                return null;
            }
            TreePatternNode[] children = TreePatternUtils.createPositiveNodes((MultiMap<AW<TreePatternNode.Group>, TreePatternNode.BaseNaming>)mergedBranches);
            return new TreePatternNode.Group(kind, children);
        }

        @Nullable
        public TreePatternNode.Group[] mergeNodes(@Nullable TreePatternNode.BaseNaming naming, @Nullable ObjectKind kind, @NotNull Iterable<TreePatternNode> nodes) {
            if (nodes == null) {
                GroupedGroupFactory.$$$reportNull$$$0(1);
            }
            this.enter(naming, kind, nodes);
            if (!this.checkNode(naming, kind, nodes)) {
                this.leave(naming, kind, nodes);
                return null;
            }
            MultiMap grouped = this.mergeChildren() ? MultiMap.createLinkedSet() : MultiMap.createLinked();
            LinkedHashSet<ObjectKind> allKinds = new LinkedHashSet<ObjectKind>();
            for (TreePatternNode treePatternNode : nodes) {
                if (treePatternNode == null) continue;
                for (TreePatternNode.Group group : treePatternNode.groups) {
                    allKinds.add(group.kind);
                }
            }
            for (TreePatternNode treePatternNode : nodes) {
                HashSet<ObjectKind> currentKinds = null;
                if (treePatternNode != null) {
                    currentKinds = new HashSet<ObjectKind>();
                    for (TreePatternNode.Group group : treePatternNode.groups) {
                        grouped.putValue((Object)group.kind, (Object)group);
                        currentKinds.add(group.kind);
                    }
                }
                for (ObjectKind gkind : allKinds) {
                    if (currentKinds != null && currentKinds.contains(gkind)) continue;
                    grouped.putValue((Object)gkind, null);
                }
            }
            SmartList res = new SmartList();
            for (Map.Entry entry : grouped.entrySet()) {
                this.enterGroups(naming, kind, (Iterable)entry.getValue());
                if (this.checkGroup(naming, kind, (Iterable)entry.getValue())) {
                    ContainerUtil.addAllNotNull((Collection)res, (Object[])new TreePatternNode.Group[]{TreePatternUtils.processGrouped((ObjectKind)entry.getKey(), (Iterable)entry.getValue(), this)});
                }
                this.leaveGroups(naming, kind, (Iterable)entry.getValue());
            }
            TreePatternNode.Group[] groupArray = !res.isEmpty() ? res.toArray(new TreePatternNode.Group[0]) : (this.willDestroyEmpty(naming, kind, nodes) ? null : TreePatternNode.NO_GROUPS);
            this.leave(naming, kind, nodes);
            return groupArray;
        }

        @NotNull
        public TreePattern merge(@NotNull Iterable<TreePattern> patterns) {
            TreePatternNode.Group[] groups;
            if (patterns == null) {
                GroupedGroupFactory.$$$reportNull$$$0(2);
            }
            return (groups = this.mergeRoots((Iterable<TreePatternNode>)JBIterable.from(patterns).transform(p -> p.root))) == null ? TreePattern.EMPTY : new TreePattern(groups);
        }

        @Nullable
        public TreePatternNode.Group[] mergeRoots(@NotNull Iterable<TreePatternNode> nodes) {
            if (nodes == null) {
                GroupedGroupFactory.$$$reportNull$$$0(3);
            }
            return this.mergeNodes(TreePatternNode.NegativeNaming.WILDCARD, ObjectKind.NONE, nodes);
        }

        @Nullable
        public TreePatternNode.Group mergeGroups(@NotNull ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> groups) {
            if (kind == null) {
                GroupedGroupFactory.$$$reportNull$$$0(4);
            }
            if (groups == null) {
                GroupedGroupFactory.$$$reportNull$$$0(5);
            }
            return TreePatternUtils.processGrouped(kind, groups, this);
        }

        protected abstract boolean checkGroup(TreePatternNode.BaseNaming var1, ObjectKind var2, @NotNull Iterable<TreePatternNode.Group> var3);

        protected abstract boolean checkNode(TreePatternNode.BaseNaming var1, ObjectKind var2, @NotNull Iterable<TreePatternNode> var3);

        protected abstract boolean willDestroyEmpty(TreePatternNode.BaseNaming var1, ObjectKind var2, Iterable<TreePatternNode> var3);

        protected void enter(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode> nodes) {
        }

        protected void leave(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode> nodes) {
        }

        protected void enterGroups(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode.Group> groups) {
        }

        protected void leaveGroups(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode.Group> groups) {
        }

        public boolean mergeChildren() {
            return true;
        }

        protected static boolean containsNull(Iterable<?> it) {
            if (it instanceof Collection) {
                return ((Collection)it).contains(null);
            }
            for (Object o : it) {
                if (o != null) continue;
                return true;
            }
            return false;
        }

        protected static boolean containsNotNull(Iterable<?> it) {
            for (Object o : it) {
                if (o == null) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patterns";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groups";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/util/TreePatternUtils$GroupedGroupFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mergeNodes";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "merge";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mergeRoots";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mergeGroups";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class AW<T> {
        public final T[] array;
        private Integer myHashCode;

        AW(@Nullable T[] array) {
            this.array = array;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AW aw = (AW)o;
            return Arrays.equals(this.array, aw.array);
        }

        public int hashCode() {
            if (this.myHashCode != null) {
                return this.myHashCode;
            }
            this.myHashCode = Arrays.hashCode(this.array);
            return this.myHashCode;
        }
    }

    public static interface PatternProcessor {
        @Nullable
        public TreePatternNode.Group process(@NotNull TreePatternNode.Group var1, @Nullable TreePatternNode.BaseNaming var2, @Nullable ObjectKind var3);
    }

    public static final class GroupBuilder {
        public final List<TreePatternNode> children = new SmartList();

        @Nullable
        public TreePatternNode.Group build(@NotNull ObjectKind kind) {
            if (kind == null) {
                GroupBuilder.$$$reportNull$$$0(0);
            }
            return this.build(kind, true);
        }

        @Nullable
        public TreePatternNode.Group build(@NotNull ObjectKind kind, boolean validate) {
            if (kind == null) {
                GroupBuilder.$$$reportNull$$$0(1);
            }
            TreePatternNode[] p = this.children.isEmpty() ? null : this.children.toArray(new TreePatternNode[0]);
            return p == null ? null : new TreePatternNode.Group(kind, p, validate);
        }

        public void add(@NotNull TreePatternNode node) {
            if (node == null) {
                GroupBuilder.$$$reportNull$$$0(2);
            }
            this.children.add(node);
        }

        public void deduplicate() {
            if (this.children.size() < 2) {
                return;
            }
            MultiMap map = MultiMap.createLinked();
            for (TreePatternNode c2 : this.children) {
                map.putValue(new AW<TreePatternNode.Group>(c2.groups), (Object)c2);
            }
            if (map.size() == this.children.size()) {
                return;
            }
            ArrayList<TreePatternNode> newPos = new ArrayList<TreePatternNode>();
            for (Map.Entry entry : map.entrySet()) {
                if (((Collection)entry.getValue()).size() == 1) {
                    newPos.add((TreePatternNode)ContainerUtil.getFirstItem((Collection)((Collection)entry.getValue())));
                    continue;
                }
                TreePatternNode.BaseNaming[] merged = TreePatternUtils.merge((Iterable<? extends TreePatternNode.BaseNaming>)JBIterable.from((Iterable)((Iterable)entry.getValue())).map(x -> x.naming), false);
                if (merged == null) continue;
                for (TreePatternNode.BaseNaming naming : merged) {
                    newPos.add(new TreePatternNode(naming, (TreePatternNode.Group[])((AW)entry.getKey()).array));
                }
            }
            this.children.clear();
            this.children.addAll(newPos);
        }

        @NotNull
        public static GroupBuilder from(@Nullable TreePatternNode.Group g) {
            GroupBuilder builder = new GroupBuilder();
            if (g != null && g.children != null) {
                ContainerUtil.addAll(builder.children, (Object[])g.children);
            }
            GroupBuilder groupBuilder = builder;
            if (groupBuilder == null) {
                GroupBuilder.$$$reportNull$$$0(3);
            }
            return groupBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/TreePatternUtils$GroupBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/TreePatternUtils$GroupBuilder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "from";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "build";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static final class NodeBuilder {
        public final List<TreePatternNode.Group> groups = new SmartList();

        public NodeBuilder addGroup(@Nullable TreePatternNode.Group g) {
            if (g != null) {
                this.groups.add(g);
            }
            return this;
        }

        @NotNull
        public TreePatternNode build(TreePatternNode.BaseNaming naming) {
            return new TreePatternNode(naming, this.buildGroups());
        }

        public TreePatternNode.Group @Nullable [] buildGroupsOpt() {
            return this.groups.isEmpty() ? null : this.groups.toArray(new TreePatternNode.Group[0]);
        }

        public TreePatternNode.Group @NotNull [] buildGroups() {
            TreePatternNode.Group[] groupArray = (TreePatternNode.Group[])ObjectUtils.chooseNotNull((Object)this.buildGroupsOpt(), (Object)TreePatternNode.NO_GROUPS);
            if (groupArray == null) {
                NodeBuilder.$$$reportNull$$$0(0);
            }
            return groupArray;
        }

        @NotNull
        public static NodeBuilder from(@Nullable TreePatternNode node) {
            return NodeBuilder.from(node == null ? null : node.groups);
        }

        @NotNull
        public static NodeBuilder from(@Nullable TreePatternNode.Group[] groups) {
            NodeBuilder b = new NodeBuilder();
            if (groups != null) {
                ContainerUtil.addAll(b.groups, (Object[])groups);
            }
            NodeBuilder nodeBuilder = b;
            if (nodeBuilder == null) {
                NodeBuilder.$$$reportNull$$$0(1);
            }
            return nodeBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/util/TreePatternUtils$NodeBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildGroups";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "from";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

