/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.beans;

import com.intellij.cdi.beans.AbstractCdiBeanDescriptor;
import com.intellij.cdi.beans.CdiCustomizationManager;
import com.intellij.cdi.beans.CdiCustomizationProvider;
import com.intellij.cdi.beans.ProducerBeanDescriptor;
import com.intellij.cdi.manager.CdiDescriptorsFactory;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.javaee.constants.CdiAnnoConstants;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public abstract class CdiBeanPsiClassDescriptor
extends AbstractCdiBeanDescriptor<PsiClass> {
    private final PsiClass myPsiClass;

    protected CdiBeanPsiClassDescriptor(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiBeanPsiClassDescriptor.$$$reportNull$$$0(0);
        }
        this.myPsiClass = psiClass;
    }

    @Override
    @NotNull
    public PsiClass getAnnotatedItem() {
        PsiClass psiClass = this.myPsiClass;
        if (psiClass == null) {
            CdiBeanPsiClassDescriptor.$$$reportNull$$$0(1);
        }
        return psiClass;
    }

    @Override
    protected PsiClass getDefaultDeploymentType() {
        return this.getAnnotationClass(CdiAnnoConstants.PRODUCTION_ANNOTATION.fqn((PsiElement)this.myPsiClass));
    }

    @NotNull
    public List<PsiMethod> getInjectedConstructors() {
        CdiCustomizationProvider customization;
        PsiMethod[] constructors = this.getAnnotatedItem().getConstructors();
        if (constructors.length == 0) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                CdiBeanPsiClassDescriptor.$$$reportNull$$$0(2);
            }
            return list;
        }
        SmartList injectedConstructors = new SmartList();
        for (PsiMethod psiMethod : constructors) {
            if (!CdiAnnoConstants.INJECT_ANNOTATION.isAnnotated((PsiModifierListOwner)psiMethod, 1)) continue;
            injectedConstructors.add(psiMethod);
        }
        if (injectedConstructors.isEmpty() && (customization = CdiCustomizationManager.getCustomization((PsiElement)this.getAnnotatedItem())) != null && customization.isImplicitInjectionToConstructorEnabled()) {
            injectedConstructors.add(constructors[0]);
        }
        SmartList smartList = injectedConstructors;
        if (smartList == null) {
            CdiBeanPsiClassDescriptor.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    @NotNull
    public List<PsiMethod> getInjectedMethods() {
        PsiMethod[] methods = this.getAnnotatedItem().getAllMethods();
        if (methods.length == 0) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                CdiBeanPsiClassDescriptor.$$$reportNull$$$0(4);
            }
            return list;
        }
        ArrayList<PsiMethod> injectedMethods = new ArrayList<PsiMethod>();
        PsiClass annotatedItem = this.getAnnotatedItem();
        for (PsiMethod psiMethod : methods) {
            if (!CdiInjectionUtils.isInjectedMember(annotatedItem, (PsiModifierListOwner)psiMethod)) continue;
            injectedMethods.add(psiMethod);
        }
        ArrayList<PsiMethod> arrayList = injectedMethods;
        if (arrayList == null) {
            CdiBeanPsiClassDescriptor.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public @Unmodifiable List<ProducerBeanDescriptor<?>> getProducerDescriptors() {
        List list = ContainerUtil.mapNotNull(this.collectProducesPsiMembers(), psiMember -> CdiDescriptorsFactory.createProducerCdiBeanDescriptor(psiMember));
        if (list == null) {
            CdiBeanPsiClassDescriptor.$$$reportNull$$$0(6);
        }
        return list;
    }

    private List<PsiMember> collectProducesPsiMembers() {
        ArrayList<PsiMember> candidates = new ArrayList<PsiMember>();
        candidates.addAll(this.getProducerMethods());
        candidates.addAll(this.getProducerFields());
        return candidates;
    }

    public List<PsiMethod> getProducerMethods() {
        return CdiCommonUtils.getProducerMethods(this.getAnnotatedItem());
    }

    public List<PsiField> getProducerFields() {
        return CdiCommonUtils.getProducerFields(this.getAnnotatedItem());
    }

    @NotNull
    public List<PsiField> getInjectedFields() {
        PsiField[] fields = this.getAnnotatedItem().getFields();
        if (fields.length == 0) {
            List<PsiField> list = Collections.emptyList();
            if (list == null) {
                CdiBeanPsiClassDescriptor.$$$reportNull$$$0(7);
            }
            return list;
        }
        ArrayList<PsiField> injectedFields = new ArrayList<PsiField>();
        PsiClass annotatedItem = this.getAnnotatedItem();
        for (PsiField psiField : fields) {
            if (!CdiInjectionUtils.isInjectedMember(annotatedItem, (PsiModifierListOwner)psiField)) continue;
            injectedFields.add(psiField);
        }
        ArrayList<PsiField> arrayList = injectedFields;
        if (arrayList == null) {
            CdiBeanPsiClassDescriptor.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Override
    public boolean isDefault() {
        return CdiCustomizationManager.hasDefaultBeanAnnotation((PsiModifierListOwner)this.myPsiClass);
    }

    @Override
    public boolean isMock() {
        return CdiCustomizationManager.hasMockAnnotation((PsiModifierListOwner)this.myPsiClass);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CdiBeanPsiClassDescriptor)) {
            return false;
        }
        CdiBeanPsiClassDescriptor that = (CdiBeanPsiClassDescriptor)o;
        return Objects.equals(this.myPsiClass, that.myPsiClass);
    }

    public int hashCode() {
        return this.myPsiClass.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/beans/CdiBeanPsiClassDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/beans/CdiBeanPsiClassDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotatedItem";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedConstructors";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedMethods";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProducerDescriptors";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

