/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.ManagedBeanDescriptor;
import com.intellij.cdi.beans.ProducerBeanDescriptor;
import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.manager.CdiManager;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class CdiBeanDescriptorInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(@NotNull PsiClass aClass, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (aClass == null) {
            CdiBeanDescriptorInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            CdiBeanDescriptorInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            CdiBeanDescriptorInspection.$$$reportNull$$$0(2);
        }
        if (CdiCommonUtils.isManagedBean(aClass)) {
            Set<CdiBeanDescriptor<?>> descriptors = CdiManager.resolveBeanByClass(module, aClass, false, new PsiAnnotation[0]);
            for (CdiBeanDescriptor<?> descriptor : descriptors) {
                this.checkBeanDescriptor(descriptor, holder);
                if (!(descriptor instanceof ManagedBeanDescriptor)) continue;
                for (ProducerBeanDescriptor<?> producerBeanDescriptor : ((ManagedBeanDescriptor)descriptor).getProducerDescriptors()) {
                    this.checkBeanDescriptor(producerBeanDescriptor, holder);
                }
            }
        }
    }

    protected void checkBeanDescriptor(CdiBeanDescriptor<?> descriptor, ProblemsHolder holder) {
        if (descriptor instanceof ManagedBeanDescriptor) {
            this.checkManagedBean((ManagedBeanDescriptor)descriptor, holder);
        }
    }

    protected void checkManagedBean(ManagedBeanDescriptor descriptor, ProblemsHolder holder) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "aClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
        }
        objectArray[1] = "com/intellij/cdi/highlighting/CdiBeanDescriptorInspection";
        objectArray[2] = "checkClass";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

