/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.BeanNamesMapper;
import com.intellij.spring.contexts.model.BeansSpringModel;
import com.intellij.spring.contexts.model.CacheableCommonSpringModel;
import com.intellij.spring.contexts.model.Direction;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.LocalXmlModelIndexProcessor;
import com.intellij.spring.contexts.model.SpringComponentScanModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.dom.PlaceholderDomReferenceInjector;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.spring.impl.SpringLocalModelFactoryImpl;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.javaConfig.SpringJavaBean;
import com.intellij.spring.model.jam.javaConfig.SpringJavaConfiguration;
import com.intellij.spring.model.jam.javaConfig.SpringOldJavaConfigurationUtil;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.xml.AbstractDomSpringBean;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringImport;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScanBean;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalXmlModelImpl
extends LocalXmlModel {
    private volatile Collection<SpringBeanPointer<?>> myLocalXmlBeans;
    private final XmlFile myConfigFile;
    private final Module myModule;
    private final Set<String> myActiveProfiles;
    private final LocalXmlModelIndexProcessor myIndexProcessor;
    private final NotNullLazyValue<BeanNamesMapper> myLocalBeanNamesMapper;
    private final CachedValue<Set<SpringComponentScanModel<?>>> scannedModels;
    private final CachedValue<CommonSpringModel> javaConfigurationModel;
    private final CachedValue<CommonSpringModel> explicitlyDefinedBeansModel;
    private final CachedValue<List<SpringBeanPointer<?>>> myPlaceholders;
    private final Map<String, Collection<XmlTag>> myCustomBeanIdCandidates;
    private final CachedValue<Set<String>> myProfiles;
    private final CachedValue<List<SpringBeanPointer<?>>> myAnnotationConfigApplicationContexts;
    private final CachedValue<List<SpringBeansPackagesScan>> myComponentScanBeans;
    private final CachedValue<MultiMap<SpringBeanPointer<?>, SpringBeanPointer<?>>> myDirectInheritorsMap;
    private final Map<SpringQualifier, List<SpringBeanPointer<?>>> myLocalBeansByQualifier;
    private static final Key<CachedValue<Set<PsiClass>>> EXPLICIT_BEAN_CLASSES = Key.create((String)"explicitBeanClasses");

    public LocalXmlModelImpl(@NotNull XmlFile configFile, @NotNull Module module, @NotNull Set<String> activeProfiles) {
        if (configFile == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(0);
        }
        if (module == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(1);
        }
        if (activeProfiles == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(2);
        }
        this.myLocalBeanNamesMapper = NotNullLazyValue.volatileLazy(() -> new BeanNamesMapper(this));
        this.myConfigFile = configFile;
        this.myModule = module;
        this.myActiveProfiles = activeProfiles;
        this.myIndexProcessor = (LocalXmlModelIndexProcessor)CachedValuesManager.getCachedValue((PsiElement)this.myConfigFile, () -> LocalXmlModelImpl.createIndexProcessor(configFile));
        this.myCustomBeanIdCandidates = ConcurrentFactoryMap.createMap(key -> {
            if (!this.canProcessBeans()) {
                return Collections.emptyList();
            }
            return this.myIndexProcessor.getCustomBeanCandidates((String)key);
        });
        this.myLocalBeansByQualifier = ConcurrentFactoryMap.createMap(key -> LocalXmlModelImpl.findLocalBeansByQualifier((CacheableCommonSpringModel)this, (SpringQualifier)key));
        this.scannedModels = CachedValuesManager.getManager((Project)this.getModule().getProject()).createCachedValue(() -> CachedValueProvider.Result.create(this.getPackagesScans(this.myActiveProfiles).stream().map(scan -> new SpringComponentScanModel(this.myModule, scan, this.myActiveProfiles, true)).collect(Collectors.toSet()), (Object[])LocalXmlModelImpl.getOutsideModelDependencies((LocalModel)this)), false);
        this.myPlaceholders = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> CachedValueProvider.Result.create(this.computePlaceholders(), (Object[])LocalXmlModelImpl.getOutsideModelDependencies((LocalModel)this)), false);
        this.myProfiles = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> CachedValueProvider.Result.create(this.computeProfiles(), (Object[])LocalXmlModelImpl.getOutsideModelDependencies((LocalModel)this)), false);
        this.myAnnotationConfigApplicationContexts = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> CachedValueProvider.Result.create(this.computeAnnotationConfigApplicationContexts(), (Object[])LocalXmlModelImpl.getOutsideModelDependencies((LocalModel)this)), false);
        this.myComponentScanBeans = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> CachedValueProvider.Result.create(this.canProcessBeans() ? this.myIndexProcessor.getComponentScans() : Collections.emptyList(), (Object[])LocalXmlModelImpl.getOutsideModelDependencies((LocalModel)this)), false);
        this.myDirectInheritorsMap = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> CachedValueProvider.Result.create(this.computeDirectInheritorsMap(), (Object[])LocalXmlModelImpl.getOutsideModelDependencies((LocalModel)this)), false);
        this.javaConfigurationModel = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
            BeansSpringModel model = new BeansSpringModel(this.getModule(), NotNullLazyValue.lazy(() -> this.computeJavaConfigurations()));
            return CachedValueProvider.Result.create((Object)model, (Object[])LocalXmlModelImpl.getOutsideModelDependencies((LocalModel)this));
        }, false);
        this.explicitlyDefinedBeansModel = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
            BeansSpringModel model = new BeansSpringModel(this.getModule(), NotNullLazyValue.lazy(() -> this.computeExplicitlyDefinedBeans()));
            return CachedValueProvider.Result.create((Object)model, (Object[])LocalXmlModelImpl.getOutsideModelDependencies((LocalModel)this));
        }, false);
    }

    @NotNull
    private static CachedValueProvider.Result<LocalXmlModelIndexProcessor> createIndexProcessor(@NotNull XmlFile configFile) {
        if (configFile == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(3);
        }
        CachedValueProvider.Result result2 = CachedValueProvider.Result.create((Object)new LocalXmlModelIndexProcessor(configFile), (Object[])SpringLocalModelFactoryImpl.getLocalXmlModelDependencies(configFile));
        if (result2 == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(4);
        }
        return result2;
    }

    @Nullable
    public DomFileElement<Beans> getRoot() {
        return SpringDomUtils.getSpringDomFileElement((XmlFile)this.myConfigFile);
    }

    private Project getProject() {
        return this.myConfigFile.getProject();
    }

    @NotNull
    public XmlFile getConfig() {
        XmlFile xmlFile = this.myConfigFile;
        if (xmlFile == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(5);
        }
        return xmlFile;
    }

    public Collection<XmlTag> getCustomBeans(String id) {
        return this.myCustomBeanIdCandidates.get(id);
    }

    private BeanNamesMapper getLocalBeanNamesMapper() {
        return (BeanNamesMapper)this.myLocalBeanNamesMapper.getValue();
    }

    @NotNull
    public Set<String> getAllBeanNames(@NotNull SpringBeanPointer<?> beanPointer) {
        String beanName;
        if (beanPointer == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(6);
        }
        return StringUtil.isEmptyOrSpaces((String)(beanName = beanPointer.getName())) ? Collections.emptySet() : new HashSet<String>(this.getLocalBeanNamesMapper().getAllBeanNames(beanName));
    }

    public Collection<SpringBeanPointer<?>> getLocalBeans() {
        return this.myLocalXmlBeans == null ? (this.myLocalXmlBeans = this.calculateLocalXmlBeans()) : this.myLocalXmlBeans;
    }

    protected Collection<SpringBeanPointer<?>> calculateLocalXmlBeans() {
        ArrayList beans = new ArrayList();
        Processor processor2 = bean -> {
            beans.add(BeanService.getInstance().createSpringBeanPointer(bean));
            return true;
        };
        DomFileElement<Beans> element = this.getRoot();
        if (element != null) {
            this.processDomBeans((Beans)element.getRootElement(), (Processor<CommonSpringBean>)processor2);
        }
        return Collections.unmodifiableList(beans);
    }

    public Set<CommonSpringModel> getRelatedModels() {
        LinkedHashSet<CommonSpringModel> models = new LinkedHashSet<CommonSpringModel>();
        ContainerUtil.addAllNotNull(models, (Iterable)this.getDependentLocalModels().stream().map(pair -> (LocalModel)pair.first).collect(Collectors.toSet()));
        ContainerUtil.addAllNotNull(models, this.getCachedPackageScanModel());
        ContainerUtil.addAllNotNull(models, (Object[])new CommonSpringModel[]{this.getCustomDiscoveredBeansModel()});
        if (SpringCommonUtils.findLibraryClass((Module)this.getModule(), (String)"org.springframework.config.java.annotation.Configuration") != null) {
            ContainerUtil.addIfNotNull(models, (Object)this.getOldJavaConfigurationBeansModel());
        }
        if (LocalXmlModelImpl.isProcessExplicitlyDefinedAnnotatedBeans(this.getModule())) {
            ContainerUtil.addIfNotNull(models, (Object)this.getExplicitlyDefinedBeansModel());
        }
        return models;
    }

    private Set<SpringComponentScanModel<?>> getCachedPackageScanModel() {
        return (Set)this.scannedModels.getValue();
    }

    private CommonSpringModel getOldJavaConfigurationBeansModel() {
        return (CommonSpringModel)this.javaConfigurationModel.getValue();
    }

    private void processDomBeans(@NotNull Beans rootElement, Processor<CommonSpringBean> processor2) {
        if (rootElement == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(7);
        }
        if (SpringProfileUtils.isActiveProfile((Beans)rootElement, this.getActiveProfiles())) {
            SpringBeanUtils.getInstance().processChildBeans((DomElement)rootElement, false, processor2);
            for (Beans profile : rootElement.getBeansProfiles()) {
                this.processDomBeans(profile, processor2);
            }
        }
    }

    @NotNull
    public List<SpringBeanPointer<?>> getDescendantBeans(@NotNull SpringBeanPointer<?> pointer) {
        if (pointer == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(8);
        }
        HashSet visited = new HashSet();
        visited.add(pointer);
        MultiMap map = (MultiMap)this.myDirectInheritorsMap.getValue();
        LocalXmlModelImpl.addDescendants(map, pointer, visited);
        visited.remove(pointer);
        return new SmartList(visited);
    }

    private static void addDescendants(MultiMap<SpringBeanPointer<?>, SpringBeanPointer<?>> map, SpringBeanPointer<?> current, Set<SpringBeanPointer<?>> result2) {
        Collection pointers = map.get(current);
        for (SpringBeanPointer pointer : pointers) {
            if (!result2.add(pointer)) continue;
            LocalXmlModelImpl.addDescendants(map, pointer, result2);
        }
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(9);
        }
        return module;
    }

    @NotNull
    public List<SpringBeanPointer<?>> getPlaceholderConfigurerBeans() {
        List list = (List)this.myPlaceholders.getValue();
        if (list == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public List<SpringBeansPackagesScan> getPackagesScans() {
        List<SpringBeansPackagesScan> list = this.getPackagesScans(this.getActiveProfiles());
        if (list == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(11);
        }
        return list;
    }

    protected List<SpringBeansPackagesScan> getPackagesScans(@NotNull Set<String> activeProfiles) {
        if (activeProfiles == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(12);
        }
        List allComponentScans = (List)this.myComponentScanBeans.getValue();
        if (activeProfiles.isEmpty() || "_DEFAULT_TEST_PROFILE_NAME_".equals(ContainerUtil.getOnlyItem(activeProfiles))) {
            return allComponentScans;
        }
        return ContainerUtil.mapNotNull((Collection)allComponentScans, scan -> {
            if (scan instanceof DomSpringBean && LocalXmlModelImpl.isInActiveProfile((DomElement)((DomSpringBean)scan), activeProfiles)) {
                return scan;
            }
            return null;
        });
    }

    @NotNull
    public List<SpringBeanPointer<?>> getAnnotationConfigAppContexts() {
        List list = (List)this.myAnnotationConfigApplicationContexts.getValue();
        if (list == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public Set<String> getProfiles() {
        Set set = (Set)this.myProfiles.getValue();
        if (set == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(14);
        }
        return set;
    }

    @NotNull
    public Set<String> getActiveProfiles() {
        Set<String> set = this.myActiveProfiles;
        if (set == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(15);
        }
        return set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalXmlModel)) {
            return false;
        }
        LocalXmlModel model = (LocalXmlModel)o;
        if (!this.myConfigFile.equals((Object)model.getConfig())) {
            return false;
        }
        if (!this.myModule.equals((Object)model.getModule())) {
            return false;
        }
        return SpringProfileUtils.profilesAsString(this.myActiveProfiles).equals(SpringProfileUtils.profilesAsString((Set)model.getActiveProfiles()));
    }

    public int hashCode() {
        int result2 = this.myConfigFile.hashCode();
        result2 = 31 * result2 + this.myModule.hashCode();
        result2 = 31 * result2 + SpringProfileUtils.profilesAsString(this.myActiveProfiles).hashCode();
        return result2;
    }

    @NotNull
    public Direction traverseByClass(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<? super SpringBeanPointer<?>> processor2) {
        if (params == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(16);
        }
        if (processor2 == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(17);
        }
        if (!params.canSearch() || !this.canProcessBeans()) {
            Direction direction = Direction.PROCEED;
            if (direction == null) {
                LocalXmlModelImpl.$$$reportNull$$$0(18);
            }
            return direction;
        }
        if (!this.processLocalBeansByClass(params, processor2)) {
            Direction direction = Direction.STOP;
            if (direction == null) {
                LocalXmlModelImpl.$$$reportNull$$$0(19);
            }
            return direction;
        }
        Direction direction = Direction.TRAVERSE;
        if (direction == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(20);
        }
        return direction;
    }

    @NotNull
    public Direction traverseByName(@NotNull SpringModelSearchParameters.BeanName params, @NotNull Processor<? super SpringBeanPointer<?>> processor2) {
        if (params == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(21);
        }
        if (processor2 == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(22);
        }
        if (!this.processLocalBeansByName(params, processor2)) {
            Direction direction = Direction.STOP;
            if (direction == null) {
                LocalXmlModelImpl.$$$reportNull$$$0(23);
            }
            return direction;
        }
        Direction direction = Direction.TRAVERSE;
        if (direction == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(24);
        }
        return direction;
    }

    public boolean processLocalBeansByClass(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<? super SpringBeanPointer<?>> processor2) {
        if (params == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(25);
        }
        if (processor2 == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(26);
        }
        return this.processLocalBeansByClass(params, processor2, false);
    }

    @NotNull
    public Boolean processLocalBeansByClass(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<? super SpringBeanPointer<?>> processor2, boolean onlyPlainBeans) {
        if (params == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(27);
        }
        if (processor2 == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(28);
        }
        if (!params.canSearch() || !this.canProcessBeans()) {
            Boolean bl = true;
            if (bl == null) {
                LocalXmlModelImpl.$$$reportNull$$$0(29);
            }
            return bl;
        }
        Boolean bl = this.myIndexProcessor.processByClass(params, processor2, this.getActiveProfiles(), this.myModule, onlyPlainBeans);
        if (bl == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(30);
        }
        return bl;
    }

    public boolean processLocalBeansByName(@NotNull SpringModelSearchParameters.BeanName params, @NotNull Processor<? super SpringBeanPointer<?>> processor2) {
        if (params == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(31);
        }
        if (processor2 == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(32);
        }
        if (!params.canSearch() || !this.canProcessBeans()) {
            return true;
        }
        return this.myIndexProcessor.processByName(params, processor2, this.getActiveProfiles());
    }

    private boolean canProcessBeans() {
        DomFileElement<Beans> root = this.getRoot();
        return root != null && SpringProfileUtils.isActiveProfile((Beans)((Beans)root.getRootElement()), this.getActiveProfiles());
    }

    @NotNull
    public Set<Pair<LocalModel<?>, LocalModelDependency>> getDependentLocalModels() {
        Set<Pair<LocalModel<?>, LocalModelDependency>> set = LocalXmlModelImpl.getCachedDependentLocalModels(this);
        if (set == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(33);
        }
        return set;
    }

    private static Set<Pair<LocalModel<?>, LocalModelDependency>> getCachedDependentLocalModels(LocalXmlModelImpl model) {
        return (Set)CachedValuesManager.getManager((Project)model.getConfig().getProject()).getCachedValue((UserDataHolder)model, () -> {
            LinkedHashSet models = new LinkedHashSet();
            Set<String> profiles = model.getActiveProfiles();
            Module module = model.getModule();
            for (Map.Entry<XmlFile, LocalModelDependency> importedXml : LocalXmlModelImpl.getImports(model.getConfig(), profiles).entrySet()) {
                LocalXmlModelImpl.addNotNullModel(models, (LocalModel)SpringLocalModelFactory.getInstance().getOrCreateLocalXmlModel(importedXml.getKey(), module, profiles), (LocalModelDependency)importedXml.getValue());
            }
            for (SpringBeansPackagesScan packagesScan : model.getPackagesScans()) {
                if (!packagesScan.isValid()) continue;
                if (!(packagesScan instanceof SpringBeansPackagesScanBean)) {
                    throw new UnsupportedOperationException("not support " + String.valueOf(packagesScan));
                }
                SpringBeansPackagesScanBean domScan = (SpringBeansPackagesScanBean)packagesScan;
                String label = "<" + domScan.getXmlElementName() + " [" + domScan.getProviderName() + "] \"" + domScan.getBasePackage().getStringValue() + "\">";
                LocalModelDependency dependency = LocalModelDependency.create((String)label, (LocalModelDependencyType)LocalModelDependencyType.COMPONENT_SCAN, (DomElement)domScan);
                Set beans = packagesScan.getScannedElements(module, true);
                for (CommonSpringBean bean : beans) {
                    PsiClass psiClass;
                    if (!(bean instanceof SpringStereotypeElement)) continue;
                    SpringStereotypeElement stereotypeElement = (SpringStereotypeElement)bean;
                    if (!bean.isValid() || !SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)(psiClass = stereotypeElement.getPsiElement())) || JamService.getJamService((Project)psiClass.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, (PsiElement)psiClass) == null || !SpringProfileUtils.isInActiveProfiles((CommonSpringBean)stereotypeElement, profiles)) continue;
                    LocalXmlModelImpl.addNotNullModel(models, (LocalModel)SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(psiClass, module, profiles), (LocalModelDependency)dependency);
                }
            }
            LinkedHashSet dependencies = new LinkedHashSet();
            ContainerUtil.addAll(dependencies, (Object[])LocalXmlModelImpl.getOutsideModelDependencies((LocalModel)model));
            dependencies.addAll(models.stream().map(pair -> ((LocalModel)pair.first).getConfig()).collect(Collectors.toSet()));
            return CachedValueProvider.Result.create(models, (Object[])ArrayUtil.toObjectArray(dependencies));
        });
    }

    private static Map<XmlFile, LocalModelDependency> getImports(@NotNull XmlFile file, @Nullable Set<String> activeProfiles) {
        if (file == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(34);
        }
        LinkedHashMap<XmlFile, LocalModelDependency> includes = new LinkedHashMap<XmlFile, LocalModelDependency>();
        DomFileElement beans = SpringDomUtils.getSpringDomFileElement((XmlFile)file);
        if (beans != null) {
            LocalXmlModelImpl.processLocalImports(includes, (Beans)beans.getRootElement(), activeProfiles);
        }
        includes.remove(file);
        return includes;
    }

    private static void processLocalImports(Map<XmlFile, LocalModelDependency> includes, Beans beans, @Nullable Set<String> activeProfiles) {
        for (SpringImport springImport : beans.getImports()) {
            Set psiFiles = (Set)springImport.getResource().getValue();
            if (psiFiles == null) continue;
            for (PsiFile psiFile : psiFiles) {
                XmlFile xmlFile;
                if (!(psiFile instanceof XmlFile) || includes.containsKey(xmlFile = (XmlFile)psiFile) || !SpringDomUtils.isSpringXml((XmlFile)xmlFile)) continue;
                DomFileElement fileElement = SpringDomUtils.getSpringDomFileElement((XmlFile)xmlFile);
                assert (fileElement != null) : psiFile;
                Beans child = (Beans)fileElement.getRootElement();
                if (activeProfiles != null && !SpringProfileUtils.isActiveProfile((Beans)child, activeProfiles)) continue;
                String label = "<import resource=\"" + springImport.getResource().getStringValue() + "/>";
                includes.put(xmlFile, LocalModelDependency.create((String)label, (LocalModelDependencyType)LocalModelDependencyType.IMPORT, (DomElement)springImport));
            }
        }
        for (Beans beanProfiles : beans.getBeansProfiles()) {
            if (activeProfiles != null && !SpringProfileUtils.isActiveProfile((Beans)beanProfiles, activeProfiles)) continue;
            LocalXmlModelImpl.processLocalImports(includes, beanProfiles, activeProfiles);
        }
    }

    private CommonSpringModel getExplicitlyDefinedBeansModel() {
        return (CommonSpringModel)this.explicitlyDefinedBeansModel.getValue();
    }

    private static boolean isProcessExplicitlyDefinedAnnotatedBeans(@NotNull Module module) {
        SpringFacet springFacet;
        if (module == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(35);
        }
        if ((springFacet = SpringFacet.getInstance((Module)module)) == null) {
            return true;
        }
        CustomSetting.BOOLEAN setting = (CustomSetting.BOOLEAN)springFacet.findSetting(PROCESS_EXPLICITLY_ANNOTATED);
        return setting == null || setting.getBooleanValue();
    }

    @NotNull
    private Collection<? extends SpringBeanPointer<?>> computeExplicitlyDefinedBeans() {
        LinkedHashSet explicitBeans = new LinkedHashSet();
        Module module = this.getModule();
        if (LocalXmlModelImpl.isProcessExplicitlyDefinedAnnotatedBeans(module)) {
            for (PsiClass explicitBeanClass : LocalXmlModelImpl.getExplicitBeanCandidatePsiClasses(module)) {
                if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)explicitBeanClass)) continue;
                SpringModelSearchParameters.BeanClass candidateClassParams = SpringModelSearchParameters.byClass((PsiClass)explicitBeanClass).effectiveBeanTypes();
                CommonProcessors.FindFirstProcessor findFirstProcessor = new CommonProcessors.FindFirstProcessor();
                this.myIndexProcessor.processByClass(candidateClassParams, (Processor<? super SpringBeanPointer<?>>)findFirstProcessor, this.getActiveProfiles(), this.myModule, true);
                if (!findFirstProcessor.isFound()) continue;
                explicitBeans.addAll(SpringJamUtils.getInstance().getContextBeans(explicitBeanClass, Collections.emptySet()));
            }
        }
        Set set = BeanService.getInstance().mapSpringBeans(explicitBeans);
        if (set == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(36);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<SpringBeanPointer<?>> computePlaceholders() {
        SmartList result2 = new SmartList();
        try {
            PlaceholderDomReferenceInjector.IS_COMPUTING.set(true);
            DomFileElement<Beans> element = this.getRoot();
            if (element != null) {
                CommonProcessors.CollectProcessor<CommonSpringBean> processor2 = new CommonProcessors.CollectProcessor<CommonSpringBean>((List)result2){
                    final /* synthetic */ List val$result;
                    {
                        this.val$result = list;
                    }

                    public boolean process(CommonSpringBean bean) {
                        PsiClass psiClass;
                        String className;
                        if (bean instanceof AbstractDomSpringBean && (className = ((AbstractDomSpringBean)bean).getClassName()) != null && InheritanceUtil.isInheritor((PsiClass)(psiClass = DomJavaUtil.findClass((String)className.trim(), (PsiFile)LocalXmlModelImpl.this.getConfig(), (Module)LocalXmlModelImpl.this.getModule(), null)), (String)"org.springframework.core.io.support.PropertiesLoaderSupport")) {
                            this.val$result.add(BeanService.getInstance().createSpringBeanPointer(bean));
                        }
                        return true;
                    }
                };
                this.processDomBeans((Beans)element.getRootElement(), (Processor<CommonSpringBean>)processor2);
            }
        }
        finally {
            PlaceholderDomReferenceInjector.IS_COMPUTING.set(false);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(37);
        }
        return smartList;
    }

    @NotNull
    private List<SpringBeanPointer<?>> computeAnnotationConfigApplicationContexts() {
        if (!this.canProcessBeans()) {
            List<SpringBeanPointer<?>> list = Collections.emptyList();
            if (list == null) {
                LocalXmlModelImpl.$$$reportNull$$$0(38);
            }
            return list;
        }
        PsiClass annotationConfigAppContext = SpringCommonUtils.findLibraryClass((Module)this.myModule, (String)"org.springframework.context.annotation.AnnotationConfigApplicationContext");
        if (annotationConfigAppContext == null) {
            List<SpringBeanPointer<?>> list = Collections.emptyList();
            if (list == null) {
                LocalXmlModelImpl.$$$reportNull$$$0(39);
            }
            return list;
        }
        SmartList result2 = new SmartList();
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor<SpringBeanPointer<?>>(this, (Collection)result2){

            public boolean process(SpringBeanPointer pointer) {
                ProgressManager.checkCanceled();
                return super.process((Object)pointer);
            }

            protected boolean accept(SpringBeanPointer pointer) {
                return pointer.getSpringBean() instanceof SpringBean;
            }
        };
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)annotationConfigAppContext).withInheritors();
        this.myIndexProcessor.processByClass(searchParameters, (Processor<? super SpringBeanPointer<?>>)processor2, this.getActiveProfiles(), this.myModule, true);
        SmartList smartList = result2;
        if (smartList == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(40);
        }
        return smartList;
    }

    @NotNull
    private MultiMap<SpringBeanPointer<?>, SpringBeanPointer<?>> computeDirectInheritorsMap() {
        MultiMap map = new MultiMap(new ConcurrentHashMap());
        for (SpringBeanPointer<?> pointer : this.getLocalBeans()) {
            SpringBeanPointer parentPointer = pointer.getParentPointer();
            if (parentPointer == null) continue;
            map.putValue((Object)parentPointer.getBasePointer(), pointer);
        }
        MultiMap multiMap = map;
        if (multiMap == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(41);
        }
        return multiMap;
    }

    @NotNull
    private Collection<? extends SpringBeanPointer<?>> computeJavaConfigurations() {
        LinkedHashSet<SpringBeanPointer> pointers = new LinkedHashSet<SpringBeanPointer>();
        for (SpringJavaConfiguration javaConfiguration : SpringOldJavaConfigurationUtil.getJavaConfigurations((Module)this.myModule)) {
            for (SpringJavaBean javaBean : javaConfiguration.getBeans()) {
                if (!javaBean.isPublic()) continue;
                pointers.add(BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)javaBean));
            }
        }
        LinkedHashSet<SpringBeanPointer> linkedHashSet = pointers;
        if (linkedHashSet == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(42);
        }
        return linkedHashSet;
    }

    @NotNull
    private Set<String> computeProfiles() {
        DomFileElement<Beans> element = this.getRoot();
        return element == null ? Collections.emptySet() : LocalXmlModelImpl.getAllProfiles((Beans)element.getRootElement());
    }

    @NotNull
    public List<SpringBeanPointer<?>> findQualified(@NotNull SpringQualifier qualifier) {
        if (qualifier == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(43);
        }
        List<SpringBeanPointer<?>> list = this.myLocalBeansByQualifier.get(qualifier);
        if (list == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(44);
        }
        return list;
    }

    @NotNull
    private static Set<String> getAllProfiles(@Nullable Beans beans) {
        LinkedHashSet<String> names2 = new LinkedHashSet<String>();
        LocalXmlModelImpl.processProfiles(beans, (Processor<? super Beans>)((Processor)nestedBeans -> {
            names2.addAll(nestedBeans.getProfile().getNames());
            return true;
        }));
        LinkedHashSet<String> linkedHashSet = names2;
        if (linkedHashSet == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(45);
        }
        return linkedHashSet;
    }

    private static boolean processProfiles(@Nullable Beans beans, @NotNull Processor<? super Beans> processor2) {
        if (processor2 == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(46);
        }
        if (beans != null) {
            if (!processor2.process((Object)beans)) {
                return false;
            }
            for (Beans childrenBeans : beans.getBeansProfiles()) {
                if (LocalXmlModelImpl.processProfiles(childrenBeans, processor2)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isInActiveProfile(@NotNull DomElement domElement, @NotNull Set<String> profiles) {
        Beans beans;
        if (domElement == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(47);
        }
        if (profiles == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(48);
        }
        return (beans = (Beans)DomUtil.getParentOfType((DomElement)domElement, Beans.class, (boolean)true)) == null || SpringProfileUtils.isActiveProfile((Beans)beans, profiles);
    }

    @NotNull
    private static Set<PsiClass> getExplicitBeanCandidatePsiClasses(@NotNull Module module) {
        if (module == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(49);
        }
        Set set = (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, EXPLICIT_BEAN_CLASSES, () -> {
            PsiClass annotationClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.context.annotation.Bean");
            Object[] outerModelsDependencies = SpringModificationTrackersManager.getInstance((Project)module.getProject()).getOuterModelsDependencies();
            if (annotationClass == null) {
                return CachedValueProvider.Result.create(Collections.emptySet(), (Object[])outerModelsDependencies);
            }
            LinkedHashSet psiClasses = new LinkedHashSet();
            Query annotatedMethods = AnnotatedElementsSearch.searchPsiMethods((PsiClass)annotationClass, (SearchScope)SpringGlobalSearchScopes.runtime((Module)module));
            for (PsiMember member : annotatedMethods.findAll()) {
                PsiClass containingClass = member.getContainingClass();
                if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)containingClass)) continue;
                ContainerUtil.addIfNotNull(psiClasses, (Object)containingClass);
            }
            LinkedHashSet dependencies = new LinkedHashSet();
            ContainerUtil.addAll(dependencies, (Object[])outerModelsDependencies);
            dependencies.addAll(psiClasses.stream().filter(psiClass -> !(psiClass instanceof ClsClassImpl)).collect(Collectors.toSet()));
            return CachedValueProvider.Result.create(psiClasses, (Object[])ArrayUtil.toObjectArray(dependencies));
        }, false);
        if (set == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(50);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 9, 10, 11, 13, 14, 15, 18, 19, 20, 23, 24, 29, 30, 33, 36, 37, 38, 39, 40, 41, 42, 44, 45, 50 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 1: 
            case 35: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/LocalXmlModelImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanPointer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 16: 
            case 21: 
            case 25: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 17: 
            case 22: 
            case 26: 
            case 28: 
            case 32: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domElement";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/LocalXmlModelImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createIndexProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholderConfigurerBeans";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagesScans";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationConfigAppContexts";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfiles";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveProfiles";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "traverseByClass";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "traverseByName";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "processLocalBeansByClass";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentLocalModels";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "computeExplicitlyDefinedBeans";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "computePlaceholders";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAnnotationConfigApplicationContexts";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDirectInheritorsMap";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "computeJavaConfigurations";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "findQualified";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProfiles";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitBeanCandidatePsiClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createIndexProcessor";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 50: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllBeanNames";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processDomBeans";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDescendantBeans";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPackagesScans";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "traverseByClass";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "traverseByName";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processLocalBeansByClass";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processLocalBeansByName";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getImports";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isProcessExplicitlyDefinedAnnotatedBeans";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findQualified";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "processProfiles";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isInActiveProfile";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitBeanCandidatePsiClasses";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 9, 10, 11, 13, 14, 15, 18, 19, 20, 23, 24, 29, 30, 33, 36, 37, 38, 39, 40, 41, 42, 44, 45, 50 -> new IllegalStateException(string);
        };
    }
}

