/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.gutter;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.facet.Facet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.gutter.BeanClassLineMarker;
import com.intellij.spring.gutter.groups.SpringGroupMergeableLineMarkerInfo;
import com.intellij.spring.impl.SpringAutoConfiguredModels;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import java.awt.event.MouseEvent;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationKt;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\f0\u000bH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/spring/gutter/SpringClassFilesetLineMarker;", "Lcom/intellij/spring/gutter/BeanClassLineMarker;", "<init>", "()V", "annotate", "", "psiClass", "Lcom/intellij/psi/PsiClass;", "psiElement", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "createFilesetGutter", "Lcom/intellij/spring/gutter/groups/SpringGroupMergeableLineMarkerInfo;", "filesetResult", "Lcom/intellij/spring/facet/SpringFileSet;", "createNavigationHandler", "Lcom/intellij/codeInsight/daemon/GutterIconNavigationHandler;", "facet", "Lcom/intellij/spring/facet/SpringFacet;", "getFileset", "psiFile", "Lcom/intellij/psi/PsiFile;", "module", "Lcom/intellij/openapi/module/Module;", "intellij.spring.core"})
public final class SpringClassFilesetLineMarker
implements BeanClassLineMarker {
    public void annotate(@NotNull PsiClass psiClass, @NotNull PsiElement psiElement, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (!SpringCommonUtils.isConfigurationOrMeta((PsiClass)psiClass)) {
            return;
        }
        if (!SpringFacet.exists((Project)psiClass.getProject())) {
            return;
        }
        PsiFile psiFile = psiClass.getContainingFile();
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiFile2));
        if (module == null) {
            return;
        }
        Module module2 = module;
        SpringFileSet springFileSet = this.getFileset(psiFile2, module2);
        if (springFileSet == null) {
            return;
        }
        SpringFileSet filesetResult = springFileSet;
        UAnnotation uAnnotation = (UAnnotation)UastContextKt.toUElement((PsiElement)((PsiElement)AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiModifierListOwner)psiClass), (Collection)SpringAutoConfiguredModels.bootAnnotations)), UAnnotation.class);
        Object anno = uAnnotation != null ? UAnnotationKt.getNamePsiElement((UAnnotation)uAnnotation) : null;
        PsiElement psiElement2 = anno;
        if (psiElement2 == null) {
            psiElement2 = psiElement;
        }
        result2.add((LineMarkerInfo<?>)this.createFilesetGutter(psiElement2, filesetResult));
    }

    private final SpringGroupMergeableLineMarkerInfo createFilesetGutter(PsiElement psiElement, SpringFileSet filesetResult) {
        TextRange textRange = psiElement.getTextRange();
        Function function = (Function)new ConstantFunction((Object)SpringBundle.message("navigate.to.fileset.configuration", new Object[0]));
        SpringFacet springFacet = filesetResult.getFacet();
        Intrinsics.checkNotNullExpressionValue((Object)springFacet, (String)"getFacet(...)");
        return new SpringGroupMergeableLineMarkerInfo(psiElement, textRange, SpringApiIcons.Gutter.SpringConfig, function, this.createNavigationHandler(springFacet));
    }

    private final GutterIconNavigationHandler<PsiElement> createNavigationHandler(SpringFacet facet) {
        return (arg_0, arg_1) -> SpringClassFilesetLineMarker.createNavigationHandler$lambda$0(facet, arg_0, arg_1);
    }

    private final SpringFileSet getFileset(PsiFile psiFile, Module module) {
        Ref ref = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
        Ref filesetResult = ref;
        ModuleUtilCore.visitMeAndDependentModules((Module)module, arg_0 -> SpringClassFilesetLineMarker.getFileset$lambda$0(module, psiFile, filesetResult, arg_0));
        return (SpringFileSet)filesetResult.get();
    }

    private static final void createNavigationHandler$lambda$0(SpringFacet $facet, MouseEvent mouseEvent, PsiElement psiElement) {
        ModulesConfigurator.showFacetSettingsDialog((Facet)((Facet)$facet), null);
    }

    private static final boolean getFileset$lambda$0(Module $module, PsiFile $psiFile, Ref<SpringFileSet> filesetResult, Module module) {
        SpringFacet springFacet = SpringFacet.getInstance((Module)$module);
        if (springFacet == null) {
            return true;
        }
        SpringFacet springFacet2 = springFacet;
        VirtualFile virtualFile = $psiFile.getVirtualFile();
        for (SpringFileSet fileSet : SpringFileSetService.getInstance().getAllSets(springFacet2)) {
            if (!fileSet.hasFile(virtualFile)) continue;
            filesetResult.set((Object)fileSet);
            return false;
        }
        return true;
    }
}

