/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.utils.filters;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.filters.SpringContextFilter;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringContextIncludeRegexFilter
extends SpringContextFilter.IncludeExpression {
    public SpringContextIncludeRegexFilter(@Nullable String expression) {
        super(expression);
    }

    @NotNull
    public Set<SpringStereotypeElement> includeStereotypes(@NotNull Module module, @NotNull Set<PsiPackage> packages) {
        if (module == null) {
            SpringContextIncludeRegexFilter.$$$reportNull$$$0(0);
        }
        if (packages == null) {
            SpringContextIncludeRegexFilter.$$$reportNull$$$0(1);
        }
        LinkedHashSet<SpringStereotypeElement> components = new LinkedHashSet<SpringStereotypeElement>();
        String regexp = this.getExpression();
        if (!StringUtil.isEmptyOrSpaces((String)regexp)) {
            try {
                Pattern pattern = Pattern.compile(regexp);
                GlobalSearchScope searchScope = SpringGlobalSearchScopes.runtime((Module)module);
                for (PsiClass annotatedClass : SpringContextIncludeRegexFilter.findClassesByMask(searchScope, pattern, packages)) {
                    components.add((SpringStereotypeElement)new CustomSpringComponent(annotatedClass));
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        LinkedHashSet<SpringStereotypeElement> linkedHashSet = components;
        if (linkedHashSet == null) {
            SpringContextIncludeRegexFilter.$$$reportNull$$$0(2);
        }
        return linkedHashSet;
    }

    private static Set<PsiClass> findClassesByMask(GlobalSearchScope searchScope, @NotNull Pattern pattern, @NotNull Set<PsiPackage> packages) {
        if (pattern == null) {
            SpringContextIncludeRegexFilter.$$$reportNull$$$0(3);
        }
        if (packages == null) {
            SpringContextIncludeRegexFilter.$$$reportNull$$$0(4);
        }
        LinkedHashSet<PsiClass> classes = new LinkedHashSet<PsiClass>();
        for (PsiPackage psiPackage : packages) {
            SpringContextIncludeRegexFilter.findClassesByMask(searchScope, pattern, classes, psiPackage);
        }
        return classes;
    }

    private static void findClassesByMask(@NotNull GlobalSearchScope searchScope, @NotNull Pattern pattern, @NotNull Set<PsiClass> classes, @NotNull PsiPackage psiPackage) {
        if (searchScope == null) {
            SpringContextIncludeRegexFilter.$$$reportNull$$$0(5);
        }
        if (pattern == null) {
            SpringContextIncludeRegexFilter.$$$reportNull$$$0(6);
        }
        if (classes == null) {
            SpringContextIncludeRegexFilter.$$$reportNull$$$0(7);
        }
        if (psiPackage == null) {
            SpringContextIncludeRegexFilter.$$$reportNull$$$0(8);
        }
        for (PsiClass psiClass : psiPackage.getClasses(searchScope)) {
            String fqn = psiClass.getQualifiedName();
            if (fqn == null || !pattern.matcher(fqn).matches()) continue;
            classes.add(psiClass);
        }
        for (PsiClass psiClass : psiPackage.getSubPackages(searchScope)) {
            SpringContextIncludeRegexFilter.findClassesByMask(searchScope, pattern, classes, (PsiPackage)psiClass);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeRegexFilter";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeRegexFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "includeStereotypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "includeStereotypes";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findClassesByMask";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

