/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.refactoring;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.refactoring.SpringUpdateSchemaIntention;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.xml.XmlNamespaceHelper;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class UsePNamespaceIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = SpringBundle.message("use.p.namespace", new Object[0]);
        if (string == null) {
            UsePNamespaceIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            UsePNamespaceIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            UsePNamespaceIntention.$$$reportNull$$$0(2);
        }
        if (!(psiFile instanceof XmlFile)) {
            return false;
        }
        if (psiFile instanceof JspFile) {
            return false;
        }
        SpringProperty property = (SpringProperty)DomUtil.getContextElement((Editor)editor, SpringProperty.class);
        return property != null && property.getParent() instanceof SpringBean && property.getName().getStringValue() != null && (property.getValueElement() != null && DomUtil.hasXml((DomElement)property.getValueElement()) || property.getRefElement() != null && DomUtil.hasXml((DomElement)property.getRefElement()));
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            UsePNamespaceIntention.$$$reportNull$$$0(3);
        }
        if (SpringUpdateSchemaIntention.requestSchemaUpdate((XmlFile)psiFile)) {
            String ref;
            SpringProperty property = (SpringProperty)DomUtil.getContextElement((Editor)editor, SpringProperty.class);
            assert (property != null);
            if (property.getXmlTag().getNamespaceByPrefix("p").equals("")) {
                XmlNamespaceHelper.getHelper((PsiFile)psiFile).insertNamespaceDeclaration((XmlFile)psiFile, editor, Collections.singleton("http://www.springframework.org/schema/p"), "p", null);
            }
            SpringBean bean = (SpringBean)property.getParent();
            assert (bean != null);
            String name = property.getName().getStringValue();
            GenericDomValue valueElement = property.getValueElement();
            String value = valueElement == null ? null : valueElement.getRawText();
            XmlTag tag = bean.getXmlTag();
            if (value != null) {
                property.undefine();
                XmlAttribute attribute = XmlElementFactory.getInstance((Project)project).createXmlAttribute("p:" + name, value);
                tag.add((PsiElement)attribute);
                tag.collapseIfEmpty();
                return;
            }
            GenericDomValue refElement = property.getRefElement();
            String string = ref = refElement == null ? null : refElement.getRawText();
            if (ref != null) {
                property.undefine();
                XmlAttribute attribute = XmlElementFactory.getInstance((Project)project).createXmlAttribute("p:" + name + "-ref", ref);
                tag.add((PsiElement)attribute);
                tag.collapseIfEmpty();
            }
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/refactoring/UsePNamespaceIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/refactoring/UsePNamespaceIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

