/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.mongodb.json.highlighting;

import com.intellij.icons.AllIcons;
import com.intellij.json.JsonBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.RainbowColorSettingsPage;
import com.intellij.persistence.PersistenceBundle;
import com.intellij.persistence.mongodb.json.MongoDBJsonLanguage;
import com.intellij.persistence.mongodb.json.highlighting.MongoDBJsonSyntaxHighlighterFactoryKt;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0013\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fH\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\nH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\rH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lcom/intellij/persistence/mongodb/json/highlighting/MongoDBJsonColorsPage;", "Lcom/intellij/openapi/options/colors/RainbowColorSettingsPage;", "Lcom/intellij/psi/codeStyle/DisplayPrioritySortable;", "<init>", "()V", "getIcon", "Ljavax/swing/Icon;", "getHighlighter", "Lcom/intellij/openapi/fileTypes/SyntaxHighlighter;", "getDemoText", "", "getAdditionalHighlightingTagToDescriptorMap", "", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getAttributeDescriptors", "", "Lcom/intellij/openapi/options/colors/AttributesDescriptor;", "()[Lcom/intellij/openapi/options/colors/AttributesDescriptor;", "getColorDescriptors", "Lcom/intellij/openapi/options/colors/ColorDescriptor;", "()[Lcom/intellij/openapi/options/colors/ColorDescriptor;", "getDisplayName", "getPriority", "Lcom/intellij/psi/codeStyle/DisplayPriority;", "isRainbowType", "", "type", "getLanguage", "Lcom/intellij/lang/Language;", "attributeDescriptors", "[Lcom/intellij/openapi/options/colors/AttributesDescriptor;", "intellij.javaee.persistence.impl"})
public final class MongoDBJsonColorsPage
implements RainbowColorSettingsPage,
DisplayPrioritySortable {
    @NotNull
    private final AttributesDescriptor[] attributeDescriptors;

    public MongoDBJsonColorsPage() {
        AttributesDescriptor[] attributesDescriptorArray = new AttributesDescriptor[]{new AttributesDescriptor(JsonBundle.messagePointer((String)"color.page.attribute.property.key", (Object[])new Object[0]), MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_PROPERTY_KEY()), new AttributesDescriptor(JsonBundle.messagePointer((String)"color.page.attribute.braces", (Object[])new Object[0]), MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_BRACES()), new AttributesDescriptor(JsonBundle.messagePointer((String)"color.page.attribute.brackets", (Object[])new Object[0]), MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_BRACKETS()), new AttributesDescriptor(JsonBundle.messagePointer((String)"color.page.attribute.comma", (Object[])new Object[0]), MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_COMMA()), new AttributesDescriptor(JsonBundle.messagePointer((String)"color.page.attribute.colon", (Object[])new Object[0]), MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_COLON()), new AttributesDescriptor(JsonBundle.messagePointer((String)"color.page.attribute.number", (Object[])new Object[0]), MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_NUMBER()), new AttributesDescriptor(JsonBundle.messagePointer((String)"color.page.attribute.string", (Object[])new Object[0]), MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_STRING()), new AttributesDescriptor(JsonBundle.messagePointer((String)"color.page.attribute.keyword", (Object[])new Object[0]), MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_KEYWORD()), new AttributesDescriptor(JsonBundle.messagePointer((String)"color.page.attribute.line.comment", (Object[])new Object[0]), MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_LINE_COMMENT()), new AttributesDescriptor(JsonBundle.messagePointer((String)"color.page.attribute.block.comment", (Object[])new Object[0]), MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_BLOCK_COMMENT()), new AttributesDescriptor(JsonBundle.messagePointer((String)"color.page.attribute.valid.escape.sequence", (Object[])new Object[0]), MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_VALID_ESCAPE()), new AttributesDescriptor(JsonBundle.messagePointer((String)"color.page.attribute.invalid.escape.sequence", (Object[])new Object[0]), MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_INVALID_ESCAPE()), new AttributesDescriptor(JsonBundle.messagePointer((String)"color.page.attribute.parameter", (Object[])new Object[0]), MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_PARAMETER())};
        this.attributeDescriptors = attributesDescriptorArray;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.FileTypes.Json;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Json");
        return icon;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)MongoDBJsonLanguage.Companion.getINSTANCE(), null, null);
        Intrinsics.checkNotNullExpressionValue((Object)syntaxHighlighter, (String)"getSyntaxHighlighter(...)");
        return syntaxHighlighter;
    }

    @NotNull
    public String getDemoText() {
        return "      {\n        // Line comments are not included in standard but nonetheless allowed.\n        /* As well as block comments. */\n        <propertyKey>\"the only keywords are\"</propertyKey>: [true, false, null],\n        <propertyKey>\"strings with\"</propertyKey>: {\n          <propertyKey>\"no escapes\"</propertyKey>: \"pseudopolinomiality\"\n          <propertyKey>\"valid escapes\"</propertyKey>: \"C-style\\\n\\\n           and unicode\\u0021\",\n          <propertyKey>\"illegal escapes\"</propertyKey>: \"\\0377\\x\\\"\n        },\n        <propertyKey>\"some numbers\"</propertyKey>: [\n          42,\n          -0.0e-0,\n          6.626e-34\n        ] \n      }";
    }

    @NotNull
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"propertyKey", (Object)MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_PROPERTY_KEY()));
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        return this.attributeDescriptors;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        Intrinsics.checkNotNullExpressionValue((Object)ColorDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public String getDisplayName() {
        String string = PersistenceBundle.message("mongodb.json", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public DisplayPriority getPriority() {
        return DisplayPriority.LANGUAGE_SETTINGS;
    }

    public boolean isRainbowType(@NotNull TextAttributesKey type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return Intrinsics.areEqual((Object)MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_PROPERTY_KEY(), (Object)type) || Intrinsics.areEqual((Object)MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_BRACES(), (Object)type) || Intrinsics.areEqual((Object)MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_BRACKETS(), (Object)type) || Intrinsics.areEqual((Object)MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_STRING(), (Object)type) || Intrinsics.areEqual((Object)MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_NUMBER(), (Object)type) || Intrinsics.areEqual((Object)MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_KEYWORD(), (Object)type);
    }

    @NotNull
    public Language getLanguage() {
        return MongoDBJsonLanguage.Companion.getINSTANCE();
    }
}

