/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.model.common;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.jam.JamElement;
import com.intellij.jam.JavaJamBundle;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.CommonModelManager;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.view.DeleteHandler;
import com.intellij.jam.view.JamDeleteHandler;
import com.intellij.jam.view.JamUserResponse;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.ModelMergerUtil;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

final class CommonModelManagerImpl
extends CommonModelManager {
    private static final ExtensionPointName<JamDeleteHandler> EP_NAME = new ExtensionPointName("com.intellij.jamDeleteHandler");
    private final Map<Class<? extends CommonModelElement>, JamDeleteHandler> myHandlersMap = new HashMap<Class<? extends CommonModelElement>, JamDeleteHandler>();

    CommonModelManagerImpl() {
    }

    @Nullable
    public <T extends DomElement> T getDomElement(CommonModelElement element) {
        return (T)((DomElement)ModelMergerUtil.getImplementation((Object)element, DomElement.class));
    }

    public void deleteModelElement(CommonModelElement element, JamUserResponse response) {
        this.deleteModelElements(Collections.singletonList(element), response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteModelElements(Collection<? extends CommonModelElement> elements, JamUserResponse response) {
        String string;
        HashSet<CommonModelElement> modelElements = new HashSet<CommonModelElement>();
        for (CommonModelElement commonModelElement : elements) {
            if (commonModelElement == null || !commonModelElement.isValid()) continue;
            modelElements.add(commonModelElement);
        }
        if (modelElements.isEmpty()) {
            return;
        }
        CommonModelElement firstElement = elements.iterator().next();
        String string2 = string = elements.size() == 1 ? JamCommonUtil.getDisplayName((Object)firstElement) : JavaJamBundle.message((String)"model.delete.items", (Object[])new Object[0]);
        if (!CommonModelManagerImpl.confirmDeletion(string, response)) {
            return;
        }
        this.addModelElements(modelElements);
        ArrayList<? extends PsiElement> psiElements = new ArrayList<PsiElement>(this.addPsiElements(modelElements));
        if (psiElements.size() > modelElements.size()) {
            ArrayList elements1 = new ArrayList(response.askUserToDeletePsiElements(psiElements, string));
            if (elements1.isEmpty()) {
                return;
            }
            psiElements.clear();
            psiElements.addAll(elements1);
        }
        Project project = firstElement.getPsiManager().getProject();
        String name = JavaJamBundle.message((String)"local.vcs.action.name.deleting.element", (Object[])new Object[]{string});
        LocalHistoryAction a = LocalHistory.getInstance().startAction(name);
        try {
            if (psiElements.isEmpty() || CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, psiElements)) {
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                WriteCommandAction.writeCommandAction((Project)project).withName(JavaJamBundle.message((String)"command.name.deleting.element", (Object[])new Object[]{string})).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).withGlobalUndo().run(() -> {
                    HashSet parents = new HashSet();
                    for (PsiElement psiElement : psiElements) {
                        ContainerUtil.addIfNotNull(parents, (Object)psiElement.getParent());
                    }
                    CommonModelManagerImpl.doDelete(psiElements, response, displayName);
                    DomManager domManager = DomManager.getDomManager((Project)project);
                    block1: for (PsiElement parent : parents) {
                        if (!parent.isValid()) continue;
                        DomElement domParent = parent instanceof XmlTag ? domManager.getDomElement((XmlTag)parent) : null;
                        for (JamDeleteHandler deleteHandler : this.getDeleteHandlers(domParent == null ? parent : domParent)) {
                            if ((domParent == null || !deleteHandler.onChildrenDelete(domParent)) && (domParent != null || !deleteHandler.onChildrenDelete(parent))) continue;
                            continue block1;
                        }
                    }
                });
            }
        }
        finally {
            a.finish();
        }
        response.onDeletingHasBeenFinished();
    }

    private void addModelElements(Set<CommonModelElement> modelElements) {
        HashSet<Object> curElements = new HashSet<CommonModelElement>(CommonModelManagerImpl.removeNullAndInvalidElements(modelElements));
        while (!curElements.isEmpty()) {
            HashSet newModelElements = new HashSet();
            for (CommonModelElement element : curElements) {
                for (JamDeleteHandler deleteHandler : this.getDeleteHandlers(element)) {
                    deleteHandler.addModelElements(element, newModelElements);
                }
            }
            newModelElements.removeAll(modelElements);
            modelElements.addAll(CommonModelManagerImpl.removeNullAndInvalidElements(newModelElements));
            curElements = newModelElements;
        }
    }

    private @Unmodifiable @NotNull List<JamDeleteHandler> getDeleteHandlers(@NotNull Object element) {
        Class<?> elementClass;
        if (element == null) {
            CommonModelManagerImpl.$$$reportNull$$$0(0);
        }
        if (!CommonModelElement.class.isAssignableFrom(elementClass = element.getClass())) {
            List list = EP_NAME.getExtensionList();
            if (list == null) {
                CommonModelManagerImpl.$$$reportNull$$$0(1);
            }
            return list;
        }
        JamDeleteHandler handler = this.myHandlersMap.computeIfAbsent(elementClass, key -> {
            DeleteHandler result = (DeleteHandler)DomReflectionUtil.findAnnotationDFS((Class)key, DeleteHandler.class);
            if (result == null) {
                return null;
            }
            try {
                Class<?> aClass = result.handlerClass();
                if (aClass == JamDeleteHandler.class) {
                    aClass = Class.forName(result.value(), true, key.getClassLoader());
                }
                Constructor constructor = aClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return (JamDeleteHandler)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        if (handler == null) {
            List list = EP_NAME.getExtensionList();
            if (list == null) {
                CommonModelManagerImpl.$$$reportNull$$$0(2);
            }
            return list;
        }
        List list = ContainerUtil.concat((List)EP_NAME.getExtensionList(), Collections.singletonList(handler));
        if (list == null) {
            CommonModelManagerImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static <T extends Collection<CommonModelElement>> T removeNullAndInvalidElements(T curElements) {
        Iterator<CommonModelElement> it = curElements.iterator();
        while (it.hasNext()) {
            CommonModelElement element = it.next();
            if (element != null && element.isValid()) continue;
            it.remove();
        }
        return curElements;
    }

    @NotNull
    private Collection<? extends PsiElement> addPsiElements(Collection<? extends CommonModelElement> elements) {
        HashSet collection = new HashSet();
        for (CommonModelElement commonModelElement : elements) {
            for (JamDeleteHandler deleteHandler : this.getDeleteHandlers(commonModelElement)) {
                deleteHandler.addPsiElements(commonModelElement, collection);
            }
        }
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            PsiElement psiElement = (PsiElement)it.next();
            if (psiElement != null && !(psiElement instanceof PsiCompiledElement) && !(psiElement instanceof FakePsiElement) && psiElement.isValid() && psiElement.getManager().isInProject(psiElement)) continue;
            it.remove();
        }
        HashSet hashSet = collection;
        if (hashSet == null) {
            CommonModelManagerImpl.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    private static void doDelete(List<? extends PsiElement> psiElements, JamUserResponse userResponse, String displayName) {
        for (PsiElement psiElement : psiElements) {
            if (!psiElement.isValid()) continue;
            try {
                psiElement.delete();
            }
            catch (IncorrectOperationException e) {
                userResponse.logErrorWhileDeletingPsiElement(e, displayName, psiElement);
            }
        }
    }

    private static boolean confirmDeletion(String displayName, JamUserResponse response) {
        return response.showYesNoDialog(JavaJamBundle.message((String)"confirmation.text.delete.element", (Object[])new Object[]{displayName}), JavaJamBundle.message((String)"message.title.deleting.element", (Object[])new Object[]{displayName}), Messages.getQuestionIcon()) == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jam/model/common/CommonModelManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jam/model/common/CommonModelManagerImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeleteHandlers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addPsiElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDeleteHandlers";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    static final class MyJamDeleteHandler
    extends JamDeleteHandler {
        MyJamDeleteHandler() {
        }

        public void addPsiElements(CommonModelElement element, Collection<? super PsiElement> result) {
            PsiElement element1;
            DomElement domElement = (DomElement)ModelMergerUtil.getImplementation((Object)element, DomElement.class);
            JamElement annoElement2 = (JamElement)ModelMergerUtil.getImplementation((Object)element, JamElement.class);
            if (domElement != null) {
                XmlTag domElementTag = domElement.getXmlTag();
                if (domElementTag != null) {
                    result.add((PsiElement)domElementTag);
                }
            } else if (annoElement2 instanceof CommonModelElement && (element1 = ((CommonModelElement)annoElement2).getIdentifyingPsiElement()) != null) {
                result.add((PsiElement)element1);
            }
        }
    }
}

