/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.model.common;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.jam.JavaJamBundle;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.JavaElementKind;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.naming.AutomaticUsageRenamer;
import com.intellij.refactoring.rename.naming.AutomaticUsageRenamingDialog;
import com.intellij.refactoring.rename.naming.PsiNamedElementAutomaticRenamer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ElementPresentationManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommonModelRefactoringSupport<T extends CommonModelElement, V extends PsiElement>
extends FindUsagesHandlerFactory {
    private final Class<V> myPsiElementClass;

    protected CommonModelRefactoringSupport(Class<V> psiElementClass) {
        this.myPsiElementClass = psiElementClass;
    }

    @Nullable
    public T getModelElement(PsiElement psiElement) {
        T t = this.getModelElementFromMetaData(psiElement);
        if (t != null) {
            return t;
        }
        if (this.myPsiElementClass.isInstance(psiElement)) {
            return this.getModelElementFromPsi(psiElement);
        }
        return null;
    }

    protected abstract FindUsagesHandler createFindUsagesHandler(T var1, PsiElement var2);

    public boolean canFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            CommonModelRefactoringSupport.$$$reportNull$$$0(0);
        }
        return this.getModelElement(element) != null;
    }

    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        T otherT;
        T t;
        if (element == null) {
            CommonModelRefactoringSupport.$$$reportNull$$$0(1);
        }
        if ((t = this.getModelElementFromMetaData(element)) != null) {
            return this.createFindUsagesHandler(t, element);
        }
        if (this.myPsiElementClass.isInstance(element) && (otherT = this.getModelElementFromPsi(element)) != null) {
            return this.createFindUsagesHandler(otherT, element);
        }
        return null;
    }

    @Nullable
    public abstract T getModelElementFromPsi(V var1);

    @Nullable
    public abstract T getModelElementFromMetaData(PsiElement var1);

    public abstract Collection<PsiElement> getAccessors(T var1);

    public static boolean addPsiClasses(final CommonModelElement t, List<? extends PsiClass> list, final String oldRawName, String newRawName, RenameProcessor processor) {
        if (newRawName == null) {
            return false;
        }
        PsiNamedElementAutomaticRenamer<PsiClass> automaticRenamer = new PsiNamedElementAutomaticRenamer<PsiClass>(ContainerUtil.findAll(list, psiClass -> psiClass != null && psiClass.isValid() && !(psiClass instanceof PsiCompiledElement)), oldRawName, newRawName){

            protected boolean isCheckedInitially(PsiClass element) {
                return Objects.equals(element.getName(), oldRawName);
            }

            public String getDialogTitle() {
                return JavaJamBundle.message((String)"dialog.title.rename.0.classes", (Object[])new Object[]{ElementPresentationManager.getTypeNameForObject((Object)t)});
            }

            public String getDialogDescription() {
                return this.getDialogTitle();
            }

            public String getEntityName() {
                return JavaElementKind.CLASS.subject();
            }
        };
        if (automaticRenamer.getElements().isEmpty()) {
            return true;
        }
        Project project = t.getPsiManager().getProject();
        AutomaticUsageRenamingDialog renamingDialog = new AutomaticUsageRenamingDialog(project, (AutomaticUsageRenamer)automaticRenamer);
        if (!renamingDialog.showAndGet()) {
            return false;
        }
        for (Map.Entry entry : automaticRenamer.getRenames().entrySet()) {
            String newElementName = (String)entry.getValue();
            if (newElementName == null) continue;
            processor.addElement((PsiElement)entry.getKey(), newElementName);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/jam/model/common/CommonModelRefactoringSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canFindUsages";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createFindUsagesHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

