/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.nbformat.schema.v4;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterKernelBase;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterKernelSpec;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterMetadata;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookSchema;
import com.intellij.jupyter.core.jupyter.nbformat.schema.JupyterNotebookCellSchema;
import com.intellij.jupyter.core.jupyter.nbformat.schema.JupyterNotebookSchemaBase;
import com.intellij.jupyter.core.jupyter.nbformat.schema.JupyterNotebookSchemaVersion;
import com.intellij.jupyter.core.jupyter.nbformat.schema.v4.V4JupyterNotebookCellSchema;
import com.intellij.openapi.diagnostic.Logger;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0001&B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010 \u001a\u00020\u0017H\u0016J\u0013\u0010!\u001a\u00020\u00062\b\u0010\"\u001a\u0004\u0018\u00010#H\u0096\u0002J\b\u0010$\u001a\u00020%H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006'"}, d2={"Lcom/intellij/jupyter/core/jupyter/nbformat/schema/v4/V4JupyterNotebookSchema;", "Lcom/intellij/jupyter/core/jupyter/nbformat/schema/JupyterNotebookSchemaBase;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookSchema;", "version", "Lcom/intellij/jupyter/core/jupyter/nbformat/schema/JupyterNotebookSchemaVersion;", "isExplicit", "", "<init>", "(Lcom/intellij/jupyter/core/jupyter/nbformat/schema/JupyterNotebookSchemaVersion;Z)V", "()Z", "cellFieldName", "", "metadataFieldName", "kernelSpecFieldName", "kernelSpecDisplayNameFieldName", "kernelSpecLanguageFieldName", "kernelSpecNameFieldName", "cellSchema", "Lcom/intellij/jupyter/core/jupyter/nbformat/schema/JupyterNotebookCellSchema;", "getCellSchema", "()Lcom/intellij/jupyter/core/jupyter/nbformat/schema/JupyterNotebookCellSchema;", "getLanguage", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "getJupyterKernelSpec", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterKernelBase;", "setJupyterKernelSpec", "", "value", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterKernelSpec;", "getCells", "Lcom/fasterxml/jackson/databind/JsonNode;", "createEmptyNotebook", "equals", "other", "", "hashCode", "", "Companion", "intellij.jupyter.core"})
public final class V4JupyterNotebookSchema
extends JupyterNotebookSchemaBase
implements JupyterNotebookSchema {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isExplicit;
    @NotNull
    private final String cellFieldName;
    @NotNull
    private final String metadataFieldName;
    @NotNull
    private final String kernelSpecFieldName;
    @NotNull
    private final String kernelSpecDisplayNameFieldName;
    @NotNull
    private final String kernelSpecLanguageFieldName;
    @NotNull
    private final String kernelSpecNameFieldName;
    @NotNull
    private final JupyterNotebookCellSchema cellSchema;
    @NotNull
    private static final Logger LOG;

    public V4JupyterNotebookSchema(@NotNull JupyterNotebookSchemaVersion version, boolean isExplicit) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        super(version);
        this.isExplicit = isExplicit;
        this.cellFieldName = "cells";
        this.metadataFieldName = "metadata";
        this.kernelSpecFieldName = "kernelspec";
        this.kernelSpecDisplayNameFieldName = "display_name";
        this.kernelSpecLanguageFieldName = "language";
        this.kernelSpecNameFieldName = "name";
        this.cellSchema = V4JupyterNotebookCellSchema.INSTANCE;
        if (!this.isExplicit) {
            LOG.warn("No explicit schema definition for notebook version " + version);
        }
    }

    public final boolean isExplicit() {
        return this.isExplicit;
    }

    @Override
    @NotNull
    public JupyterNotebookCellSchema getCellSchema() {
        return this.cellSchema;
    }

    @Override
    @Nullable
    public String getLanguage(@NotNull ObjectNode json) {
        JsonNode jsonNode;
        JsonNode jsonNode2;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JsonNode jsonNode3 = json.get(this.metadataFieldName);
        return jsonNode3 != null && (jsonNode2 = jsonNode3.get(this.kernelSpecFieldName)) != null && (jsonNode = jsonNode2.get(this.kernelSpecLanguageFieldName)) != null ? jsonNode.asText() : null;
    }

    @Override
    @Nullable
    public JupyterKernelBase getJupyterKernelSpec(@NotNull ObjectNode json) {
        JupyterKernelBase jupyterKernelBase;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JupyterMetadata jupyterMetadata = this.getMetadata(json).getObject(this.kernelSpecFieldName);
        if (jupyterMetadata != null) {
            JupyterMetadata it = jupyterMetadata;
            boolean bl = false;
            String string = it.getString(this.kernelSpecDisplayNameFieldName);
            if (string == null) {
                return null;
            }
            String displayName = string;
            String string2 = it.getString(this.kernelSpecLanguageFieldName);
            if (string2 == null) {
                return null;
            }
            String language = string2;
            String string3 = it.getString(this.kernelSpecNameFieldName);
            if (string3 == null) {
                return null;
            }
            String name = string3;
            jupyterKernelBase = new JupyterKernelBase(displayName, language, name, null, null, 24, null);
        } else {
            jupyterKernelBase = null;
        }
        return jupyterKernelBase;
    }

    @Override
    public void setJupyterKernelSpec(@NotNull ObjectNode json, @Nullable JupyterKernelSpec value) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JupyterMetadata metadataField = this.getMetadata(json);
        JupyterKernelSpec jupyterKernelSpec = value;
        if (jupyterKernelSpec != null) {
            JupyterKernelSpec $this$setJupyterKernelSpec_u24lambda_u240 = jupyterKernelSpec;
            boolean bl = false;
            metadataField.setObject(this.kernelSpecFieldName, (Function1<? super JupyterMetadata, Unit>)((Function1)arg_0 -> V4JupyterNotebookSchema.setJupyterKernelSpec$lambda$0$0(this, value, arg_0)));
        } else {
            metadataField.remove(this.kernelSpecFieldName);
        }
    }

    @Override
    @Nullable
    public JsonNode getCells(@NotNull ObjectNode json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return json.get(this.cellFieldName);
    }

    @Override
    @NotNull
    public ObjectNode createEmptyNotebook() {
        ObjectNode objectNode;
        ObjectNode $this$createEmptyNotebook_u24lambda_u240 = objectNode = JupyterJsonKt.getJackson().createObjectNode();
        boolean bl = false;
        $this$createEmptyNotebook_u24lambda_u240.putArray("cells");
        $this$createEmptyNotebook_u24lambda_u240.putObject("metadata");
        $this$createEmptyNotebook_u24lambda_u240.put("nbformat", this.getVersion().getMajor());
        $this$createEmptyNotebook_u24lambda_u240.put("nbformat_minor", this.getVersion().getMinor());
        ObjectNode objectNode2 = objectNode;
        Intrinsics.checkNotNullExpressionValue((Object)objectNode2, (String)"apply(...)");
        return objectNode2;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof V4JupyterNotebookSchema)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return Intrinsics.areEqual((Object)this.getVersion(), (Object)((V4JupyterNotebookSchema)other).getVersion()) && this.isExplicit == ((V4JupyterNotebookSchema)other).isExplicit;
    }

    public int hashCode() {
        int result2 = this.getVersion().hashCode();
        result2 = 31 * result2 + (this.isExplicit ? 1 : 0);
        return result2;
    }

    private static final Unit setJupyterKernelSpec$lambda$0$0(V4JupyterNotebookSchema this$0, JupyterKernelSpec $value, JupyterMetadata $this$setObject) {
        Intrinsics.checkNotNullParameter((Object)$this$setObject, (String)"$this$setObject");
        $this$setObject.setString(this$0.kernelSpecNameFieldName, $value.getName());
        $this$setObject.setString(this$0.kernelSpecLanguageFieldName, $value.getLanguage());
        $this$setObject.setString(this$0.kernelSpecDisplayNameFieldName, $value.getDisplayName());
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/jupyter/core/jupyter/nbformat/schema/v4/V4JupyterNotebookSchema$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

