/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.jakarta.data.repository.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.javaee.jakarta.data.JakartaDataBundle;
import com.intellij.javaee.jakarta.data.repository.JakartaDataParserContext;
import com.intellij.javaee.jakarta.data.repository.JakartaDataRepositoryUtil;
import com.intellij.javaee.jakarta.data.repository.inspections.JakartaDataRepositoryInspection;
import com.intellij.javaee.jakarta.data.repository.jam.JakartaDataByParameter;
import com.intellij.javaee.utils.persistence.data.FrameworksDataBundle;
import com.intellij.javaee.utils.persistence.data.inspections.PartTreeInconsistencyUtils;
import com.intellij.javaee.utils.persistence.data.inspections.TypeWrapper;
import com.intellij.javaee.utils.persistence.data.parser.Part;
import com.intellij.javaee.utils.persistence.data.parser.PartTree;
import com.intellij.javaee.utils.persistence.data.parser.PartTreeParserContext;
import com.intellij.jpa.ql.model.QlAttribute;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.lang.jvm.actions.ChangeParametersRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MethodRequestsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;

public final class JakartaDataRepositoryMethodParametersInspection
extends JakartaDataRepositoryInspection {
    private static final JakartaDataPartTreeParametersChecker HELPER = new JakartaDataPartTreeParametersChecker();
    private static final String[] SPECIAL_PARAMS = new String[]{"jakarta.data.repository.Pageable", "jakarta.data.repository.Sort", "jakarta.data.page.PageRequest"};

    @Override
    protected void checkRepositoryMethod(@NotNull ProblemsHolder holder, UClass repositoryClass, @NotNull UMethod psiMethod, @NotNull Module module, @Nullable Pair<PsiClass, ? extends PsiType> typePair) {
        if (holder == null) {
            JakartaDataRepositoryMethodParametersInspection.$$$reportNull$$$0(0);
        }
        if (psiMethod == null) {
            JakartaDataRepositoryMethodParametersInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            JakartaDataRepositoryMethodParametersInspection.$$$reportNull$$$0(2);
        }
        if (!JakartaDataRepositoryUtil.hasQueryAnnotation(psiMethod.getJavaPsi())) {
            JakartaDataRepositoryMethodParametersInspection.checkParameterTypes(holder, repositoryClass, psiMethod, typePair);
            JakartaDataRepositoryMethodParametersInspection.checkByAnnotation(holder, psiMethod);
        }
    }

    private static void checkParameterTypes(@NotNull ProblemsHolder holder, UClass repositoryClass, @NotNull UMethod uMethod, @Nullable Pair<PsiClass, ? extends PsiType> typePair) {
        if (holder == null) {
            JakartaDataRepositoryMethodParametersInspection.$$$reportNull$$$0(3);
        }
        if (uMethod == null) {
            JakartaDataRepositoryMethodParametersInspection.$$$reportNull$$$0(4);
        }
        if (JakartaDataRepositoryUtil.isQueryMethod(uMethod.getJavaPsi())) {
            PsiClass domainClass;
            String methodName = uMethod.getName();
            PsiClass psiClass = domainClass = typePair != null ? (PsiClass)typePair.getFirst() : JakartaDataRepositoryUtil.getEntityClassByMethodReturnType(uMethod.getReturnType());
            if (domainClass == null) {
                return;
            }
            PartTree partTree = new PartTree(methodName, domainClass, (PartTreeParserContext)JakartaDataParserContext.create());
            if (!PartTreeInconsistencyUtils.hasUnresolvedPropertyPaths((PartTree)partTree)) {
                JakartaDataRepositoryMethodParametersInspection.checkParameters(holder, partTree, uMethod, domainClass, repositoryClass);
            }
        }
    }

    private static void checkParameters(@NotNull ProblemsHolder holder, @NotNull PartTree partTree, @NotNull UMethod psiMethod, @NotNull PsiClass domainClass, UClass repositoryClass) {
        PsiElement identifier;
        if (holder == null) {
            JakartaDataRepositoryMethodParametersInspection.$$$reportNull$$$0(5);
        }
        if (partTree == null) {
            JakartaDataRepositoryMethodParametersInspection.$$$reportNull$$$0(6);
        }
        if (psiMethod == null) {
            JakartaDataRepositoryMethodParametersInspection.$$$reportNull$$$0(7);
        }
        if (domainClass == null) {
            JakartaDataRepositoryMethodParametersInspection.$$$reportNull$$$0(8);
        }
        List parts = partTree.getParts();
        List requiredParameterTypes = PartTreeInconsistencyUtils.getRequiredParameterTypes((Iterable)parts, (Project)psiMethod.getJavaPsi().getProject(), part -> JakartaDataRepositoryMethodParametersInspection.isCollectionType(part), part -> false, (Function[])new Function[0]);
        if (!PartTreeInconsistencyUtils.areAssignableTypes((PsiMethod)psiMethod.getJavaPsi(), (List)requiredParameterTypes, (PsiClass)domainClass, (UClass)repositoryClass, (PartTreeInconsistencyUtils.PartTreeParametersCheckHelper)HELPER) && (identifier = UElementKt.getSourcePsiElement((UElement)psiMethod.getUastAnchor())) != null) {
            String text = PartTreeInconsistencyUtils.getRequiredParametersTypesToString((List)requiredParameterTypes, (PsiMethod)psiMethod.getJavaPsi(), (TypeWrapper)TypeWrapper.UNKNOWN);
            holder.registerProblem(identifier, FrameworksDataBundle.message((String)"required.parameters", (Object[])new Object[]{text}), JakartaDataRepositoryMethodParametersInspection.getQuickFixes(psiMethod.getJavaPsi(), parts));
        }
    }

    private static void checkByAnnotation(@NotNull ProblemsHolder holder, @NotNull UMethod psiMethod) {
        if (holder == null) {
            JakartaDataRepositoryMethodParametersInspection.$$$reportNull$$$0(9);
        }
        if (psiMethod == null) {
            JakartaDataRepositoryMethodParametersInspection.$$$reportNull$$$0(10);
        }
        for (UParameter parameter : psiMethod.getUastParameters()) {
            PsiType parameterType;
            PsiParameter psiParam;
            JakartaDataByParameter byParameter;
            PsiElement psi = parameter.getJavaPsi();
            if (!(psi instanceof PsiParameter) || (byParameter = (JakartaDataByParameter)JakartaDataByParameter.META.getJamElement((PsiModifierListOwner)(psiParam = (PsiParameter)psi))) == null) continue;
            JamStringAttributeElement<QlAttribute> attr = byParameter.getValueAttr();
            QlAttribute value = (QlAttribute)attr.getValue();
            if (value == null) {
                JakartaDataRepositoryMethodParametersInspection.registerBadResolve(holder, attr);
                continue;
            }
            PsiType psiType = value.getPsiType();
            if (psiType == null || psiType.isAssignableFrom(parameterType = psiParam.getType())) continue;
            PsiTypeElement typeElement = psiParam.getTypeElement();
            holder.registerProblem((PsiElement)(typeElement != null ? typeElement : psiParam), JakartaDataBundle.message("entity.attribute.expected.type.error.message", psiType.getCanonicalText()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static LocalQuickFix[] getQuickFixes(PsiMethod psiMethod, Iterable<Part> requiredParameterTypes) {
        List actions = JvmElementActionFactories.createChangeParametersActions((JvmMethod)psiMethod, (ChangeParametersRequest)MethodRequestsKt.setMethodParametersRequest(JakartaDataRepositoryMethodParametersInspection.createParamMap(requiredParameterTypes, psiMethod).entrySet()));
        return IntentionWrapper.wrapToQuickFixes((IntentionAction[])actions.toArray(IntentionAction.EMPTY_ARRAY), (PsiFile)psiMethod.getContainingFile());
    }

    @NotNull
    private static Map<String, PsiType> createParamMap(@NotNull Iterable<Part> nodes, @NotNull PsiMethod psiMethod) {
        if (nodes == null) {
            JakartaDataRepositoryMethodParametersInspection.$$$reportNull$$$0(11);
        }
        if (psiMethod == null) {
            JakartaDataRepositoryMethodParametersInspection.$$$reportNull$$$0(12);
        }
        Map map = PartTreeInconsistencyUtils.getPropertyPathParamsMap(nodes, (PsiMethod)psiMethod, part -> JakartaDataRepositoryMethodParametersInspection.isCollectionType(part));
        block0: for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
            for (String param : SPECIAL_PARAMS) {
                if (!InheritanceUtil.isInheritor((PsiType)parameter.getType(), (String)param)) continue;
                map.put(parameter.getName(), PartTreeInconsistencyUtils.getPsiType((Project)parameter.getProject(), (String)param));
                continue block0;
            }
        }
        Map map2 = map;
        if (map2 == null) {
            JakartaDataRepositoryMethodParametersInspection.$$$reportNull$$$0(13);
        }
        return map2;
    }

    private static boolean isCollectionType(Part node) {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partTree";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/jakarta/data/repository/inspections/JakartaDataRepositoryMethodParametersInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/jakarta/data/repository/inspections/JakartaDataRepositoryMethodParametersInspection";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createParamMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkRepositoryMethod";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkParameterTypes";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkParameters";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkByAnnotation";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createParamMap";
                break;
            }
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }

    private static class JakartaDataPartTreeParametersChecker
    implements PartTreeInconsistencyUtils.PartTreeParametersCheckHelper {
        private JakartaDataPartTreeParametersChecker() {
        }

        public String[] getPossibleWrappers(boolean withReactive, boolean withCoroutines) {
            ArrayList<String> wrappers = new ArrayList<String>(Collections.singletonList("java.util.Optional"));
            if (withReactive) {
                // empty if block
            }
            return ArrayUtil.toStringArray(wrappers);
        }

        public String[] getPossibleCollections(boolean withReactive, boolean withCoroutines) {
            ArrayList<String> wrappers = new ArrayList<String>(Collections.singletonList("java.util.Collection"));
            return ArrayUtil.toStringArray(wrappers);
        }

        public boolean acceptReactiveTypeParameters(UClass uClass) {
            return false;
        }

        public boolean acceptCoroutineTypeParameters(UClass uClass) {
            return false;
        }

        public boolean isNotQueryParameter(@NotNull PsiMethod psiMethod, PsiType parameterType) {
            if (psiMethod == null) {
                JakartaDataPartTreeParametersChecker.$$$reportNull$$$0(0);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/javaee/jakarta/data/repository/inspections/JakartaDataRepositoryMethodParametersInspection$JakartaDataPartTreeParametersChecker", "isNotQueryParameter"));
        }
    }
}

