/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProviderImpl;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.LazyDeclarationResolver;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.expressions.LocalClassDescriptorHolder;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/types/expressions/DeclarationScopeProviderForLocalClassifierAnalyzer;", "Lorg/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl;", "lazyDeclarationResolver", "Lorg/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver;", "fileScopeProvider", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopeProvider;", "localClassDescriptorManager", "Lorg/jetbrains/kotlin/types/expressions/LocalClassDescriptorHolder;", "<init>", "(Lorg/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver;Lorg/jetbrains/kotlin/resolve/lazy/FileScopeProvider;Lorg/jetbrains/kotlin/types/expressions/LocalClassDescriptorHolder;)V", "getResolutionScopeForDeclaration", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "elementOfDeclaration", "Lcom/intellij/psi/PsiElement;", "getOuterDataFlowInfoForDeclaration", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "frontend"})
public final class DeclarationScopeProviderForLocalClassifierAnalyzer
extends DeclarationScopeProviderImpl {
    @NotNull
    private final LocalClassDescriptorHolder localClassDescriptorManager;

    public DeclarationScopeProviderForLocalClassifierAnalyzer(@NotNull LazyDeclarationResolver lazyDeclarationResolver, @NotNull FileScopeProvider fileScopeProvider, @NotNull LocalClassDescriptorHolder localClassDescriptorManager) {
        Intrinsics.checkNotNullParameter((Object)lazyDeclarationResolver, (String)"lazyDeclarationResolver");
        Intrinsics.checkNotNullParameter((Object)fileScopeProvider, (String)"fileScopeProvider");
        Intrinsics.checkNotNullParameter((Object)localClassDescriptorManager, (String)"localClassDescriptorManager");
        super(lazyDeclarationResolver, fileScopeProvider);
        this.localClassDescriptorManager = localClassDescriptorManager;
    }

    @Override
    @NotNull
    public LexicalScope getResolutionScopeForDeclaration(@NotNull PsiElement elementOfDeclaration) {
        Intrinsics.checkNotNullParameter((Object)elementOfDeclaration, (String)"elementOfDeclaration");
        if (this.localClassDescriptorManager.isMyClass(elementOfDeclaration)) {
            return this.localClassDescriptorManager.getResolutionScopeForClass((KtClassOrObject)elementOfDeclaration);
        }
        LexicalScope lexicalScope = super.getResolutionScopeForDeclaration(elementOfDeclaration);
        Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"getResolutionScopeForDeclaration(...)");
        return lexicalScope;
    }

    @Override
    @NotNull
    public DataFlowInfo getOuterDataFlowInfoForDeclaration(@NotNull PsiElement elementOfDeclaration) {
        Intrinsics.checkNotNullParameter((Object)elementOfDeclaration, (String)"elementOfDeclaration");
        if (this.localClassDescriptorManager.insideMyClass(elementOfDeclaration)) {
            DataFlowInfo dataFlowInfo = this.localClassDescriptorManager.getExpressionTypingContext().dataFlowInfo;
            Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"dataFlowInfo");
            return dataFlowInfo;
        }
        DataFlowInfo dataFlowInfo = super.getOuterDataFlowInfoForDeclaration(elementOfDeclaration);
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"getOuterDataFlowInfoForDeclaration(...)");
        return dataFlowInfo;
    }
}

