/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.annotations;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.xml.converters.QuotedValueConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class AnnotationModelUtil {
    private AnnotationModelUtil() {
    }

    @NotNull
    public static @Unmodifiable List<PsiAnnotation> getAnnotationsValue(PsiAnnotation annotation, String parameterName, String childAnnotationName) {
        if (annotation != null) {
            PsiAnnotationMemberValue annotationMemberValue = annotation.findAttributeValue(parameterName);
            List list = JBIterable.from((Iterable)AnnotationUtil.arrayAttributeValues((PsiAnnotationMemberValue)annotationMemberValue)).filter(PsiAnnotation.class).filter(childAnnotation -> childAnnotationName.equals(childAnnotation.getQualifiedName())).toList();
            if (list == null) {
                AnnotationModelUtil.$$$reportNull$$$0(0);
            }
            return list;
        }
        List<PsiAnnotation> list = Collections.emptyList();
        if (list == null) {
            AnnotationModelUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static List<AnnotationGenericValue<String>> getStringArrayValue(PsiAnnotation annotation, @NonNls String attributeName) {
        return AnnotationModelUtil.getObjectArrayValue(annotation, attributeName, FunctionUtil.id());
    }

    @NotNull
    public static <T extends Enum> List<AnnotationGenericValue<T>> getEnumArrayValue(PsiAnnotation annotation, @NonNls String attributeName, Class<? extends T> clazz) {
        return AnnotationModelUtil.getObjectArrayValue(annotation, attributeName, clazz, FunctionUtil.id());
    }

    @NotNull
    public static <T> List<AnnotationGenericValue<T>> getObjectArrayValue(PsiAnnotation annotation, String attributeName, Function<? super String, ? extends T> function) {
        return AnnotationModelUtil.getObjectArrayValue(annotation, attributeName, String.class, function);
    }

    @NotNull
    public static <T, V> List<AnnotationGenericValue<T>> getObjectArrayValue(PsiAnnotation annotation, String attributeName, Class<V> clazz, Function<? super V, ? extends T> mapper) {
        ArrayList result = new ArrayList();
        JamCommonUtil.processObjectArrayValue((PsiAnnotation)annotation, (String)attributeName, value -> {
            Object obj = JamCommonUtil.getObjectValue((PsiElement)value, (Class)clazz);
            if (obj != null) {
                result.add(AnnotationGenericValue.getInstance(mapper.fun(obj), annotation, (PsiElement)value));
            }
            return true;
        });
        ArrayList arrayList = result;
        if (arrayList == null) {
            AnnotationModelUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public static AnnotationGenericValue<Boolean> getBooleanValue(PsiAnnotation annotation) {
        AnnotationGenericValue<Boolean> annotationGenericValue = AnnotationGenericValue.getInstance(annotation != null ? Boolean.TRUE : Boolean.FALSE, annotation, null);
        if (annotationGenericValue == null) {
            AnnotationModelUtil.$$$reportNull$$$0(3);
        }
        return annotationGenericValue;
    }

    @NotNull
    public static AnnotationGenericValue<Boolean> getBooleanValue(PsiAnnotation annotation, @NonNls String attributeName, boolean def) {
        PsiAnnotationMemberValue memberValue = annotation.findAttributeValue(attributeName);
        Boolean value = AnnotationModelUtil.getBooleanValue(memberValue, def);
        AnnotationGenericValue<Boolean> annotationGenericValue = AnnotationGenericValue.getInstance(value, annotation, (PsiElement)memberValue);
        if (annotationGenericValue == null) {
            AnnotationModelUtil.$$$reportNull$$$0(4);
        }
        return annotationGenericValue;
    }

    private static boolean getBooleanValue(@Nullable PsiAnnotationMemberValue memberValue, boolean defValue) {
        boolean result;
        if (memberValue != null) {
            String s = memberValue.getText();
            result = Boolean.valueOf(s);
        } else {
            result = defValue;
        }
        return result;
    }

    @NotNull
    public static <T extends Enum> AnnotationGenericValue<T> getEnumValue(PsiAnnotation annotation, String attributeName, Class<? extends T> clazz) {
        PsiAnnotationMemberValue memberValue;
        Enum value;
        if (annotation != null && (value = JamCommonUtil.getEnumValue((PsiElement)(memberValue = annotation.findAttributeValue(attributeName)), clazz)) != null) {
            AnnotationGenericValue<Enum> annotationGenericValue = AnnotationGenericValue.getInstance(value, annotation, (PsiElement)memberValue);
            if (annotationGenericValue == null) {
                AnnotationModelUtil.$$$reportNull$$$0(5);
            }
            return annotationGenericValue;
        }
        AnnotationGenericValue annotationGenericValue = AnnotationGenericValue.NULL;
        if (annotationGenericValue == null) {
            AnnotationModelUtil.$$$reportNull$$$0(6);
        }
        return annotationGenericValue;
    }

    @NotNull
    public static AnnotationGenericValue<String> getStringValue(PsiAnnotation annotation, @NonNls String attributeName, @Nullable String defaultValue) {
        if (annotation != null) {
            PsiAnnotationMemberValue value = annotation.findDeclaredAttributeValue(attributeName);
            String obj = (String)JamCommonUtil.getObjectValue((PsiElement)value, String.class);
            String result = obj == null ? defaultValue : obj;
            AnnotationGenericValue<String> annotationGenericValue = AnnotationGenericValue.getInstance(QuotedValueConverter.unquote((String)result), annotation, (PsiElement)value);
            if (annotationGenericValue == null) {
                AnnotationModelUtil.$$$reportNull$$$0(7);
            }
            return annotationGenericValue;
        }
        if (defaultValue != null) {
            AnnotationGenericValue<String> annotationGenericValue = AnnotationGenericValue.getInstance(QuotedValueConverter.unquote((String)defaultValue), null, null);
            if (annotationGenericValue == null) {
                AnnotationModelUtil.$$$reportNull$$$0(8);
            }
            return annotationGenericValue;
        }
        AnnotationGenericValue annotationGenericValue = AnnotationGenericValue.NULL;
        if (annotationGenericValue == null) {
            AnnotationModelUtil.$$$reportNull$$$0(9);
        }
        return annotationGenericValue;
    }

    @NotNull
    public static <T> AnnotationGenericValue<T> getObjectValue(PsiAnnotation annotation, @NonNls String attributeName, Class<? extends T> clazz) {
        if (annotation != null) {
            PsiAnnotationMemberValue value = annotation.findAttributeValue(attributeName);
            Object obj = JamCommonUtil.getObjectValue((PsiElement)value, clazz);
            AnnotationGenericValue<Object> annotationGenericValue = AnnotationGenericValue.getInstance(obj, annotation, (PsiElement)value);
            if (annotationGenericValue == null) {
                AnnotationModelUtil.$$$reportNull$$$0(10);
            }
            return annotationGenericValue;
        }
        AnnotationGenericValue annotationGenericValue = AnnotationGenericValue.NULL;
        if (annotationGenericValue == null) {
            AnnotationModelUtil.$$$reportNull$$$0(11);
        }
        return annotationGenericValue;
    }

    @NotNull
    public static AnnotationGenericValue<PsiClass> getPsiClassValue(PsiAnnotation annotation, String attributeName, PsiClass defaultValue) {
        if (annotation != null) {
            PsiAnnotationMemberValue memberValue = annotation.findAttributeValue(attributeName);
            PsiClass psiClass = JamCommonUtil.getPsiClass((PsiElement)memberValue);
            if (psiClass == null) {
                psiClass = defaultValue;
            }
            if (psiClass != null || memberValue != null) {
                AnnotationGenericValue<PsiClass> annotationGenericValue = AnnotationGenericValue.getInstance(psiClass, annotation, (PsiElement)memberValue);
                if (annotationGenericValue == null) {
                    AnnotationModelUtil.$$$reportNull$$$0(12);
                }
                return annotationGenericValue;
            }
        }
        AnnotationGenericValue annotationGenericValue = AnnotationGenericValue.NULL;
        if (annotationGenericValue == null) {
            AnnotationModelUtil.$$$reportNull$$$0(13);
        }
        return annotationGenericValue;
    }

    @NotNull
    public static @Unmodifiable List<AnnotationGenericValue<PsiClass>> getPsiClassArrayValue(PsiAnnotation annotation, String attributeName) {
        PsiAnnotationMemberValue memberValue = annotation != null ? annotation.findAttributeValue(attributeName) : null;
        List list = ContainerUtil.mapNotNull((Collection)AnnotationUtil.arrayAttributeValues((PsiAnnotationMemberValue)memberValue), value -> {
            PsiClass psiClass = JamCommonUtil.getPsiClass((PsiElement)value);
            return psiClass != null ? AnnotationGenericValue.getInstance(psiClass, annotation, (PsiElement)value) : null;
        });
        if (list == null) {
            AnnotationModelUtil.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Nullable
    public static String getPsiMemberName(PsiMember member) {
        String attributeName = PropertyUtilBase.getPropertyName((PsiMember)member);
        return attributeName == null ? null : member.getContainingClass().getQualifiedName() + "/" + attributeName;
    }

    @Nullable
    public static PsiClass getPsiMemberType(PsiMember member) {
        PsiMethod method;
        Object psiType = member instanceof PsiField ? ((PsiField)member).getType() : (member instanceof PsiMethod ? (PropertyUtilBase.isSimplePropertyGetter((PsiMethod)(method = (PsiMethod)member)) ? method.getReturnType() : (PropertyUtilBase.isSimplePropertySetter((PsiMethod)method) ? method.getParameterList().getParameters()[0].getType() : null)) : null);
        if (psiType == null) {
            return null;
        }
        if (psiType instanceof PsiClassType) {
            return ((PsiClassType)psiType).resolve();
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)psiType) && StringUtil.isNotEmpty((String)((PsiPrimitiveType)psiType).getBoxedTypeName())) {
            return JavaPsiFacade.getInstance((Project)member.getProject()).findClass(((PsiPrimitiveType)psiType).getBoxedTypeName(), member.getResolveScope());
        }
        return null;
    }

    public static List<PsiAnnotation> getAnnotationsValueIncludingSingle(PsiModifierListOwner modifierListOwner, String annotationName, String contentAnnotation) {
        if (modifierListOwner == null) {
            return Collections.emptyList();
        }
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null) {
            return Collections.emptyList();
        }
        ArrayList<PsiAnnotation> result = new ArrayList<PsiAnnotation>();
        PsiAnnotation psiSingleAnnotation = modifierList.findAnnotation(contentAnnotation);
        if (psiSingleAnnotation != null) {
            result.add(psiSingleAnnotation);
        }
        PsiAnnotation annotation = modifierList.findAnnotation(annotationName);
        result.addAll(AnnotationModelUtil.getAnnotationsValue(annotation, "value", contentAnnotation));
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/javaee/model/annotations/AnnotationModelUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationsValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectArrayValue";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBooleanValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumValue";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValue";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectValue";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiClassValue";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiClassArrayValue";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

