/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.spring.security.references.SpringSecurityRolePsiReference;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringSecurityRolePsiReferenceProvider
extends PsiReferenceProvider {
    private final boolean tokenize;
    private final boolean includePredefinedRoles;

    protected SpringSecurityRolePsiReferenceProvider(boolean tokenize, boolean includePredefinedRoles) {
        this.tokenize = tokenize;
        this.includePredefinedRoles = includePredefinedRoles;
    }

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            SpringSecurityRolePsiReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SpringSecurityRolePsiReferenceProvider.$$$reportNull$$$0(1);
        }
        String value = this.getStringValue(element);
        PsiReference[] psiReferenceArray = SpringSecurityRolePsiReferenceProvider.getSecurityRolesReferences(element, value, this.tokenize, this.includePredefinedRoles);
        if (psiReferenceArray == null) {
            SpringSecurityRolePsiReferenceProvider.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    @Nullable
    protected abstract String getStringValue(PsiElement var1);

    public static PsiReference[] getSecurityRolesReferences(@NotNull PsiElement element, @Nullable String value, boolean tokenize, boolean includePredefinedRoles) {
        if (element == null) {
            SpringSecurityRolePsiReferenceProvider.$$$reportNull$$$0(3);
        }
        return SpringSecurityRolePsiReferenceProvider.getSecurityRolesReferences(element, value, tokenize, includePredefinedRoles, false);
    }

    public static PsiReference[] getSecurityRolesReferences(@NotNull PsiElement element, @Nullable String value, boolean tokenize, boolean includePredefinedRoles, boolean soft) {
        if (element == null) {
            SpringSecurityRolePsiReferenceProvider.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmptyOrSpaces((String)value)) {
            return PsiReference.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (!tokenize) {
            return new PsiReference[]{SpringSecurityRolePsiReferenceProvider.getReference(element, value, module, includePredefinedRoles, soft)};
        }
        SmartList references = new SmartList();
        for (String token : StringUtil.tokenize((String)value, (String)",")) {
            if (StringUtil.isEmptyOrSpaces((String)token)) continue;
            references.add(SpringSecurityRolePsiReferenceProvider.getReference(element, token, module, includePredefinedRoles, soft));
        }
        return references.toArray(PsiReference.EMPTY_ARRAY);
    }

    private static PsiReference getReference(PsiElement element, String token, Module module, boolean includePredefinedRoles, boolean soft) {
        return new SpringSecurityRolePsiReference(element, token, module, includePredefinedRoles, soft);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/security/references/SpringSecurityRolePsiReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/security/references/SpringSecurityRolePsiReferenceProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSecurityRolesReferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static class XmlAttributeValueProvider
    extends SpringSecurityRolePsiReferenceProvider {
        public XmlAttributeValueProvider(boolean tokenize) {
            super(tokenize, true);
        }

        @Override
        protected String getStringValue(PsiElement element) {
            if (element instanceof XmlAttributeValue) {
                return ((XmlAttributeValue)element).getValue();
            }
            return null;
        }
    }
}

