/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.konan;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.konan.KlibLoadingMetadataCache;
import org.jetbrains.kotlin.analysis.decompiler.konan.KlibMetaFileType;
import org.jetbrains.kotlin.analysis.decompiler.konan.NearFileClassDataFinder;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.KotlinMetadataStubBuilder;
import org.jetbrains.kotlin.library.metadata.KlibMetadataProtoBuf;
import org.jetbrains.kotlin.library.metadata.KlibMetadataSerializerProtocol;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0011H\u0014R\u0014\u0010\u0006\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/konan/KlibMetadataStubBuilder;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder;", "<init>", "()V", "getStubVersion", "", "supportedFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getSupportedFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "expectedBinaryVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "getExpectedBinaryVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "hasMetadata", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "readFile", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata;", "content", "", "classDataFinder", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassDataFinder;", "original", "file", "KlibFileWithMetadata", "decompiler-native"})
public final class KlibMetadataStubBuilder
extends KotlinMetadataStubBuilder {
    @NotNull
    public static final KlibMetadataStubBuilder INSTANCE = new KlibMetadataStubBuilder();

    private KlibMetadataStubBuilder() {
    }

    public int getStubVersion() {
        return 188;
    }

    @Override
    @NotNull
    protected FileType getSupportedFileType() {
        return KlibMetaFileType.INSTANCE;
    }

    @Override
    @NotNull
    protected BinaryVersion getExpectedBinaryVersion() {
        return MetadataVersion.INSTANCE;
    }

    @Override
    protected boolean hasMetadata(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        KlibLoadingMetadataCache metadataCache = KlibLoadingMetadataCache.Companion.getInstance();
        return metadataCache.getCachedPackageFragment(virtualFile) != null;
    }

    @Override
    @Nullable
    protected KotlinMetadataStubBuilder.FileWithMetadata readFile(@NotNull VirtualFile virtualFile, @Nullable byte[] content) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        KlibLoadingMetadataCache klibMetadataLoadingCache = KlibLoadingMetadataCache.Companion.getInstance();
        Pair<ProtoBuf.PackageFragment, MetadataVersion> pair = klibMetadataLoadingCache.getCachedPackageFragmentWithVersion(virtualFile);
        ProtoBuf.PackageFragment fragment = (ProtoBuf.PackageFragment)pair.component1();
        MetadataVersion version2 = (MetadataVersion)pair.component2();
        if (fragment == null || version2 == null) {
            return null;
        }
        if (!version2.isCompatibleWithCurrentCompilerVersion()) {
            return new KotlinMetadataStubBuilder.FileWithMetadata.Incompatible(version2);
        }
        return new KlibFileWithMetadata(fragment, version2);
    }

    @Override
    @NotNull
    protected ClassDataFinder classDataFinder(@NotNull ClassDataFinder original, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return NearFileClassDataFinder.Companion.wrapIfNeeded(original, file, (Function1<? super VirtualFile, ? extends KotlinMetadataStubBuilder.FileWithMetadata>)((Function1)KlibMetadataStubBuilder::classDataFinder$lambda$0));
    }

    private static final KotlinMetadataStubBuilder.FileWithMetadata classDataFinder$lambda$0(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return KotlinMetadataStubBuilder.readFileSafely$default(INSTANCE, it, null, 2, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/konan/KlibMetadataStubBuilder$KlibFileWithMetadata;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Compatible;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "version", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "<init>", "(Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;)V", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "decompiler-native"})
    public static final class KlibFileWithMetadata
    extends KotlinMetadataStubBuilder.FileWithMetadata.Compatible {
        public KlibFileWithMetadata(@NotNull ProtoBuf.PackageFragment proto, @NotNull BinaryVersion version2) {
            Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
            super(proto, version2, (SerializerExtensionProtocol)KlibMetadataSerializerProtocol.INSTANCE);
        }

        @Override
        @NotNull
        public FqName getPackageFqName() {
            String string = this.getProto().getExtension(KlibMetadataProtoBuf.fqName);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExtension(...)");
            return new FqName(string);
        }
    }
}

