/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.util;

import com.intellij.javaee.appServers.deployment.DeploymentModel;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.oss.admin.ModuleTypeWrapper;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import org.jetbrains.annotations.Nullable;

public final class ModuleTypeUtil {
    @Nullable
    public static ModuleTypeWrapper getModuleType(DeploymentModel deployment) {
        Artifact artifact = deployment.getArtifact();
        if (artifact == null) {
            return null;
        }
        return ModuleTypeUtil.getModuleType(artifact);
    }

    @Nullable
    public static ModuleTypeWrapper getModuleType(Artifact artifact) {
        ArtifactType artifactType = artifact.getArtifactType();
        if (JavaeeArtifactUtil.getInstance().isJavaeeApplication(artifactType)) {
            return ModuleTypeWrapper.EAR;
        }
        if (JavaeeArtifactUtil.getInstance().isEjbApplication(artifactType)) {
            return ModuleTypeWrapper.EJB;
        }
        if (WebArtifactUtil.getInstance().isWebApplication(artifactType)) {
            return ModuleTypeWrapper.WAR;
        }
        return null;
    }
}

