/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.serverInstances;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.javaee.appServers.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServers.deployment.DeploymentModel;
import com.intellij.javaee.appServers.run.configuration.CommonModel;
import com.intellij.javaee.appServers.run.configuration.ServerModel;
import com.intellij.javaee.appServers.run.localRun.ExecutableObject;
import com.intellij.javaee.appServers.serverInstances.DefaultJ2EEServerEvent;
import com.intellij.javaee.appServers.serverInstances.J2EEServerEvent;
import com.intellij.javaee.appServers.serverInstances.J2EEServerInstance;
import com.intellij.javaee.appServers.serverInstances.J2EEServerStateListener;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DefaultServerInstance
implements J2EEServerInstance {
    private static final Logger LOG = Logger.getInstance(DefaultServerInstance.class);
    private final List<J2EEServerStateListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final CommonModel myCommonModel;
    private final String myHost;
    private final int myPort;
    private ProcessHandler myProcessHandler;
    @NonNls
    protected static final String LOCALHOST = "localhost";

    public DefaultServerInstance(CommonModel runConfiguration) {
        this.myCommonModel = runConfiguration;
        this.myHost = this.myCommonModel.getHost();
        this.myPort = this.myCommonModel.getPort();
    }

    protected String getHost() {
        return this.myHost;
    }

    @Override
    public String getName() {
        return this.myCommonModel.getName();
    }

    @Override
    public AppServerIntegration getIntegration() {
        return this.myCommonModel.getIntegration();
    }

    @Override
    public CommonModel getCommonModel() {
        return this.myCommonModel;
    }

    public ServerModel getServerModel() {
        return this.myCommonModel.getServerModel();
    }

    @Override
    public void start(ProcessHandler processHandler) {
        this.myProcessHandler = processHandler;
    }

    @Override
    public boolean isStopped() {
        return this.myProcessHandler != null && this.myProcessHandler.isProcessTerminated();
    }

    @Override
    public boolean isStarting() {
        return this.myProcessHandler == null;
    }

    public boolean isStartupScriptTerminatesAfterServerStartup(@NotNull ExecutableObject startupScript) {
        if (startupScript == null) {
            DefaultServerInstance.$$$reportNull$$$0(0);
        }
        return false;
    }

    public void updateChangedFiles(Set<String> changedFilesPaths) {
    }

    @Override
    public boolean isConnected() {
        return this.isConnected(this.myPort);
    }

    protected boolean isConnected(int port) {
        return DefaultServerInstance.tryConnection(this.myHost, port, this.myCommonModel.isLocal());
    }

    protected static boolean tryConnection(String host, int port, boolean tryServerSocketFirst) {
        LOG.debug("tryConnection: " + host + ":" + port + ", force try server socket: " + tryServerSocketFirst);
        if (LOCALHOST.equals(host) || tryServerSocketFirst) {
            try {
                LOG.debug("\t trying ServerSocket");
                ServerSocket serverSocket = new ServerSocket(port);
                serverSocket.close();
            }
            catch (BindException e) {
                LOG.debug("\t BindException, someone is listening: true");
                LOG.trace((Throwable)e);
                return true;
            }
            catch (IOException traceOnly) {
                LOG.debug("\t failed to create ServerSocket, continue");
                LOG.trace((Throwable)traceOnly);
            }
        }
        try {
            LOG.debug("\t trying Socket");
            Socket socket = new Socket(host, port);
            LOG.debug("\t connected, true");
            socket.setSoTimeout(30000);
            try {
                socket.close();
            }
            catch (IOException traceOnly) {
                LOG.debug("\t connected but cant close, still assuming true");
                LOG.trace((Throwable)traceOnly);
            }
            return true;
        }
        catch (SocketTimeoutException ex) {
            LOG.debug("\t timeout, assuming true", (Throwable)ex);
            return true;
        }
        catch (Exception e) {
            LOG.debug("\t failed to connect, false", (Throwable)e);
            return false;
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean connect() throws Exception {
        return true;
    }

    @Override
    public void registerServerError(Throwable e1) {
        LOG.error(e1);
    }

    @Override
    public void addServerListener(J2EEServerStateListener j2EEServerStateListener) {
        this.myListeners.add(j2EEServerStateListener);
    }

    @Override
    public void removeServerListener(J2EEServerStateListener j2EEServerStateListener) {
        this.myListeners.remove(j2EEServerStateListener);
    }

    public void fireServerListeners(J2EEServerEvent event) {
        for (J2EEServerStateListener listener : this.myListeners) {
            listener.serverStateChanged(event);
        }
    }

    protected final void notifyBeforeDisconnect() {
        this.fireServerListeners(new DefaultJ2EEServerEvent(false, false, true));
    }

    protected ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    public static JavaeeFacet[] getScopeFacets(CommonModel commonModel) {
        return (JavaeeFacet[])ReadAction.compute(() -> {
            ArrayList facetsToDeploy = new ArrayList();
            for (DeploymentModel deploymentModel : commonModel.getDeploymentModels()) {
                Artifact artifact = deploymentModel.getArtifact();
                if (artifact == null) continue;
                facetsToDeploy.addAll(JavaeeArtifactUtil.getInstance().getFacetsIncludedInArtifact(commonModel.getProject(), artifact, null));
            }
            return facetsToDeploy.toArray(new JavaeeFacet[0]);
        });
    }

    public static JavaeeFacet[] getScopeFacetsWithIncluded(CommonModel commonModel) {
        return DefaultServerInstance.getScopeFacets(commonModel);
    }

    public void registerAdditionalContent(RunnerLayoutUi layoutUi) {
    }

    public void prepare() throws ExecutionException {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startupScript", "com/intellij/javaee/appServers/serverInstances/DefaultServerInstance", "isStartupScriptTerminatesAfterServerStartup"));
    }
}

