/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.structure;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.treeStructure.SimpleTree;
import java.awt.event.InputEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectsStructure;
import org.jetbrains.idea.maven.navigator.structure.MavenSimpleNode;
import org.jetbrains.idea.maven.navigator.structure.RunConfigurationsNode;
import org.jetbrains.idea.maven.statistics.MavenActionsUsagesCollector;

final class RunConfigurationNode
extends MavenSimpleNode {
    private final RunnerAndConfigurationSettings mySettings;

    RunConfigurationNode(MavenProjectsStructure structure, RunConfigurationsNode parent, RunnerAndConfigurationSettings settings) {
        super(structure, parent);
        this.mySettings = settings;
        this.getTemplatePresentation().setIcon(ProgramRunnerUtil.getConfigurationIcon((RunnerAndConfigurationSettings)settings, (boolean)false));
    }

    public RunnerAndConfigurationSettings getSettings() {
        return this.mySettings;
    }

    public String getName() {
        return this.mySettings.getName();
    }

    @Override
    protected void doUpdate(@NotNull PresentationData presentation) {
        if (presentation == null) {
            RunConfigurationNode.$$$reportNull$$$0(0);
        }
        this.setNameAndTooltip(presentation, this.getName(), null, StringUtil.join(((MavenRunConfiguration)this.mySettings.getConfiguration()).getRunnerParameters().getGoals(), (String)" "));
    }

    @Override
    @Nullable
    String getMenuId() {
        return "Maven.RunConfigurationMenu";
    }

    public void updateRunConfiguration() {
    }

    @Override
    public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
        MavenActionsUsagesCollector.trigger(this.myProject, MavenActionsUsagesCollector.EXECUTE_MAVEN_CONFIGURATION, "Maven tool window", false, null);
        ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)this.mySettings, (Executor)DefaultRunExecutor.getRunExecutorInstance());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "org/jetbrains/idea/maven/navigator/structure/RunConfigurationNode", "doUpdate"));
    }
}

