/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.free;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.thymeleaf.free.ThymeleafFreeFragmentInspectionSuppressor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ThymeleafFreeHtmlInspectionsSuppressor
implements InspectionSuppressor {
    @NonNls
    private static final String[] THYMELEAF_URIS = new String[]{"http://www.thymeleaf.org", "http://www.thymeleaf.org/", "https://www.thymeleaf.org", "https://www.thymeleaf.org/"};
    private static final List<String> TABLE_CONTENT_TAGS = List.of("tr", "tbody", "thead");

    public SuppressQuickFix @NotNull [] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            ThymeleafFreeHtmlInspectionsSuppressor.$$$reportNull$$$0(0);
        }
        if (SuppressQuickFix.EMPTY_ARRAY == null) {
            ThymeleafFreeHtmlInspectionsSuppressor.$$$reportNull$$$0(1);
        }
        return SuppressQuickFix.EMPTY_ARRAY;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        XmlTag tag;
        XmlTag parentTag;
        PsiElement textAttr2;
        if (element == null) {
            ThymeleafFreeHtmlInspectionsSuppressor.$$$reportNull$$$0(2);
        }
        if (toolId == null) {
            ThymeleafFreeHtmlInspectionsSuppressor.$$$reportNull$$$0(3);
        }
        if (!ThymeleafFreeFragmentInspectionSuppressor.isFreeMode()) {
            return false;
        }
        if ("HtmlRequiredLangAttribute".equals(toolId)) {
            XmlAttribute replaceAttr;
            XmlTag tag2;
            PsiElement psiElement;
            if (element instanceof XmlToken && (psiElement = element.getParent()) instanceof XmlTag && "html".equalsIgnoreCase((tag2 = (XmlTag)psiElement).getLocalName()) && (replaceAttr = tag2.getAttribute("th:replace")) != null && ThymeleafFreeHtmlInspectionsSuppressor.isThymeleafNs(replaceAttr.getNamespace())) {
                return true;
            }
        } else if ("RequiredAttributes".equals(toolId)) {
            XmlTag tag3;
            PsiElement replaceAttr;
            if (element instanceof XmlToken && (replaceAttr = element.getParent()) instanceof XmlTag && ContainerUtil.and(ThymeleafFreeHtmlInspectionsSuppressor.getRequiredAttributes(tag3 = (XmlTag)replaceAttr), it -> tag3.getAttribute("th:" + it) != null)) {
                return true;
            }
        } else if ("HtmlRequiredAltAttribute".equals(toolId)) {
            XmlTag tag4;
            PsiElement replaceAttr;
            if (element instanceof XmlToken && (replaceAttr = element.getParent()) instanceof XmlTag && (tag4 = (XmlTag)replaceAttr).getAttribute("th:alt") != null) {
                return true;
            }
        } else if ("CheckEmptyScriptTag".equals(toolId)) {
            if (element instanceof XmlTag) {
                XmlTag tag5 = (XmlTag)element;
                XmlAttribute textAttr2 = tag5.getAttribute("th:text");
                if (textAttr2 != null && ThymeleafFreeHtmlInspectionsSuppressor.isThymeleafNs(textAttr2.getNamespace())) {
                    return true;
                }
                if (tag5.getAttribute("data-th-text") != null) {
                    return true;
                }
            }
        } else if ("HtmlUnknownTag".equals(toolId) && element instanceof XmlToken && (textAttr2 = element.getParent()) instanceof XmlTag && (parentTag = (tag = (XmlTag)textAttr2).getParentTag()) != null) {
            if ("block".equals(parentTag.getLocalName()) && ThymeleafFreeHtmlInspectionsSuppressor.isThymeleafNs(parentTag.getNamespace())) {
                return ThymeleafFreeHtmlInspectionsSuppressor.isHtmlTagName(tag.getName());
            }
            if ("th-block".equals(parentTag.getLocalName())) {
                return ThymeleafFreeHtmlInspectionsSuppressor.isHtmlTagName(tag.getName());
            }
        }
        return false;
    }

    @NotNull
    private static Set<String> getRequiredAttributes(@NotNull XmlTag tag) {
        XmlElementDescriptor descriptor;
        if (tag == null) {
            ThymeleafFreeHtmlInspectionsSuppressor.$$$reportNull$$$0(4);
        }
        if ((descriptor = tag.getDescriptor()) == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                ThymeleafFreeHtmlInspectionsSuppressor.$$$reportNull$$$0(5);
            }
            return set;
        }
        Set<String> set = Arrays.stream(descriptor.getAttributesDescriptors(tag)).filter(Objects::nonNull).filter(attr -> attr.isRequired()).map(attr -> attr.getName((PsiElement)tag)).collect(Collectors.toSet());
        if (set == null) {
            ThymeleafFreeHtmlInspectionsSuppressor.$$$reportNull$$$0(6);
        }
        return set;
    }

    private static boolean isHtmlTagName(@NotNull String tagName) {
        if (tagName == null) {
            ThymeleafFreeHtmlInspectionsSuppressor.$$$reportNull$$$0(7);
        }
        return HtmlUtil.isHtmlBlockTag((String)tagName, (boolean)false) || HtmlUtil.isHtml5Tag((String)tagName) || HtmlUtil.isPossiblyInlineTag((String)tagName) || TABLE_CONTENT_TAGS.contains(tagName);
    }

    private static boolean isThymeleafNs(String ns) {
        return ArrayUtil.contains((String)ns, (String[])THYMELEAF_URIS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/thymeleaf/free/ThymeleafFreeHtmlInspectionsSuppressor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/thymeleaf/free/ThymeleafFreeHtmlInspectionsSuppressor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressActions";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredAttributes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isHtmlTagName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 6 -> new IllegalStateException(string);
        };
    }
}

