/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.persistence.integration.hibernate;

import com.intellij.hibernate.facet.HibernateFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.persistence.extensions.PersistencePackagesProvider;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.persistence.integration.hibernate.HibernateIntegrationUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class SpringHibernateSessionFactoryProvider
implements PersistencePackagesProvider {
    private static final Key<CachedValue<List<PersistencePackage>>> SPRING_SESSION_FACTORIES_KEY = Key.create((String)"SPRING_SESSION_FACTORIES_KEY");

    SpringHibernateSessionFactoryProvider() {
    }

    @NotNull
    public List<PersistencePackage> getPersistencePackages(PersistenceFacet facet) {
        Module module = facet.getModule();
        if (!(facet instanceof HibernateFacet) || !module.isLoaded() || module.isDisposed() || DumbService.isDumb((Project)module.getProject()) || !SpringCommonUtils.isSpringConfigured((Module)module)) {
            List<PersistencePackage> list = Collections.emptyList();
            if (list == null) {
                SpringHibernateSessionFactoryProvider.$$$reportNull$$$0(0);
            }
            return list;
        }
        return SpringHibernateSessionFactoryProvider.getCachedValuePackages(facet);
    }

    @NotNull
    private static List<PersistencePackage> getCachedValuePackages(@NotNull PersistenceFacet facet) {
        if (facet == null) {
            SpringHibernateSessionFactoryProvider.$$$reportNull$$$0(1);
        }
        List list = (List)CachedValuesManager.getManager((Project)facet.getModule().getProject()).getCachedValue((UserDataHolder)facet, SPRING_SESSION_FACTORIES_KEY, () -> {
            HashSet<PersistencePackage> result = new HashSet<PersistencePackage>();
            SpringManager springManager = SpringManager.getInstance((Project)facet.getModule().getProject());
            Module facetModule = facet.getModule();
            SpringModel springModel = springManager.getCombinedModel(facetModule);
            PsiClass sessionFactoryClass = SpringCommonUtils.findLibraryClass((Module)facetModule, (String)"org.hibernate.SessionFactory");
            if (sessionFactoryClass != null) {
                SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)sessionFactoryClass).withInheritors().effectiveBeanTypes();
                for (SpringBeanPointer bean : SpringModelSearchers.findBeans((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)searchParameters)) {
                    Function<Pair<SpringBeanPointer<?>, PersistenceFacet>, PersistencePackage> provider = HibernateIntegrationUtil.getProvider(bean, HibernateIntegrationUtil.myProviders, true);
                    if (provider == null) continue;
                    PersistencePackage unit = (PersistencePackage)provider.fun((Object)Pair.create((Object)bean, (Object)facet));
                    if (bean.isAbstract()) continue;
                    result.add(unit);
                }
            }
            ArrayList factories = new ArrayList(result);
            HashSet dependencies = new HashSet();
            ContainerUtil.addAll(dependencies, (Object[])SpringModificationTrackersManager.getInstance((Project)facet.getModule().getProject()).getOuterModelsDependencies());
            dependencies.addAll(SpringModelVisitorUtils.getConfigFiles((CommonSpringModel)springModel));
            return CachedValueProvider.Result.create(factories, (Object[])springManager.getModelsDependencies(facetModule, ArrayUtil.toObjectArray(dependencies)));
        }, false);
        if (list == null) {
            SpringHibernateSessionFactoryProvider.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/persistence/integration/hibernate/SpringHibernateSessionFactoryProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistencePackages";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/persistence/integration/hibernate/SpringHibernateSessionFactoryProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedValuePackages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCachedValuePackages";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

