/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.config.OpenSshConfigViaToolServiceKt;
import com.intellij.ssh.config.SshConfigParseException;
import com.intellij.ssh.config.SshConnectionConfig;
import com.intellij.ssh.config.SshConnectionConfigService;
import com.intellij.ssh.config.ToolResult;
import com.intellij.util.SystemProperties;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0006H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ssh/config/OpenSshConfigViaToolService;", "Lcom/intellij/openapi/Disposable;", "OpenSshConfigViaToolService", "()V", "cache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "", "Lcom/intellij/ssh/config/ToolResult;", "get", "Lcom/intellij/ssh/config/SshConnectionConfig;", "host", "dispose", "", "q", "Companion", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nOpenSshConfigViaToolService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenSshConfigViaToolService.kt\ncom/intellij/ssh/config/OpenSshConfigViaToolService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,500:1\n1#2:501\n60#3,5:502\n*S KotlinDebug\n*F\n+ 1 OpenSshConfigViaToolService.kt\ncom/intellij/ssh/config/OpenSshConfigViaToolService\n*L\n83#1:502,5\n*E\n"})
public final class OpenSshConfigViaToolService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LoadingCache<String, ToolResult> cache;
    @NotNull
    private static final String CONFIG_LOAD_TIMEOUT_KEY = "ssh.openssh.config.load.timeout.seconds";

    private OpenSshConfigViaToolService() {
        LoadingCache loadingCache = Caffeine.newBuilder().executor((Executor)ProcessIOExecutorService.INSTANCE).expireAfterWrite(Duration.ofSeconds(5L)).build(new CacheLoader(this){
            final /* synthetic */ OpenSshConfigViaToolService $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final ToolResult load(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return OpenSshConfigViaToolService.access$cacheLoader(this.$tmp0, p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        this.cache = loadingCache;
    }

    @NotNull
    public final SshConnectionConfig get(@NotNull String host) throws SshConfigParseException {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return (SshConnectionConfig)Ssh.wrapBlockingSshCall$default(null, false, () -> OpenSshConfigViaToolService.q(this, host), 1, null);
    }

    public void dispose() {
        this.cache.invalidateAll();
    }

    private final ToolResult q(String attachmentArray) {
        List list;
        Attachment[] attachmentArray2;
        long l = System.nanoTime();
        Duration duration = Duration.ofSeconds(Registry.Companion.intValue(CONFIG_LOAD_TIMEOUT_KEY));
        Attachment[] attachmentArray3 = attachmentArray2 = ((Object)StringsKt.trim((CharSequence)SshConnectionConfigService.Companion.getInstance().getCustomOpenSshExecutable())).toString();
        Attachment[] attachmentArray4 = attachmentArray;
        boolean bl = false;
        boolean bl2 = ((CharSequence)attachmentArray3).length() > 0;
        Attachment[] attachmentArray5 = attachmentArray4;
        Object object = bl2 ? attachmentArray2 : null;
        if (object != null) {
            attachmentArray3 = object;
            attachmentArray4 = attachmentArray5;
            bl = false;
            list = CollectionsKt.listOf((Object)attachmentArray3);
            attachmentArray5 = attachmentArray4;
        } else {
            list = null;
        }
        String string = SystemProperties.getUserHome();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserHome(...)");
        Intrinsics.checkNotNull((Object)duration);
        ToolResult toolResult = OpenSshConfigViaToolServiceKt.access$openSshConfigViaToolImpl((String)attachmentArray5, list, string, duration);
        Duration duration2 = Duration.ofNanos(System.nanoTime() - l);
        if (duration2.compareTo(duration) >= 0) {
            attachmentArray2 = new Attachment[]{new Attachment("command_line.txt", toolResult.getCmdLine()), new Attachment("stdout.txt", toolResult.getRawStdout()), new Attachment("stderr.txt", toolResult.getRawStderr())};
            OpenSshConfigViaToolServiceKt.access$getLOG().error("Getting the configuration via OpenSSH took too long: " + duration2 + ". Timeout: " + duration.getSeconds() + "s.", attachmentArray2);
        } else {
            attachmentArray2 = OpenSshConfigViaToolServiceKt.access$getLOG();
            attachmentArray3 = null;
            bl = false;
            if (attachmentArray2.isDebugEnabled()) {
                attachmentArray4 = attachmentArray2;
                boolean bl3 = false;
                attachmentArray4.debug(toolResult.getCmdLine() + " executed in " + duration2, (Throwable)attachmentArray3);
            }
        }
        return toolResult;
    }

    private static final SshConnectionConfig q(OpenSshConfigViaToolService openSshConfigViaToolService, String string) {
        SshConnectionConfig sshConnectionConfig;
        try {
            sshConnectionConfig = ((ToolResult)openSshConfigViaToolService.cache.get((Object)string)).getResult();
        }
        catch (CompletionException completionException) {
            Throwable throwable = completionException.getCause();
            if (throwable == null) {
                throwable = completionException;
            }
            throw throwable;
        }
        return sshConnectionConfig;
    }

    @JvmStatic
    @NotNull
    public static final OpenSshConfigViaToolService getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ ToolResult access$cacheLoader(OpenSshConfigViaToolService $this, String host) {
        return $this.q(host);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ssh/config/OpenSshConfigViaToolService$Companion;", "", "OpenSshConfigViaToolService$Companion", "()V", "CONFIG_LOAD_TIMEOUT_KEY", "", "getInstance", "Lcom/intellij/ssh/config/OpenSshConfigViaToolService;", "intellij.platform.ssh"})
    @SourceDebugExtension(value={"SMAP\nOpenSshConfigViaToolService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenSshConfigViaToolService.kt\ncom/intellij/ssh/config/OpenSshConfigViaToolService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,500:1\n42#2,3:501\n*S KotlinDebug\n*F\n+ 1 OpenSshConfigViaToolService.kt\ncom/intellij/ssh/config/OpenSshConfigViaToolService$Companion\n*L\n92#1:501,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final OpenSshConfigViaToolService getInstance() {
            boolean bl = false;
            Class<OpenSshConfigViaToolService> clazz = OpenSshConfigViaToolService.class;
            Object object = ApplicationManager.getApplication().getService(clazz);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + clazz.getName() + " (classloader=" + clazz.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (OpenSshConfigViaToolService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

