/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.interaction;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ssh.common.ServerDescription;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.ssh.interaction.ConnectionOwnerFactory;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectBasedConnectionOwner
implements ConnectionOwner {
    @Nullable
    protected final Project myProject;

    protected ProjectBasedConnectionOwner(@Nullable Project project) {
        this.myProject = project;
    }

    @Override
    public boolean promptYesNo(@NlsContexts.DialogMessage @NotNull String message, @NlsContexts.DialogTitle @NotNull String title, @Nullable ProgressIndicator progressIndicator2) {
        if (message == null) {
            ProjectBasedConnectionOwner.q(0);
        }
        if (title == null) {
            ProjectBasedConnectionOwner.q(1);
        }
        Computable computable = () -> {
            ProgressManager.checkCanceled();
            return ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)title, (String)message).asWarning()).ask(this.myProject);
        };
        ProgressManager.checkCanceled();
        return (Boolean)ConnectionOwnerFactory.computeOnEDT(computable, progressIndicator2, ModalityState.any(), ModalityState.any());
    }

    @Override
    @Nullable
    public String promptPassword(@NlsContexts.DialogMessage @NotNull String message, @NlsContexts.DialogTitle @NotNull String title, @Nullable ProgressIndicator progressIndicator2) {
        if (message == null) {
            ProjectBasedConnectionOwner.q(2);
        }
        if (title == null) {
            ProjectBasedConnectionOwner.q(3);
        }
        Computable computable = () -> {
            ProgressManager.checkCanceled();
            return MessagesService.getInstance().showPasswordDialog(this.myProject, message, title, UIUtil.getQuestionIcon(), null);
        };
        ProgressManager.checkCanceled();
        return (String)ConnectionOwnerFactory.computeOnEDT(computable, progressIndicator2, ModalityState.any(), ModalityState.any());
    }

    @Override
    public final void showMessage(@NlsContexts.DialogMessage @NotNull String message, @NlsContexts.DialogTitle @NotNull String title, @Nullable ServerDescription server, @Nullable ProgressIndicator progressIndicator2, @Nullable DoNotAskOption doNotAskOption) {
        if (message == null) {
            ProjectBasedConnectionOwner.q(4);
        }
        if (title == null) {
            ProjectBasedConnectionOwner.q(5);
        }
        ConnectionOwnerFactory.invokeLater(() -> this.showMessageImpl(message, title, server, doNotAskOption), progressIndicator2, ModalityState.defaultModalityState());
    }

    protected abstract void showMessageImpl(@NlsContexts.DialogMessage @NotNull String var1, @NlsContexts.DialogTitle @NotNull String var2, @Nullable ServerDescription var3, @Nullable DoNotAskOption var4);

    @Override
    @Nullable
    public final String getHash() {
        return this.myProject != null && !this.myProject.isDisposed() ? this.myProject.getLocationHash() : null;
    }

    @Override
    @Nullable
    public Project getProjectForDialogCreation() {
        return this.myProject;
    }

    @Override
    @Nullable
    public Component getComponentForDialogCreation() {
        return null;
    }

    @Override
    public void checkDisposed() throws IllegalStateException {
        if (this.myProject != null && this.myProject.isDisposed()) {
            throw new IllegalStateException("Project is disposed");
        }
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProjectBasedConnectionOwner)) {
            return false;
        }
        ProjectBasedConnectionOwner projectBasedConnectionOwner = (ProjectBasedConnectionOwner)o;
        if (this.myProject == null) {
            return projectBasedConnectionOwner.myProject == null;
        }
        return this.myProject.equals((Object)projectBasedConnectionOwner.myProject);
    }

    public final int hashCode() {
        return this.myProject != null ? this.myProject.hashCode() : 0;
    }

    private static /* synthetic */ void q(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ssh/interaction/ProjectBasedConnectionOwner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "promptYesNo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "promptPassword";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

